/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.formplugin.bill.originalbill.util.SelectDeviceUtil;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;

public class RedConfirmBillAddDialogPlugin
extends AbstractFormPlugin {
    private static final String BUYER_APPLY = "1";
    private static final String electric_billKey = "rim_inv_electric";
    private static final String special_billKey = "rim_inv_special";
    private static final String ordinary_billKey = "rim_inv_ordinary";

    public void afterCreateNewData(EventObject e) {
        JSONObject invoice = (JSONObject)this.getView().getFormShowParameter().getCustomParam("data");
        this.getView().setVisible(Boolean.FALSE, new String[]{"accountflex"});
        if (invoice == null) {
            this.getModel().setValue("org", this.getView().getFormShowParameter().getCustomParam("org"));
            return;
        }
        this.getModel().setValue("originalinvoiceno", (Object)invoice.getString("invoiceno"));
        this.getModel().setValue("originalinvoicetype", (Object)invoice.getString("invoicetype"));
        this.getView().setVisible(Boolean.FALSE, new String[]{"originalinvoicetype", "originalinvoicecode"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"originalinvoiceno", "applicant", "originalinvoicetype", "org"});
        JSONObject org = (JSONObject)invoice.get((Object)"orgid");
        if (Objects.nonNull(org)) {
            this.getModel().setValue("org", org.get((Object)"id"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object org = this.getModel().getValue("org");
        if (org != null) {
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")));
            SelectDeviceUtil.setAccount((AbstractFormPlugin)this, (String)saleInfo.getSaleTaxNo());
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        TextEdit invoiceNoEdit = (TextEdit)this.getView().getControl("originalinvoiceno");
        invoiceNoEdit.addClickListener((ClickListener)this);
        TextEdit invoiceCodeEdit = (TextEdit)this.getView().getControl("originalinvoicecode");
        invoiceCodeEdit.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "originalinvoicetype": 
            case "applicant": {
                this.getModel().setValue("originalinvoiceno", null);
                this.getModel().setValue("originalinvoicecode", null);
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "originalinvoicecode": 
            case "originalinvoiceno": {
                this.openVatInvoiceListView();
                break;
            }
            case "btnok": {
                this.goAddRedConfirmBill();
                break;
            }
        }
    }

    private void goAddRedConfirmBill() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmBillAddDialogPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String originalInvoiceNo = (String)this.getModel().getValue("originalinvoiceno");
        if (StringUtils.isBlank((CharSequence)originalInvoiceNo)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u84dd\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmBillAddDialogPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        String originalInvoiceCode = (String)this.getModel().getValue("originalinvoicecode");
        this.checkOriInvoice(originalInvoiceCode, originalInvoiceNo);
        String redReason = (String)this.getModel().getValue("redreason");
        if (StringUtils.isBlank((CharSequence)redReason)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ea2\u51b2\u539f\u56e0", (String)"RedConfirmBillAddDialogPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
        PermissionHelper.checkPermission((String)"sim", (String)"sim_red_confirm_bill", (long)orgId, (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
        HashMap<String, Object> returnData = new HashMap<String, Object>(4);
        returnData.put("applicant", this.getModel().getValue("applicant"));
        returnData.put("org", String.valueOf(orgId));
        String pk = this.getPageCache().get("id");
        if (StringUtils.isBlank((CharSequence)pk)) {
            returnData.put("id", "0");
        } else {
            returnData.put("id", pk);
        }
        returnData.put("billKey", this.getPageCache().get("billKey"));
        returnData.put("redreason", this.getModel().getValue("redreason"));
        returnData.put("account", this.getModel().getValue("account"));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void checkOriInvoice(String originalInvoiceCode, String oriInvoiceNo) {
        Object applicant = this.getModel().getValue("applicant");
        if (BUYER_APPLY.equals(applicant)) {
            DynamicObject rimInvoice;
            String billKey = this.getRimBillFormId();
            QFilter filter = new QFilter("invoice_no", "=", (Object)oriInvoiceNo);
            if (billKey.equals(special_billKey) || billKey.equals(ordinary_billKey)) {
                filter.and("invoice_code", "=", (Object)originalInvoiceCode);
            }
            if ((rimInvoice = BusinessDataServiceHelper.loadSingle((String)billKey, (String)PropertieUtil.getAllPropertiesSplitByComma((String)billKey), (QFilter[])filter.toArray())) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8fdb\u9879\u7968\u6c60\u672a\u67e5\u8be2\u5230\u8be5\u53d1\u7968", (String)"RedConfirmBillAddDialogPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            Object type = rimInvoice.get("type");
            if (!"0".equals(type)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8fdb\u9879\u7968\u6c60\u4e2d\u8be5\u53d1\u7968\u975e\u84dd\u5b57\u53d1\u7968", (String)"RedConfirmBillAddDialogPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (!"0".equals(rimInvoice.get("invoice_status"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8fdb\u9879\u7968\u6c60\u4e2d\u8be5\u53d1\u7968\u72b6\u6001\u4e0d\u662f\u6b63\u5e38\u72b6\u6001", (String)"RedConfirmBillAddDialogPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")));
            String taxNo = saleInfo.getSaleTaxNo();
            if (!taxNo.equals(rimInvoice.get("buyer_tax_no"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8fdb\u9879\u7968\u6c60\u4e2d\u8be5\u53d1\u7968\u8d2d\u65b9\u7a0e\u53f7\u548c\u6240\u9009\u7ec4\u7ec7\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"RedConfirmBillAddDialogPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put("id", rimInvoice.getPkValue().toString());
            this.getPageCache().put("billKey", billKey);
            return;
        }
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)originalInvoiceCode, (String)oriInvoiceNo).toArray());
        if (invoice == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u53d1\u7968", (String)"RedConfirmBillAddDialogPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (!Objects.equals(DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")), DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u53f7\u7801\u4e0d\u5728\u6240\u9009\u7ec4\u7ec7\u4e0b", (String)"RedConfirmBillAddDialogPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (!InvoiceStatus.isNormalInvIncludePartRed((String)invoice.getString("invoicestatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u53f7\u7801\u975e\u6b63\u5e38\u72b6\u6001", (String)"RedConfirmBillAddDialogPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (!IssueType.BLUE_INVOICE.getTypeCode().equals(invoice.getString("issuetype"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u53f7\u7801\u975e\u84dd\u5b57\u53d1\u7968", (String)"RedConfirmBillAddDialogPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        BigDecimal remainRedAmount = invoice.getBigDecimal("remainredamount");
        if (BigDecimalUtil.compareZero((BigDecimal)remainRedAmount)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u53f7\u7801\u53ef\u7ea2\u51b2\u91d1\u989d\u4e3a0", (String)"RedConfirmBillAddDialogPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String redReason = (String)this.getModel().getValue("redreason");
        BigDecimal invoiceAmount = invoice.getBigDecimal("invoiceamount");
        if (RedConfirmBillRedReasonEnum.INVOICE_ERR.getCode().equals(redReason) && invoiceAmount.compareTo(remainRedAmount) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u53f7\u7801\u5df2\u8fdb\u884c\u90e8\u5206\u7ea2\u51b2\uff0c\u4e0d\u652f\u6301\u7ea2\u51b2\u539f\u56e0\u4e3a\u3010\u5f00\u7968\u6709\u8bef\u3011\uff01", (String)"RedConfirmBillAddDialogPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (invoiceAmount.compareTo(remainRedAmount) == 0) {
            IssueInvoiceService.setBlueInvoiceRemainRedAmount((DynamicObject)invoice);
            SaveServiceHelper.update((DynamicObject)invoice);
        }
        this.getPageCache().put("id", invoice.getPkValue().toString());
        this.getPageCache().put("billKey", "sim_vatinvoice");
    }

    private void openVatInvoiceListView() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7!", (String)"RedConfirmBillAddDialogPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        Object applicant = this.getModel().getValue("applicant");
        if (BUYER_APPLY.equals(applicant)) {
            Object originalInvoiceType = this.getModel().getValue("originalinvoicetype");
            if (null == originalInvoiceType) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u539f\u53d1\u7968\u7c7b\u578b", (String)"RedConfirmBillAddDialogPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            String billKey = this.getRimBillFormId();
            try {
                QFilter qFilter = this.getRimCommonFilter();
                QueryServiceHelper.exists((String)billKey, (QFilter[])qFilter.toArray());
                HashMap customParams = new HashMap(4);
                RedConfirmBillHelper.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)billKey, (String)billKey, customParams, (String)ResManager.loadKDString((String)"\u8fdb\u9879\u53d1\u7968\u6c60", (String)"RedConfirmBillAddDialogPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u9009\u62e9", (String)"RedConfirmBillAddDialogPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        } else {
            Object originalInvoiceType = this.getModel().getValue("originalinvoicetype");
            QFilter baseFilter = new QFilter("invoicetype", "=", originalInvoiceType);
            QFilter qFilter = baseFilter.and("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray).and("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"))).and("remainredamount", ">", (Object)BigDecimal.ZERO);
            RedConfirmBillHelper.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_choose_vatinvoice", (String)"originalinvoiceno", null, (String)ResManager.loadKDString((String)"\u9500\u9879\u5f00\u7968\u5217\u8868", (String)"RedConfirmBillAddDialogPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private String getRimBillFormId() {
        String originalInvoiceType = (String)this.getModel().getValue("originalinvoicetype");
        String billKey = electric_billKey;
        if (InvoiceUtils.isSpecialInvoice((String)originalInvoiceType)) {
            billKey = special_billKey;
        } else if (InvoiceUtils.isNormalInvoice((String)originalInvoiceType)) {
            billKey = ordinary_billKey;
        }
        return billKey;
    }

    private QFilter getRimCommonFilter() {
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        return new QFilter("type", "=", (Object)"0").and("invoice_status", "=", (Object)"0").and("buyer_tax_no", "=", (Object)saleInfo.getSaleTaxNo());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "rim_inv_electric": 
            case "rim_inv_ordinary": 
            case "rim_inv_special": {
                DynamicObject dynamicObject;
                if (closedCallBackEvent.getReturnData() == null) break;
                ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (actionId.equals(ordinary_billKey) || actionId.equals(special_billKey)) {
                    dynamicObject = BusinessDataServiceHelper.loadSingle((Object)listSelectedRows.getPrimaryKeyValues()[0], (String)actionId, (String)"invoice_code,invoice_no");
                    this.getView().getModel().setValue("originalinvoicecode", dynamicObject.get("invoice_code"));
                } else {
                    dynamicObject = BusinessDataServiceHelper.loadSingle((Object)listSelectedRows.getPrimaryKeyValues()[0], (String)actionId, (String)"invoice_no");
                }
                this.getView().getModel().setValue("originalinvoiceno", dynamicObject.get("invoice_no"));
                break;
            }
            case "originalinvoiceno": {
                if (closedCallBackEvent.getReturnData() == null) break;
                ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)listSelectedRows.getPrimaryKeyValues()[0], (String)"sim_vatinvoice", (String)"invoicecode,invoiceno");
                this.getView().getModel().setValue("originalinvoicecode", dynamicObject.get("invoicecode"));
                this.getView().getModel().setValue("originalinvoiceno", dynamicObject.get("invoiceno"));
            }
        }
    }
}

