/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.op;

import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.enums.CancelRedEum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;

public class RedConfirmBillBeforeIssueOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_red_confirm_bill", (boolean)true));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.dataEntities;
                OperateOption option = this.getOption();
                SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)Long.parseLong(option.getVariableValue("org")));
                String taxNo = saleInfo.getSaleTaxNo();
                this.getOption().setVariableValue("salertaxno", taxNo);
                String applicantFirst = dataEntities[0].getDataEntity().getString("applicant");
                String orgFirst = dataEntities[0].getDataEntity().getString("org");
                HashSet<String> accountSet = new HashSet<String>(4);
                DynamicObject[] redConfirms = new DynamicObject[dataEntities.length];
                for (int i = 0; i < dataEntities.length; ++i) {
                    DynamicObject redConfirm = dataEntities[i].getDataEntity();
                    accountSet.add(redConfirm.getString("account"));
                    if (!redConfirm.getString("org").equals(orgFirst) || !redConfirm.getString("applicant").equals(applicantFirst)) {
                        this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u53ea\u652f\u6301\u9009\u62e9\u76f8\u540c\u7ec4\u7ec7\uff0c\u548c\u76f8\u540c\u7533\u8bf7\u65b9\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u8fdb\u884c\u6279\u91cf\u7ea2\u51b2,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RedConfirmBillBeforeIssueOp_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    }
                    if (!saleInfo.getSaleTaxNo().equals(redConfirm.getString("salertaxno"))) {
                        this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u7ec4\u7ec7\u5173\u8054\u7a0e\u53f7\u4e0e\u8be5\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u53f7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ea2\u51b2\u64cd\u4f5c\u3002", (String)"RedConfirmBillBeforeIssueOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    }
                    redConfirms[i] = redConfirm;
                }
                try {
                    BotpHelper.checkRedConfirmPartRed((DynamicObject[])redConfirms);
                }
                catch (MsgException me) {
                    throw new KDBizException(me.getErrorMsg());
                }
                JSONObject param = BotpHelper.cancelOrRedArInvoice((DynamicObject[])redConfirms, (CancelRedEum)CancelRedEum.ISSUE_RED_CONFIRM);
                Integer billPksSize = param.getInteger("billPksSize");
                if (redConfirms.length > 1 && billPksSize > 0) {
                    option.setVariableValue("cancelOrRedArInvoiceBillPks", param.toJSONString());
                }
                this.getOption().setVariableValue("account", accountSet.size() == 1 ? (String)accountSet.toArray()[0] : "");
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        JSONObject json = new JSONObject();
        json.put("taxNo", (Object)this.operateOption.getVariableValue("salertaxno"));
        json.put("org", (Object)this.operateOption.getVariableValue("org"));
        json.put("account", (Object)this.operateOption.getVariableValue("account"));
        if (this.operateOption.containsVariable("cancelOrRedArInvoiceBillPks")) {
            json.put("cancelOrRedArInvoiceBillPks", (Object)this.operateOption.getVariableValue("cancelOrRedArInvoiceBillPks"));
        }
        this.operationResult.setMessage(json.toJSONString());
    }
}

