/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.op;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.base.redconfirmapply.RedConfirmBillApplyRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.redconfirmapply.RedConfirmBillApplyResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.dto.allele.AllEleRedConfirmBillUploadResponseDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueRequestDTO;
import kd.imc.sim.common.helper.NegativeBillMatchHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.service.issueinvoice.impl.AllEleIssueInvoiceImpl;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;

public class RedConfirmBillUploadOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_red_confirm_bill", (boolean)true));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> successObj = new ArrayList<DynamicObject>(dataEntities.length);
        String account = this.getOption().containsVariable("account") ? this.getOption().getVariableValue("account") : "";
        for (DynamicObject redConfirmBill : dataEntities) {
            String taxNo = "2".equals(redConfirmBill.getString("applicant")) ? redConfirmBill.getString("salertaxno") : redConfirmBill.getString("buyertaxno");
            if (EnterpriseHelper.isLqptChannel((String)taxNo)) {
                this.redConfirmUploadLq(redConfirmBill, taxNo, successObj);
                continue;
            }
            AllEleIssueRequestDTO allEleIssueRequestDTO = AllEleIssueInvoiceImpl.buildIssueInvoide((DynamicObject)redConfirmBill);
            if (StringUtils.isNotBlank((CharSequence)account)) {
                allEleIssueRequestDTO.setAccount(account);
            }
            allEleIssueRequestDTO.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_APPLY.getRequestPath());
            RedConfirmBillHelper.addOriginalSeq((AllEleIssueRequestDTO)allEleIssueRequestDTO);
            AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)allEleIssueRequestDTO, AllEleRedConfirmBillUploadResponseDTO.class);
            if (response.getSuccess().booleanValue()) {
                AllEleRedConfirmBillUploadResponseDTO uploadResponse = (AllEleRedConfirmBillUploadResponseDTO)response.getData();
                if (StringUtils.isBlank((CharSequence)uploadResponse.getGovRedConfirmBillUuid()) && StringUtils.isNotBlank((CharSequence)uploadResponse.getRedConfirmBillNo()) && uploadResponse.getRedConfirmBillNo().length() == 16) {
                    redConfirmBill.set("uploadstatus", (Object)"2");
                    redConfirmBill.set("failreason", (Object)"\u8be5\u84dd\u7968\u5b58\u5728\u7ea2\u5b57\u4fe1\u606f\u8868");
                    this.operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo((DynamicObject)redConfirmBill, (String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedConfirmBillUploadOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirmBill.getString("orderno"), response.getDescription())));
                    continue;
                }
                redConfirmBill.set("uploadstatus", (Object)"1");
                redConfirmBill.set("uploaddate", (Object)DateUtils.stringToDate((String)uploadResponse.getRedConfirmEnterDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                redConfirmBill.set("govuuid", (Object)uploadResponse.getGovRedConfirmBillUuid());
                redConfirmBill.set("number", (Object)uploadResponse.getRedConfirmBillNo());
                redConfirmBill.set("confirmstatus", (Object)uploadResponse.getRedConfirmBillStatus());
                redConfirmBill.set("failreason", (Object)"");
                if ("0".equals(redConfirmBill.getString("enteridentity")) && (RedConfirmStatusEnum.NO_CONFIRM.getBillCode().equals(redConfirmBill.getString("confirmstatus")) || RedConfirmStatusEnum.BUYER_CONFIRM.getBillCode().equals(redConfirmBill.getString("confirmstatus")))) {
                    redConfirmBill.set("account", (Object)allEleIssueRequestDTO.getAccount());
                    if (StringUtils.isNotBlank((CharSequence)allEleIssueRequestDTO.getAccount())) {
                        redConfirmBill.set("drawer", (Object)AllEleAuthHelper.getDrawerByAccount((String)allEleIssueRequestDTO.getSalerTaxNo(), (String)allEleIssueRequestDTO.getAccount()));
                    }
                }
                successObj.add(redConfirmBill);
                continue;
            }
            if (response.getErrcode().equals("1304")) {
                redConfirmBill.set("uploadstatus", (Object)"3");
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_comfirm_bill_temp");
                dynamicObject.set("orderno", (Object)redConfirmBill.getString("orderno"));
                dynamicObject.set("operate", (Object)"0");
                dynamicObject.set("createdate", (Object)new Date());
                dynamicObject.set("redid", redConfirmBill.get("id"));
                ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
                continue;
            }
            redConfirmBill.set("uploadstatus", (Object)"2");
            RedConfirmBillHelper.setFailReason((DynamicObject)redConfirmBill, (String)response.getDescription());
            this.operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo((DynamicObject)redConfirmBill, (String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedConfirmBillUploadOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirmBill.getString("orderno"), response.getDescription())));
        }
        new NegativeBillMatchHelper().writeInfoCode2MatchBill(successObj);
        e.setDataEntities(successObj.toArray(new DynamicObject[0]));
        ImcSaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private void redConfirmUploadLq(DynamicObject redConfirmBill, String taxNo, List<DynamicObject> successObj) {
        RedConfirmBillApplyRequest request = (RedConfirmBillApplyRequest)DynamicObjectUtil.dynamicObject2Bean(RedConfirmBillApplyRequest.class, (DynamicObject)redConfirmBill);
        request.setNsrsbh(taxNo);
        RedConfirmBillHelper.buildRedConfirmApply((RedConfirmBillApplyRequest)request, (DynamicObject)redConfirmBill);
        LqptResponse response = new LqptService().send((LqptRequest)request);
        if (response.success()) {
            redConfirmBill.set("uploadstatus", (Object)"1");
            RedConfirmBillApplyResponse data = (RedConfirmBillApplyResponse)response.getData();
            redConfirmBill.set("uploaddate", (Object)new Date());
            redConfirmBill.set("govuuid", (Object)data.getUuid());
            redConfirmBill.set("number", (Object)data.getHzfpxxqrdbh());
            redConfirmBill.set("confirmstatus", (Object)data.getHzqrxxztDm());
            redConfirmBill.set("failreason", (Object)"");
            successObj.add(redConfirmBill);
        } else {
            redConfirmBill.set("uploadstatus", (Object)"2");
            RedConfirmBillHelper.setFailReason((DynamicObject)redConfirmBill, (String)response.getDescription());
            this.operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo((DynamicObject)redConfirmBill, (String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedConfirmBillUploadOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirmBill.getString("orderno"), response.getDescription())));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] redConfirmList = e.getDataEntities();
        RequestContext context = RequestContext.get();
        ThreadPools.executeOnceIncludeRequestContext((String)"assignRedConfirm", () -> {
            RequestContext.copyAndSet((RequestContext)context);
            RedConfirmBillHelper redConfirmBillHelper = new RedConfirmBillHelper();
            for (DynamicObject recConfirm : redConfirmList) {
                ArrayList<DynamicObject> redConfirms = new ArrayList<DynamicObject>(4);
                redConfirms.add(recConfirm);
                redConfirmBillHelper.assignRedConfirm(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)recConfirm.get("org"))), recConfirm.getString("applicant"), redConfirms);
            }
        });
    }
}

