/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.dto.redinfo.RedInfoDownloadRequestDTO;
import kd.imc.sim.common.helper.HostModeInvoiceHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.model.redinfo.Resp93007;
import org.apache.commons.lang3.tuple.Pair;

public class RedInfoDownloadDialogPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Date today = new Date();
        this.getModel().setValue("applytime_start", (Object)DateUtils.getFirstDateOfMonth((Date)today));
        this.getModel().setValue("applytime_end", (Object)today);
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        this.setEquipmentAndTerminaNo();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "jqbh": {
                String equipmentNo = (String)e.getChangeSet()[0].getNewValue();
                if (StringUtils.isBlank((CharSequence)equipmentNo)) {
                    return;
                }
                SaleInfo saleInfoByOrg = TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")));
                EquipmentUtil.showTerminalNo((AbstractFormPlugin)this, (String)equipmentNo, (String)saleInfoByOrg.getSaleTaxNo(), (String)"terminalno", (boolean)false);
                break;
            }
            case "org": {
                this.setEquipmentAndTerminaNo();
            }
        }
    }

    public void click(EventObject evt) {
        PermissionHelper.checkPermission((String)"sim", (String)"sim_red_info", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")), (ImcPermItemEnum)ImcPermItemEnum.ITEM_DOWNLOAD);
        Date applyTimeStart = (Date)this.getModel().getValue("applytime_start");
        Date applyTimeEnd = (Date)this.getModel().getValue("applytime_end");
        if (applyTimeStart == null || applyTimeEnd == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoDownloadDialogPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (applyTimeStart.compareTo(new Date()) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u8d77\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u65e5\u671f", (String)"RedInfoDownloadDialogPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (applyTimeEnd.compareTo(DateUtils.getLastDateOfMonth((Date)new Date())) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u6b62\u4e0d\u80fd\u8d85\u8fc7\u5f53\u6708\u6700\u540e\u4e00\u5929", (String)"RedInfoDownloadDialogPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (DateUtils.timeDifferenceDay((Date)applyTimeStart, (Date)applyTimeEnd) > 30) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8d77\u6b62\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e31\u5929", (String)"RedInfoDownloadDialogPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String jqbh = (String)this.getModel().getValue("jqbh");
        if (StringUtils.isBlank((CharSequence)jqbh)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoDownloadDialogPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String terminalNo = (String)this.getModel().getValue("terminalno");
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")));
        EquipmentHelper.checkTerminalNo((String)jqbh, (String)saleInfo.getSaleTaxNo(), (String)terminalNo);
        String buyertaxno = (String)this.getModel().getValue("buyertaxno");
        String infoCode = (String)this.getModel().getValue("infocode");
        if (StringUtils.isNotBlank((CharSequence)infoCode) && (!RegexUtil.isNumber((String)infoCode) || infoCode.length() != 16)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fe1\u606f\u8868\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"RedInfoDownloadDialogPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String taxNo = saleInfo.getSaleTaxNo();
        String equipmentType = EquipmentHelper.getEquipmentTypeByNo((String)jqbh);
        if (EquipmentHelper.isBlockChainOrHostModeDevice((String)equipmentType)) {
            this.downloadRedInfoFromHostMode(this.createRequestJson(taxNo));
        } else {
            if ("8".equals(equipmentType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301", (String)"RedInfoDownloadDialogPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (EquipmentType.isLyServer((String)equipmentType)) {
                this.downloadRedInfoFromLyServer(this.createRequestJson(taxNo));
            } else {
                this.downloadRedInfoFromComponent(jqbh, terminalNo, taxNo, applyTimeStart, applyTimeEnd, buyertaxno, infoCode);
            }
        }
    }

    private JSONObject createRequestJson(String taxNo) {
        JSONObject invoiceJson = new JSONObject();
        invoiceJson.put("salertaxno", (Object)taxNo);
        invoiceJson.put("jqbh", this.getModel().getValue("jqbh"));
        invoiceJson.put("thirdserialno", (Object)UUID.getBatchNumber());
        invoiceJson.put("orderno", (Object)UUID.getBatchNumber());
        invoiceJson.put("applytime_start", (Object)DateUtils.format((Date)((Date)this.getModel().getValue("applytime_start")), (String)"yyyyMMdd"));
        invoiceJson.put("applytime_end", (Object)DateUtils.format((Date)((Date)this.getModel().getValue("applytime_end")), (String)"yyyyMMdd"));
        invoiceJson.put("applicantfw", this.getModel().getValue("applicantfw"));
        invoiceJson.put("buyertaxno", this.getModel().getValue("buyertaxno"));
        invoiceJson.put("infocode", this.getModel().getValue("infocode"));
        invoiceJson.put("invoicetype", this.getModel().getValue("invoicetype"));
        return invoiceJson;
    }

    private void downloadRedInfoFromLyServer(JSONObject invoiceJson) {
        if (!"004".equals(this.getModel().getValue("invoicetype"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff0c\u53ea\u80fd\u9009\u62e9\u7eb8\u8d28\u4e13\u7528\u53d1\u7968\u4e0b\u8f7d\u7ea2\u5b57\u4fe1\u606f\u8868", (String)"RedInfoDownloadDialogPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        MsgResponse msgResponse = LyServerInvoiceHelper.redInfoDownload((JSONObject)invoiceJson);
        if (!ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff0c%s", (String)"RedInfoDownloadDialogPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), msgResponse.getErrorMsg()));
        }
        JSONArray responseJsonArray = JSON.parseArray((String)msgResponse.getRespData());
        List redInfoList = DynamicObjectUtil.array2DynamicListContainItems((JSONArray)responseJsonArray, (String)"sim_red_info");
        Resp93007 resp93007 = RedInfoHelper.dynamicObjectBuildResp93007((int)redInfoList.size(), (List)redInfoList);
        List pairList = RedInfoHelper.convertResp93007ToDynamicObject((List)resp93007.getHzxxb(), (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")), (String)invoiceJson.getString("jqbh"));
        this.handlerPairList(pairList, resp93007.getHzxxb().size());
    }

    public void setEquipmentAndTerminaNo() {
        try {
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
            EquipmentUtil.initEquipmentAndTerminal((AbstractFormPlugin)this, (long)orgId, (String)saleInfo.getSaleTaxNo(), (String)"jqbh", (String)"terminalno", (boolean)true);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void downloadRedInfoFromComponent(String jqbh, String terminalNo, String taxNo, Date applyTimeStart, Date applyTimeEnd, String buyertaxno, String infoCode) {
        RedInfoDownloadRequestDTO request = new RedInfoDownloadRequestDTO();
        request.setKjf_jh(jqbh);
        request.setHxbzdh(terminalNo);
        request.setKjf_nsrsbh(taxNo);
        request.setKjf_sbbh(jqbh);
        request.setQstkrq(DateUtils.format((Date)applyTimeStart, (String)"yyyy-MM-dd"));
        request.setJstkrq(DateUtils.format((Date)applyTimeEnd, (String)"yyyy-MM-dd"));
        request.setXhf_nsrsbh(taxNo);
        request.setGhf_nsrsbh(buyertaxno);
        request.setXxbbh(infoCode);
        request.setXzfw((String)this.getModel().getValue("applicantfw"));
        request.setYqzt("N");
        request.setFpzl((String)this.getModel().getValue("invoicetype"));
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
        Resp93007 resp93007 = RedInfoHelper.downloadRedInfo((RedInfoDownloadRequestDTO)request, (long)orgId);
        List pairList = RedInfoHelper.convertResp93007ToDynamicObject((List)resp93007.getHzxxb(), (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")), (String)request.getKjf_sbbh());
        this.handlerPairList(pairList, resp93007.getHzxxb().size());
    }

    private void downloadRedInfoFromHostMode(JSONObject invoiceJson) {
        MsgResponse msgResponse = HostModeInvoiceHelper.redInfoDownload((JSONObject)invoiceJson);
        if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
            Resp93007 resp93007 = (Resp93007)JSONObject.parseObject((String)msgResponse.getRespData(), Resp93007.class);
            if (resp93007.getZjls() == null || resp93007.getZjls() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7ea2\u5b57\u4fe1\u606f\u8868\u6570\u636e", (String)"RedInfoDownloadDialogPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            List pairList = RedInfoHelper.convertResp93007ToDynamicObject((List)resp93007.getHzxxb(), (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")), (String)invoiceJson.getString("jqbh"));
            this.handlerPairList(pairList, resp93007.getHzxxb().size());
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff0c%s", (String)"RedInfoDownloadDialogPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), msgResponse.getErrorMsg()));
        }
    }

    private void handlerPairList(List<Pair<String, List<DynamicObject>>> pairList, int totalSize) {
        int saveSize = 0;
        int updateSize = 0;
        for (Pair<String, List<DynamicObject>> pair : pairList) {
            DynamicObject[] dynamicObjects = ((List)pair.getRight()).toArray(new DynamicObject[0]);
            if ("save".equals(pair.getLeft())) {
                OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_info", (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
                saveSize += dynamicObjects.length;
                continue;
            }
            ImcSaveServiceHelper.save((DynamicObject[])dynamicObjects);
            updateSize += dynamicObjects.length;
        }
        String message = String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\uff0c\u5171\u4e0b\u8f7d%1$s\u6761\uff0c\u65b0\u589e%2$s\u6761\uff0c\u66f4\u65b0%3$s\u6761", (String)"RedInfoDownloadDialogPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), totalSize, saveSize, updateSize);
        this.getView().returnDataToParent((Object)message);
        this.getView().close();
    }
}

