/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.enums.CancelRedEum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.ErrorMsgDTO;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.helper.SimCallBackHelper;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.editorg.EditOrgController;

public class RedInfoListPlugin
extends AbstractListPlugin {
    private static ImmutableMultimap<String, String> BILL_STATUS_OPERATION = new ImmutableMultimap.Builder().putAll((Object)BillStatusEnum.TEMP_SAVE.getCode(), (Object[])new String[]{"btn_modify", "btnrollback", "rollbackori", "btn_revoke"}).putAll((Object)BillStatusEnum.IN_AUDIT.getCode(), (Object[])new String[]{""}).putAll((Object)BillStatusEnum.AUDIT_SUCCESS.getCode(), (Object[])new String[]{"btn_submit", "btn_red"}).putAll((Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode(), (Object[])new String[]{"btn_modify", "btn_submit", "btn_revoke", "btn_red", "btnrollback", "rollbackori"}).build();

    public void setFilter(SetFilterEvent e) {
        QFilter idFilter = new QFilter("infosource", "!=", (Object)"6");
        e.getCustomQFilters().add(idFilter);
    }

    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"close"});
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "btn_add": {
                ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d1\u7968\u57fa\u672c\u4fe1\u606f", (String)"RedInfoListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), null, (String)"sim_red_info_dialog", (String)"sim_red_info_dialog");
                break;
            }
            case "btn_modify": {
                this.updateRedInfo();
                break;
            }
            case "btn_red": {
                this.chechRedInfoSpecialCodeRemark();
                break;
            }
            case "btn_download": {
                ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0b\u8f7d", (String)"RedInfoListPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), null, (String)"sim_red_info_download", (String)"sim_red_info_download");
                break;
            }
            case "btn_import": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_IMPORT);
                TaxUtils.getSaleInfoByOrg();
                ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)"sim_red_info_import", (String)"sim_red_info_import");
                break;
            }
            case "rollbackori": {
                this.preRollBack();
                break;
            }
            case "nextquery": {
                this.nextQuery();
                break;
            }
            case "editOrg": {
                this.editOrg();
                break;
            }
        }
    }

    private void editOrg() {
        Object[] primaryKeyValues = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            return;
        }
        DynamicObject[] redInfos = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"));
        HashSet orgSet = Sets.newHashSetWithExpectedSize((int)1);
        for (DynamicObject redInfo : redInfos) {
            if ("4".equals(redInfo.getString("status"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u5f00\u7968\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539", (String)"RedInfoListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), redInfo.getString("billno")), Integer.valueOf(2000));
                return;
            }
            if (!RedInfoConstant.INFO_SOURCES_ORG_EDITABLE.contains(redInfo.getString("infosource"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6570\u636e\u6765\u6e90\u4e3a\"\u7a0e\u5c40\u4e0b\u8f7d\",\"\u624b\u5de5\u65b0\u589e\",\"\u6279\u91cf\u5bfc\u5165\",\"\u5355\u636e\u624b\u5de5\u8f93\u5165\"\u8fdb\u884c\u4fee\u6539", (String)"RedInfoListPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            orgSet.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)redInfo.get("org")));
        }
        if (orgSet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u76f8\u540c\u4e1a\u52a1\u5355\u5143\u6570\u636e\u8fdb\u884c\u64cd\u4f5c", (String)"RedInfoListPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        PermissionHelper.checkPermission((String)"sim", (String)"sim_red_info", (long)orgSet.toArray(new Long[0])[0], (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_RED_INFO_EDIT_ORG);
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)redInfos[0].get("org"));
        new EditOrgController().openEditOrgView((AbstractFormPlugin)this, orgId, ResManager.loadKDString((String)"\u7ef4\u62a4\u7ec4\u7ec7", (String)"RedInfoListPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
    }

    private void nextQuery() {
        DynamicObject[] invoiceList;
        Object[] primaryKeyValues = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"RedInfoListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)String.join((CharSequence)",", "infocode", "status", "org"), (QFilter[])new QFilter("id", "in", (Object)primaryKeyValues).and("status", "in", (Object)new String[]{"3", "4"}).toArray());
        CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_NEXT_QUERY, (DynamicObject[])redInfos);
        if (redInfos.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u53d1\u7968", (String)"RedInfoListPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Object> successInvIds = new HashSet<Object>(primaryKeyValues.length);
        HashSet<Object> unSuccessInvIds = new HashSet<Object>(primaryKeyValues.length);
        Object[] infoCodes = Stream.of(redInfos).map(redInfo -> redInfo.getString("infocode")).filter(StringUtils::isNotBlank).toArray();
        for (DynamicObject invoice : invoiceList = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"issuestatus", (QFilter[])new QFilter("infocode", "in", (Object)infoCodes).toArray())) {
            if (IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus"))) {
                successInvIds.add(invoice.getPkValue());
                continue;
            }
            unSuccessInvIds.add(invoice.getPkValue());
        }
        if (CollectionUtils.isEmpty(unSuccessInvIds) && CollectionUtils.isEmpty(successInvIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"RedInfoListPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!CollectionUtils.isEmpty(unSuccessInvIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)this, (String)"sim_invoice_wait", unSuccessInvIds);
        }
        if (!CollectionUtils.isEmpty(successInvIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)this, (String)"sim_vatinvoice", successInvIds);
        }
    }

    public void chechRedInfoSpecialCodeRemark() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"RedInfoListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        ErrorMsgDTO errorMsgDTO = BillHelper.checkRedInfoSpecialGoodCodeRemark((ListSelectedRowCollection)rows);
        if (errorMsgDTO != null) {
            String msgKey = "SPECIAL_GOODSCODE_REMARK_CHECK";
            String msg = String.format(ResManager.loadKDString((String)"%s,\u662f\u5426\u8865\u5145?", (String)"RedInfoListPlugin_31", (String)"imc-sim-formplugin", (Object[])new Object[0]), errorMsgDTO.getFailmsg());
            ViewUtil.openConfirm((String)msgKey, (String)msg, (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u8865\u5145", (String)"RedInfoListPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4e0d\u8865\u5145", (String)"RedInfoListPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        } else {
            this.issueRedInvoice();
        }
    }

    private void updateRedInfo() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)rows) || rows.getPrimaryKeyValues().length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c", (String)"RedInfoListPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)rows.get(0).getPrimaryKeyValue(), (String)"sim_red_info");
        PermissionHelper.checkPermission((String)"sim", (String)"sim_red_info", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("org")), (ImcPermItemEnum)ImcPermItemEnum.ITEM_EDIT);
        if ("5".equals(obj.getString("infosource")) || "10".equals(obj.getString("infosource"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u5df2\u5173\u8054\u5f00\u7968\u4e1a\u52a1\u5355\u636e\u4e0d\u80fd\u7f16\u8f91,\u53ef\u4ee5\u70b9\u51fb\u6d41\u6c34\u53f7\u67e5\u770b\u8be6\u60c5", (String)"RedInfoListPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (RedInfoListPlugin.operationRedInfo(obj.getString("billstatus"), "btn_modify")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u5185\u90e8\u5ba1\u6838\u72b6\u6001\u4e3a\u4e0d\u53ef\u7f16\u8f91\u72b6\u6001,\u53ef\u4ee5\u70b9\u51fb\u6d41\u6c34\u53f7\u67e5\u770b\u8be6\u60c5", (String)"RedInfoListPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)obj.getString("infocode"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u672a\u4e0a\u4f20\u201d\u548c\u201c\u5ba1\u6838\u5931\u8d25\u201d\u72b6\u6001\u4e0b\u652f\u6301\u7f16\u8f91", (String)"RedInfoListPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("sim_red_info", rows.get(0).getPrimaryKeyValue());
        ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, (String)("redInfoEdit" + rows.get(0).getPrimaryKeyValue()), (Map)map, (String)"sim_red_info_edit", (String)"sim_red_info_edit", (String)ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u8f91", (String)"RedInfoListPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
    }

    public void issueRedInvoice() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"RedInfoListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] redInfoDynamicObjects = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"));
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_ROLLBACK_1, (DynamicObject[])redInfoDynamicObjects);
        this.checkRedInfo(redInfoDynamicObjects);
        JSONObject param = BotpHelper.cancelOrRedArInvoice((DynamicObject[])redInfoDynamicObjects, (CancelRedEum)CancelRedEum.ISSUE_RED_INFO);
        Object[] primaryKeyValues = rows.getPrimaryKeyValues();
        if (primaryKeyValues.length == 1) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)1);
            map.put("id", rows.get(0).getPrimaryKeyValue());
            ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, null, (Map)map, (String)"sim_red_info_openinvoice", (String)"sim_red_info_openinvoice");
            return;
        }
        Integer billPksSize = param.getInteger("billPksSize");
        if (billPksSize > 0) {
            this.getPageCache().put("cancelOrRedArInvoiceBillPks", param.toJSONString());
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u7ea2\u51b2\u53d1\u7968\u5c06\u51b2\u9500\u5f00\u7968\u7533\u8bf7\u5355\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RedInfoListPlugin_38", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"cancelOrRedArInvoice");
            return;
        }
        boolean showTip = this.isShowArTip(redInfoDynamicObjects);
        HashSet<String> errMsg = new HashSet<String>(redInfoDynamicObjects.length);
        int successNum = 0;
        for (DynamicObject redInfoDynamicObject : redInfoDynamicObjects) {
            RedInfoHelper.queryWaitInvoiceByInfoCodeThenDelete((DynamicObject)redInfoDynamicObject);
            DynamicObject invoiceObj = RedInfoHelper.redInfoToInvoice((DynamicObject)redInfoDynamicObject);
            MsgResponse response = IssueInvoiceService.doIssueInvoice((DynamicObject)invoiceObj);
            if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
                JSONObject json = JSONObject.parseObject((String)response.getRespData());
                redInfoDynamicObject.set("invoicecode", json.get((Object)"invoicecode"));
                redInfoDynamicObject.set("invoiceno", json.get((Object)"invoiceno"));
                redInfoDynamicObject.set("status", (Object)"4");
                Object issueTime = json.get((Object)"issuetime");
                if (issueTime == null) {
                    redInfoDynamicObject.set("issuetime", (Object)new Date());
                } else {
                    redInfoDynamicObject.set("issuetime", (Object)IssueInvoiceService.handleIssueTime((String)String.valueOf(json.get((Object)"issuetime"))));
                }
                SaveServiceHelper.update((DynamicObject)redInfoDynamicObject);
                ++successNum;
                continue;
            }
            errMsg.add(response.getErrorMsg());
        }
        this.refreshList();
        if (!CollectionUtils.isEmpty(errMsg)) {
            String errMsgs = String.join((CharSequence)",", errMsg);
            if (showTip && successNum > 0) {
                String msg = ResManager.loadKDString((String)"\u90e8\u5206\u7ea2\u51b2\u5931\u8d25\u539f\u56e0:", (String)"RedInfoListPlugin_37", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                errMsgs = BotpHelper.getRedFiTip() + System.lineSeparator() + msg + errMsgs;
            }
            this.getView().showErrorNotification(String.join((CharSequence)",", errMsgs));
        } else if (showTip && successNum > 0) {
            this.getView().showTipNotification(BotpHelper.getRedFiTip(), Integer.valueOf(8000));
        }
    }

    private boolean isShowArTip(DynamicObject[] redInfoDynamicObjects) {
        boolean showTip = false;
        for (DynamicObject dynamicObject : redInfoDynamicObjects) {
            String errorMsg = InvoiceCheckService.checkParams((DynamicObject)dynamicObject, (boolean)false);
            if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                throw new KDBizException(errorMsg);
            }
            if (showTip || !BotpHelper.isRedConfirmOrInfoNeedShowArTip((DynamicObject)dynamicObject)) continue;
            showTip = true;
        }
        return showTip;
    }

    private void checkRedInfo(DynamicObject[] dynamicObjects) {
        HashSet orgSet = Sets.newHashSetWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dataEntity : dynamicObjects) {
            String jqbh;
            orgSet.add(dataEntity.getDynamicObject("org").getString("id"));
            if (RedInfoListPlugin.operationRedInfo(dataEntity.getString("billstatus"), "btn_red")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7(%1$s)\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u5185\u90e8\u5ba1\u6838\u72b6\u6001\u4e3a%2$s,\u4e0d\u5141\u8bb8\u7ea2\u51b2", (String)"RedInfoListPlugin_32", (String)"imc-sim-formplugin", (Object[])new Object[0]), dataEntity.getString("infoserialno"), RedInfoListPlugin.getRedInfoBillStatuNameByCode(dataEntity.getString("billstatus"))));
            }
            String status = dataEntity.getString("status");
            if ("4".equals(status)) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7{0}\u5df2\u5f00\u7968\uff0c\u65e0\u6cd5\u91cd\u590d\u5f00\u7968", (String)"RedInfoListPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]), dataEntity.getString("infoserialno")));
            }
            if (!"3".equals(dataEntity.getString("status")) || StringUtils.isBlank((CharSequence)dataEntity.getString("infocode"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7[%s]\u672a\u5ba1\u6838\u6210\u529f\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ea2\u51b2", (String)"RedInfoListPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]), dataEntity.getString("infoserialno")));
            }
            String sellerTaxNo = dataEntity.getString("salertaxno");
            if (!EquipmentHelper.isDisableJQBH((Object)sellerTaxNo, (Object)(jqbh = dataEntity.getString("jqbh")))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7\uff1a%1$s\u4e0b\u4e0d\u5b58\u5728\u542f\u7528\u7684\u673a\u5668\u7f16\u53f7[%2$s]\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ea2\u51b2", (String)"RedInfoListPlugin_33", (String)"imc-sim-formplugin", (Object[])new Object[0]), sellerTaxNo, jqbh));
        }
        if (orgSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u6765\u6e90\u4e8e\u591a\u4e2a\u4e0d\u540c\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u9009\u62e9\u540c\u4e00\u6838\u7b97\u7ec4\u7ec7\u7684\u6570\u636e\u64cd\u4f5c", (String)"RedInvoiceTreeListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "btn_submit": 
            case "btn_revoke": {
                if (!CollectionUtils.isEmpty((Collection)result.getAllErrorOrValidateInfo())) {
                    afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
                    long errorSize = result.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).count();
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$s%2$s\u6761\uff0c\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761", (String)"RedInfoListPlugin_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), "btn_revoke".equals(afterDoOperationEventArgs.getOperateKey()) ? ResManager.loadKDString((String)"\u64a4\u9500", (String)"RedInfoListPlugin_23", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0a\u4f20", (String)"RedInfoListPlugin_24", (String)"imc-sim-formplugin", (Object[])new Object[0]), result.getBillCount(), (long)result.getBillCount() - errorSize, errorSize), result.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.joining(System.lineSeparator())), MessageTypes.Default);
                    return;
                }
                this.refreshList();
                break;
            }
            case "trackup": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                BillHelper.trackup((AbstractListPlugin)this, (String)"sim_red_info", (Object[])((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues());
                break;
            }
        }
    }

    private void refreshList() {
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("infoserialno".equals(fieldName)) {
            args.setCancel(true);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow row = billList.getCurrentSelectedRowInfo();
            BillShowParameter listParam = new BillShowParameter();
            listParam.setPkId(row.getPrimaryKeyValue());
            listParam.setStatus(OperationStatus.VIEW);
            listParam.getOpenStyle().setShowType(ShowType.Modal);
            listParam.setFormId("sim_red_info");
            listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sim_red_info"));
            listParam.setCustomParam("billListHyperLinkClick", (Object)"billListHyperLinkClick");
            this.getView().showForm((FormShowParameter)listParam);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        SimCallBackHelper.callBack((AbstractFormPlugin)this, (Object)closedCallBackEvent);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        SimCallBackHelper.callBack((AbstractFormPlugin)this, (Object)e);
    }

    private void preRollBack() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"RedInfoListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] redInfoList = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"));
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_ROLLBACK_1, (DynamicObject[])redInfoList);
        for (DynamicObject obj : redInfoList) {
            if (!"5".equals(obj.getString("infosource")) && !"10".equals(obj.getString("infosource"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7(%s)\uff1a\u4ec5\u4ece\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u8fc7\u6765\uff0c\u4e14\u672a\u83b7\u53d6\u7ea2\u5b57\u7f16\u53f7\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\uff0c\u624d\u5141\u8bb8\u56de\u9000\uff01", (String)"RedInfoListPlugin_25", (String)"imc-sim-formplugin", (Object[])new Object[0]), obj.getString("infoserialno")));
                return;
            }
            if (!"1".equals(obj.getString("status")) && !"2".equals(obj.getString("status"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7(%s)\u5df2\u63d0\u4ea4\u5ba1\u6838\u6216\u5df2\u5f00\u7968\uff0c\u4e0d\u5141\u8bb8\u56de\u9000\uff01", (String)"RedInfoListPlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), obj.getString("infoserialno")));
                return;
            }
            if (!RedInfoListPlugin.operationRedInfo(obj.getString("billstatus"), "rollbackori")) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7(%1$s)\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u5185\u90e8\u5ba1\u6838\u72b6\u6001\u4e3a%2$s,\u4e0d\u5141\u8bb8\u56de\u9000", (String)"RedInfoListPlugin_35", (String)"imc-sim-formplugin", (Object[])new Object[0]), obj.getString("infoserialno"), RedInfoListPlugin.getRedInfoBillStatuNameByCode(obj.getString("billstatus"))));
            return;
        }
        QFilter qFilter = new QFilter("tbillid", "in", (Object)rows.getPrimaryKeyValues()).and("ttable", "=", (Object)"sim_red_info").and("isdelete", "!=", (Object)"Y");
        DynamicObject[] billInvRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"pushtype", (QFilter[])qFilter.toArray());
        if (Stream.of(billInvRelations).anyMatch(relation -> "-1".equals(relation.getString("pushtype")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u76f4\u63a5\u5173\u8054\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u56de\u9000", (String)"RedInfoListPlugin_28", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9%1$s\u6761\u7ea2\u5b57\u4fe1\u606f\u8868,\u5c06\u56de\u9000\u5230%2$s\u5355\u636e,\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"RedInfoListPlugin_36", (String)"imc-sim-formplugin", (Object[])new Object[0]), redInfoList.length, ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355", (String)"RedInfoListPlugin_30", (String)"imc-sim-formplugin", (Object[])new Object[0])), (String)"rollbackori");
    }

    public static String getRedInfoBillStatuNameByCode(String code) {
        BillStatusEnum[] billStatuses = BillStatusEnum.values();
        return Stream.of(billStatuses).filter(statu -> statu.getCode().equals(code)).map(BillStatusEnum::getName).findFirst().orElse("");
    }

    public static boolean operationRedInfo(String billStatus, String itemKey) {
        return !BILL_STATUS_OPERATION.get((Object)billStatus).contains((Object)itemKey);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List listCommonFilterColumns = args.getCommonFilterColumns();
        if (!CollectionUtils.isEmpty((Collection)listCommonFilterColumns)) {
            for (FilterColumn filterColumn : listCommonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!fieldName.startsWith("org") || !(filterColumn instanceof CommonFilterColumn)) continue;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String org = (String)this.getView().getFormShowParameter().getCustomParam("org");
                if (!StringUtils.isNotBlank((CharSequence)org)) continue;
                commonFilterColumn.setDefaultValue(org);
            }
        }
    }
}

