/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo.redinfoprint;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.sim.common.constant.BillConstant;

public class RedInfoPrintPreviewPlugin
extends AbstractPrintServicePlugin {
    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        String dataSourceName = e.getDataSourceName();
        if ("sim_red_info".equals(dataSourceName)) {
            this.rewriteRedInfoData(e);
        } else if ("items".equals(dataSourceName)) {
            this.rewriteRedInfoItemData(e);
        }
    }

    private void rewriteRedInfoData(CustomPrintDataEntitiesArgs e) {
        List redInfoList = e.getDataEntities();
        ArrayList<DynamicObject> newDataEntities = new ArrayList<DynamicObject>();
        Set customFields = e.getCustomFields();
        DynamicObjectType redInfoEntityType = (DynamicObjectType)((DynamicObject)redInfoList.get(0)).getDataEntityType();
        for (DynamicObject redInfo : redInfoList) {
            try {
                DynamicObjectType newEntityType = this.createCustomField(redInfoEntityType, customFields);
                DynamicObject newRedInfo = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityType)newEntityType, (Object)redInfo);
                this.rewriteRedInfoCustomData(newRedInfo);
                newDataEntities.add(newRedInfo);
            }
            catch (CloneNotSupportedException e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u514b\u9686\u5c5e\u6027\u51fa\u9519\uff01%s", (String)"RedInfoPrintPreviewPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), e1.getMessage()));
            }
            e.setDataEntities(newDataEntities);
        }
    }

    private void rewriteRedInfoCustomData(DynamicObject newRedInfo) {
        boolean isSaler;
        String applicant = newRedInfo.getString("applicant");
        boolean bl = isSaler = RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant) || applicant.contains("\u9500");
        if (isSaler) {
            newRedInfo.set("saler", (Object)"\u221a");
            newRedInfo.set("invoicecode", (Object)"");
            newRedInfo.set("invoiceno", (Object)"");
        } else {
            newRedInfo.set("buyer", (Object)"\u221a");
            if (RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode().equals(applicant) || applicant.contains("\u5df2\u62b5\u6263")) {
                newRedInfo.set("deducted", (Object)"\u221a");
            } else {
                newRedInfo.set("nodeducted", (Object)"\u221a");
            }
            newRedInfo.set("invoicecode", (Object)newRedInfo.getString("originalinvoicecode"));
            newRedInfo.set("invoiceno", (Object)newRedInfo.getString("originalinvoiceno"));
            newRedInfo.set("originalinvoicecode", (Object)"");
            newRedInfo.set("originalinvoiceno", (Object)"");
        }
    }

    public void rewriteRedInfoItemData(CustomPrintDataEntitiesArgs e) {
        try {
            List items2 = e.getDataEntities();
            Set customFields = e.getCustomFields();
            ArrayList<DynamicObject> newDataEntities = new ArrayList<DynamicObject>();
            DynamicObjectType itemEntityType = (DynamicObjectType)((DynamicObject)items2.get(0)).getDataEntityType();
            if (items2.size() > 8) {
                DynamicObjectType newEntityType = this.createCustomField(itemEntityType, customFields);
                DynamicObject newItem = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityType)newEntityType, items2.get(0));
                BigDecimal amount = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                HashSet<String> taxRateSet = new HashSet<String>(16);
                for (DynamicObject item : items2) {
                    amount = amount.add(item.getBigDecimal("amount"));
                    tax = tax.add(item.getBigDecimal("tax"));
                    taxRateSet.add(item.getString("taxrate"));
                }
                newItem.set("goodsname", (Object)BillConstant.TIP_ITEM_DETAIL);
                newItem.set("num", (Object)"");
                newItem.set("specification", (Object)"");
                newItem.set("unit", (Object)"");
                newItem.set("unitprice", (Object)"");
                newItem.set("amount", (Object)amount);
                newItem.set("tax", (Object)tax);
                newItem.set("taxrate", taxRateSet.size() == 1 ? taxRateSet.toArray()[0] : "");
                newItem.set("taxratestr", (Object)newItem.getString("taxrate"));
                newDataEntities.add(newItem);
            } else {
                for (DynamicObject item : items2) {
                    DynamicObjectType fieldEntityType = this.createCustomField(itemEntityType, customFields);
                    DynamicObject newObj = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityType)fieldEntityType, (Object)item);
                    newObj.set("taxratestr", (Object)newObj.getString("taxrate"));
                    newDataEntities.add(newObj);
                }
            }
            e.setDataEntities(newDataEntities);
        }
        catch (CloneNotSupportedException e1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u514b\u9686\u5c5e\u6027\u51fa\u9519\uff01%s", (String)"RedInfoPrintPreviewPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), e1.getMessage()));
        }
    }

    private DynamicObjectType createCustomField(DynamicObjectType itemEntityType, Set<String> customFields) throws CloneNotSupportedException {
        DynamicObjectType newEntityType = (DynamicObjectType)itemEntityType.clone();
        for (String customField : customFields) {
            DynamicSimpleProperty demoProp = new DynamicSimpleProperty(customField, String.class, (Object)"");
            newEntityType.registerSimpleProperty(demoProp);
        }
        return newEntityType;
    }
}

