/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report.plugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.dto.AllEleAccountCheckDto;
import kd.imc.sim.common.dto.allele.AllEleQueryInvoiceBodyDTO;
import kd.imc.sim.common.dto.allele.AllEleQueryInvoiceBodyResponseDTO;
import kd.imc.sim.formplugin.issuing.control.InvoiceQueryControl;
import kd.imc.sim.schedule.report.AllEleInvoiceBodyQueryTask;

public class SimAllEleAccountCheckPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String CHECK_SUCCESS = "1";
    private static final String CHECK_FAIL = "0";
    private static final String REASON_DETAIL_ERROR = "0";
    private static final String REASON_TAX_NOT_EXIST = "1";
    private static final String REASON_DB_NOT_EXIST = "2";
    private static final Log LOGGER = LogFactory.getLog(SimAllEleAccountCheckPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject epInfo;
        long orgPk = RequestContext.get().getOrgId();
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_org", (boolean)true), (QFilter[])new QFilter("id", "=", (Object)orgPk).toArray());
        if (array.length > 0 && null != (epInfo = array[0].getDynamicObject("epinfo"))) {
            this.getModel().setValue("orgname", (Object)array[0]);
            this.getModel().setValue("saler", (Object)epInfo.getString("name"));
            this.getModel().setValue("salertaxno", (Object)epInfo.getString("number"));
        }
        Date today = DateUtils.getDayStart((Date)new Date());
        this.getModel().setValue("starttime", (Object)DateUtils.getFirstDateOfMonth((Date)today));
        this.getModel().setValue("endtime", (Object)today);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("query".equals(itemKey)) {
            try {
                this.checkFilters();
                if (this.checkIsNeedLogin()) {
                    return;
                }
                AllEleInvoiceBodyQueryTask.dispatchTask(this, this.getRequestDto());
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("AllEleAccountCheck" + e.getMessage(), (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u5931\u8d25\uff1a%s", (String)"SimAllEleAccountCheckPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private boolean checkIsNeedLogin() {
        Object taxNo = this.getModel().getValue("salertaxno");
        QFilter qFilter = new QFilter("taxno", "=", taxNo);
        DynamicObject account = BusinessDataServiceHelper.loadSingle((String)"bdm_einvoice_account", (String)"alleinvoiceaccount", (QFilter[])qFilter.toArray());
        if (account == null) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"SimAllEleAccountCheckPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), taxNo));
        }
        HashMap param = Maps.newHashMap();
        param.put("salertaxno", taxNo);
        return AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)param);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if ("dispatchTask".equals(actionId)) {
            try {
                this.dispatchTaskCloseCallback(this, event.getReturnData());
            }
            catch (Exception e) {
                LOGGER.error("dispatchTask" + e.getMessage(), (Throwable)e);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u5931\u8d25\uff1a%s", (String)"SimAllEleAccountCheckPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private void dispatchTaskCloseCallback(SimAllEleAccountCheckPlugin listPlugin, Object returnData) {
        TaskInfo taskInfo;
        Map result = (Map)returnData;
        if (result == null) {
            return;
        }
        String taskInfoStr = (String)result.get("taskinfo");
        if (StringUtils.isNotBlank((CharSequence)taskInfoStr) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotBlank((CharSequence)taskInfo.getData())) {
            Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
            Boolean success = (Boolean)data.get("success");
            if (success.booleanValue()) {
                List responseList = (List)data.get("responseLists");
                List queryInvoices = JSONObject.parseArray((String)JSONObject.toJSONString((Object)responseList), AllEleQueryInvoiceBodyResponseDTO.class);
                DynamicObject[] invoiceArray = this.queryInovicesFromDB();
                Map<String, Object> compareResult = this.compareInvoices(invoiceArray, queryInvoices);
                this.showView(compareResult);
            } else {
                listPlugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u5931\u8d25\uff1a%s", (String)"SimAllEleAccountCheckPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), data.get("errMsg")));
            }
        }
    }

    private void showView(Map<String, Object> compareMap) {
        ArrayList compareResult = (ArrayList)compareMap.get("compareResult");
        int successNum = (Integer)compareMap.get("successNum");
        int failNum = compareResult.size() - successNum;
        String description = String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u6210\u529f\uff1a%1$s\u5f20\u53d1\u7968%2$s\u5bf9\u8d26\u5931\u8d25\uff1a%3$s\u5f20\u53d1\u7968", (String)"SimAllEleAccountCheckPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), successNum, "\t\t\t", failNum);
        Label label = (Label)this.getControl("labelap");
        label.setText(description);
        this.getModel().deleteEntryData("entryentity");
        int size = compareResult.size();
        if (size == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", size);
        int i = 0;
        for (AllEleAccountCheckDto dto : compareResult) {
            this.getModel().setValue("invoiceno", (Object)dto.getInvoiceNo(), i);
            this.getModel().setValue("salername", (Object)dto.getSalerName(), i);
            this.getModel().setValue("org", (Object)dto.getOrg(), i);
            this.getModel().setValue("buyername", (Object)dto.getBuyerName(), i);
            this.getModel().setValue("invoicetype", (Object)dto.getInvoiceType(), i);
            this.getModel().setValue("issuetime", (Object)dto.getIssueTime(), i);
            this.getModel().setValue("totalamount", (Object)dto.getTotalAmount(), i);
            this.getModel().setValue("invoiceamount", (Object)dto.getInvoiceAmount(), i);
            this.getModel().setValue("totaltax", (Object)dto.getTotalTax(), i);
            this.getModel().setValue("checkstatus", (Object)dto.getCheckStatus(), i);
            this.getModel().setValue("failreason", (Object)dto.getFailReason(), i);
            this.getModel().setValue("pdfurl", (Object)dto.getPdfUrl(), i);
            ++i;
        }
    }

    private Map<String, Object> compareInvoices(DynamicObject[] dbInvoices, List<AllEleQueryInvoiceBodyResponseDTO> taxInvoices) {
        HashMap<String, DynamicObject> dbInvoiceMap = new HashMap<String, DynamicObject>(8);
        for (DynamicObject dbInvoice : dbInvoices) {
            dbInvoiceMap.put(dbInvoice.getString("invoiceno"), dbInvoice);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<AllEleAccountCheckDto> compareResult = new ArrayList<AllEleAccountCheckDto>();
        result.put("compareResult", compareResult);
        int successNum = 0;
        for (AllEleQueryInvoiceBodyResponseDTO allEleQueryInvoiceBodyResponseDTO : taxInvoices) {
            String invoiceNo = allEleQueryInvoiceBodyResponseDTO.getInvoiceNo();
            int invoiceType = allEleQueryInvoiceBodyResponseDTO.getInvoiceType();
            String invoiceTypeCode = 27 == invoiceType ? InvoiceType.ALL_E_SPECIAL.getTypeCode() : InvoiceType.ALL_E_NORMAL.getTypeCode();
            DynamicObject invoice = (DynamicObject)dbInvoiceMap.get(invoiceNo);
            AllEleAccountCheckDto compare = new AllEleAccountCheckDto();
            if (null != invoice) {
                boolean isCompareSuccess = this.compareIsSame(invoice, allEleQueryInvoiceBodyResponseDTO);
                String checkStatus = isCompareSuccess ? "1" : "0";
                compare.setInvoiceType(invoice.getString("invoicetype"));
                this.fillCompareFromDBInvoice(invoice, compare, checkStatus);
                if (!isCompareSuccess) {
                    compare.setFailReason("0");
                } else {
                    ++successNum;
                }
                compareResult.add(compare);
            } else {
                compare.setInvoiceType(invoiceTypeCode);
                compare.setOrg(null);
                compare.setTotalTax(allEleQueryInvoiceBodyResponseDTO.getTotalTaxAmount());
                compare.setTotalAmount(allEleQueryInvoiceBodyResponseDTO.getTotalAmount());
                compare.setInvoiceAmount(allEleQueryInvoiceBodyResponseDTO.getInvoiceAmount());
                compare.setCheckStatus("0");
                compare.setBuyerName(allEleQueryInvoiceBodyResponseDTO.getBuyerName());
                compare.setInvoiceNo(allEleQueryInvoiceBodyResponseDTO.getInvoiceNo());
                String invoiceDate = allEleQueryInvoiceBodyResponseDTO.getInvoiceDate();
                compare.setIssueTime(DateUtils.stringToDate((String)invoiceDate, (String)"yyyy-MM-dd HH:mm:ss"));
                compare.setSalerName(allEleQueryInvoiceBodyResponseDTO.getSalerName());
                compareResult.add(compare);
                compare.setFailReason(REASON_DB_NOT_EXIST);
            }
            dbInvoiceMap.remove(invoiceNo);
        }
        if (dbInvoiceMap.size() > 0) {
            for (Map.Entry entry : dbInvoiceMap.entrySet()) {
                DynamicObject invoice = (DynamicObject)entry.getValue();
                AllEleAccountCheckDto compare = new AllEleAccountCheckDto();
                compare.setInvoiceType(invoice.getString("invoicetype"));
                this.fillCompareFromDBInvoice(invoice, compare, "0");
                compare.setFailReason("1");
                compareResult.add(compare);
            }
        }
        result.put("successNum", successNum);
        return result;
    }

    private void fillCompareFromDBInvoice(DynamicObject invoice, AllEleAccountCheckDto compare, String checkStatus) {
        compare.setOrg(invoice.getDynamicObject("orgid"));
        compare.setTotalTax(invoice.getBigDecimal("totaltax"));
        compare.setTotalAmount(invoice.getBigDecimal("totalamount"));
        compare.setInvoiceAmount(invoice.getBigDecimal("invoiceamount"));
        compare.setCheckStatus(checkStatus);
        compare.setBuyerName(invoice.getString("buyername"));
        compare.setInvoiceNo(invoice.getString("invoiceno"));
        compare.setIssueTime(invoice.getDate("issuetime"));
        compare.setSalerName(invoice.getString("salername"));
        compare.setPdfUrl(invoice.getString("pdffileurl"));
    }

    private boolean compareIsSame(DynamicObject invoice, AllEleQueryInvoiceBodyResponseDTO dto) {
        try {
            String buyerTaxNo;
            String dbBuyerTaxNo;
            if (StringUtils.equals((CharSequence)invoice.getString("buyerproperty"), (CharSequence)"0") && !Objects.equals(dbBuyerTaxNo = invoice.getString("buyertaxno"), buyerTaxNo = dto.getBuyerTaxNo())) {
                return false;
            }
            String dbIssueTime = DateUtils.format((Date)invoice.getDate("issuetime"), (String)"yyyy-MM-dd");
            String invoiceDate = dto.getInvoiceDate();
            if (StringUtils.isNotBlank((CharSequence)invoiceDate) && invoiceDate.length() >= 10) {
                invoiceDate = invoiceDate.substring(0, 10);
            }
            if (!Objects.equals(dbIssueTime, invoiceDate)) {
                return false;
            }
            BigDecimal totalAmount = dto.getTotalAmount();
            BigDecimal dbTotalAmount = invoice.getBigDecimal("totalamount");
            if (dbTotalAmount.compareTo(totalAmount) != 0) {
                return false;
            }
            BigDecimal totalTax = dto.getTotalTaxAmount();
            BigDecimal dbTotalTax = invoice.getBigDecimal("totaltax");
            if (dbTotalTax.compareTo(totalTax) != 0) {
                return false;
            }
            String buyerName = dto.getBuyerName();
            String dbBuyerName = invoice.getString("buyername");
            if (StringUtils.isNotBlank((CharSequence)buyerName)) {
                buyerName = buyerName.replace("\uff08\u4e2a\u4eba\uff09", "");
            }
            if (StringUtils.isNotBlank((CharSequence)dbBuyerName)) {
                dbBuyerName = dbBuyerName.replace("\uff08\u4e2a\u4eba\uff09", "");
            }
            if (!dbBuyerName.equals(buyerName)) {
                return false;
            }
            BigDecimal invoiceAmount = dto.getInvoiceAmount();
            BigDecimal dbInvoiceAmount = invoice.getBigDecimal("invoiceamount");
            return dbInvoiceAmount.compareTo(invoiceAmount) == 0;
        }
        catch (Exception e) {
            LOGGER.error("compareIsSame" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void checkFilters() {
        IDataModel model = this.getModel();
        Object org = model.getValue("orgname");
        if (null == org) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5fc5\u586b", (String)"SimAllEleAccountCheckPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        Object salertaxno = model.getValue("salertaxno");
        Object startTime = model.getValue("starttime");
        if (startTime == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u586b", (String)"SimAllEleAccountCheckPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        Object endTime = model.getValue("endtime");
        if (endTime == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u586b", (String)"SimAllEleAccountCheckPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)salertaxno)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u4e3a\u7ed1\u5b9a\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"SimAllEleAccountCheckPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        Date startDate = (Date)startTime;
        Date endDate = (Date)endTime;
        int differenceDay = DateUtils.timeDifferenceDay((Date)startDate, (Date)endDate);
        if (differenceDay > 31) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u95f4\u9694\u6700\u5927\u4e3a31\u5929", (String)"SimAllEleAccountCheckPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        Object invoiceTypeIntValue = this.getModel().getValue("invoicetypeintvalue");
        if (StringUtils.isBlank((Object)invoiceTypeIntValue)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u5fc5\u586b", (String)"SimAllEleAccountCheckPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public DynamicObject[] queryInovicesFromDB() {
        Object org = this.getModel().getValue("orgName");
        Date endTime = (Date)this.getModel().getValue("endtime");
        QFilter filter = new QFilter("issuetime", ">=", this.getModel().getValue("starttime")).and("issuetime", "<", (Object)DateUtils.addDay((Date)endTime, (int)1)).and("orgid", "=", ((DynamicObject)org).getPkValue()).and("invoicetype", "=", this.getModel().getValue("invoicetypeintvalue"));
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])filter.toArray());
    }

    private AllEleQueryInvoiceBodyDTO getRequestDto() {
        AllEleQueryInvoiceBodyDTO bodyDto = new AllEleQueryInvoiceBodyDTO();
        Date endTime = (Date)this.getModel().getValue("endtime");
        Date startTime = (Date)this.getModel().getValue("starttime");
        String endStr = DateUtils.format((Date)endTime, (String)"yyyy-MM-dd");
        String startStr = DateUtils.format((Date)startTime, (String)"yyyy-MM-dd");
        bodyDto.setStartDate(startStr);
        bodyDto.setEndDate(endStr);
        Object invoiceType = this.getModel().getValue("invoicetypeintvalue");
        int invoiceTypeIntValue = InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType) ? 27 : 26;
        bodyDto.setInvoiceType(invoiceTypeIntValue);
        Object salertaxno = this.getModel().getValue("salertaxno");
        bodyDto.setSellerTaxNo((String)salertaxno);
        bodyDto.setRequest_path(AllEleInterfaceTypeEnum.PAGE_QUERY_INVOICE_BODY.getRequestPath());
        return bodyDto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        String pdfUrl = (String)this.getModel().getValue("pdfurl", rowIndex);
        if (StringUtils.isNotBlank((CharSequence)pdfUrl)) {
            this.getView().openUrl(AwsFpyService.replaceUrl((String)pdfUrl));
            return;
        }
        String invoiceNo = (String)this.getModel().getValue("invoiceno", rowIndex);
        String checkStatus = (String)this.getModel().getValue("checkstatus", rowIndex);
        String failReason = (String)this.getModel().getValue("failreason", rowIndex);
        Date issueTime = (Date)this.getModel().getValue("issuetime", rowIndex);
        String sellerTaxNo = (String)this.getModel().getValue("salertaxno", rowIndex);
        if ("1".equals(checkStatus) || "1".equals(failReason)) {
            QFilter filter = new QFilter("invoiceno", "=", (Object)invoiceNo);
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])filter.toArray());
            if (array.length <= 0) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u53d1\u7968\uff1a%s", (String)"SimAllEleAccountCheckPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceNo));
            InvoiceQueryControl.showInvoiceView((AbstractFormPlugin)this, (DynamicObject)array[0]);
            return;
        } else {
            if (this.checkIsNeedLogin()) {
                return;
            }
            DynamicObject invoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            invoice.set("invoiceno", (Object)invoiceNo);
            invoice.set("issuetime", (Object)issueTime);
            invoice.set("salertaxno", (Object)sellerTaxNo);
            pdfUrl = InvoiceQueryControl.queryUrl((DynamicObject)invoice, (int)2);
            this.getModel().setValue("pdfurl", (Object)pdfUrl, rowIndex);
            if (StringUtils.isNotBlank((CharSequence)pdfUrl)) {
                this.getView().openUrl(AwsFpyService.replaceUrl((String)pdfUrl));
                return;
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u53d1\u7968\u6587\u4ef6\u5730\u5740", (String)"SimAllEleAccountCheckPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("orgname".equals(e.getProperty().getName())) {
            DynamicObject org = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (org != null) {
                DynamicObject epInfo = (org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"epinfo", (QFilter[])new QFilter("id", "=", org.getPkValue()).toArray())).getDynamicObject("epinfo");
                if (null != epInfo) {
                    Object name = epInfo.get("name");
                    Object taxNo = epInfo.get("number");
                    this.getModel().setValue("saler", name);
                    this.getModel().setValue("salertaxno", taxNo);
                }
                return;
            }
            this.getModel().setValue("saler", null);
            this.getModel().setValue("salertaxno", null);
        }
    }
}

