/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.util.DBUtils;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.imc.sim.formplugin.report.AbstractReportDataPlugin;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;

public class SimGoldenTaxReportDataPlugin
extends AbstractReportDataPlugin
implements SimFormPluginConstellationUntrans {
    private static final Log LOGGER = LogFactory.getLog(SimGoldenTaxReportDataPlugin.class);
    private static String[] invoiceType = new String[]{"0", "2", "51", "61"};
    private static String[] groupBySellerNameAndTaxNo = new String[]{"salername", "salertaxno"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        JSONObject goldenInvoice;
        Boolean equipmentno;
        String jqbh;
        QFilter qFilter = this.initFilters(reportQueryParam);
        QFilter nullFilter = new QFilter("id", "=", (Object)RequestContext.get().getOrgId());
        DataSet tempDataset = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bdm_org", (String)"id", (QFilter[])nullFilter.toArray(), null);
        tempDataset = tempDataset.groupBy(new String[]{"id"}).count().finish();
        if (this.orgIdsSet.isEmpty()) {
            LOGGER.error("\u91d1\u7a0e\u53d1\u7968\u7edf\u8ba1\uff1a\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a");
            return tempDataset.select("'\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a' as countname,0 as sourcecloud,0 as sourcegolden,0 as datadiffer");
        }
        Long origid = (Long)this.orgIdsSet.iterator().next();
        QFilter filter = new QFilter("id", "=", (Object)origid);
        DynamicObject orgDy = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_org", (boolean)true), (QFilter[])filter.toArray());
        if (orgDy == null) {
            LOGGER.error("\u91d1\u7a0e\u53d1\u7968\u7edf\u8ba1\uff1aorigid = " + origid + " \u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7");
            return tempDataset.select("'\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7' as countname,0 as sourcecloud,0 as sourcegolden,0 as datadiffer");
        }
        QFilter issueDeviceFilter = this.initIssueDeviceFilter(reportQueryParam.getFilter());
        if (null == issueDeviceFilter) {
            DynamicObject defaultDev = EquipmentUtil.getDefaultDev((Long)origid);
            if (null == defaultDev) {
                LOGGER.error("\u91d1\u7a0e\u53d1\u7968\u7edf\u8ba1\uff1aorigid = " + origid + " \u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u5f00\u7968\u8bbe\u5907");
                return tempDataset.select("'\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u5f00\u7968\u8bbe\u5907' as countname,0 as sourcecloud,0 as sourcegolden,0 as datadiffer");
            }
            jqbh = defaultDev.getString("defaultDev");
            equipmentno = EquipmentHelper.isDevOnline((String)jqbh);
            if (!equipmentno.booleanValue()) {
                LOGGER.error("\u91d1\u7a0e\u53d1\u7968\u7edf\u8ba1\uff1aorigid = " + origid + " \u7ec4\u7ec7\u9ed8\u8ba4\u8bbe\u5907" + jqbh + "\u4e0d\u5728\u7ebf");
                return tempDataset.select("'\u7ec4\u7ec7\u9ed8\u8ba4\u8bbe\u5907[" + jqbh + "]\u4e0d\u5728\u7ebf'" + " as countname,0 as sourcecloud,0 as sourcegolden,0 as datadiffer");
            }
        } else {
            jqbh = reportQueryParam.getFilter().getString("issuedevice");
            BigDecimal itemsMaxTaxDiff = new BillMergeHelper().getItemsMaxTaxDiff(jqbh);
            if (!itemsMaxTaxDiff.toPlainString().equals("0.06")) {
                LOGGER.error("\u91d1\u7a0e\u53d1\u7968\u7edf\u8ba1\uff1a\u76d8\u7c7b\u578b\uff1a0.06\u822a\u4fe1\u76d8\u30020.01\u767e\u671b\u548cUKey  " + itemsMaxTaxDiff);
                return tempDataset.select("'\u6682\u4e0d\u652f\u6301\u767e\u671b\u76d8\uff0c\u7a0e\u52a1UKey\u5bf9\u8d26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9' as countname,0 as sourcecloud,0 as sourcegolden,0 as datadiffer");
            }
            equipmentno = EquipmentHelper.isDevOnline((String)jqbh);
            if (!equipmentno.booleanValue()) {
                LOGGER.error("\u91d1\u7a0e\u53d1\u7968\u7edf\u8ba1\uff1aorigid = " + origid + " \u7ec4\u7ec7\u5f53\u524d\u9009\u62e9\u8bbe\u5907" + jqbh + "\u4e0d\u5728\u7ebf");
                return tempDataset.select("'\u7ec4\u7ec7\u5f53\u524d\u9009\u62e9\u8bbe\u5907[" + jqbh + "]\u4e0d\u5728\u7ebf'" + " as countname,0 as sourcecloud,0 as sourcegolden,0 as datadiffer");
            }
        }
        if (!(goldenInvoice = this.queryInvoiceFromCompent(reportQueryParam, jqbh)).getString("errcode").equals("0000")) {
            LOGGER.error("\u91d1\u7a0e\u53d1\u7968\u7edf\u8ba1\uff1aorigid = " + origid + " \u7ec4\u7ec7\u67e5\u8be2\u91d1\u7a0e\u53d1\u7968\u5931\u8d25:" + goldenInvoice.getString("errMsg"));
            return tempDataset.select("'\u67e5\u8be2\u91d1\u7a0e\u53d1\u7968\u5931\u8d25' as countname,0 as sourcecloud,0 as sourcegolden,0 as datadiffer");
        }
        JSONObject data = goldenInvoice.getJSONObject("data");
        Integer goldenInvoiceNo = data.getInteger("goldenInvoiceNo");
        Integer goldenBlueInvoiceNo = data.getInteger("goldenBlueInvoiceNo");
        Integer goldenRedInvoiceNo = data.getInteger("goldenRedInvoiceNo");
        Integer goldenBlueAbolishInvoiceNo = data.getInteger("goldenBlueAbolishInvoiceNo");
        Integer goldenRedAbolishInvoiceNo = data.getInteger("goldenRedAbolishInvoiceNo");
        BigDecimal goldenInvoiceAmount = data.getBigDecimal("goldenInvoiceAmount");
        BigDecimal goldenBlueInvoiceAmount = data.getBigDecimal("goldenBlueInvoiceAmount");
        BigDecimal goldenRedInvoiceAmount = data.getBigDecimal("goldenRedInvoiceAmount");
        BigDecimal goldenBlueAbolishInvoiceAmount = data.getBigDecimal("goldenBlueAbolishInvoiceAmount");
        BigDecimal goldenRedAbolishInvoiceAmount = data.getBigDecimal("goldenRedAbolishInvoiceAmount");
        BigDecimal goldenInvoiceTax = data.getBigDecimal("goldenInvoiceTax");
        BigDecimal goldenBlueInvoiceTax = data.getBigDecimal("goldenBlueInvoiceTax");
        BigDecimal goldenRedInvoiceTax = data.getBigDecimal("goldenRedInvoiceTax");
        BigDecimal goldenBlueAbolishInvoiceTax = data.getBigDecimal("goldenBlueAbolishInvoiceTax");
        BigDecimal goldenRedAbolishInvoiceTax = data.getBigDecimal("goldenRedAbolishInvoiceTax");
        try {
            DataSet resultDataSet;
            qFilter.and("issuestatus", "=", (Object)"0");
            qFilter.and("buyertype", "not in", (Object)new String[]{"8", "9", "10"});
            String currentFiled = DBUtils.getQueryFields((String[])new String[]{"salername", "salertaxno", "orderno", "orgid", "totalamount", "invoiceamount", "totaltax", "issuetype", "invoicestatus"});
            DataSet allDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sim_vatinvoice", (String)currentFiled, (QFilter[])new QFilter[]{qFilter}, null);
            if (allDataSet.isEmpty()) {
                resultDataSet = tempDataset.select("'\u6b63\u6570\u53d1\u7968\u4efd\u6570' as countname,0 as sourcecloud," + goldenBlueInvoiceNo + " as sourcegolden,0-" + goldenBlueInvoiceNo + " as datadiffer");
                resultDataSet = resultDataSet.union(tempDataset.select("'\u8d1f\u6570\u53d1\u7968\u4efd\u6570' as countname,0 as sourcecloud," + goldenRedInvoiceNo + " as sourcegolden,0-" + goldenRedInvoiceNo + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u6b63\u6570\u5e9f\u7968\u4efd\u6570' as countname,0 as sourcecloud," + goldenBlueAbolishInvoiceNo + " as sourcegolden,0-" + goldenBlueAbolishInvoiceNo + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u8d1f\u6570\u5e9f\u7968\u4efd\u6570' as countname,0 as sourcecloud," + goldenRedAbolishInvoiceNo + " as sourcegolden,0-" + goldenRedAbolishInvoiceNo + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u5b9e\u9645\u53d1\u7968\u4efd\u6570' as countname,0 as sourcecloud," + goldenInvoiceNo + " as sourcegolden,0-" + goldenInvoiceNo + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u9500\u9879\u6b63\u6570\u91d1\u989d' as countname,0 as sourcecloud," + goldenBlueInvoiceAmount + " as sourcegolden,0-" + goldenBlueInvoiceAmount + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u9500\u9879\u8d1f\u6570\u91d1\u989d' as countname,0 as sourcecloud,-" + goldenRedInvoiceAmount + " as sourcegolden,0+" + goldenRedInvoiceAmount + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u9500\u9879\u6b63\u5e9f\u91d1\u989d' as countname,0 as sourcecloud," + goldenBlueAbolishInvoiceAmount + " as sourcegolden,0-" + goldenBlueAbolishInvoiceAmount + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u9500\u9879\u8d1f\u5e9f\u91d1\u989d' as countname,0 as sourcecloud,-" + goldenRedAbolishInvoiceAmount + " as sourcegolden,0+" + goldenRedAbolishInvoiceAmount + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u5b9e\u9645\u9500\u552e\u91d1\u989d' as countname,0 as sourcecloud," + goldenInvoiceAmount + " as sourcegolden,0-" + goldenInvoiceAmount + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u9500\u9879\u6b63\u6570\u7a0e\u989d' as countname,0 as sourcecloud," + goldenBlueInvoiceTax + " as sourcegolden,0-" + goldenBlueInvoiceTax + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u9500\u9879\u8d1f\u6570\u7a0e\u989d' as countname,0 as sourcecloud,-" + goldenRedInvoiceTax + " as sourcegolden,0+" + goldenRedInvoiceTax + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u9500\u9879\u6b63\u5e9f\u7a0e\u989d' as countname,0 as sourcecloud," + goldenBlueAbolishInvoiceTax + " as sourcegolden,0-" + goldenBlueAbolishInvoiceTax + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u9500\u9879\u8d1f\u5e9f\u7a0e\u989d' as countname,0 as sourcecloud,-" + goldenRedAbolishInvoiceTax + " as sourcegolden,0+" + goldenRedAbolishInvoiceTax + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u5b9e\u9645\u9500\u552e\u7a0e\u989d' as countname,0 as sourcecloud," + goldenInvoiceTax + " as sourcegolden,0-" + goldenInvoiceTax + " as datadiffer"));
                resultDataSet = resultDataSet.union(tempDataset.select("'\u4ef7\u7a0e\u5408\u8ba1\u7edf\u8ba1' as countname,0 as sourcecloud," + goldenInvoiceAmount.add(goldenInvoiceTax) + " as sourcegolden,0-" + goldenInvoiceAmount.add(goldenInvoiceTax) + " as datadiffer"));
            } else {
                DataSet tempDataSet = allDataSet.copy().groupBy(groupBySellerNameAndTaxNo).count().finish();
                QFilter blueFilter = new QFilter("issuetype", "=", (Object)"0");
                DataSet blueInvoice = allDataSet.copy().filter(blueFilter.toString());
                GroupbyDataSet groupbyBlueInvoice = null;
                if (blueInvoice.isEmpty()) {
                    resultDataSet = tempDataSet.copy().select("'\u6b63\u6570\u53d1\u7968\u4efd\u6570' as countname,0 as sourcecloud," + goldenBlueInvoiceNo + " as sourcegolden,0-" + goldenBlueInvoiceNo + " as datadiffer");
                } else {
                    groupbyBlueInvoice = blueInvoice.copy().groupBy(groupBySellerNameAndTaxNo);
                    resultDataSet = groupbyBlueInvoice.count().finish().select("'\u6b63\u6570\u53d1\u7968\u4efd\u6570' as countname,count as sourcecloud," + goldenBlueInvoiceNo + " as sourcegolden,count-" + goldenBlueInvoiceNo + " as datadiffer");
                }
                QFilter redFilter = new QFilter("issuetype", "=", (Object)"1");
                DataSet redInvoice = allDataSet.copy().filter(redFilter.toString());
                GroupbyDataSet groupbyRedInvoice = null;
                if (redInvoice.isEmpty()) {
                    resultDataSet = resultDataSet.union(tempDataSet.copy().select("'\u8d1f\u6570\u53d1\u7968\u4efd\u6570' as countname,0 as sourcecloud," + goldenRedInvoiceNo + " as sourcegolden,0-" + goldenRedInvoiceNo + " as datadiffer"));
                } else {
                    groupbyRedInvoice = redInvoice.copy().groupBy(groupBySellerNameAndTaxNo);
                    DataSet redInvoiceSum = groupbyRedInvoice.count().finish().select("'\u8d1f\u6570\u53d1\u7968\u4efd\u6570' as countname,count as sourcecloud," + goldenRedInvoiceNo + " as sourcegolden,count-" + goldenRedInvoiceNo + " as datadiffer");
                    resultDataSet = resultDataSet.union(redInvoiceSum);
                }
                QFilter blueAbolishFilter = new QFilter("invoicestatus", "=", (Object)"6").and(blueFilter);
                DataSet blueAbolish = allDataSet.copy().filter(blueAbolishFilter.toString());
                GroupbyDataSet groupbyBlueAbolish = null;
                if (blueAbolish.isEmpty()) {
                    resultDataSet = resultDataSet.union(tempDataSet.copy().select("'\u6b63\u6570\u5e9f\u7968\u4efd\u6570' as countname,0 as sourcecloud," + goldenBlueAbolishInvoiceNo + " as sourcegolden,0-" + goldenBlueAbolishInvoiceNo + " as datadiffer"));
                } else {
                    groupbyBlueAbolish = blueAbolish.copy().groupBy(groupBySellerNameAndTaxNo);
                    DataSet blueAbolishSum = groupbyBlueAbolish.count().finish().select("'\u6b63\u6570\u5e9f\u7968\u4efd\u6570' as countname,count as sourcecloud," + goldenBlueAbolishInvoiceNo + " as sourcegolden,count-" + goldenBlueAbolishInvoiceNo + " as datadiffer");
                    resultDataSet = resultDataSet.union(blueAbolishSum);
                }
                QFilter redAbolishFilter = new QFilter("invoicestatus", "=", (Object)"6").and(redFilter);
                DataSet redAbolish = allDataSet.copy().filter(redAbolishFilter.toString());
                GroupbyDataSet groupbyRedAbolish = null;
                if (redAbolish.isEmpty()) {
                    resultDataSet = resultDataSet.union(tempDataSet.copy().select("'\u8d1f\u6570\u5e9f\u7968\u4efd\u6570' as countname,0 as sourcecloud," + goldenRedAbolishInvoiceNo + " as sourcegolden,0-" + goldenRedAbolishInvoiceNo + " as datadiffer"));
                } else {
                    groupbyRedAbolish = redAbolish.copy().groupBy(groupBySellerNameAndTaxNo);
                    DataSet redAbolishSum = groupbyRedAbolish.count().finish().select("'\u8d1f\u6570\u5e9f\u7968\u4efd\u6570' as countname,count as sourcecloud," + goldenRedAbolishInvoiceNo + " as sourcegolden,count-" + goldenRedAbolishInvoiceNo + " as datadiffer");
                    resultDataSet = resultDataSet.union(redAbolishSum);
                }
                GroupbyDataSet groupbyAllInvoice = allDataSet.copy().groupBy(groupBySellerNameAndTaxNo);
                DataSet allInvoiceSum = groupbyAllInvoice.count().finish().select("'\u5b9e\u9645\u53d1\u7968\u4efd\u6570' as countname,count as sourcecloud," + goldenInvoiceNo + " as sourcegolden,count-" + goldenInvoiceNo + " as datadiffer");
                resultDataSet = resultDataSet.union(allInvoiceSum);
                if (blueInvoice.isEmpty()) {
                    resultDataSet = resultDataSet.union(tempDataSet.copy().select("'\u9500\u9879\u6b63\u6570\u91d1\u989d' as countname,0 as sourcecloud," + goldenBlueInvoiceAmount + " as sourcegolden,0-" + goldenBlueInvoiceAmount + " as datadiffer"));
                } else if (null != groupbyBlueInvoice) {
                    DataSet blueInvoiceAmount = groupbyBlueInvoice.sum("invoiceamount").finish().select("'\u9500\u9879\u6b63\u6570\u91d1\u989d' as countname,invoiceamount as sourcecloud," + goldenBlueInvoiceAmount + " as sourcegolden,invoiceamount-" + goldenBlueInvoiceAmount + " as datadiffer");
                    resultDataSet = resultDataSet.union(blueInvoiceAmount);
                }
                if (redInvoice.isEmpty()) {
                    resultDataSet = resultDataSet.union(tempDataSet.copy().select("'\u9500\u9879\u8d1f\u6570\u91d1\u989d' as countname,0 as sourcecloud,-" + goldenRedInvoiceAmount + " as sourcegolden," + goldenRedInvoiceAmount + " as datadiffer"));
                } else if (null != groupbyRedInvoice) {
                    DataSet redInvoiceAmount = groupbyRedInvoice.sum("invoiceamount").finish().select("'\u9500\u9879\u8d1f\u6570\u91d1\u989d' as countname,invoiceamount as sourcecloud,-" + goldenRedInvoiceAmount + " as sourcegolden,invoiceamount+" + goldenRedInvoiceAmount + " as datadiffer");
                    resultDataSet = resultDataSet.union(redInvoiceAmount);
                }
                if (blueAbolish.isEmpty()) {
                    resultDataSet = resultDataSet.union(tempDataSet.copy().select("'\u9500\u9879\u6b63\u5e9f\u91d1\u989d' as countname,0 as sourcecloud," + goldenBlueAbolishInvoiceAmount + " as sourcegolden,0-" + goldenBlueAbolishInvoiceAmount + " as datadiffer"));
                } else if (null != groupbyBlueAbolish) {
                    DataSet blueAbolishAmount = groupbyBlueAbolish.sum("invoiceamount").finish().select("'\u9500\u9879\u6b63\u5e9f\u91d1\u989d' as countname,invoiceamount as sourcecloud," + goldenBlueAbolishInvoiceAmount + " as sourcegolden,invoiceamount-" + goldenBlueAbolishInvoiceAmount + " as datadiffer");
                    resultDataSet = resultDataSet.union(blueAbolishAmount);
                }
                if (redAbolish.isEmpty()) {
                    resultDataSet = resultDataSet.union(tempDataSet.copy().select("'\u9500\u9879\u8d1f\u5e9f\u91d1\u989d' as countname,0 as sourcecloud,-" + goldenRedAbolishInvoiceAmount + " as sourcegolden," + goldenRedAbolishInvoiceAmount + " as datadiffer"));
                } else if (null != groupbyRedAbolish) {
                    DataSet redAbolishAmount = groupbyRedAbolish.sum("invoiceamount").finish().select("'\u9500\u9879\u8d1f\u5e9f\u91d1\u989d' as countname,invoiceamount as sourcecloud,-" + goldenRedAbolishInvoiceAmount + " as sourcegolden,invoiceamount+" + goldenRedAbolishInvoiceAmount + " as datadiffer");
                    resultDataSet = resultDataSet.union(redAbolishAmount);
                }
                QFilter actAmountFilter1 = new QFilter("issuetype", "=", (Object)"0").and("invoicestatus", "=", (Object)"0");
                QFilter actAmountFilter2 = new QFilter("issuetype", "=", (Object)"1").and("invoicestatus", "=", (Object)"0");
                DataSet filter1 = allDataSet.copy().filter(actAmountFilter1.toString());
                DataSet filter2 = allDataSet.copy().filter(actAmountFilter2.toString());
                DataSet countUnion = filter1.union(filter2);
                GroupbyDataSet actAmountDataSet = countUnion.copy().groupBy(groupBySellerNameAndTaxNo);
                DataSet allInvoiceAmount = null != actAmountDataSet ? actAmountDataSet.sum("invoiceamount").finish().select("'\u5b9e\u9645\u9500\u552e\u91d1\u989d' as countname,invoiceamount as sourcecloud," + goldenInvoiceAmount + " as sourcegolden,invoiceamount-" + goldenInvoiceAmount + " as datadiffer") : tempDataSet.copy().select("'\u5b9e\u9645\u9500\u552e\u91d1\u989d' as countname,0 as sourcecloud,-" + goldenInvoiceAmount + " as sourcegolden," + goldenInvoiceAmount + " as datadiffer");
                resultDataSet = resultDataSet.union(allInvoiceAmount);
                if (blueInvoice.isEmpty()) {
                    resultDataSet = resultDataSet.union(tempDataSet.copy().select("'\u9500\u9879\u6b63\u6570\u7a0e\u989d' as countname,0 as sourcecloud," + goldenBlueInvoiceTax + " as sourcegolden,0-" + goldenBlueInvoiceTax + " as datadiffer"));
                } else if (null != groupbyBlueInvoice) {
                    DataSet blueInvoiceTax = groupbyBlueInvoice.sum("totaltax").finish().select("'\u9500\u9879\u6b63\u6570\u7a0e\u989d' as countname,totaltax as sourcecloud," + goldenBlueInvoiceTax + " as sourcegolden,totaltax-" + goldenBlueInvoiceTax + " as datadiffer");
                    resultDataSet = resultDataSet.union(blueInvoiceTax);
                }
                if (redInvoice.isEmpty()) {
                    resultDataSet = resultDataSet.union(tempDataSet.copy().select("'\u9500\u9879\u8d1f\u6570\u7a0e\u989d' as countname,0 as sourcecloud,-" + goldenRedInvoiceTax + " as sourcegolden," + goldenRedInvoiceTax + " as datadiffer"));
                } else if (null != groupbyRedInvoice) {
                    DataSet redInvoiceTax = groupbyRedInvoice.sum("totaltax").finish().select("'\u9500\u9879\u8d1f\u6570\u7a0e\u989d' as countname,totaltax as sourcecloud,-" + goldenRedInvoiceTax + " as sourcegolden,totaltax+" + goldenRedInvoiceTax + " as datadiffer");
                    resultDataSet = resultDataSet.union(redInvoiceTax);
                }
                if (blueAbolish.isEmpty()) {
                    resultDataSet = resultDataSet.union(tempDataSet.copy().select("'\u9500\u9879\u6b63\u5e9f\u7a0e\u989d' as countname,0 as sourcecloud," + goldenBlueAbolishInvoiceTax + " as sourcegolden,0-" + goldenBlueAbolishInvoiceTax + " as datadiffer"));
                } else if (null != groupbyBlueAbolish) {
                    DataSet blueAbolishTax = groupbyBlueAbolish.sum("totaltax").finish().select("'\u9500\u9879\u6b63\u5e9f\u7a0e\u989d' as countname,totaltax as sourcecloud," + goldenBlueAbolishInvoiceTax + " as sourcegolden,totaltax-" + goldenBlueAbolishInvoiceTax + " as datadiffer");
                    resultDataSet = resultDataSet.union(blueAbolishTax);
                }
                if (redAbolish.isEmpty()) {
                    resultDataSet = resultDataSet.union(tempDataSet.copy().select("'\u9500\u9879\u8d1f\u5e9f\u7a0e\u989d' as countname,0 as sourcecloud,-" + goldenRedAbolishInvoiceTax + " as sourcegolden," + goldenRedAbolishInvoiceTax + " as datadiffer"));
                } else if (null != groupbyRedAbolish) {
                    DataSet redAbolishTax = groupbyRedAbolish.sum("totaltax").finish().select("'\u9500\u9879\u8d1f\u5e9f\u7a0e\u989d' as countname,totaltax as sourcecloud,-" + goldenRedAbolishInvoiceTax + " as sourcegolden,totaltax+" + goldenRedAbolishInvoiceTax + " as datadiffer");
                    resultDataSet = resultDataSet.union(redAbolishTax);
                }
                GroupbyDataSet actTaxDataSet = countUnion.copy().groupBy(groupBySellerNameAndTaxNo);
                DataSet allInvoiceTax = null != actTaxDataSet ? actTaxDataSet.sum("totaltax").finish().select("'\u5b9e\u9645\u9500\u552e\u7a0e\u989d' as countname,totaltax as sourcecloud," + goldenInvoiceTax + " as sourcegolden,totaltax-" + goldenInvoiceTax + " as datadiffer") : tempDataSet.copy().select("'\u5b9e\u9645\u9500\u552e\u7a0e\u989d' as countname,0 as sourcecloud,-" + goldenInvoiceTax + " as sourcegolden," + goldenInvoiceTax + " as datadiffer");
                resultDataSet = resultDataSet.union(allInvoiceTax);
                GroupbyDataSet totalAmountDataSet = countUnion.copy().groupBy(groupBySellerNameAndTaxNo);
                DataSet allTotalAmount = totalAmountDataSet.sum("totalamount").finish().select("'\u4ef7\u7a0e\u5408\u8ba1\u7edf\u8ba1' as countname,totalamount as sourcecloud," + goldenInvoiceAmount.add(goldenInvoiceTax) + " as sourcegolden,totalamount-" + goldenInvoiceAmount.add(goldenInvoiceTax) + " as datadiffer");
                resultDataSet = resultDataSet.union(allTotalAmount);
            }
            return resultDataSet;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private QFilter initFilters(ReportQueryParam param) {
        QFilter sellerTaxNoFilter;
        QFilter sellerNameFilter;
        QFilter orgNameFilter;
        QFilter issueDeviceFilter;
        QFilter invoiceKindFilter;
        FilterInfo filterInfo = param.getFilter();
        Date countdate = filterInfo.getDate("countdate");
        QFilter startFilter = new QFilter("issuetime", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)countdate));
        QFilter endFilter = new QFilter("issuetime", "<", (Object)DateUtils.getLastDateOfMonth((Date)countdate));
        QFilter resultFilter = startFilter.and(endFilter);
        QFilter orgFilter = this.initOrgFilter(filterInfo);
        if (null != orgFilter) {
            resultFilter = resultFilter.and(orgFilter);
        }
        if (null != (invoiceKindFilter = this.initInvoiceKindFilter(filterInfo))) {
            resultFilter = resultFilter.and(invoiceKindFilter);
        }
        if (null != (issueDeviceFilter = this.initIssueDeviceFilter(filterInfo))) {
            resultFilter = resultFilter.and(issueDeviceFilter);
        }
        if (null != (orgNameFilter = this.initOrgNameFilter(filterInfo))) {
            resultFilter = resultFilter.and(orgNameFilter);
        }
        if (null != (sellerNameFilter = this.initSellerNameFilter(filterInfo))) {
            resultFilter = resultFilter.and(sellerNameFilter);
        }
        if (null != (sellerTaxNoFilter = this.initSellerTaxNoFilter(filterInfo))) {
            resultFilter = resultFilter.and(sellerTaxNoFilter);
        }
        QFilter issuedFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        resultFilter = resultFilter.and(issuedFilter);
        return resultFilter;
    }

    private JSONObject queryInvoiceFromCompent(ReportQueryParam param, String jqbh) {
        JSONObject result = JSONObject.parseObject((String)"{}");
        result.put("errcode", (Object)"-1");
        JSONArray respArr = new JSONArray();
        try {
            for (String type : invoiceType) {
                JSONObject reqParam = this.makeJSONRequesParam(param, type);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("\u91d1\u7a0e\u5bf9\u8d26\u7ec4\u4ef6\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\uff1a" + reqParam.toJSONString());
                }
                String componentUrl = ComponentServiceHelper.getComponentRequestUrl((String)jqbh);
                String data = HttpClientUtils.postjson((String)componentUrl, null, (String)reqParam.toJSONString(), (int)120000, (int)120000);
                JSONObject jsonObject = JSONObject.parseObject((String)data);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("\u91d1\u7a0e\u5bf9\u8d26\u67e5\u8be2\u53d1\u7968http\u8bf7\u6c42\u7684\u8fd4\u56de\u6570\u636e\uff1a" + type + ":    " + jsonObject);
                }
                if (!"7011".equals(jsonObject.getString("errcode")) && !"0000".equals(jsonObject.getString("errcode")) && !"0".equals(jsonObject.getString("errcode"))) continue;
                respArr.add((Object)jsonObject);
            }
            result.put("errcode", (Object)"0000");
            result.put("data", (Object)this.getGoldenTaxInvocieInfo(respArr));
        }
        catch (Exception e) {
            LOGGER.error("componentGoldenTaxReportQueryFailed ", (Throwable)e);
            result.put("errcode", (Object)"7777");
            result.put("errMsg", (Object)e.getMessage());
        }
        return result;
    }

    private JSONObject getGoldenTaxInvocieInfo(JSONArray respArr) {
        Integer goldenBlueInvoiceNo = 0;
        Integer goldenRedInvoiceNo = 0;
        Integer goldenBlueAbolishInvoiceNo = 0;
        Integer goldenRedAbolishInvoiceNo = 0;
        BigDecimal goldenBlueInvoiceAmount = BigDecimal.ZERO;
        BigDecimal goldenRedInvoiceAmount = BigDecimal.ZERO;
        BigDecimal goldenBlueAbolishInvoiceAmount = BigDecimal.ZERO;
        BigDecimal goldenRedAbolishInvoiceAmount = BigDecimal.ZERO;
        BigDecimal goldenInvoiceAmount = BigDecimal.ZERO;
        BigDecimal goldenBlueInvoiceTax = BigDecimal.ZERO;
        BigDecimal goldenRedInvoiceTax = BigDecimal.ZERO;
        BigDecimal goldenBlueAbolishInvoiceTax = BigDecimal.ZERO;
        BigDecimal goldenRedAbolishInvoiceTax = BigDecimal.ZERO;
        BigDecimal goldenInvoiceTax = BigDecimal.ZERO;
        if (respArr.size() > 0) {
            for (Object o : respArr) {
                JSONObject jsonObject = (JSONObject)o;
                JSONObject goldenInvoice = jsonObject.getJSONObject("sjd");
                goldenBlueInvoiceNo = goldenBlueInvoiceNo + goldenInvoice.getInteger("zsfpfs");
                goldenRedInvoiceNo = goldenRedInvoiceNo + goldenInvoice.getInteger("fsfpfs");
                goldenBlueAbolishInvoiceNo = goldenBlueAbolishInvoiceNo + goldenInvoice.getInteger("zffpfs");
                goldenRedAbolishInvoiceNo = goldenRedAbolishInvoiceNo + goldenInvoice.getInteger("fffpfs");
                goldenBlueInvoiceAmount = goldenBlueInvoiceAmount.add(goldenInvoice.getBigDecimal("zsfpljje"));
                goldenRedInvoiceAmount = goldenRedInvoiceAmount.add(goldenInvoice.getBigDecimal("fsfpljje"));
                goldenBlueAbolishInvoiceAmount = goldenBlueAbolishInvoiceAmount.add(goldenInvoice.getBigDecimal("zffpljje"));
                goldenRedAbolishInvoiceAmount = goldenRedAbolishInvoiceAmount.add(goldenInvoice.getBigDecimal("fffpljje"));
                goldenInvoiceAmount = goldenInvoiceAmount.add(goldenInvoice.getBigDecimal("sjxsje"));
                goldenBlueInvoiceTax = goldenBlueInvoiceTax.add(goldenInvoice.getBigDecimal("zsfpljse"));
                goldenRedInvoiceTax = goldenRedInvoiceTax.add(goldenInvoice.getBigDecimal("fsfpljse"));
                goldenBlueAbolishInvoiceTax = goldenBlueAbolishInvoiceTax.add(goldenInvoice.getBigDecimal("zffpljse"));
                goldenRedAbolishInvoiceTax = goldenRedAbolishInvoiceTax.add(goldenInvoice.getBigDecimal("fffpljse"));
                goldenInvoiceTax = goldenInvoiceTax.add(goldenInvoice.getBigDecimal("sjxsse"));
            }
        }
        JSONObject result = JSONObject.parseObject((String)"{}");
        result.put("goldenBlueInvoiceNo", (Object)goldenBlueInvoiceNo);
        result.put("goldenRedInvoiceNo", (Object)goldenRedInvoiceNo);
        result.put("goldenBlueAbolishInvoiceNo", (Object)goldenBlueAbolishInvoiceNo);
        result.put("goldenRedAbolishInvoiceNo", (Object)goldenRedAbolishInvoiceNo);
        result.put("goldenInvoiceNo", (Object)(goldenBlueInvoiceNo + goldenRedInvoiceNo));
        result.put("goldenBlueInvoiceAmount", (Object)goldenBlueInvoiceAmount);
        result.put("goldenRedInvoiceAmount", (Object)goldenRedInvoiceAmount);
        result.put("goldenBlueAbolishInvoiceAmount", (Object)goldenBlueAbolishInvoiceAmount);
        result.put("goldenRedAbolishInvoiceAmount", (Object)goldenRedAbolishInvoiceAmount);
        result.put("goldenInvoiceAmount", (Object)goldenInvoiceAmount);
        result.put("goldenBlueInvoiceTax", (Object)goldenBlueInvoiceTax);
        result.put("goldenRedInvoiceTax", (Object)goldenRedInvoiceTax);
        result.put("goldenBlueAbolishInvoiceTax", (Object)goldenBlueAbolishInvoiceTax);
        result.put("goldenRedAbolishInvoiceTax", (Object)goldenRedAbolishInvoiceTax);
        result.put("goldenInvoiceTax", (Object)goldenInvoiceTax);
        return result;
    }

    private JSONObject makeJSONRequesParam(ReportQueryParam param, String invoiceType) {
        FilterInfo filterInfo = param.getFilter();
        String yyyymm = DateUtils.format((Date)filterInfo.getDate("countdate"), (String)"YYYYMM");
        JSONObject reqParam = JSONObject.parseObject((String)"{}");
        JSONObject sjd = JSONObject.parseObject((String)"{}");
        reqParam.put("czlx", (Object)"56");
        reqParam.put("hxbzdh", (Object)"");
        reqParam.put("sjd", (Object)sjd);
        sjd.put("fplx", (Object)invoiceType);
        sjd.put("nf", (Object)yyyymm.substring(0, 4));
        sjd.put("yf", (Object)yyyymm.substring(4, 6));
        return reqParam;
    }
}

