/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report.plugin;

import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.sim.formplugin.report.AbstractReportDataPlugin;

public class SimGoodsReportDataPlugin
extends AbstractReportDataPlugin {
    private static final Log LOGGER = LogFactory.getLog(SimGoodsReportDataPlugin.class);
    private DataSet totallize = null;

    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        try {
            String fields = "id,items.goodsname,items.specification,items.unit,items.amount,items.num,items.tax,items.taxrate,items.taxamount,orgid,issuetime";
            QFilter filters = this.initFilters(param);
            DataSet set = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sim_vatinvoice", (String)fields, (QFilter[])filters.toArray(), null);
            String orgFields = "id,name";
            DataSet resultSet = null;
            if (this.orgIdsSet.isEmpty()) {
                QFilter filter = new QFilter("orgid", "=", (Object)-12344261L);
                return set.filter(filter.toString());
            }
            for (Object orgId : this.orgIdsSet) {
                DataSet copy;
                QFilter idFilter = new QFilter("orgid", "=", orgId);
                DataSet oneOrgResultSet = this.getOneOrgResultSet(orgFields, idFilter, copy = set.copy());
                if (null == oneOrgResultSet) continue;
                if (null == resultSet) {
                    resultSet = oneOrgResultSet;
                    continue;
                }
                resultSet = resultSet.union(oneOrgResultSet);
            }
            if (null != resultSet) {
                resultSet = resultSet.orderBy(new String[]{"bdm_org.name", "order", "items.amount desc", "items.taxrate desc"});
                DataSet totallizeRow = this.totallize.groupBy(new String[]{"totallize"}).sum("items.tax").sum("items.amount").sum("items.num").sum("items.taxamount").sum("orgid").finish();
                DataSet selectLastRow = totallizeRow.select(new String[]{"'' as items.goodsname", "'' as items.specification", "'' as items.unit", "'\u603b\u8ba1' as items.taxrate", "items.amount", "items.num", "items.tax", "items.taxamount", "0 as orgid", "'' as bdm_org.name", "1 as order", "totallize"});
                return resultSet.union(selectLastRow);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private DataSet getOneOrgResultSet(String orgFields, QFilter idFilter, DataSet copy) {
        DataSet oneOrgSet = copy.filter(idFilter.toString());
        oneOrgSet = oneOrgSet.filter("items.goodsname <> null and items.goodsname <> ''");
        DataSet orgSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bdm_org", (String)orgFields, null, null);
        GroupbyDataSet gSet = oneOrgSet.groupBy(new String[]{"orgid", "items.goodsname", "items.specification", "items.unit", "items.taxrate", "id"});
        GroupbyDataSet sumSet = gSet.sum("items.amount").sum("items.tax").sum("items.taxamount").sum("items.num").count();
        DataSet finish = sumSet.finish();
        GroupbyDataSet groupBySet2 = finish.groupBy(new String[]{"orgid", "items.goodsname", "items.specification", "items.unit", "items.taxrate"});
        finish = groupBySet2.sum("items.amount").sum("items.tax").sum("items.taxamount").sum("items.num").sum("count").count().finish();
        JoinDataSet on = finish.join(orgSet.select("id,name"), JoinType.LEFT).on("orgid", "id");
        DataSet oneOrgDetailSet = on.select(new String[]{"items.goodsname", "items.specification", "items.unit", "items.taxrate", "items.amount", "items.num", "items.tax", "items.taxamount", "count as orgid", "name as bdm_org.name", "0 as order", "'0' as totallize"}).finish();
        DataSet totalGroupSet = oneOrgDetailSet.copy().groupBy(new String[]{"bdm_org.name", "totallize"}).sum("items.amount").sum("items.tax").sum("items.taxamount").sum("items.num").sum("orgid").finish();
        DataSet oneCountLineSet = totalGroupSet.select(new String[]{"'' as items.goodsname", "'' as items.specification", "'' as items.unit", "'\u5c0f\u8ba1' as items.taxrate", "items.amount", "items.num", "items.tax", "items.taxamount", "0 as orgid", "bdm_org.name", "1 as order", "totallize"});
        this.totallize = null == this.totallize ? oneCountLineSet.copy() : this.totallize.union(oneCountLineSet.copy());
        return oneOrgDetailSet.union(oneCountLineSet);
    }

    public QFilter initFilters(ReportQueryParam param) {
        QFilter invoiceNatureFilter;
        QFilter orgNameFilter;
        QFilter goodsCodeFilter;
        FilterInfo info = param.getFilter();
        QFilter resultFilter = this.initTimePeriodFilter(info);
        QFilter orgFilter = this.initOrgFilter(info);
        if (null != orgFilter) {
            resultFilter = resultFilter.and(orgFilter);
        }
        QFilter excludeCancelInvoiceFilter = this.initExcludeCancelInvoiceFilter();
        resultFilter = resultFilter.and(excludeCancelInvoiceFilter);
        QFilter goodsNameFilter = this.initGoodsNameFilter(info);
        if (null != goodsNameFilter) {
            resultFilter = resultFilter.and(goodsNameFilter);
        }
        if (null != (goodsCodeFilter = this.initGoodsCodeFilter(info))) {
            resultFilter = resultFilter.and(goodsCodeFilter);
        }
        if (null != (orgNameFilter = this.initOrgNameFilter(info))) {
            resultFilter = resultFilter.and(orgNameFilter);
        }
        if (null != (invoiceNatureFilter = this.initInvoiceNatureFilter(info))) {
            resultFilter = resultFilter.and(invoiceNatureFilter);
        }
        QFilter issuedFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        resultFilter = resultFilter.and(issuedFilter);
        return resultFilter;
    }
}

