/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.taxcopyandclear;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.sim.common.helper.CopyTaxAndRestHelper;
import kd.imc.sim.common.model.taxcopyandreset.CopyTaxAndRestUnlockVo;
import org.apache.commons.lang3.StringUtils;

public class CopyTaxAndRestTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(CopyTaxAndRestTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String selectFields = "id,epinfo,equipmentno,equipmenttype,authstatus";
        QFilter equipmentFilter = new QFilter("authstatus", "=", (Object)"1");
        DynamicObject[] equipments = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)selectFields, (QFilter[])new QFilter[]{equipmentFilter});
        if (null == equipments || equipments.length <= 0) {
            return;
        }
        for (DynamicObject equipment : equipments) {
            Long epinfoId;
            DynamicObject bdmEpInfo;
            DynamicObject org;
            DynamicObject epInfo = equipment.getDynamicObject("epinfo");
            if (null == epInfo || null == (org = (bdmEpInfo = BusinessDataServiceHelper.loadSingle((Object)(epinfoId = Long.valueOf(Long.parseLong(epInfo.getString("id")))), (String)"bdm_enterprise_baseinfo")).getDynamicObject("org"))) continue;
            String taxNo = StringUtils.isBlank((CharSequence)epInfo.getString("number")) ? "" : epInfo.getString("number");
            String deviceNo = equipment.getString("equipmentno");
            deviceNo = StringUtils.isBlank((CharSequence)deviceNo) ? "" : deviceNo;
            Integer deviceType = equipment.getInt("equipmenttype");
            Long orgId = Long.parseLong(org.getString("id"));
            Integer authStatus = equipment.getInt("authstatus") != 1 ? 2 : equipment.getInt("authstatus");
            HashMap<String, Object> pMap = new HashMap<String, Object>();
            pMap.put("deviceStatus", authStatus);
            pMap.put("copySuccessDate", "");
            pMap.put("taxReturnEndDate", "");
            String msg = CopyTaxAndRestHelper.checkRules(pMap);
            if (StringUtils.isNotBlank((CharSequence)msg)) continue;
            CopyTaxAndRestUnlockVo taskvo = new CopyTaxAndRestUnlockVo();
            taskvo.setTaxNo(taxNo);
            taskvo.setCopyTaxReturnId(Long.valueOf(-999999999L));
            taskvo.setDeviceNo(deviceNo);
            taskvo.setDeviceType(deviceType);
            taskvo.setOrgId(orgId);
            taskvo.setEpInfoId(epinfoId);
            taskvo.setEqupmentStatus(authStatus);
            taskvo.setEquipmentId(Long.valueOf(Long.parseLong(equipment.getString("id"))));
            if (logger.isInfoEnabled()) {
                logger.info(String.format("\u8c03\u7528\u81ea\u52a8\u6284\u7a0e\u6e05\u5361\u7684\u7a0e\u53f7\u662f\uff1a%s,\u8bbe\u5907\u53f7\u662f\uff1a%s,\u8bbe\u5907\u7c7b\u578b\u662f\uff1a%s", taxNo, deviceNo, deviceType));
            }
            try {
                Map rMap = CopyTaxAndRestHelper.copyTaxAndRestUnlock((CopyTaxAndRestUnlockVo)taskvo);
                if (!logger.isInfoEnabled()) continue;
                logger.info(String.format("\u8c03\u7528\u81ea\u52a8\u6284\u7a0e\u6e05\u5361\u8fd4\u56de\u7ed3\u679c\u662f\uff1a%s", JSON.toJSONString((Object)rMap)));
            }
            catch (Exception e) {
                logger.info(String.format("\u8bbe\u5907\uff1a%s, \u81ea\u52a8\u6284\u62a5\u7a0e\u5f02\u5e38:", deviceNo));
                logger.error((Throwable)e);
            }
        }
    }
}

