/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.ComponentRequest;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.dto.MoudleDataDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleVehicleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleVehicleResponseDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AddressSplitHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.ConvertUpMoneyUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.vehicle.VehicleInvoiceIssueResponseDTO;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.DeviceUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceHelper;
import kd.imc.sim.mq.consumer.service.IssueVehicleInvoiceServiceImpl;
import org.apache.commons.lang3.tuple.Pair;

public class VehicleInvoiceFormPlugin
extends AbstractFormPlugin {
    public static final String OPENINVOICE = "openinvoice";
    public static final String QUERY_VEHICLE_IDCODE = "queryvehicleidcode";
    public static final String SIM_FILL_VIHICLE_CODE = "sim_fill_vihicle_code";

    public void afterCreateNewData(EventObject e) {
        try {
            this.initData();
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void initData() {
        long orgId = this.getOrgId();
        this.getModel().setValue("orgid", (Object)orgId);
        this.getModel().setValue("billno", (Object)("200_" + UUID.getBatchNumber() + "_0001"));
        this.getModel().setValue("orderno", (Object)("vehicle_" + UUID.next()));
        this.getModel().setValue("billsource", (Object)"2");
        this.setDrawer(orgId);
        this.setSaleInfo(orgId);
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        if (InvoiceUtils.isAllEVehicleInv((String)invoiceType)) {
            this.initAccountListAndSetDefault();
        } else {
            EquipmentUtil.bindDevNoByOrg((AbstractFormPlugin)this, (String)"jqbh", (Long)orgId, null);
        }
    }

    private void initAccountListAndSetDefault() {
        String salerTaxNo = (String)this.getModel().getValue("salertaxno");
        DynamicObject accountObj = AllEleAuthHelper.getAccountByTaxNo((String)salerTaxNo);
        if (null == accountObj) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9500\u65b9\u672a\u914d\u7f6e\u6570\u7535\u8d26\u53f7", (String)"VehicleInvoiceFormPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(7000));
            return;
        }
        Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)accountObj, (boolean)true);
        ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"account", (Map)((Map)accountList.getValue()));
        String defaultAccount = AllEleAuthHelper.getEpDefaultAccount((DynamicObject)accountObj, (boolean)true, (boolean)false);
        this.getModel().setValue("account", (Object)defaultAccount);
    }

    private long getOrgId() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
        long orgId = org == null ? RequestContext.get().getOrgId() : DynamicObjectUtil.getDynamicObjectLongValue((Object)org);
        return orgId;
    }

    private void setSaleInfo(long orgId) {
        try {
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
            this.getModel().setValue("salername", (Object)saleInfo.getSaleName());
            this.getModel().setValue("salertaxno", (Object)saleInfo.getSaleTaxNo());
            DynamicObject saleDynamicObject = TaxUtils.getSaleAddrBankByOrg((SaleInfo)saleInfo);
            if (saleDynamicObject != null) {
                Pair bankAndAccPair = AddressSplitHelper.splitBankAndName((String)saleDynamicObject.getString("openuserbank"));
                this.getView().getModel().setValue("salerbankname", bankAndAccPair.getKey());
                this.getView().getModel().setValue("saleraccount", bankAndAccPair.getValue());
                Pair addrPhonePair = AddressSplitHelper.splitAddressAndTel((String)saleDynamicObject.getString("invoiceaddr"));
                this.getView().getModel().setValue("saleraddress", addrPhonePair.getKey());
                this.getView().getModel().setValue("salerphone", addrPhonePair.getValue());
            } else {
                this.setVehicleInfoNull("salerbankname", "saleraccount", "saleraddress", "salerphone");
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void setDrawer(long orgId) {
        String jqbh = (String)this.getModel().getValue("jqbh");
        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
        bill.set("drawer", (Object)RequestContext.get().getUserName());
        bill.set("orgid", (Object)orgId);
        DrawerInfo info = DrawerStrategyHelper.getOriginalBillDrawerStrategy((Object)jqbh, (DynamicObject)bill);
        this.getModel().setValue("drawer", (Object)info.getDrawer());
    }

    public void afterBindData(EventObject e) {
        try {
            long orgId = this.getOrgId();
            EquipmentUtil.bindDevNoByOrgNotDefault((AbstractFormPlugin)this, (long)orgId, (String)"jqbh", null);
            String salerTaxNo = (String)this.getModel().getValue("salertaxno");
            DynamicObject accountObj = AllEleAuthHelper.getAccountByTaxNo((String)salerTaxNo);
            Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)accountObj, (boolean)true);
            ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"account", (Map)((Map)accountList.getValue()));
            String invoiceType = (String)this.getModel().getValue("invoicetype");
            if (!InvoiceUtils.isAllEVehicleInv((String)invoiceType)) {
                Label jqbhAp = (Label)this.getControl("jqbhap");
                jqbhAp.setText((String)this.getModel().getValue("jqbh"));
            }
            this.setTotalAmountUp();
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW || IssueStatusEnum.ok.getCode().equals(this.getModel().getValue("issuestatus"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{OPENINVOICE, "refresh"});
            } else if (!InvoiceUtils.isAllEVehicleInv((String)invoiceType)) {
                this.setNextInvoiceCodeNo();
            }
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        TextEdit textEdit = (TextEdit)this.getView().getControl("buyername");
        textEdit.addClickListener((ClickListener)this);
        TextEdit vehicleTypeEdit = (TextEdit)this.getView().getControl("vehicletype");
        vehicleTypeEdit.addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "buyername": {
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)ImcBaseDataHelper.getInvTitleFilter((Object)this.getOrgId()), (String)"bdm_invice_title_strate", (String)"close_call_back_buyer_name");
                break;
            }
            case "vehicletype": {
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)new QFilter("org", "=", (Object)this.getOrgId()), (String)"bdm_vehicle_info", (String)"bdm_vehicle_info");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "queryvehicleidcode": {
                this.queryVehicleInfo();
            }
        }
    }

    private void queryVehicleInfo() {
        String vehicleCode = (String)this.getModel().getValue("vehicleidcode");
        HashMap<String, String> vehicleMap = new HashMap<String, String>();
        vehicleMap.put("vehicleidcode", vehicleCode);
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u63d0\u793a", (String)"VehicleInvoiceFormPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), vehicleMap, (String)SIM_FILL_VIHICLE_CODE, (String)SIM_FILL_VIHICLE_CODE);
    }

    private void queryVehicleInfo(String vehicleIdCode) {
        AllEleVehicleRequestDTO requestDto = new AllEleVehicleRequestDTO();
        String account = (String)this.getModel().getValue("account");
        String salerTaxNo = (String)this.getModel().getValue("salertaxno");
        requestDto.setAccount(account);
        requestDto.setChassisNo(vehicleIdCode);
        requestDto.setInvoiceType("12");
        requestDto.setRequest_path(AllEleInterfaceTypeEnum.ELE_PAPER_MOTORVEHICLE_INFO_QUERY.getRequestPath());
        AllEleResponseDTO response = AllEleServiceHelper.doPost((String)salerTaxNo, (AllEleRequestDTO)requestDto, AllEleVehicleResponseDTO.class);
        if (!ErrorType.SUCCESS.getCode().equals(response.getErrcode())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8f66\u8f86\u4fe1\u606f\u5931\u8d25:%s", (String)"VehicleInvoiceFormPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), response.getDescription()));
        }
        AllEleVehicleResponseDTO data = (AllEleVehicleResponseDTO)response.getData();
        this.updateViewData(data);
        this.updateViewFromVehicleInfo(data);
    }

    private void updateViewFromVehicleInfo(AllEleVehicleResponseDTO data) {
        Object org = this.getModel().getValue("orgid");
        long orgPk = DynamicObjectUtil.getDynamicObjectLongValue((Object)org);
        QFilter filter = new QFilter("vehicletype", "=", (Object)data.getVehicleType()).and("org", "=", (Object)orgPk);
        DynamicObject[] arrays = BusinessDataServiceHelper.load((String)"bdm_vehicle_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_vehicle_info", (boolean)true), (QFilter[])filter.toArray());
        if (arrays.length > 0) {
            this.updateViewFromEleVehicleInfo(arrays[0]);
        }
    }

    private void updateViewData(AllEleVehicleResponseDTO data) {
        this.getModel().setValue("brandmodel", (Object)data.getModel());
        this.getModel().setValue("producingarea", (Object)data.getOrigin());
        this.getModel().setValue("certificatenum", (Object)data.getComplianceNo());
        this.getModel().setValue("importcertificate", (Object)data.getImportNo());
        this.getModel().setValue("enginenum", (Object)data.getEngineNo());
        this.getModel().setValue("vehicleidcode", (Object)data.getChassisNo());
        this.getModel().setValue("totalton", (Object)data.getVehicleWeight());
        this.getModel().setValue("limitepeople", (Object)data.getVehicleCapacity());
        this.getModel().setValue("overtaxcode", (Object)data.getTaxationVoucher());
        this.getModel().setValue("vehicletype", (Object)data.getVehicleType());
        this.getModel().setValue("producingname", (Object)data.getManufacturer());
        this.getModel().setValue("uuid", (Object)data.getVehicleUuid());
        this.getModel().setValue("commodityinspectionnum", (Object)data.getBusinessNo());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("doNotChangeProperty"))) {
            return;
        }
        switch (e.getProperty().getName()) {
            case "jqbh": {
                this.setNextInvoiceCodeNo();
                break;
            }
            case "totalamount": {
                this.calcTaxAndInvoiceAmount();
                break;
            }
            case "taxrate": {
                this.calcTaxAndInvoiceAmount();
                break;
            }
            case "vehicletype": {
                if (!StringUtils.isBlank((CharSequence)((String)this.getModel().getValue("vehicletype")))) break;
                this.updateVehicleInfo(null);
                break;
            }
            case "invoicetype": {
                this.editInvoiceType(e);
            }
        }
    }

    private void editInvoiceType(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equals(newValue)) {
            long orgId = this.getOrgId();
            EquipmentUtil.bindDevNoByOrg((AbstractFormPlugin)this, (String)"jqbh", (Long)orgId, null);
            this.getModel().setValue("account", null);
            this.getModel().setValue("version", (Object)"1");
            Label jqbhAp = (Label)this.getControl("jqbhap");
            jqbhAp.setText((String)this.getModel().getValue("jqbh"));
        } else {
            this.initAccountListAndSetDefault();
            this.getModel().setValue("jqbh", null);
        }
    }

    private String toChinese(String str) {
        String upStr = ConvertUpMoneyUtils.toChinese((String)str);
        if (upStr.endsWith("\u5706")) {
            upStr = upStr + "\u6574";
        }
        return upStr;
    }

    private void calcTaxAndInvoiceAmount() {
        this.setTotalAmountUp();
        BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount");
        if (MathUtils.isNullOrZero((BigDecimal)totalAmount)) {
            return;
        }
        String taxRate = (String)this.getModel().getValue("taxrate");
        BigDecimal tax = TaxCalcUtil.calTax((BigDecimal)totalAmount, (BigDecimal)BigDecimal.ZERO, (String)taxRate, (boolean)true);
        this.getModel().setValue("totaltax", (Object)tax);
        this.getModel().setValue("invoiceamount", (Object)totalAmount.subtract(tax).setScale(2, 4));
    }

    private void setTotalAmountUp() {
        Label totalAmountAp = (Label)this.getControl("totalamountap");
        BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount");
        totalAmountAp.setText(this.toChinese(MathUtils.isNullOrZero((BigDecimal)totalAmount) ? "0.00" : totalAmount.toString()));
    }

    private void updateVehicleInfo(DynamicObject vehicle) {
        try {
            this.getPageCache().put("doNotChangeProperty", "doNotChangeProperty");
            if (InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(this.getModel().getValue("invoicetype"))) {
                if (vehicle == null) {
                    return;
                }
                this.updateViewFromEleVehicleInfo(vehicle);
            } else {
                if (vehicle == null) {
                    this.setVehicleInfoNull("vehicletype", "brandmodel", "producingarea", "producingname", "taxrate", "goodscode", "zerotaxmark", "taxpremark", "zzstsgl");
                    return;
                }
                this.updateVehicleTypeBaseInfo(vehicle);
            }
        }
        finally {
            this.getPageCache().remove("doNotChangeProperty");
        }
    }

    private void updateViewFromEleVehicleInfo(DynamicObject vehicle) {
        this.getModel().setValue("taxrate", vehicle.get("taxrate"));
        this.getModel().setValue("goodscode", (Object)vehicle.getDynamicObject("goodscode").getString("mergecode"));
        this.getModel().setValue("zerotaxmark", vehicle.get("zerotaxmark"));
        this.getModel().setValue("taxpremark", vehicle.get("taxpremark"));
        this.getModel().setValue("zzstsgl", vehicle.get("zzstsgl"));
        if (StringUtils.isBlank((Object)this.getModel().getValue("vehicletype"))) {
            this.getModel().setValue("vehicletype", vehicle.get("vehicletype"));
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("brandmodel"))) {
            this.getModel().setValue("brandmodel", vehicle.get("brandmodel"));
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("producingarea"))) {
            this.getModel().setValue("producingarea", vehicle.get("producingarea"));
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("producingname"))) {
            this.getModel().setValue("producingname", vehicle.get("producingname"));
        }
    }

    private void updateVehicleTypeBaseInfo(DynamicObject vehicle) {
        this.getModel().setValue("vehicletype", vehicle.get("vehicletype"));
        this.getModel().setValue("brandmodel", vehicle.get("brandmodel"));
        this.getModel().setValue("producingarea", vehicle.get("producingarea"));
        this.getModel().setValue("producingname", vehicle.get("producingname"));
        this.getModel().setValue("taxrate", vehicle.get("taxrate"));
        this.getModel().setValue("goodscode", (Object)vehicle.getDynamicObject("goodscode").getString("mergecode"));
        this.getModel().setValue("zerotaxmark", vehicle.get("zerotaxmark"));
        this.getModel().setValue("taxpremark", vehicle.get("taxpremark"));
        this.getModel().setValue("zzstsgl", vehicle.get("zzstsgl"));
    }

    private void setVehicleInfoNull(String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (StringUtils.equalsIgnoreCase((CharSequence)OPENINVOICE, (CharSequence)((FormOperate)args.getSource()).getOperateKey())) {
            JSONObject json = new JSONObject();
            json.put("salertaxno", this.getModel().getValue("salertaxno"));
            String invoiceType = (String)this.getModel().getValue("invoicetype");
            if (InvoiceUtils.isAllEVehicleInv((String)invoiceType)) {
                if (StringUtils.isBlank((Object)this.getModel().getValue("account"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u7535\u8d26\u53f7", (String)"VehicleInvoiceFormPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(7000));
                    args.setCancel(true);
                    return;
                }
                if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)json)) {
                    args.setCancel(true);
                    return;
                }
                String vehicleType = (String)this.getModel().getValue("vehicletype");
                if (StringUtils.isNotBlank((CharSequence)vehicleType) && StringUtils.isBlank((Object)this.getModel().getValue("uuid"))) {
                    AllEleVehicleRequestDTO requestDto = new AllEleVehicleRequestDTO();
                    String account = (String)this.getModel().getValue("account");
                    String salerTaxNo = (String)this.getModel().getValue("salertaxno");
                    requestDto.setAccount(account);
                    requestDto.setChassisNo(vehicleType);
                    requestDto.setInvoiceType("12");
                    requestDto.setRequest_path(AllEleInterfaceTypeEnum.ELE_PAPER_MOTORVEHICLE_INFO_QUERY.getRequestPath());
                    AllEleResponseDTO response = AllEleServiceHelper.doPost((String)salerTaxNo, (AllEleRequestDTO)requestDto, AllEleVehicleResponseDTO.class);
                    if (ErrorType.SUCCESS.getCode().equals(response.getErrcode())) {
                        this.getModel().setValue("uuid", (Object)((AllEleVehicleResponseDTO)response.getData()).getVehicleUuid());
                    } else {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u673a\u52a8\u8f66uuid\u5931\u8d25:%s", (String)"VehicleInvoiceFormPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), response.getDescription()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (OPENINVOICE.equals(operateKey)) {
            try {
                OperationResult result = afterDoOperationEventArgs.getOperationResult();
                if (result.isSuccess()) {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f00\u7968\u4e2d", (String)"VehicleInvoiceFormPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0])));
                    result.setShowMessage(false);
                    Object vehicleId = result.getSuccessPkIds().get(0);
                    DynamicObject vehicle = BusinessDataServiceHelper.loadSingle(vehicleId, (String)"sim_vatinvoice_vehicles");
                    String invoiceType = vehicle.getString("invoicetype");
                    boolean isGold3VehicleInv = !InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(invoiceType);
                    VehicleInvoiceIssueResponseDTO response = IssueVehicleInvoiceServiceImpl.issueAllVehicleInvoice(vehicle);
                    IssueInvoiceService.handleVehicleInvoiceIssueResponse((VehicleInvoiceIssueResponseDTO)response, (DynamicObject)vehicle);
                    if (ErrorType.SUBMITED.getCode().equals(response.getErrorCode())) {
                        this.getView().invokeOperation("refresh");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5f00\u7968\u6210\u529f", (String)"VehicleInvoiceFormPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        this.resetView();
                    } else if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode()) && isGold3VehicleInv) {
                        this.getView().invokeOperation("refresh");
                        IssueInvoiceService.openPrintDialog((AbstractFormPlugin)this, (DynamicObject)vehicle);
                        this.resetView();
                    } else if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
                        this.getView().invokeOperation("refresh");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u7968\u6210\u529f", (String)"VehicleInvoiceFormPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        this.resetView();
                    } else {
                        this.getView().showErrorNotification(response.getDescription());
                    }
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    private void resetView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{OPENINVOICE, QUERY_VEHICLE_IDCODE, "refresh"});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "close_call_back_buyer_name": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bdm_invice_title_strate", (String)String.join((CharSequence)",", "name", "buyertype", "idcode", "taxno"));
                this.updateBuyerTitleView(dynamicObject);
                break;
            }
            case "bdm_vehicle_info": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
                DynamicObject vehicleInfo = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bdm_vehicle_info");
                this.updateVehicleInfo(vehicleInfo);
                break;
            }
            case "callback_sim_invoice_print_confirm": {
                IssueInvoiceHelper.handleInvoicePrinterConfirm(this, closedCallBackEvent);
                break;
            }
            case "sim_fill_vihicle_code": {
                String vihicleCode = (String)closedCallBackEvent.getReturnData();
                if (!StringUtils.isNotBlank((CharSequence)vihicleCode)) break;
                this.queryVehicleInfo(vihicleCode);
            }
        }
    }

    private void updateBuyerTitleView(DynamicObject dynamicObject) {
        this.getModel().setValue("buyername", dynamicObject.get("name"));
        String taxNo = "2".equals(dynamicObject.getString("buyertype")) ? dynamicObject.getString("idcode") : dynamicObject.getString("taxno");
        this.getModel().setValue("buyertaxno", (Object)taxNo);
        if ("0".equals(this.getModel().getValue("version"))) {
            this.getModel().setValue("buyercardno", (Object)taxNo);
        }
    }

    private void setNextInvoiceCodeNo() {
        String jqbh = (String)this.getModel().getValue("jqbh");
        if (StringUtils.isBlank((CharSequence)jqbh)) {
            return;
        }
        this.setInvoiceAp("jqbh");
        String equipmentType = DeviceUtil.getDevType((String)jqbh);
        try {
            if ("3".equals(equipmentType)) {
                return;
            }
            ComponentRequest request = new ComponentRequest(ComponentInterfaceTypeEnum.GETTAXDISKINFO.getCzlx(), null, null, null);
            ComponentResponse response = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)jqbh), (String)JSON.toJSONString((Object)request), MoudleDataDTO.class);
            if (!response.isSucess()) {
                this.getView().showErrorNotification(response.getDescription());
                return;
            }
            if ("00000000".equals(((MoudleDataDTO)response.getResponse()).getJdcfphm())) {
                return;
            }
            String invoiceCode = ((MoudleDataDTO)response.getResponse()).getJdcfpdm();
            String invoiceNo = ((MoudleDataDTO)response.getResponse()).getJdcfphm();
            this.getModel().setValue("invoicecode", (Object)invoiceCode);
            this.getModel().setValue("invoiceno", (Object)invoiceNo);
            this.getModel().setValue("issuetime", (Object)new Date());
            this.setInvoiceAp("invoicecode", "invoiceno");
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0b\u4e00\u5f20\u53d1\u7968\u4ee3\u7801\u53f7\u7801\u5931\u8d25\uff1a %s", (String)"VehicleInvoiceFormPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void setInvoiceAp(String ... keys) {
        for (String key : keys) {
            Label label = (Label)this.getControl(key + "ap");
            label.setText((String)this.getModel().getValue(key));
        }
    }
}

