/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle.op;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.formplugin.vehicle.validator.VehicleInvoiceValidator;

public class VehicleInvoiceOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_vatinvoice_vehicles"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        if (e.getDataEntities().length > 0) {
            DynamicObject invoice = e.getDataEntities()[0];
            String issueStatus = invoice.getString("issuestatus");
            String billSource = invoice.getString("billsource");
            if (!"3".equals(billSource) || !IssueStatusEnum.ok.getCode().equals(issueStatus)) {
                e.addValidator((AbstractValidator)new VehicleInvoiceValidator());
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Boolean isFromImportInvoice = null;
        if ("openinvoice".equals(e.getOperationKey())) {
            for (DynamicObject dataEntity : e.getDataEntities()) {
                if (null == isFromImportInvoice) {
                    String issueStatus = dataEntity.getString("issuestatus");
                    String billSource = dataEntity.getString("billsource");
                    isFromImportInvoice = "3".equals(billSource) && IssueStatusEnum.ok.getCode().equals(issueStatus);
                }
                if (isFromImportInvoice.booleanValue()) continue;
                dataEntity.set("invoicecode", null);
                dataEntity.set("invoiceno", null);
                dataEntity.set("issuetime", null);
            }
        }
    }
}

