/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.utils.ApiVerifyUtil;
import kd.imc.sim.common.utils.DeviceUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;

public class VehicleInvoiceValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            DynamicObject vehicleInvoice = dataEntity.getDataEntity();
            try {
                VehicleInvoiceValidator.checkVehicleInvoice(vehicleInvoice);
            }
            catch (MsgException e) {
                this.addErrorMessage(dataEntity, e.getErrorMsg());
            }
        }
    }

    public static void checkVehicleInvoice(DynamicObject vehicleInvoice) {
        String invoiceType = vehicleInvoice.getString("invoicetype");
        VehicleInvoiceValidator.checkNull(invoiceType, ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b", (String)"VehicleInvoiceValidator_41", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        boolean isGold3VehicleInvoice = InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equalsIgnoreCase(invoiceType);
        if (isGold3VehicleInvoice) {
            VehicleInvoiceValidator.checkGold3Fields(vehicleInvoice);
        } else {
            VehicleInvoiceValidator.checkEleFields(vehicleInvoice);
        }
    }

    private static void checkEleFields(DynamicObject vehicleInvoice) {
        String issueType = vehicleInvoice.getString("issuetype");
        VehicleInvoiceValidator.checkNull(issueType, ResManager.loadKDString((String)"\u5f00\u7968\u7c7b\u578b", (String)"VehicleInvoiceValidator_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("vehicleidcode"), 30, ResManager.loadKDString((String)"\u8f66\u8f86\u8bc6\u522b\u4ee3\u53f7/\u8f66\u67b6\u53f7\u7801", (String)"VehicleInvoiceValidator_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("brandmodel"), 50, ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"VehicleInvoiceValidator_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("producingarea"), 50, ResManager.loadKDString((String)"\u4ea7\u5730", (String)"VehicleInvoiceValidator_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("certificatenum"), 30, ResManager.loadKDString((String)"\u5408\u683c\u8bc1\u53f7", (String)"VehicleInvoiceValidator_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("enginenum"), 50, ResManager.loadKDString((String)"\u53d1\u52a8\u673a\u53f7", (String)"VehicleInvoiceValidator_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("vehicletype"), 20, ResManager.loadKDString((String)"\u8f66\u8f86\u7c7b\u578b", (String)"VehicleInvoiceValidator_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("producingname"), 100, ResManager.loadKDString((String)"\u751f\u4ea7\u4f01\u4e1a\u540d\u79f0", (String)"VehicleInvoiceValidator_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("uuid"), 30, ResManager.loadKDString((String)"\u673a\u52a8\u8f66uuid", (String)"VehicleInvoiceValidator_39", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("importcertificate"), 30, ResManager.loadKDString((String)"\u8fdb\u53e3\u8bc1\u660e\u4e66\u53f7", (String)"VehicleInvoiceValidator_24", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("commodityinspectionnum"), 30, ResManager.loadKDString((String)"\u5546\u68c0\u5355\u53f7", (String)"VehicleInvoiceValidator_25", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("totalton"), 10, ResManager.loadKDString((String)"\u5428\u4f4d", (String)"VehicleInvoiceValidator_37", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("limitepeople"), 5, ResManager.loadKDString((String)"\u9650\u4e58\u4eba\u6570", (String)"VehicleInvoiceValidator_38", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("overtaxcode"), 30, ResManager.loadKDString((String)"\u5b8c\u7a0e\u51ed\u8bc1\u53f7\u7801", (String)"VehicleInvoiceValidator_40", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("buyername"), 100, ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u540d\u79f0", (String)"VehicleInvoiceValidator_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("buyertaxno"), 20, ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7/\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"VehicleInvoiceValidator_42", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("drawer"), 16, ResManager.loadKDString((String)"\u5f00\u7968\u4eba", (String)"VehicleInvoiceValidator_21", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("goodscode"), 19, ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"VehicleInvoiceValidator_22", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNull(vehicleInvoice.getString("taxpremark"), ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u7c7b\u578b", (String)"VehicleInvoiceValidator_23", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        BigDecimal totalAmount = vehicleInvoice.getBigDecimal("totalamount");
        if (!BigDecimalUtil.greaterZero((BigDecimal)totalAmount)) {
            throw new MsgException(ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u53d1\u7968\uff08\u6570\u7535\u7eb8\u7968\uff09\u6682\u53ea\u652f\u6301\u5f00\u5177\u84dd\u5b57\u53d1\u7968", (String)"VehicleInvoiceValidator_44", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        VehicleInvoiceValidator.checkAmount(vehicleInvoice, issueType);
        vehicleInvoice.set("version", null);
    }

    private static void checkGold3Fields(DynamicObject vehicleInvoice) {
        String version = vehicleInvoice.getString("version");
        VehicleInvoiceValidator.checkNull(version, ResManager.loadKDString((String)"\u7248\u672c\u53f7", (String)"VehicleInvoiceValidator_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        boolean isOldVersion = "0".equals(version);
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("buyername"), 100, ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u540d\u79f0", (String)"VehicleInvoiceValidator_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("buyertaxno"), 20, isOldVersion ? ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"VehicleInvoiceValidator_3", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7/\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"VehicleInvoiceValidator_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        if (isOldVersion) {
            VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("buyercardno"), 22, ResManager.loadKDString((String)"\u7248\u672c\u53f7\u4e3a\u65e7\u7248\u65f6\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801/\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801", (String)"VehicleInvoiceValidator_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String issueType = vehicleInvoice.getString("issuetype");
        VehicleInvoiceValidator.checkNull(issueType, ResManager.loadKDString((String)"\u5f00\u7968\u7c7b\u578b", (String)"VehicleInvoiceValidator_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("vehicletype"), 40, ResManager.loadKDString((String)"\u8f66\u8f86\u7c7b\u578b", (String)"VehicleInvoiceValidator_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("brandmodel"), 60, ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"VehicleInvoiceValidator_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("producingarea"), 32, ResManager.loadKDString((String)"\u4ea7\u5730", (String)"VehicleInvoiceValidator_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("certificatenum"), 50, ResManager.loadKDString((String)"\u5408\u683c\u8bc1\u53f7", (String)"VehicleInvoiceValidator_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("enginenum"), 60, ResManager.loadKDString((String)"\u53d1\u52a8\u673a\u53f7", (String)"VehicleInvoiceValidator_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("vehicleidcode"), 23, ResManager.loadKDString((String)"\u8f66\u8f86\u8bc6\u522b\u4ee3\u53f7/\u8f66\u67b6\u53f7\u7801", (String)"VehicleInvoiceValidator_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("producingname"), 40, ResManager.loadKDString((String)"\u751f\u4ea7\u4f01\u4e1a\u540d\u79f0", (String)"VehicleInvoiceValidator_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("salername"), 100, ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"VehicleInvoiceValidator_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("salertaxno"), 20, ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7", (String)"VehicleInvoiceValidator_20", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("drawer"), 10, ResManager.loadKDString((String)"\u5f00\u7968\u4eba", (String)"VehicleInvoiceValidator_21", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("goodscode"), 19, ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"VehicleInvoiceValidator_22", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        String taxPremark = vehicleInvoice.getString("taxpremark");
        VehicleInvoiceValidator.checkNull(taxPremark, ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u7c7b\u578b", (String)"VehicleInvoiceValidator_23", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkLength(vehicleInvoice.getString("importcertificate"), 36, ResManager.loadKDString((String)"\u8fdb\u53e3\u8bc1\u660e\u4e66\u53f7", (String)"VehicleInvoiceValidator_24", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkLength(vehicleInvoice.getString("commodityinspectionnum"), 32, ResManager.loadKDString((String)"\u5546\u68c0\u5355\u53f7", (String)"VehicleInvoiceValidator_25", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkAmount(vehicleInvoice, issueType);
        String jqbh = vehicleInvoice.getString("jqbh");
        VehicleInvoiceValidator.checkNull(jqbh, ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7", (String)"VehicleInvoiceValidator_28", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        String equipmentType = DeviceUtil.getDevType((String)vehicleInvoice.getString("jqbh"));
        if (!"2".equals(equipmentType) && !"3".equals(equipmentType)) {
            throw new MsgException(ErrorType.EMPTY_PARAM.getCode(), ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u91d1\u7a0e\u76d8\u5f00\u5177\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\u3002", (String)"VehicleInvoiceValidator_29", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private static void checkAmount(DynamicObject vehicleInvoice, String issueType) {
        BigDecimal totalAmount = vehicleInvoice.getBigDecimal("totalamount");
        if (MathUtils.isNullOrZero((BigDecimal)totalAmount)) {
            throw new MsgException(ErrorType.EMPTY_PARAM.getCode(), ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a0", (String)"VehicleInvoiceValidator_14", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        BigDecimal totalTax = vehicleInvoice.getBigDecimal("totaltax");
        if (MathUtils.isNullOrZero((BigDecimal)totalTax)) {
            throw new MsgException(ErrorType.EMPTY_PARAM.getCode(), ResManager.loadKDString((String)"\u7a0e\u989d\u4e0d\u80fd\u4e3a0", (String)"VehicleInvoiceValidator_15", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String taxRate = vehicleInvoice.getString("taxrate");
        VehicleInvoiceValidator.checkNull(taxRate, ResManager.loadKDString((String)"\u7a0e\u7387", (String)"VehicleInvoiceValidator_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        if (!Arrays.asList(ApiVerifyUtil.getFloatTaxRate()).contains(taxRate)) {
            throw new MsgException(ErrorType.EMPTY_PARAM.getCode(), ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"VehicleInvoiceValidator_17", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        BigDecimal calcTax = TaxCalcUtil.calTax((BigDecimal)totalAmount, (BigDecimal)BigDecimal.ZERO, (String)vehicleInvoice.getString("taxrate"), (boolean)true);
        if (calcTax.compareTo(totalTax) != 0) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u7a0e\u989d\u9519\u8bef\uff0c\u5b9e\u9645\u7a0e\u989d%1$s,\u4f20\u5165\u7a0e\u989d%2$s", (String)"VehicleInvoiceValidator_33", (String)"imc-sim-formplugin", (Object[])new Object[0]), calcTax.toString(), totalTax.setScale(2, 4).toString()));
        }
        if (issueType.equals("0") && totalAmount.compareTo(BigDecimal.ZERO) < 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u5f00\u7968\u7c7b\u578b\u4e3a\u84dd\u7968\u65f6\uff0c\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"VehicleInvoiceValidator_26", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (issueType.equals("1") && totalAmount.compareTo(BigDecimal.ZERO) > 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u5f00\u7968\u7c7b\u578b\u4e3a\u7ea2\u7968\u65f6\uff0c\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"VehicleInvoiceValidator_27", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkCharLength(String val, int length, String description) {
        if (val.length() > length) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\uff08\u4e00\u4e2a\u6c49\u5b571\u4e2a\u5b57\u7b26\u957f\u5ea6\uff09", (String)"VehicleInvoiceValidator_43", (String)"imc-sim-formplugin", (Object[])new Object[0]), description, length));
        }
    }

    public static void checkNullAndCharLength(String val, int length, String description) {
        VehicleInvoiceValidator.checkNull(val, description);
        VehicleInvoiceValidator.checkCharLength(val, length, description);
    }

    public static void checkNullAndLength(String val, int length, String description) {
        VehicleInvoiceValidator.checkNull(val, description);
        VehicleInvoiceValidator.checkLength(val, length, description);
    }

    public static void checkNull(String val, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInvoiceValidator_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), description));
        }
    }

    public static void checkLength(String val, int length, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return;
        }
        if (GBKUtils.getGBKLength((String)val) > length) {
            throw new MsgException(String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE, description, length));
        }
    }

    public static String checkNullAndLengthMessage(String val, int length, String description) {
        return VehicleInvoiceValidator.checkNullMessage(val, description) + VehicleInvoiceValidator.checkLengthMessage(val, length, description);
    }

    public static String checkNullMessage(String val, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInvoiceValidator_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), description);
        }
        return "";
    }

    public static String checkLengthMessage(String val, int length, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return "";
        }
        if (GBKUtils.getGBKLength((String)val) > length) {
            return String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE, description, length) + ";";
        }
        return "";
    }

    public static String checkIsNumberMessage(String val, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInvoiceValidator_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), description);
        }
        if (!BigDecimalUtil.isNumber((String)val)) {
            return String.format(ResManager.loadKDString((String)"%s\u5fc5\u987b\u4e3a\u6570\u503c\u7c7b\u578b", (String)"VehicleInvoiceValidator_35", (String)"imc-sim-formplugin", (Object[])new Object[0]), description);
        }
        return "";
    }
}

