/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.redconfirm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.enums.EnableStatusEnum;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.schedule.factory.HandleBusinessFacotry;
import kd.imc.sim.schedule.service.BusinessAutoHandle;
import org.apache.commons.lang3.time.StopWatch;

public class AutoHandleBusinessTask
extends AbstractTask {
    private static Log LOGGER = LogFactory.getLog(AutoHandleBusinessTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String cacheKey = "AutoHandleBusinessTaskCache";
        try (DLock lock = DLock.create((String)cacheKey);){
            if (!lock.tryLock(500L)) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)cacheKey))) {
                LOGGER.info("AutoHandleBusinessTask is Running,this task is stopped");
                return;
            }
            CacheHelper.put((String)cacheKey, (String)"id", (int)1800);
            LOGGER.info("AutoHandleBusinessTaskStart");
            QFilter filter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getStatus());
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"bdm_auto_task", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_auto_task", (boolean)true), (QFilter[])filter.toArray(), (String)"type desc");
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            ArrayList excuteSeq = new ArrayList();
            Collections.addAll(excuteSeq, "1", "2", "0", "3", "4");
            Iterator iterator = excuteSeq.iterator();
            block22: while (true) {
                if (!iterator.hasNext()) return;
                String seq = (String)iterator.next();
                DynamicObject[] dynamicObjectArray = tasks;
                int n = dynamicObjectArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block22;
                    DynamicObject task = dynamicObjectArray[n2];
                    if (seq.equals(task.getString("type"))) {
                        BusinessAutoHandle service = HandleBusinessFacotry.getIssueInvoice(task);
                        if (null != service) {
                            try {
                                service.handleTask(task);
                            }
                            catch (Exception e) {
                                LOGGER.error("AutoHandleBusinessTask" + e.getMessage(), (Throwable)e);
                            }
                        } else {
                            LOGGER.info("notSupportTaskNumber:" + task.getString("number"));
                        }
                        stopWatch.split();
                        LOGGER.info(String.format("redConfirmAutoTask,number[%s],time[%s]", task.getString("number"), stopWatch.getTime()));
                    }
                    ++n2;
                }
                break;
            }
        }
        finally {
            CacheHelper.remove((String)cacheKey);
        }
    }
}

