/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.syncaws;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.formplugin.issuing.AwsSyncInvoicePlugin;

public class SyncAwsInvoiceTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(SyncAwsInvoiceTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.syncAwsInvoice();
    }

    public void syncAwsInvoice() {
        boolean isStarrySky = "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_STARRY_SKY));
        if (!isStarrySky) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u975e\u661f\u7a7a\uff0c\u4e0d\u540c\u6b65aws\u9500\u9879\u53d1\u7968\u6570\u636e");
            }
            return;
        }
        this.beginSync();
    }

    public void beginSync() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5b9a\u65f6\u540c\u6b65aws\u9500\u9879\u53d1\u7968\u6570\u636e... ");
        }
        try (DLock lock = DLock.create((String)"SyncAwsInvoiceTask", (String)"SyncAwsInvoiceTask");){
            if (!lock.tryLock()) {
                LOGGER.info("SyncAwsInvoiceTask-Lock");
                return;
            }
            QFilter qFilter = new QFilter("enterprisemainorg", "=", (Object)"1").and("epinfo.number", "!=", null).and("epinfo.number", "!=", (Object)"");
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bdm_org", (String)String.join((CharSequence)",", "id", "name", "epinfo.name", "epinfo.number"), (QFilter[])qFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)orgs)) {
                return;
            }
            Map<String, DynamicObject> taxNoOrgMap = orgs.stream().collect(Collectors.toMap(k -> k.getString("epinfo.number"), v -> v, (v1, v2) -> v1));
            QFilter enableQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and("taxregnum", "in", (Object)orgs.stream().map(org -> org.getString("epinfo.number")).toArray());
            DynamicObjectCollection configResult = QueryServiceHelper.query((String)"er_bd_kdinvoicecloudcfg", (String)"taxregnum,firmname,client_id,client_secret,encrypt_key", (QFilter[])new QFilter[]{enableQFilter});
            if (CollectionUtils.isEmpty((Collection)configResult)) {
                return;
            }
            QFilter filter = new QFilter("status", "=", (Object)"2").and("tax_no", "in", (Object)configResult.stream().map(config -> config.getString("taxregnum")).toArray()).and("appid", "=", (Object)"sim");
            DynamicObjectCollection hisSyncLogList = QueryServiceHelper.query((String)"bdm_his_sync_log", (String)"tax_no", (QFilter[])new QFilter[]{filter});
            Set existTaxNoSet = hisSyncLogList.stream().map(sync -> sync.getString("tax_no")).collect(Collectors.toSet());
            ZoneId zone = ZoneId.systemDefault();
            Date yesterday = Date.from(LocalDate.now().minusDays(1L).atStartOfDay().atZone(zone).toInstant());
            Date beforeYesterday = Date.from(LocalDate.now().minusDays(2L).atStartOfDay().atZone(zone).toInstant());
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(configResult.size());
            for (DynamicObject config2 : configResult) {
                String taxNo = config2.getString("taxregnum");
                if (existTaxNoSet.contains(taxNo) || StringUtils.isBlank((CharSequence)config2.getString("client_id")) || StringUtils.isBlank((CharSequence)config2.getString("client_secret")) || StringUtils.isBlank((CharSequence)config2.getString("encrypt_key"))) continue;
                DynamicObject hisSyncLog = this.createHisSyncLog(config2, yesterday, beforeYesterday, taxNoOrgMap);
                if (hisSyncLog != null) {
                    saveList.add(hisSyncLog);
                }
                existTaxNoSet.add(taxNo);
            }
            if (!CollectionUtils.isEmpty(saveList)) {
                ImcSaveServiceHelper.save(saveList);
                new AwsSyncInvoicePlugin().syncAwsInvoice(saveList.stream().map(DataEntityBase::getPkValue).toArray());
            }
        }
    }

    private DynamicObject createHisSyncLog(DynamicObject config, Date yesterDay, Date beforeYesterday, Map<String, DynamicObject> taxNoOrgMap) {
        String taxNo = config.getString("taxregnum");
        DynamicObject org = taxNoOrgMap.get(taxNo);
        if (org == null) {
            return null;
        }
        DynamicObject syncLog = BusinessDataServiceHelper.newDynamicObject((String)"bdm_his_sync_log");
        syncLog.set("deal_times", (Object)0);
        syncLog.set("start_time", (Object)new Date());
        syncLog.set("success", (Object)0);
        syncLog.set("page_no", (Object)0);
        syncLog.set("appid", (Object)"sim");
        syncLog.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
        syncLog.set("data_date", (Object)"");
        syncLog.set("status", (Object)"2");
        syncLog.set("org", org.get("id"));
        syncLog.set("tax_no", (Object)taxNo);
        syncLog.set("company_name", org.get("epinfo.name"));
        syncLog.set("data_date_start", (Object)beforeYesterday);
        syncLog.set("data_date_end", (Object)yesterDay);
        syncLog.set("sync_type", (Object)"2");
        syncLog.set("clientid", config.get("client_id"));
        return syncLog;
    }
}

