/*
 * Decompiled with CFR 0.152.
 */
package kd.ismc.dim.common.invoice;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ismc.dim.common.constant.InvoiceType;
import kd.ismc.dim.common.message.exception.MsgException;
import kd.ismc.dim.common.model.InvoiceTypeEnum;
import kd.ismc.dim.common.model.PdfCreateInfo;
import kd.ismc.dim.common.util.CacheHelper;
import kd.ismc.dim.common.util.IsmcConfigUtil;
import kd.ismc.dim.common.util.PropertieUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class InvoiceUtil {
    private static final String RETRY_CONFIG_TYPE = "retry_config";
    private static final String RETRY_NUM = "retry_num";
    private static final String RETRY_BUSY_TIME = "retry_busy_time";
    private static final Log LOGGER = LogFactory.getLog(InvoiceUtil.class);

    public static InvoiceTypeEnum getInvoiceType(String invoiceTypeCode) {
        if (StringUtils.isEmpty((CharSequence)invoiceTypeCode)) {
            return InvoiceTypeEnum.UNKNOWN_TYPE;
        }
        if ("026".compareTo(invoiceTypeCode) == 0) {
            return InvoiceTypeEnum.ELECTRONIC_NORMAL;
        }
        if ("028".compareTo(invoiceTypeCode) == 0) {
            return InvoiceTypeEnum.ELECTRONIC_SPECIAL;
        }
        if ("004".compareTo(invoiceTypeCode) == 0) {
            return InvoiceTypeEnum.PAPERY_SPECIAL;
        }
        if ("007".compareTo(invoiceTypeCode) == 0) {
            return InvoiceTypeEnum.PAPERY_NORMAL;
        }
        return InvoiceTypeEnum.UNKNOWN_TYPE;
    }

    public static String paddingGoodscode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return "";
        }
        return org.apache.commons.lang.StringUtils.rightPad((String)code, (int)19, (char)'0');
    }

    public static boolean isStrValEqualZero(String strDecimal) {
        if (StringUtils.isEmpty((CharSequence)strDecimal)) {
            return true;
        }
        BigDecimal dec = new BigDecimal(strDecimal);
        return dec.compareTo(BigDecimal.ZERO) == 0;
    }

    public static String transDateFormate(String date) {
        if (StringUtils.isEmpty((CharSequence)date)) {
            return date;
        }
        if (date.indexOf(45) == -1) {
            return date;
        }
        return date.replaceAll("-", "").substring(0, 8);
    }

    public static int getRetryTimes() {
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"dim_param_config", (String)"config_value", (QFilter[])new QFilter("config_key", "=", (Object)"retry_time").toArray());
        if (array.length == 0) {
            return 5;
        }
        String retryTime = array[0].getString("config_value");
        return Integer.parseInt(retryTime);
    }

    public static int getRetryNum() {
        try {
            Integer object = InvoiceUtil.getConfigValue((String)"retry_num");
            if (object != null) {
                return object;
            }
        }
        catch (Exception e) {
            LOGGER.error("getRetryInfoError:" + e.getMessage(), (Throwable)e);
        }
        return 500;
    }

    public static void consumeBusy() {
        int busyTime = InvoiceUtil.getBusyTime();
        if (busyTime > 0) {
            CacheHelper.put((String)"DimConsumerBusy", (String)"id", (int)busyTime);
        }
    }

    public static void consumeBusy(int time) {
        int busyTime = InvoiceUtil.getBusyTime();
        if (0 != busyTime && time > 0) {
            CacheHelper.put((String)"DimConsumerBusy", (String)"id", (int)time);
        }
    }

    private static int getBusyTime() {
        try {
            Integer object = InvoiceUtil.getConfigValue((String)"retry_busy_time");
            if (object != null) {
                return object;
            }
        }
        catch (Exception e) {
            LOGGER.error("getRetryInfoError:" + e.getMessage(), (Throwable)e);
        }
        return 1;
    }

    public static boolean isMockBwServer() {
        Map dimImcConfig = IsmcConfigUtil.getValue((String)"dim_mock_config");
        String mockBwConfig = (String)dimImcConfig.get("mock_bw_server");
        return "1".equalsIgnoreCase(mockBwConfig);
    }

    public static boolean isTrusteeWeCreate() {
        Map dimImcConfig = IsmcConfigUtil.getValue((String)"isTrusteeWeCreate");
        String mockBwConfig = (String)dimImcConfig.get("isTrusteeWeCreate");
        return "1".equalsIgnoreCase(mockBwConfig);
    }

    public static boolean isDownloadJpg() {
        Map dimImcConfig = IsmcConfigUtil.getValue((String)"dim_pdf_config");
        String downloadJpg = (String)dimImcConfig.get("dim_download_jpg");
        return "1".equalsIgnoreCase(downloadJpg);
    }

    public static boolean isProxyDownloadOfd() {
        Map dimImcConfig = IsmcConfigUtil.getValue((String)"dim_imc_config");
        String proxyDownload = (String)dimImcConfig.get("dim_proxy_download_ofd");
        return "1".equalsIgnoreCase(proxyDownload);
    }

    public static boolean isSignS3Together() {
        Map dimImcConfig = IsmcConfigUtil.getValue((String)"dim_pdf_config");
        String sealS3 = (String)dimImcConfig.get("dim_seal_s3");
        return "1".equalsIgnoreCase(sealS3);
    }

    public static DynamicObject getInvoiceByOrderNo(String orderNo) {
        QFilter allFilter = new QFilter("orderno", "=", (Object)orderNo);
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"iim_vat_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"iim_vat_invoice", (boolean)true), (QFilter[])allFilter.toArray());
        if (null == array || array.length == 0) {
            throw new MsgException(String.format("\u6d41\u6c34\u53f7\uff1a%s\u5bf9\u5e94\u7684\u53d1\u7968\u6570\u636e\u672a\u627e\u5230", orderNo));
        }
        return array[0];
    }

    public static DynamicObject getInvoiceByOrderOrNull(String orderNo) {
        try {
            return InvoiceUtil.getInvoiceByOrderNo((String)orderNo);
        }
        catch (MsgException e) {
            LOGGER.info(String.format("%s:\u6570\u636e\u4e0d\u5b58\u5728,\u63d2\u5165\u65b0\u6570\u636e", orderNo));
            return null;
        }
    }

    private static Integer getConfigValue(String config_key) {
        JSONObject cacheJSON;
        String cacheValue;
        String cacheStr = CacheHelper.get((String)"retry_config");
        if (StringUtils.isNotBlank((CharSequence)cacheStr) && StringUtils.isNotBlank((CharSequence)(cacheValue = (cacheJSON = JSONObject.parseObject((String)cacheStr)).getString(config_key)))) {
            return Integer.parseInt(cacheValue);
        }
        QFilter filter = new QFilter("config_type", "=", (Object)"retry_config");
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"dim_param_config", (String)"config_key,config_value", (QFilter[])filter.toArray());
        HashMap<String, String> param = new HashMap<String, String>();
        Integer result = null;
        for (DynamicObject object : array) {
            param.put(object.getString("config_key"), object.getString("config_value"));
            if (!config_key.equals(object.getString("config_key"))) continue;
            result = Integer.parseInt(object.getString("config_value"));
        }
        CacheHelper.put((String)"retry_config", (String)JSONObject.toJSONString(param), (int)86400);
        return result;
    }

    public static Set<String> getPaperInvoiceType() {
        return ImmutableSet.of((Object)InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), (Object)InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode(), (Object)InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode());
    }

    public static boolean isPaperInvoice(String invoiceType) {
        return InvoiceUtil.getPaperInvoiceType().contains(invoiceType);
    }

    public static Set<String> getSpecialInvoiceType() {
        return ImmutableSet.of((Object)InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), (Object)InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode());
    }

    public static boolean isSpecialInvoice(String invoiceType) {
        return InvoiceUtil.getSpecialInvoiceType().contains(invoiceType);
    }

    public static boolean useFastFail() {
        Map dimImcConfig = IsmcConfigUtil.getValue((String)"dim_imc_config");
        String proxyDownload = (String)dimImcConfig.get("dim_fast_fail");
        return "1".equalsIgnoreCase(proxyDownload);
    }

    public static boolean useSmartMode() {
        Map dimImcConfig = IsmcConfigUtil.getValue((String)"dim_imc_config");
        String proxyDownload = (String)dimImcConfig.get("dim_smart_mode");
        return "1".equalsIgnoreCase(proxyDownload);
    }

    public static boolean isNewConvertImage() {
        Map dimImcConfig = IsmcConfigUtil.getValue((String)"dim_imc_config");
        String newCreateImageConfig = (String)dimImcConfig.get("dim_create_jpg");
        return "1".equalsIgnoreCase(newCreateImageConfig);
    }

    public static PdfCreateInfo getPdfCreateInfo(DynamicObject invoice) {
        String taxNo;
        PdfCreateInfo pdfInfo = PdfCreateInfo.getInfo();
        String specialType = invoice.getString("specialtype");
        String jqbh = invoice.getString("jqbh");
        if ("02".equals(specialType)) {
            pdfInfo.setSGInvoice(true);
            taxNo = invoice.getString("buyertaxno");
        } else {
            pdfInfo.setSGInvoice(false);
            taxNo = invoice.getString("salertaxno");
        }
        pdfInfo.setUseNewTempalte(InvoiceUtil.isUseNewTemplate((String)taxNo, (String)jqbh));
        String issueSource = invoice.getString("issuesource");
        if ("3".equalsIgnoreCase(issueSource)) {
            pdfInfo.setVirtualUkey(true);
        }
        pdfInfo.setPaperInvoice(InvoiceUtil.isPaperInvoice((String)invoice.getString("invoicetype")));
        if ("1".equals(IsmcConfigUtil.getValue((String)"volumeInvoiceCreate", (String)"volumeInvoiceCreate")) && "025".equals(invoice.getString("invoicetype"))) {
            pdfInfo.setPaperInvoice(false);
            if ("6".equals(invoice.getString("invoicestatus"))) {
                pdfInfo.setAddCancelLable(true);
            }
            pdfInfo.setInvoiceCodeAndNo(invoice.getString("invoicecode") + "-" + invoice.getString("invoiceno"));
        }
        pdfInfo.setOrderNo(invoice.getString("orderno"));
        pdfInfo.setInvoice(invoice);
        pdfInfo.setIssueSource(issueSource);
        pdfInfo.setInvoiceTypeCode(invoice.getString("invoicetype"));
        pdfInfo.setInventoryMark("1".equalsIgnoreCase(invoice.getString("inventorymark")));
        return pdfInfo;
    }

    public static boolean isUseNewTemplate(String taxNo, String jqbh) {
        String concatKey;
        Map dimImcConfig = IsmcConfigUtil.getValue((String)"dim_pdf_template_config");
        String dim_pdf_template_config = (String)dimImcConfig.get(concatKey = taxNo.concat(jqbh));
        if (StringUtils.isNotBlank((CharSequence)dim_pdf_template_config)) {
            return "2".equalsIgnoreCase(dim_pdf_template_config);
        }
        String taxNoConfig = (String)dimImcConfig.get(taxNo);
        return "2".equalsIgnoreCase(taxNoConfig);
    }
}

