/*
 * Decompiled with CFR 0.152.
 */
package kd.ismc.dim.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ismc.dim.common.constant.BeanFieldAnnotation;
import kd.ismc.dim.common.constant.IssueType;
import kd.ismc.dim.common.constant.TaxRate;
import kd.ismc.dim.common.model.InvoicePdf;
import kd.ismc.dim.common.model.InvoicePdfItem;
import kd.ismc.dim.common.util.DateUtils;
import kd.ismc.dim.common.util.IsmcConfigUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class DynamicObjectUtil {
    private static Log log = LogFactory.getLog(DynamicObjectUtil.class);
    private static final String TAXED_TYPE_DIFFERENCE = "2";

    public static <T> T dynamicObject2Bean(Class<T> clazz, DynamicObject dynamicObject) {
        T entity = null;
        try {
            DataEntityPropertyCollection collect = dynamicObject.getDataEntityType().getProperties();
            entity = clazz.newInstance();
            List fields = DynamicObjectUtil.getDeclaredFields(entity);
            for (Field field : fields) {
                String name;
                ReflectionUtils.makeAccessible((Field)field);
                BeanFieldAnnotation beanField = field.getAnnotation(BeanFieldAnnotation.class);
                if (beanField == null || !collect.containsKey((Object)(name = beanField.dynamicFiled()))) continue;
                DynamicObjectUtil.setField((DynamicObject)dynamicObject, (BeanFieldAnnotation)beanField, (Field)field, entity);
            }
        }
        catch (Exception e) {
            log.error("dynamicObject\u8f6c\u6362\u5931\u8d25,\u5b9e\u4f53\u540d:[" + dynamicObject.getDataEntityType().getName() + "]");
        }
        return entity;
    }

    private static <T> List<Field> getDeclaredFields(T bean) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(bean.getClass().getDeclaredFields()));
        if (bean.getClass().getClassLoader() != null) {
            fields.addAll(Arrays.asList(bean.getClass().getSuperclass().getDeclaredFields()));
        }
        return fields;
    }

    public static DynamicObject json2DynamicObject(JSONObject json, DynamicObject dynamicObject) {
        DataEntityPropertyCollection collect = dynamicObject.getDataEntityType().getProperties();
        Set fields = collect.stream().map(IMetadata::getName).collect(Collectors.toSet());
        for (Map.Entry entry : json.entrySet()) {
            try {
                if ("id".equals(entry.getKey())) continue;
                if ("zerotaxmark".equals(entry.getKey())) {
                    dynamicObject.set("zeromark", entry.getValue());
                    continue;
                }
                if (!fields.contains(entry.getKey())) continue;
                if ("null".equals(entry.getValue())) {
                    dynamicObject.set((String)entry.getKey(), null);
                    continue;
                }
                Class clazz = ((IDataEntityProperty)collect.get(entry.getKey())).getPropertyType();
                if (clazz == String.class) {
                    dynamicObject.set((String)entry.getKey(), entry.getValue());
                    continue;
                }
                if (clazz == Date.class && StringUtils.isNotBlank(entry.getValue())) {
                    dynamicObject.set((String)entry.getKey(), (Object)DateUtils.stringToDate((String)((String)entry.getValue()), (String)"yyyy-MM-dd HH:mm:ss"));
                    continue;
                }
                if (clazz == BigDecimal.class && StringUtils.isBlank(entry.getValue())) {
                    dynamicObject.set((String)entry.getKey(), (Object)BigDecimal.ZERO);
                    continue;
                }
                if (clazz == Integer.class && StringUtils.isBlank(entry.getValue())) {
                    dynamicObject.set((String)entry.getKey(), (Object)0);
                    continue;
                }
                if (clazz == Long.class && StringUtils.isBlank(entry.getValue())) {
                    dynamicObject.set((String)entry.getKey(), (Object)0L);
                    continue;
                }
                if (collect.get(entry.getKey()) instanceof EntryProp) {
                    JSONArray jsonArray = (JSONArray)entry.getValue();
                    for (Object itemObject : jsonArray) {
                        DynamicObject obj = dynamicObject.getDynamicObjectCollection((String)entry.getKey()).addNew();
                        DynamicObjectUtil.json2DynamicObject((JSONObject)((JSONObject)itemObject), (DynamicObject)obj);
                    }
                    continue;
                }
                dynamicObject.set((String)entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                log.error(MessageFormat.format("json\u8f6c\u6362DynamicObject\u5931\u8d25{0}, key\u4e3a{1}, \u503c\u4e3a{2}", e.getMessage(), entry.getKey(), entry.getValue()), (Throwable)e);
            }
        }
        return dynamicObject;
    }

    private static <T> void setField(DynamicObject dynamicObject, BeanFieldAnnotation beanField, Field field, T entity) throws IllegalAccessException {
        Class<?> fieldType = field.getType();
        if (String.class == fieldType) {
            field.set(entity, dynamicObject.getString(beanField.dynamicFiled()));
        } else if (Integer.TYPE == fieldType || Integer.class == fieldType) {
            field.set(entity, dynamicObject.getInt(beanField.dynamicFiled()));
        } else if (Long.TYPE == fieldType || Long.class == fieldType) {
            field.set(entity, dynamicObject.getLong(beanField.dynamicFiled()));
        } else if (BigDecimal.class == fieldType) {
            field.set(entity, DynamicObjectUtil.getBigDecimalVal((DynamicObject)dynamicObject, (BeanFieldAnnotation)beanField));
        } else if (Date.class == fieldType) {
            field.set(entity, dynamicObject.getDate(beanField.dynamicFiled()));
        } else if (BigInteger.class == fieldType) {
            field.set(entity, DynamicObjectUtil.getBigIntegerVal((DynamicObject)dynamicObject, (BeanFieldAnnotation)beanField));
        } else if (List.class == fieldType) {
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(beanField.dynamicFiled());
            ArrayList<Object> newList = new ArrayList<Object>();
            for (DynamicObject obj : collection) {
                newList.add(DynamicObjectUtil.dynamicObject2Bean((Class)beanField.classType(), (DynamicObject)obj));
            }
            field.set(entity, newList);
        } else if (fieldType.getClassLoader() != null) {
            DynamicObject obj = dynamicObject.getDynamicObject(beanField.dynamicFiled());
            field.set(entity, DynamicObjectUtil.dynamicObject2Bean(fieldType, (DynamicObject)obj));
        } else {
            field.set(entity, dynamicObject.get(beanField.dynamicFiled()));
        }
    }

    private static BigInteger getBigIntegerVal(DynamicObject dynamicObject, BeanFieldAnnotation beanField) {
        BigInteger integer = BigInteger.ZERO;
        try {
            Object valObject = dynamicObject.get(beanField.dynamicFiled());
            if (valObject != null) {
                String val = String.valueOf(valObject);
                integer = new BigInteger(val);
            }
        }
        catch (Exception e) {
            log.error("BigInteger\u8f6c\u6362\u5931\u8d25,\u5b57\u6bb5\u540d:" + beanField.dynamicFiled());
        }
        return integer;
    }

    private static BigDecimal getBigDecimalVal(DynamicObject obj, BeanFieldAnnotation beanField) {
        BigDecimal val = obj.getBigDecimal(beanField.dynamicFiled());
        if (val != null) {
            val = val.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal("0.00") : val.setScale(beanField.scale(), 4);
        }
        return val;
    }

    public static void map2DynamicObject(Map<String, Object> map, DynamicObject dynamicObject) {
        DataEntityPropertyCollection collect = dynamicObject.getDataEntityType().getProperties();
        for (IDataEntityProperty property : collect) {
            String field = property.getName();
            if (property instanceof EntryProp) {
                DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(field);
                List list = (List)map.get(field);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    list.forEach(o -> DynamicObjectUtil.map2DynamicObject((Map)o, (DynamicObject)collection.addNew()));
                }
            }
            dynamicObject.set(field, map.get(field));
        }
    }

    public static void copyDynamicObject(DynamicObject source, DynamicObject target) {
        Set sourceProperties = source.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
        DataEntityPropertyCollection collect = target.getDataEntityType().getProperties();
        for (IDataEntityProperty property : collect) {
            String field;
            if (property instanceof BasedataProp || property instanceof CreateDateProp || !sourceProperties.contains(field = property.getName())) continue;
            target.set(field, source.get(field));
        }
    }

    public static DynamicObject getKeyDynamicObject(String tableName, String tableKey, Object key) {
        QFilter filter = new QFilter(tableKey, "=", key);
        return BusinessDataServiceHelper.loadSingle((String)tableName, (String)"id", (QFilter[])filter.toArray());
    }

    public static InvoicePdf invoiceDyanmicObj2InvoicePdf(DynamicObject invoice) {
        InvoicePdf invoicePdf = new InvoicePdf();
        invoicePdf.setAmountType("0");
        invoicePdf.setInvoiceType("1");
        String specialType = invoice.getString("specialtype");
        invoicePdf.setBuyerAccount(invoice.getString("buyerbank") + invoice.getString("buyerbankacc"));
        invoicePdf.setBuyerAddressPhone(invoice.getString("buyeraddr") + invoice.getString("buyertelno"));
        invoicePdf.setBuyerName(invoice.getString("buyername"));
        invoicePdf.setBuyerTaxNo(invoice.getString("buyertaxno"));
        invoicePdf.setCheckCode(invoice.getString("checkcode"));
        invoicePdf.setDrawer(invoice.getString("drawer"));
        invoicePdf.setInvoiceCode(invoice.getString("invoicecode"));
        invoicePdf.setInvoiceNo(invoice.getString("invoiceno"));
        invoicePdf.setIssueSource(invoice.getString("issuesource"));
        Date issueDate = invoice.getDate("issuetime");
        String format = DateUtils.format((Date)issueDate, (String)"yyyy-MM-dd");
        invoicePdf.setInvoiceDate(format);
        invoicePdf.setIssueTime(issueDate);
        invoicePdf.setMachineNo(DynamicObjectUtil.dealJqbh((DynamicObject)invoice));
        String originalInvoiceCode = invoice.getString("originalinvoicecode");
        invoicePdf.setOriginalInvoiceCode(originalInvoiceCode);
        String originalInvoiceNo = invoice.getString("originalinvoiceno");
        invoicePdf.setOriginalInvoiceNo(originalInvoiceNo);
        invoicePdf.setPayee(invoice.getString("payee"));
        String remark = DynamicObjectUtil.createRemark((DynamicObject)invoice, (String)originalInvoiceCode, (String)originalInvoiceNo);
        invoicePdf.setRemark(remark);
        invoicePdf.setReviewer(invoice.getString("reviewer"));
        invoicePdf.setSalerAccount(invoice.getString("salerbank") + invoice.getString("salerbankacc"));
        invoicePdf.setSalerAddressPhone(invoice.getString("saleraddr") + invoice.getString("salertelno"));
        invoicePdf.setSalerName(invoice.getString("salername"));
        invoicePdf.setSalerTaxNo(invoice.getString("salertaxno"));
        if ("02".equals(specialType)) {
            String buyerTaxNo = invoicePdf.getBuyerTaxNo();
            invoicePdf.setBuyerTaxNo(invoicePdf.getSalerTaxNo());
            invoicePdf.setSalerTaxNo(buyerTaxNo);
            String buyerName = invoicePdf.getBuyerName();
            invoicePdf.setBuyerName(invoicePdf.getSalerName());
            invoicePdf.setSalerName(buyerName);
            String buyerAccount = invoicePdf.getBuyerAccount();
            invoicePdf.setBuyerAccount(invoicePdf.getSalerAccount());
            invoicePdf.setSalerAccount(buyerAccount);
            String buyerAddressPhone = invoicePdf.getBuyerAddressPhone();
            invoicePdf.setBuyerAddressPhone(invoicePdf.getSalerAddressPhone());
            invoicePdf.setSalerAddressPhone(buyerAddressPhone);
            invoicePdf.setIsPurchaseSign("1");
        }
        invoicePdf.setSecret(invoice.getString("skm"));
        BigDecimal amount = invoice.getBigDecimal("invoiceamount");
        invoicePdf.setTotalAmount(DynamicObjectUtil.dealMoney((BigDecimal)amount));
        BigDecimal totalAmountIncludeTax = invoice.getBigDecimal("totalamount");
        invoicePdf.setTotalPriceTax(DynamicObjectUtil.dealMoney((BigDecimal)totalAmountIncludeTax));
        BigDecimal totalTax = invoice.getBigDecimal("totaltax");
        invoicePdf.setTotalTax(DynamicObjectUtil.dealMoney((BigDecimal)totalTax));
        String issueType = invoice.getString("issuetype");
        invoicePdf.setType(issueType);
        invoicePdf.setOrderNo(invoice.getString("orderno"));
        DynamicObjectCollection items2 = invoice.getDynamicObjectCollection("items");
        invoicePdf.setInvoiceTypeCode(invoice.getString("invoicetype"));
        ArrayList<InvoicePdfItem> arrayList = new ArrayList<InvoicePdfItem>();
        invoicePdf.setItems(arrayList);
        boolean isSpecialDealJuanPiao = "1".equals(IsmcConfigUtil.getValue((String)"volumeInvoiceCreate", (String)"volumeInvoiceCreate")) && "025".equals(invoicePdf.getInvoiceTypeCode());
        for (int i = 0; i < items2.size(); ++i) {
            String goodsName;
            DynamicObject item = (DynamicObject)items2.get(i);
            String goodsCode = item.getString("goodscode");
            if (StringUtils.isBlank((CharSequence)goodsCode) && IssueType.BLUE_INVOICE.getTypeCode().equals(issueType)) continue;
            InvoicePdfItem invoicePdfItem = new InvoicePdfItem();
            BigDecimal itemAmount = item.getBigDecimal("amount");
            String money = DynamicObjectUtil.dealMoney((BigDecimal)itemAmount);
            invoicePdfItem.setDetailAmount(money.equals("0.00") ? "" : money);
            invoicePdfItem.setGoodsCode(goodsCode);
            invoicePdfItem.setGoodsName(item.getString("goodsname"));
            if (isSpecialDealJuanPiao && (goodsName = String.valueOf(invoicePdfItem.getGoodsName())).charAt(0) == '*') {
                String subValue = goodsName.substring(1, goodsName.length() - 1);
                int index = subValue.indexOf(42) + 2;
                goodsName = goodsName.substring(index, goodsName.length());
                invoicePdfItem.setGoodsName(goodsName);
            }
            invoicePdfItem.setIsDiscount(item.getString("rowtype"));
            BigDecimal num = item.getBigDecimal("num");
            String numStr = DynamicObjectUtil.dealNum((BigDecimal)num);
            invoicePdfItem.setNum(numStr.equals("0") ? "" : numStr);
            invoicePdfItem.setSpecModel(item.getString("specification"));
            BigDecimal itemTax = item.getBigDecimal("tax");
            invoicePdfItem.setTaxAmount(DynamicObjectUtil.dealMoney((BigDecimal)itemTax));
            DynamicObjectUtil.dealTaxRate((DynamicObject)item, (InvoicePdfItem)invoicePdfItem);
            invoicePdfItem.setUnit(item.getString("unit"));
            BigDecimal unitPrice = item.getBigDecimal("unitprice");
            String unitPriceStr = DynamicObjectUtil.dealNum((BigDecimal)unitPrice);
            invoicePdfItem.setUnitPrice("0.00".equalsIgnoreCase(unitPriceStr) ? "" : unitPriceStr);
            if ("1".equals(item.getString("rowtype"))) {
                DynamicObject lastRow = (DynamicObject)items2.get(i - 1);
                invoicePdfItem.setZeroRateTag(lastRow.getString("zeromark"));
                invoicePdfItem.setTaxpremark(StringUtils.trimToEmpty((String)lastRow.getString("taxpremark")));
                invoicePdfItem.setZzstsgl(StringUtils.trimToEmpty((String)lastRow.getString("zzstsgl")));
            } else {
                invoicePdfItem.setZeroRateTag(item.getString("zeromark"));
                invoicePdfItem.setTaxpremark(StringUtils.trimToEmpty((String)item.getString("taxpremark")));
                invoicePdfItem.setZzstsgl(StringUtils.trimToEmpty((String)item.getString("zzstsgl")));
            }
            arrayList.add(invoicePdfItem);
        }
        return invoicePdf;
    }

    private static String dealJqbh(DynamicObject invoice) {
        String jqbh = invoice.getString("jqbh");
        if (StringUtils.isBlank((CharSequence)jqbh)) {
            return jqbh;
        }
        if (jqbh.length() == 14 && jqbh.startsWith("44")) {
            return jqbh.substring(2);
        }
        if (jqbh.length() == 14 && jqbh.startsWith("33")) {
            return jqbh.substring(2);
        }
        return jqbh;
    }

    private static String createRemark(DynamicObject invoice, String originalInvoiceCode, String originalInvoiceNo) {
        int hsslbs = invoice.getInt("taxedtype");
        String remarkMain = invoice.getString("remark");
        String remark1 = "";
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode) && StringUtils.isNotBlank((CharSequence)originalInvoiceNo) && !remarkMain.contains("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801")) {
            remark1 = StringUtils.isBlank((CharSequence)remarkMain) ? "\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:" + originalInvoiceCode + "\u53f7\u7801:" + originalInvoiceNo : "\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:" + originalInvoiceCode + "\u53f7\u7801:" + originalInvoiceNo + "\u3002";
        }
        BigDecimal deduction = invoice.getBigDecimal("deduction");
        String remark0 = "";
        if (2 == hsslbs && !remarkMain.contains("\u5dee\u989d\u5f81\u7a0e")) {
            if (StringUtils.isBlank((CharSequence)remark1)) {
                BigDecimal deductionValue = deduction.setScale(2, RoundingMode.HALF_UP);
                remark0 = "\u5dee\u989d\u5f81\u7a0e\uff1a" + deductionValue + "\u3002";
            } else {
                remark0 = "\u5dee\u989d\u5f81\u7a0e\u3002";
            }
        }
        return remark0 + remark1 + remarkMain;
    }

    private static String dealMoney(BigDecimal money) {
        if (null == money) {
            return "";
        }
        BigDecimal bigDecimal = money.setScale(8, RoundingMode.HALF_UP);
        String result = bigDecimal.stripTrailingZeros().toPlainString();
        if (!result.contains(".")) {
            return result + ".00";
        }
        return result;
    }

    private static String dealNum(BigDecimal itemTax) {
        if (null == itemTax) {
            return "";
        }
        return itemTax.stripTrailingZeros().toPlainString();
    }

    private static void dealTaxRate(DynamicObject item, InvoicePdfItem invoicePdfItem) {
        String percentRateStr = TaxRate.getPercentStr((BigDecimal)new BigDecimal(item.getString("taxrate")));
        String s = new BigDecimal(item.getString("taxrate")).multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString();
        invoicePdfItem.setTaxRate(s);
    }

    public static long getDynamicObjectLongValue(Object value) {
        try {
            if (value instanceof DynamicObject) {
                return Long.parseLong(((DynamicObject)value).getPkValue().toString());
            }
            return Long.parseLong(value.toString());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static List<Map<String, Object>> dynamicObjects2ListMap(DynamicObject[] objs) {
        ArrayList list = Lists.newArrayListWithCapacity((int)objs.length);
        for (DynamicObject obj : objs) {
            list.add(DynamicObjectUtil.dynamicObject2Map((DynamicObject)obj));
        }
        return list;
    }

    public static Map<String, Object> dynamicObject2Map(DynamicObject obj) {
        HashMap<String, Object> map = new HashMap<String, Object>(60);
        DataEntityPropertyCollection collect = obj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : collect) {
            String field = property.getName();
            if (property.getPropertyType() == Long.class || property.getPropertyType() == Long.TYPE) {
                Object value = obj.get(field);
                if (value == null) continue;
                map.put(field, String.valueOf(value));
                continue;
            }
            if (property instanceof EntryProp) {
                DynamicObjectCollection collection = obj.getDynamicObjectCollection(field);
                map.put(field, DynamicObjectUtil.dynamicObjectColletction2ListMap((DynamicObjectCollection)collection));
                continue;
            }
            map.put(field, obj.get(field));
        }
        return map;
    }

    public static List<Map<String, Object>> dynamicObjectColletction2ListMap(DynamicObjectCollection collection) {
        ArrayList list = Lists.newArrayListWithCapacity((int)collection.size());
        for (DynamicObject obj : collection) {
            list.add(DynamicObjectUtil.dynamicObject2Map((DynamicObject)obj));
        }
        return list;
    }
}

