/*
 * Decompiled with CFR 0.152.
 */
package kd.ismc.dim.formplugin.pdf.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.itextpdf.text.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ismc.dim.common.constant.FileType;
import kd.ismc.dim.common.helper.DeviceHelper;
import kd.ismc.dim.common.helper.S3Helper;
import kd.ismc.dim.common.message.constant.ErrorType;
import kd.ismc.dim.common.message.exception.MsgException;
import kd.ismc.dim.common.message.model.MsgResponse;
import kd.ismc.dim.common.model.PdfCreateInfo;
import kd.ismc.dim.common.service.InvoiceFileService;
import kd.ismc.dim.common.util.CacheHelper;
import kd.ismc.dim.common.util.DynamicObjectUtil;
import kd.ismc.dim.common.util.FileUploadUtils;
import kd.ismc.dim.common.util.IsmcConfigUtil;
import kd.ismc.dim.common.util.StringUtils;
import kd.ismc.dim.formplugin.message.util.Pdf2JpgUtils;
import kd.ismc.dim.formplugin.pdf.ITextFactory;
import kd.ismc.dim.formplugin.pdf.model.COMMON_FPKJ_FPT;
import kd.ismc.dim.formplugin.pdf.model.COMMON_FPKJ_XMXX;
import kd.ismc.dim.formplugin.pdf.model.CheckReturnInfo;
import kd.ismc.dim.formplugin.pdf.model.Invoice_spbm;
import kd.ismc.dim.formplugin.pdf.model.PdfProduceBean;
import kd.ismc.dim.formplugin.pdf.model.PdfReturnBean;
import kd.ismc.dim.formplugin.pdf.model.REQUEST_COMMON_FPKJ;
import kd.ismc.dim.formplugin.pdf.service.ICheckService;
import kd.ismc.dim.formplugin.pdf.service.IPdfService;
import kd.ismc.dim.formplugin.pdf.service.ITaxCodeService;
import kd.ismc.dim.formplugin.pdf.service.NewSignService;
import kd.ismc.dim.formplugin.pdf.service.TaxCodeServiceImpl;
import kd.ismc.dim.formplugin.pdf.service.impl.CheckServiceImpl;
import kd.ismc.dim.formplugin.pdf.service.impl.PdfServiceImpl;
import kd.ismc.dim.formplugin.pdf.util.CodingNumberUtil;
import kd.ismc.dim.formplugin.pdf.util.Crc16Util;
import kd.ismc.dim.formplugin.pdf.util.Handle;
import kd.ismc.dim.formplugin.pdf.util.InvoiceConvertUtilv2;
import kd.ismc.dim.formplugin.pdf.util.QRUtil;
import kd.ismc.dim.formplugin.pdf.util.SelectCompanyUtil;
import kd.ismc.dim.formplugin.pdf.util.StringUtil;

public class PdfHandleService {
    private static final Log logger = LogFactory.getLog(PdfHandleService.class);
    private static final HashMap<String, String> LOCATION_MAP = new HashMap();
    private ITaxCodeService iTaxCodeService = TaxCodeServiceImpl.getInstance();
    private ICheckService checkParamService = new CheckServiceImpl();
    private IPdfService iPdfService = PdfServiceImpl.getInstance();
    private static final String targetPath = "pdf/target/";
    private static final String ELECTRIC_NORMAL_INVOICE = "026";
    private static final String ELECTRIC_SPECIAL_INVOICE = "028";

    public JSONObject generateOutputInvoicePdf(JSONObject invoice, PdfCreateInfo pdfInfo) throws Exception {
        JSONObject result = this.checkInvoiceEmptyData(invoice);
        if (!ErrorType.SUCCESS.getCode().equals(result.getString("errcode"))) {
            return result;
        }
        String createType = invoice.getString("invoiceType");
        if (null == createType || "".equals(createType)) {
            result.put("errcode", (Object)"1301");
            result.put("description", (Object)"\u751f\u6210PDF\u7c7b\u578b\u53c2\u6570\u9519\u8bef!");
            return result;
        }
        invoice.put("isSGInvoice", (Object)pdfInfo.isSGInvoice());
        result = this.checkOutputInvoiceData(invoice);
        if (!ErrorType.SUCCESS.getCode().equals(result.getString("errcode"))) {
            logger.error(result.toJSONString());
            return result;
        }
        result = this.checkGenerateTemplatePath(invoice);
        if (pdfInfo.isVirtualUkey() && "\u672a\u8bfb\u53d6\u5230\u6b63\u786e\u7684\u6a21\u677f\u8def\u5f84!".equals(result.get((Object)"description"))) {
            result.put("data", (Object)"shenzhen.pdf");
            result.put("errorcode", (Object)"0000");
            result.put("description", (Object)"\u64cd\u4f5c\u6210\u529f");
        }
        if (!ErrorType.SUCCESS.getCode().equals(result.getString("errcode"))) {
            return result;
        }
        String serinalNo = invoice.getString("orderNo");
        this.generatePDFHandle(invoice, serinalNo, pdfInfo);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("errcode", (Object)ErrorType.SUCCESS.getCode());
        return jsonObject;
    }

    public void generatePDFHandle(JSONObject invoice, String serinalNo, PdfCreateInfo pdfInfo) throws Exception {
        String invoiceTypeCode = invoice.getString("invoiceTypeCode");
        boolean isPaperInvoice = false;
        if (!ELECTRIC_NORMAL_INVOICE.equals(invoiceTypeCode) && !ELECTRIC_SPECIAL_INVOICE.equals(invoiceTypeCode)) {
            isPaperInvoice = true;
        }
        boolean isVirtualUkey = false;
        if ("3".equals(pdfInfo.getIssueSource())) {
            isVirtualUkey = true;
        }
        String randomCode = CodingNumberUtil.code();
        this.deleteLastDayDir();
        Map templateMap = this.generateTemplatePath(invoice, isPaperInvoice, invoiceTypeCode);
        if (pdfInfo.isVirtualUkey() && "\u672a\u8bfb\u53d6\u5230\u6b63\u786e\u7684\u6a21\u677f\u8def\u5f84!".equals(templateMap.get("description"))) {
            templateMap.put("data", "shenzhen.pdf");
            templateMap.put("errorcode", "0000");
            templateMap.put("description", "\u64cd\u4f5c\u6210\u529f");
        }
        if (pdfInfo.isUseNewTempalte()) {
            String templateName = (String)templateMap.get("data");
            templateMap.put("data", "2222" + templateName);
        }
        REQUEST_COMMON_FPKJ requestInvoiceData = this.resolveInvoiceData(invoice, pdfInfo);
        Map QrCodeMap = this.generateQrCode(this.assembleInvoiceMap(invoice), randomCode);
        Map extraParamMap = this.assembleExtraParamMap(invoice, (String)templateMap.get("data"), QrCodeMap);
        logger.info("\u6dfb\u52a0\u5176\u4ed6\u53c2\u6570\uff08\u6a21\u677f\u8def\u5f84\uff0c\u8fdb\u9500\u9879\u6807\u5fd7\uff09:\u751f\u6210\u53c2\u6570\u96c6\u5408");
        pdfInfo.setPaperInvoice(isPaperInvoice);
        pdfInfo.setOrderNo(serinalNo);
        pdfInfo.setInvoiceTypeCode(invoiceTypeCode);
        pdfInfo.setVirtualUkey(isVirtualUkey);
        this.convertInvoiceDataToPDF(requestInvoiceData, extraParamMap, pdfInfo);
    }

    private void deleteLastDayDir() {
        try {
            if ("deleteHistoryDir".equals(CacheHelper.get((String)"deleteHistoryDir"))) {
                return;
            }
            for (int i = 2; i < 60; ++i) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -i);
                Date lastDay = calendar.getTime();
                File lastDir = new File(targetPath + new SimpleDateFormat("yyyyMMdd").format(lastDay));
                if (!lastDir.exists()) continue;
                this.deleteFile(lastDir);
            }
            logger.info("deleteLastDayDir");
            CacheHelper.put((String)"deleteHistoryDir", (String)"deleteHistoryDir", (int)43200);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void deleteFile(File file) {
        if (file == null || !file.exists()) {
            logger.info("\u6587\u4ef6\u5220\u9664\u5931\u8d25,\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\u4ee5\u53ca\u6587\u4ef6\u8def\u5f84\u662f\u5426\u6b63\u786e");
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteFile(f);
                    continue;
                }
                f.delete();
            }
        }
        file.delete();
    }

    public REQUEST_COMMON_FPKJ resolveInvoiceData(JSONObject invoice, PdfCreateInfo pdfInfo) {
        logger.info("\u89e3\u6790\u53d1\u7968\u4fe1\u606f\u5f00\u59cb.....");
        REQUEST_COMMON_FPKJ requestCommonFpkj = new REQUEST_COMMON_FPKJ();
        COMMON_FPKJ_FPT invoiceCommonData = this.assembleInvoiceCommonData(invoice);
        Map dataMap = new HashMap();
        String flag = invoice.getString("invoiceType");
        if (Handle.isNotEmpty((Object)flag)) {
            dataMap = this.assembleOutputInvoiceDetailList(invoiceCommonData, invoice);
        }
        requestCommonFpkj.setCOMMON_FPKJ_FPT((COMMON_FPKJ_FPT)dataMap.get("bill"));
        requestCommonFpkj.setCOMMON_FPKJ_XMXXS((List)dataMap.get("items"));
        logger.info("=========\u89e3\u6790\u53d1\u7968\u8bf7\u6c42\u53c2\u6570\u5b8c\u6210\uff0c\u5f00\u59cb\u8f6c\u6362\u6570\u636e==============");
        if (pdfInfo.isSGInvoice()) {
            requestCommonFpkj.getCOMMON_FPKJ_FPT().setPurcharseSign(true);
        }
        return requestCommonFpkj;
    }

    public COMMON_FPKJ_FPT assembleInvoiceCommonData(JSONObject invoice) {
        String salerAccount;
        String salesAddress;
        String salerTaxNo;
        String salesName;
        String buyerAccount;
        String buyerAddressPhone;
        String buyerTaxNo;
        String buyerName;
        logger.info("\u7ec4\u88c5\u53d1\u7968\u57fa\u7840\u6570\u636e\u5f00\u59cb...");
        String type = invoice.getString("type");
        String originalInvoiceCode = invoice.getString("originalInvoiceCode");
        String originalInvoiceNo = invoice.getString("originalInvoiceNo");
        String invoiceDate = invoice.getString("invoiceDate");
        String isPurchaseSign = invoice.getString("isPurchaseSign");
        if (!"1".equals(isPurchaseSign)) {
            buyerName = invoice.getString("buyerName");
            buyerTaxNo = invoice.getString("buyerTaxNo");
            buyerAddressPhone = invoice.getString("buyerAddressPhone");
            buyerAccount = invoice.getString("buyerAccount");
            salesName = invoice.getString("salerName");
            salerTaxNo = invoice.getString("salerTaxNo");
            salesAddress = invoice.getString("salerAddressPhone");
            salerAccount = invoice.getString("salerAccount");
        } else {
            buyerName = invoice.getString("salerName");
            buyerTaxNo = invoice.getString("salerTaxNo");
            buyerAddressPhone = invoice.getString("salerAddressPhone");
            buyerAccount = invoice.getString("salerAccount");
            salesName = invoice.getString("buyerName");
            salerTaxNo = invoice.getString("buyerTaxNo");
            salesAddress = invoice.getString("buyerAddressPhone");
            salerAccount = invoice.getString("buyerAccount");
        }
        String remark = invoice.getString("remark");
        String payee = invoice.getString("payee");
        String reviewer = invoice.getString("reviewer");
        String drawer = invoice.getString("drawer");
        COMMON_FPKJ_FPT commonFpkjFpt = new COMMON_FPKJ_FPT();
        commonFpkjFpt.setNSRSBH(salerTaxNo);
        commonFpkjFpt.setNSRMC(salesName);
        commonFpkjFpt.setXHF_NSRSBH(salerTaxNo);
        commonFpkjFpt.setXHF_MC(salesName);
        commonFpkjFpt.setXHF_MC(salesName);
        commonFpkjFpt.setXHF_DZ(salesAddress);
        commonFpkjFpt.setSKF_YHZH(salerAccount);
        commonFpkjFpt.setGHF_MC(buyerName);
        commonFpkjFpt.setGHF_NSRSBH(buyerTaxNo);
        commonFpkjFpt.setGHF_DZ(buyerAddressPhone);
        commonFpkjFpt.setFKF_YHZH(buyerAccount);
        commonFpkjFpt.setKPY(drawer);
        commonFpkjFpt.setSKY(payee);
        commonFpkjFpt.setFHR(reviewer);
        commonFpkjFpt.setKPLX(type);
        commonFpkjFpt.setKPRQ(invoiceDate);
        commonFpkjFpt.setBZ(remark);
        commonFpkjFpt.setYFP_DM(originalInvoiceCode);
        commonFpkjFpt.setYFP_HM(originalInvoiceNo);
        return commonFpkjFpt;
    }

    public Map<String, Object> assembleOutputInvoiceDetailList(COMMON_FPKJ_FPT common, JSONObject invoice) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ArrayList<COMMON_FPKJ_XMXX> list = new ArrayList<COMMON_FPKJ_XMXX>();
        DecimalFormat df = new DecimalFormat("######0.00");
        JSONArray items2 = invoice.getJSONArray("items");
        int len = 0;
        int ggxh_len = 40;
        int dw_len = 28;
        for (Object o : items2) {
            Object zzstsgl;
            String goodsName;
            COMMON_FPKJ_XMXX commonFpkjXmxx = new COMMON_FPKJ_XMXX();
            JSONObject items1Json = JSONObject.parseObject((String)o.toString());
            if (Handle.isNotEmpty((Object)items1Json.getString("goodsName"))) {
                if (items1Json.getString("goodsName").startsWith("*")) {
                    goodsName = items1Json.getString("goodsName");
                    commonFpkjXmxx.setXMMC(goodsName);
                } else if (!StringUtils.isEmpty((String)items1Json.getString("goodsCode"))) {
                    Invoice_spbm is = new Invoice_spbm();
                    String goodsCode = items1Json.getString("goodsCode");
                    is.setFgoods_code(goodsCode);
                    is = null;
                    if (Handle.isNotEmpty((Object)is)) {
                        commonFpkjXmxx.setXMMC("*" + is.getFgoods_jmmc() + "*" + items1Json.getString("goodsName"));
                    } else {
                        commonFpkjXmxx.setXMMC(items1Json.getString("goodsName"));
                    }
                } else {
                    commonFpkjXmxx.setXMMC(items1Json.getString("goodsName"));
                }
            }
            if (!StringUtils.isEmpty((String)items1Json.getString("goodsCode"))) {
                String goodsCode = items1Json.getString("goodsCode").trim();
                if (goodsCode.length() > 11) {
                    Long goodsCodePrefix = Long.valueOf(goodsCode.substring(0, 11));
                    boolean isProductOil = goodsCodePrefix >= 10701010000L && goodsCodePrefix <= 10701011000L;
                    commonFpkjXmxx.setProductOil(isProductOil);
                }
            } else if (Handle.isNotEmpty((Object)items1Json.getString("goodsName"))) {
                goodsName = items1Json.getString("goodsName");
                boolean isProductOil = (goodsName.contains("\u6c7d\u6cb9") || goodsName.contains("\u7164\u6cb9") || goodsName.contains("\u67f4\u6cb9") || goodsName.contains("\u71c3\u6599\u6cb9") || goodsName.contains("\u77f3\u8111\u6cb9") || goodsName.contains("\u77f3\u8721") || goodsName.contains("\u6eb6\u5242\u6cb9") || goodsName.contains("\u6da6\u6ed1\u6cb9") || goodsName.contains("\u6da6\u6ed1\u8102")) && !goodsName.contains("\u5e9f\u6da6\u6ed1\u8102") && !goodsName.contains("\u5e9f\u6da6\u6ed1\u6cb9");
                commonFpkjXmxx.setProductOil(isProductOil);
            } else {
                commonFpkjXmxx.setProductOil(false);
            }
            String specification = items1Json.getString("specModel");
            if (!StringUtils.isEmpty((String)specification)) {
                for (int i = 0; i < specification.length(); ++i) {
                    if (specification.charAt(i) > '\u0100') {
                        len += 2;
                        continue;
                    }
                    ++len;
                }
            }
            if (len > ggxh_len) {
                commonFpkjXmxx.setGGXH(specification.substring(0, specification.length() - (len - ggxh_len) / 2));
            } else {
                commonFpkjXmxx.setGGXH(specification);
            }
            len = 0;
            String unit = items1Json.getString("unit");
            if (!StringUtils.isEmpty((String)unit)) {
                for (int i = 0; i < unit.length(); ++i) {
                    if (unit.charAt(i) > '\u0100') {
                        len += 2;
                        continue;
                    }
                    ++len;
                }
            }
            if (len > dw_len) {
                commonFpkjXmxx.setXMDW(unit.substring(0, unit.length() - (len - dw_len) / 2));
            } else {
                commonFpkjXmxx.setXMDW(unit);
            }
            String quantity = items1Json.getString("num");
            if (!StringUtils.isEmpty((String)quantity)) {
                commonFpkjXmxx.setXMSL(quantity);
            }
            len = 0;
            String price = items1Json.getString("unitPrice");
            if (!StringUtils.isEmpty((String)price)) {
                // empty if block
            }
            String amount = items1Json.getString("detailAmount");
            String isDiscount = "0";
            if (!StringUtils.isEmpty((String)items1Json.getString("isDiscount"))) {
                isDiscount = items1Json.getString("isDiscount");
                commonFpkjXmxx.setFPHXZ(isDiscount);
            } else if (StringUtils.isEmpty((String)specification) && StringUtils.isEmpty((String)quantity) && StringUtils.isEmpty((String)price) && StringUtils.isEmpty((String)unit) && (Double.parseDouble(amount) < 0.0 && "0".equals(common.getKPLX()) || Double.parseDouble(amount) > 0.0 && "1".equals(common.getKPLX()))) {
                isDiscount = "1";
                commonFpkjXmxx.setFPHXZ(isDiscount);
            } else {
                commonFpkjXmxx.setFPHXZ(isDiscount);
            }
            commonFpkjXmxx.setXMJE(amount);
            String taxRate = items1Json.getString("taxRate");
            String zeroRateTag = items1Json.getString("zeroRateTag");
            String tax = items1Json.getString("taxAmount");
            if (!"1".equals(isDiscount)) {
                commonFpkjXmxx.setXMDJ(price);
            }
            if ("1".equals(zeroRateTag)) {
                taxRate = "\u514d\u7a0e";
                tax = "***";
            } else if ("2".equals(zeroRateTag)) {
                taxRate = "\u4e0d\u5f81\u7a0e";
                tax = "***";
            } else if ("3".equals(zeroRateTag)) {
                taxRate = "0%";
                tax = "***";
            } else if (StringUtils.isEmpty((String)zeroRateTag)) {
                BigDecimal taxTwo = new BigDecimal(tax);
                taxRate = taxRate + "%";
                tax = df.format(taxTwo);
            }
            if (Handle.isNotEmpty((Object)invoice.getString("remark")) && invoice.getString("remark").contains("\u5dee\u989d\u5f81\u7a0e")) {
                taxRate = "***";
            }
            if (String.valueOf(zzstsgl = items1Json.get((Object)"zzstsgl")).contains("\u7b80\u6613\u5f81\u6536\u51cf\u6309")) {
                taxRate = "***";
            }
            commonFpkjXmxx.setSE(tax);
            commonFpkjXmxx.setSL(taxRate);
            list.add(commonFpkjXmxx);
        }
        if (Handle.isNotEmpty(list) && list.size() > 0) {
            common.setKPXM(((COMMON_FPKJ_XMXX)list.get(0)).getXMMC());
        }
        String totalAmount = invoice.getString("totalAmount");
        String totalpricetax = invoice.getString("totalPriceTax");
        String totaltax = invoice.getString("totalTax");
        BigDecimal totalAmount2 = new BigDecimal(String.valueOf(totalAmount));
        BigDecimal totalpricetax2 = new BigDecimal(String.valueOf(totalpricetax));
        BigDecimal totaltax2 = new BigDecimal(String.valueOf(totaltax));
        common.setKPHJJE(df.format(totalpricetax2));
        common.setHJBHSJE(df.format(totalAmount2));
        common.setKPHJSE(df.format(totaltax2));
        boolean isPurchaseSign = false;
        if (invoice != null && "1".equals(invoice.getString("isPurchaseSign"))) {
            isPurchaseSign = true;
        }
        common.setPurcharseSign(isPurchaseSign);
        dataMap.put("bill", common);
        dataMap.put("items", list);
        return dataMap;
    }

    public Map<String, String> generateTemplatePath(JSONObject invoice, boolean isPaperInvoice, String invoiceTypeCode) {
        boolean isVolumeInvoice;
        String salesRevenueNumber = invoice.getString("salerTaxNo");
        String issueSource = invoice.getString("issueSource");
        String invoiceCode = invoice.getString("invoiceCode");
        logger.info("\u8bfb\u53d6\u53d1\u7968pdf\u6a21\u677f\u5f00\u59cb...");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        boolean bl = isVolumeInvoice = "1".equals(IsmcConfigUtil.getValue((String)"volumeInvoiceCreate", (String)"volumeInvoiceCreate")) && "025".equals(invoiceTypeCode);
        if (isVolumeInvoice) {
            resultMap.put("data", "shouju2.pdf");
            resultMap.put("errorcode", "0000");
            resultMap.put("description", "\u64cd\u4f5c\u6210\u529f");
            return resultMap;
        }
        JSONObject result = SelectCompanyUtil.selectCompanyByInvoiceCode((String)invoiceCode);
        if (!"0000".equals(result.get((Object)"errcode"))) {
            result = SelectCompanyUtil.selectCompanyByRevenueNumber((String)salesRevenueNumber);
        }
        logger.info("\u67e5\u8be2company\u670d\u52a1\u7ed3\u6784\u4fe1\u606f:" + JSONObject.toJSONString((Object)result));
        String readerUrl = "";
        if ("0000".equals(result.getString("errcode")) && Handle.isNotEmpty((Object)result.getJSONObject("data"))) {
            JSONObject company = result.getJSONObject("data");
            String provinceName = company.getString("provinceName");
            String cityName = company.getString("cityName");
            HashMap<Integer, String> cityNameMap = new HashMap<Integer, String>();
            cityNameMap.put(1, "\u53a6\u95e8");
            cityNameMap.put(2, "\u5b81\u6ce2");
            cityNameMap.put(3, "\u9752\u5c9b");
            cityNameMap.put(4, "\u5927\u8fde");
            cityNameMap.put(5, "\u6df1\u5733");
            readerUrl = cityNameMap.containsValue(cityName) && !"\u8bf7\u9009\u62e9".equals(cityName) ? cityName : (!StringUtils.isEmpty((String)provinceName) && !"\u8bf7\u9009\u62e9".equals(provinceName) ? provinceName : "default");
            boolean isModelPath = false;
            if (Handle.isNotEmpty((Object)readerUrl)) {
                for (Map.Entry entry : LOCATION_MAP.entrySet()) {
                    if (!readerUrl.contains((CharSequence)entry.getKey())) continue;
                    readerUrl = StringUtils.isNotEmpty((String)issueSource) && "shenzhen".equals(entry.getValue()) && issueSource.equals("5") ? (String)entry.getValue() + "_blockchain.pdf" : (String)entry.getValue() + ".pdf";
                    logger.info("readerUrl\u5339\u914d\u7684\u6a21\u677f\u6587\u4ef6\u4e3a\uff1a" + readerUrl);
                    isModelPath = true;
                    break;
                }
            }
            if (isPaperInvoice) {
                isModelPath = true;
                readerUrl = "007".equals(invoiceTypeCode) ? "normal.pdf" : "special.pdf";
            }
            if (StringUtils.isEmpty((String)readerUrl) || !isModelPath) {
                resultMap.put("errcode", "1300");
                resultMap.put("description", "\u672a\u8bfb\u53d6\u5230\u6b63\u786e\u7684\u6a21\u677f\u8def\u5f84!");
                return resultMap;
            }
            resultMap.put("errcode", ErrorType.SUCCESS.getCode());
            resultMap.put("description", "\u64cd\u4f5c\u6210\u529f");
            resultMap.put("data", readerUrl);
            return resultMap;
        }
        resultMap.put("errcode", "1300");
        resultMap.put("description", "\u672a\u8bfb\u53d6\u5230\u6b63\u786e\u7684\u6a21\u677f\u8def\u5f84!");
        return resultMap;
    }

    public Map<String, Object> generateQrCode(Map<String, Object> paramMap, String codeRandom) {
        char ch;
        logger.info(String.format("\u5f00\u59cb\u751f\u6210\u4e8c\u7ef4\u7801\u5f00\u59cb...\u53c2\u6570map:%s,\u968f\u673a\u503c\uff1a%s", JSONObject.toJSONString(paramMap), codeRandom));
        String billDate = (String)paramMap.get("KPRQ");
        String billYear = billDate.substring(0, 4);
        String billMonth = billDate.substring(5, 7);
        String billDay = billDate.substring(8, 10);
        String kprqQrCode = billYear + billMonth + billDay;
        int qrWidth = 82;
        int qrHeight = 82;
        String sb = "0110" + paramMap.get("FP_DM") + paramMap.get("FP_HM") + paramMap.get("HJBHSJE") + billYear + billMonth + billDay + paramMap.get("JYM");
        byte[] crc16 = sb.getBytes();
        char i = ch = Crc16Util.calCRC((byte[])crc16);
        String str = Integer.toHexString(i);
        str = this.addZeroForString(str);
        String msg = "01,10," + paramMap.get("FP_DM") + "," + paramMap.get("FP_HM") + "," + paramMap.get("HJBHSJE") + "," + kprqQrCode + "," + paramMap.get("JYM") + "," + str + ",";
        byte[] bytes = QRUtil.encode((String)msg.toUpperCase(), (int)qrWidth, (int)qrHeight);
        try {
            paramMap.put("image", Image.getInstance((byte[])bytes));
            return paramMap;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String addZeroForString(String code) {
        if (StringUtil.isEmpty((Object)code)) {
            return code;
        }
        if (code.length() == 1) {
            code = "000" + code;
            return code;
        }
        if (code.length() == 2) {
            code = "00" + code;
            return code;
        }
        if (code.length() == 3) {
            code = "0" + code;
            return code;
        }
        return code;
    }

    public Map<String, Object> assembleExtraParamMap(JSONObject invoice, String templatePath, Map<String, Object> paramMap) {
        DecimalFormat df = new DecimalFormat("######0.00");
        paramMap.put("jqbh", invoice.getString("machineNo"));
        if (Handle.isNotEmpty((Object)invoice.getString("secret"))) {
            paramMap.put("FWMW", invoice.getString("secret"));
        } else {
            paramMap.put("FWMW", "");
        }
        paramMap.put("SSYF", invoice.getString("invoiceDate").substring(5, 7));
        paramMap.put("HJSE", df.format(invoice.getBigDecimal("totalTax")));
        paramMap.put("tag", invoice.getString("invoiceType"));
        paramMap.put("blockchain", invoice.getString("blockchain"));
        paramMap.put("templatePath", templatePath);
        if ("0".equals(invoice.getString("invoiceType"))) {
            paramMap.put("invoiceType", InvoiceConvertUtilv2.checkInvoiceType((String)paramMap.get("FP_DM").toString(), (String)paramMap.get("FP_HM").toString()));
        }
        return paramMap;
    }

    public Map<String, Object> assembleInvoiceMap(JSONObject invoice) {
        DecimalFormat df = new DecimalFormat("######0.00");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (Handle.isNotEmpty((Object)invoice.getString("checkCode"))) {
            paramMap.put("JYM", invoice.getString("checkCode"));
        } else {
            paramMap.put("JYM", "");
        }
        paramMap.put("KPRQ", invoice.getString("invoiceDate"));
        paramMap.put("FP_DM", invoice.getString("invoiceCode"));
        paramMap.put("FP_HM", invoice.getString("invoiceNo"));
        paramMap.put("HJBHSJE", df.format(invoice.getBigDecimal("totalAmount")));
        if (Handle.isNotEmpty((Object)invoice.getString("blockchain"))) {
            paramMap.put("sellerTaxCode", invoice.getString("salerTaxNo"));
            paramMap.put("txHash", invoice.getString("secret"));
            paramMap.put("blockchain", invoice.getString("blockchain"));
            paramMap.put("totalPriceTax", invoice.getString("totalPriceTax"));
        }
        logger.info("\u5f53\u524d\u53d1\u7968\u4e94\u8981\u7d20\uff1a" + ((Object)paramMap).toString());
        return paramMap;
    }

    public void convertInvoiceDataToPDF(REQUEST_COMMON_FPKJ requestInvoiceData, Map<String, Object> extraParamMap, PdfCreateInfo pdfInfo) throws Exception {
        List items2;
        logger.info("error\u7ea7\u522b\u65e5\u5fd7\u662f\u5426\u6253\u5f00:" + logger.isErrorEnabled());
        PdfProduceBean pdfProduceBean = this.iTaxCodeService.taxCode(requestInvoiceData, extraParamMap);
        boolean isPapaerInvoice = pdfInfo.isPaperInvoice();
        boolean isVirtualUkey = pdfInfo.isVirtualUkey();
        if (isPapaerInvoice && (items2 = pdfProduceBean.getCOMMON_FPKJ_XMXXS()).size() > 0 && "\u8be6\u89c1\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u53ca\u6e05\u5355".equals(((COMMON_FPKJ_XMXX)items2.get(0)).getXMMC()) && "0%".equals(((COMMON_FPKJ_XMXX)items2.get(0)).getSL())) {
            ((COMMON_FPKJ_XMXX)items2.get(0)).setSL("");
        }
        PdfReturnBean pdfReturnBean = this.iPdfService.pdfProduceService(pdfProduceBean, pdfInfo);
        logger.info("after iPdfService.pdfProduceService(pdfProduceBean)");
        if (pdfReturnBean.getResultMap().containsKey(-1)) {
            logger.info("PDF\u5b9e\u4f53\u586b\u5199PDF\u6a21\u677f\u5f02\u5e38\u4fe1\u606f:" + pdfReturnBean.getResultMap().get(-1));
            throw new Exception("PDF\u5b9e\u4f53\u586b\u5199PDF\u6a21\u677f\u5f02\u5e38\u4fe1\u606f:" + pdfReturnBean.getResultMap().get(-1));
        }
        byte[] bytes = ITextFactory.mergePdfFiles((Map)pdfReturnBean.getResultMap());
        logger.info("=========\u5408\u5e76PDF\u6587\u4ef6\u5b8c\u6210==============\u6587\u4ef6\u5927\u5c0f\uff1a" + bytes.length);
        boolean isVolumeInvoice = "1".equals(IsmcConfigUtil.getValue((String)"volumeInvoiceCreate", (String)"volumeInvoiceCreate")) && "025".equals(pdfInfo.getInvoiceTypeCode());
        boolean isOfdDevice = DeviceHelper.isOfdDevice((String)pdfInfo.getIssueSource());
        if (isVolumeInvoice) {
            isPapaerInvoice = false;
            isVirtualUkey = false;
            isOfdDevice = false;
        }
        if (isPapaerInvoice || isVirtualUkey || isOfdDevice) {
            logger.info("saveInvoiceRelateFilesJSON:" + JSONObject.toJSONString((Object)requestInvoiceData));
            this.saveInvoiceRelateFiles(requestInvoiceData, bytes, pdfInfo);
        } else {
            this.signInvoiceAndUpload(requestInvoiceData, bytes, pdfInfo);
        }
    }

    private void saveInvoiceRelateFiles(REQUEST_COMMON_FPKJ requestInvoiceData, byte[] bytes, PdfCreateInfo pdfInfo) throws Exception {
        String serinalNo = pdfInfo.getOrderNo();
        String userCode = this.getSellerTaxNo(requestInvoiceData);
        Pdf2JpgUtils.pdf2JpgAndUploadJpg((byte[])bytes, (String)serinalNo, (String)userCode, null, null);
        ByteArrayInputStream srcIs = new ByteArrayInputStream(bytes);
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        String fileSavePath = InvoiceFileService.getFileSavePath((String)userCode, (String)serinalNo, (FileType)FileType.PDF, null, null);
        fileService.delete(fileSavePath);
        FileUploadUtils.upload((String)fileSavePath, (String)(serinalNo + ".pdf"), (InputStream)srcIs);
        logger.info("paperInvoiceSuccessserinalNo" + serinalNo);
        DynamicObject invoice = pdfInfo.getInvoice();
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"));
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"dim_org", (String)"number", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        if ("1".equals(IsmcConfigUtil.getValue((String)"paper_invoice_upload_s3", (String)org.getString("number")))) {
            logger.info(String.format("\u6df1\u5733\u822a\u4fe1\u6258\u7ba1\u7eb8\u7968\u751f\u6210pdf\u4e0a\u4f20S3\u5f00\u59cb,\u6d41\u6c34\u53f7[%s]", serinalNo));
            ByteArrayInputStream pdfInputStream = new ByteArrayInputStream(bytes);
            JSONObject uploadResult = S3Helper.uploadS3((InputStream)pdfInputStream, (FileType)FileType.PDF, (DynamicObject)invoice);
            if (uploadResult.containsKey((Object)"storageUrl")) {
                invoice.set("fileurl", (Object)uploadResult.getString("storageUrl"));
                invoice.set("snapshoturl", (Object)uploadResult.getString("snapshotPreUrl"));
            }
        }
    }

    private void signInvoiceAndUpload(REQUEST_COMMON_FPKJ requestInvoiceData, byte[] bytes, PdfCreateInfo pdfInfo) throws Exception {
        logger.info("seal before requestInvoiceData.getCOMMON_FPKJ_FPT().isPurcharseSign();");
        String userCode = this.getSellerTaxNo(requestInvoiceData);
        MsgResponse msgResponse = new NewSignService().pdfSign(bytes, userCode, pdfInfo);
        if (!ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            throw new MsgException("pdf\u7b7e\u7ae0\u5931\u8d25:" + msgResponse.getErrorMsg());
        }
    }

    private String getSellerTaxNo(REQUEST_COMMON_FPKJ requestInvoiceData) {
        boolean isPurcharseSign = requestInvoiceData.getCOMMON_FPKJ_FPT().isPurcharseSign();
        String userCode = !isPurcharseSign ? requestInvoiceData.getCOMMON_FPKJ_FPT().getXHF_NSRSBH() : requestInvoiceData.getCOMMON_FPKJ_FPT().getGHF_NSRSBH();
        return userCode;
    }

    public JSONObject checkInvoiceEmptyData(JSONObject invoice) {
        JSONObject res = new JSONObject();
        if (Handle.isEmpty((Object)invoice)) {
            res.put("errcode", (Object)"1300");
            res.put("description", (Object)"\u5f00\u7968\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return res;
        }
        if (Handle.isEmpty((Object)invoice.getString("invoiceCode")) || Handle.isEmpty((Object)invoice.getString("invoiceNo"))) {
            res.put("errcode", (Object)"1300");
            res.put("description", (Object)"\u53d1\u7968\u4ee3\u7801\u6216\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return res;
        }
        res.put("errcode", (Object)ErrorType.SUCCESS.getCode());
        res.put("description", (Object)"\u64cd\u4f5c\u6210\u529f");
        return res;
    }

    public JSONObject checkGenerateTemplatePath(JSONObject invoice) {
        boolean isVolumeInvoice;
        String issueSource = invoice.getString("issueSource");
        String invoiceCode = invoice.getString("invoiceCode");
        String salerTaxNo = invoice.getString("salerTaxNo");
        logger.info("\u8bfb\u53d6\u53d1\u7968pdf\u6a21\u677f\u5f00\u59cb...");
        JSONObject resultMap = new JSONObject();
        boolean bl = isVolumeInvoice = "1".equals(IsmcConfigUtil.getValue((String)"volumeInvoiceCreate", (String)"volumeInvoiceCreate")) && "025".equals(invoice.getString("invoiceTypeCode"));
        if (isVolumeInvoice) {
            resultMap.put("errcode", (Object)ErrorType.SUCCESS.getCode());
            resultMap.put("description", (Object)"\u64cd\u4f5c\u6210\u529f");
            resultMap.put("data", (Object)"shouju2.pdf");
            return resultMap;
        }
        JSONObject result = SelectCompanyUtil.selectCompanyByInvoiceCode((String)invoiceCode);
        if (!"0000".equals(result.get((Object)"errcode"))) {
            result = SelectCompanyUtil.selectCompanyByRevenueNumber((String)salerTaxNo);
        }
        logger.info("\u67e5\u8be2company\u670d\u52a1\u7ed3\u6784\u4fe1\u606f:" + JSONObject.toJSONString((Object)result));
        String readerUrl = "";
        if ("0000".equals(result.getString("errcode")) && Handle.isNotEmpty((Object)result.getJSONObject("data"))) {
            JSONObject jsonData = result.getJSONObject("data");
            String provinceName = jsonData.getString("provinceName");
            String cityName = jsonData.getString("cityName");
            HashMap<Integer, String> cityNameMap = new HashMap<Integer, String>();
            cityNameMap.put(1, "\u53a6\u95e8");
            cityNameMap.put(2, "\u5b81\u6ce2");
            cityNameMap.put(3, "\u9752\u5c9b");
            cityNameMap.put(4, "\u5927\u8fde");
            cityNameMap.put(5, "\u6df1\u5733");
            readerUrl = cityNameMap.containsValue(cityName) && !"\u8bf7\u9009\u62e9".equals(cityName) ? cityName : (!StringUtils.isEmpty((String)provinceName) && !"\u8bf7\u9009\u62e9".equals(provinceName) ? provinceName : "default");
            boolean isModelPath = false;
            if (Handle.isNotEmpty((Object)readerUrl)) {
                for (Map.Entry entry : LOCATION_MAP.entrySet()) {
                    if (!readerUrl.contains((CharSequence)entry.getKey())) continue;
                    readerUrl = StringUtils.isNotEmpty((String)issueSource) && "shenzhen".equals(entry.getValue()) && issueSource.equals("5") ? (String)entry.getValue() + "_blockchain.pdf" : (String)entry.getValue() + ".pdf";
                    logger.info("readerUrl\u5339\u914d\u7684\u6a21\u677f\u6587\u4ef6\u4e3a\uff1a" + readerUrl);
                    isModelPath = true;
                    break;
                }
            }
            if (StringUtils.isEmpty((String)readerUrl) || !isModelPath) {
                resultMap.put("errcode", (Object)"1300");
                resultMap.put("description", (Object)"\u672a\u8bfb\u53d6\u5230\u6b63\u786e\u7684\u6a21\u677f\u8def\u5f84!");
                return resultMap;
            }
            resultMap.put("errcode", (Object)ErrorType.SUCCESS.getCode());
            resultMap.put("description", (Object)"\u64cd\u4f5c\u6210\u529f");
            resultMap.put("data", (Object)readerUrl);
            return resultMap;
        }
        resultMap.put("errcode", (Object)"1300");
        resultMap.put("description", (Object)"\u672a\u8bfb\u53d6\u5230\u6b63\u786e\u7684\u6a21\u677f\u8def\u5f84!");
        return resultMap;
    }

    public JSONObject checkOutputInvoiceData(JSONObject invoice) {
        JSONObject res = new JSONObject();
        try {
            CheckReturnInfo checkReturnInfo = this.checkParamService.dataCheck(invoice);
            if (ErrorType.SUCCESS.getCode().equals(checkReturnInfo.getError_code())) {
                res.put("errcode", (Object)ErrorType.SUCCESS.getCode());
                res.put("description", (Object)"\u64cd\u4f5c\u6210\u529f");
            } else {
                res.put("errcode", (Object)"1301");
                res.put("description", (Object)checkReturnInfo.getError_msg());
            }
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u6570\u636e\u51fa\u9519\uff1a" + invoice);
            res.put("errcode", (Object)"1301");
            res.put("description", (Object)"\u6570\u636e\u6821\u9a8c\u51fa\u9519");
        }
        return res;
    }

    static {
        LOCATION_MAP.put("\u5e7f\u4e1c", "guangdong");
        LOCATION_MAP.put("\u5e7f\u897f", "guangxi");
        LOCATION_MAP.put("\u5929\u6d25", "tianjin");
        LOCATION_MAP.put("\u5317\u4eac", "beijing");
        LOCATION_MAP.put("\u4e0a\u6d77", "shanghai");
        LOCATION_MAP.put("\u91cd\u5e86", "chongqing");
        LOCATION_MAP.put("\u6e56\u5357", "hunan");
        LOCATION_MAP.put("\u6cb3\u5357", "henan");
        LOCATION_MAP.put("\u6cb3\u5317", "hebei");
        LOCATION_MAP.put("\u6e56\u5317", "hubei");
        LOCATION_MAP.put("\u6c5f\u82cf", "jiangsu");
        LOCATION_MAP.put("\u6d59\u6c5f", "zhejiang");
        LOCATION_MAP.put("\u6c5f\u897f", "jiangxi");
        LOCATION_MAP.put("\u8fbd\u5b81", "liaoning");
        LOCATION_MAP.put("\u5409\u6797", "jilin");
        LOCATION_MAP.put("\u9ed1\u9f99\u6c5f", "heilongjiang");
        LOCATION_MAP.put("\u5c71\u4e1c", "shandong");
        LOCATION_MAP.put("\u5c71\u897f", "shanxi1");
        LOCATION_MAP.put("\u897f\u85cf", "xizang");
        LOCATION_MAP.put("\u56db\u5ddd", "sichuan");
        LOCATION_MAP.put("\u4e91\u5357", "yunnan");
        LOCATION_MAP.put("\u9752\u6d77", "qinghai");
        LOCATION_MAP.put("\u798f\u5efa", "fujian");
        LOCATION_MAP.put("\u9655\u897f", "shanxi2");
        LOCATION_MAP.put("\u5b81\u590f", "ningxia");
        LOCATION_MAP.put("\u5b89\u5fbd", "anhui");
        LOCATION_MAP.put("\u8d35\u5dde", "guizhou");
        LOCATION_MAP.put("\u6d77\u5357", "hainan");
        LOCATION_MAP.put("\u65b0\u7586", "xinjiang");
        LOCATION_MAP.put("\u5185\u8499\u53e4", "neimenggu");
        LOCATION_MAP.put("\u7518\u8083", "gansu");
        LOCATION_MAP.put("\u53a6\u95e8", "xiamen");
        LOCATION_MAP.put("\u5b81\u6ce2", "ningbo");
        LOCATION_MAP.put("\u9752\u5c9b", "qingdao");
        LOCATION_MAP.put("\u5927\u8fde", "dalian");
        LOCATION_MAP.put("default", "shenzhen");
        LOCATION_MAP.put("\u6df1\u5733", "shenzhen");
    }
}

