/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mservice.issuing;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.DownLoadCenterHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.send.MessageSendService;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.allele.AllEleInvoiceFileHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.Base64;

public class InvoiceMicroService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryInvoiceImageBase64(String invoiceCode, String invoiceNo) {
        QFilter filter = new QFilter("invoicecode", "=", (Object)invoiceCode);
        filter.and("invoiceno", "=", (Object)invoiceNo);
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "salertaxno", "orderno", "invoicetype", "snapshoturl"), (QFilter[])filter.toArray());
        if (invoice == null) {
            return "";
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"))) {
            String snapshotUrl = invoice.getString("snapshoturl");
            if (StringUtils.isBlank((CharSequence)snapshotUrl)) {
                return "";
            }
            InputStream in = null;
            try {
                in = snapshotUrl.startsWith("http") ? DownLoadCenterHelper.getInputStream((String)snapshotUrl) : FileServiceFactory.getAttachmentFileService().getInputStream(snapshotUrl);
                String string = new String(Base64.encodeBase64((byte[])AllEleInvoiceFileHelper.inputStreamToByteArray((InputStream)in)));
                return string;
            }
            catch (Exception e) {
                String string = "";
                return string;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        MsgRequest msgReq = new MsgRequest();
        msgReq.setMsgId(UUID.next());
        msgReq.setMsgType("GetInvoiceImageBase64");
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("taxNo", invoice.getString("salertaxno"));
        requestMap.put("orderNo", invoice.getString("orderno"));
        msgReq.setReqData(requestMap);
        MsgResponse msgResponse = MessageSendService.send((MsgRequest)msgReq);
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            return JSON.parseObject((String)msgResponse.getRespData()).getString("imageStr");
        }
        return "";
    }
}

