/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mservice.issuing;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class IssuedInvoiceQueryServiceImpl {
    public List<Object> queryInvoicePk(List<Pair<String, String>> invoiceCodeNoPair) {
        if (CollectionUtils.isEmpty(invoiceCodeNoPair)) {
            return Collections.emptyList();
        }
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1");
        for (Pair<String, String> invoice : invoiceCodeNoPair) {
            String invoiceCode;
            String invoiceNo = (String)invoice.getValue();
            if (StringUtils.isBlank((CharSequence)invoiceNo) || !StringUtils.isNotBlank((CharSequence)(invoiceCode = (String)invoice.getKey())) && (!StringUtils.isBlank((CharSequence)invoiceCode) || invoiceNo.length() <= 12)) continue;
            QFilter invoicCodeNoFilter = new QFilter("invoicecode", "=", (Object)invoiceCode).and("invoiceno", "=", (Object)invoiceNo);
            qFilter.or(invoicCodeNoFilter);
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"", (QFilter[])qFilter.toArray());
        return Arrays.stream(invoices).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }
}

