/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mservice.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.mservice.vo.FiAmtInfoVo;
import kd.imc.sim.mservice.vo.FiAmtRecenTrysVo;
import kd.imc.sim.mservice.vo.FiBaseInfoVo;
import kd.imc.sim.mservice.vo.FiBuyerInfoVo;
import kd.imc.sim.mservice.vo.FiFinInfoVo;
import kd.imc.sim.mservice.vo.FiOtherInfoVo;
import kd.imc.sim.mservice.vo.FiSellerInfoVo;
import kd.imc.sim.mservice.vo.FiSystemInfoVo;

public class FiBillDateSynVo
implements Serializable {
    private static final long serialVersionUID = -8391193632726626217L;
    private String billType;
    private String splitOrMergeFlag;
    private FiBaseInfoVo baseInfo;
    private FiSellerInfoVo sellerInfo;
    private FiBuyerInfoVo buyerInfo;
    private FiAmtInfoVo amtInfo;
    private FiFinInfoVo finInfo;
    private FiOtherInfoVo otherInfo;
    private FiSystemInfoVo systemInfo;

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getSplitOrMergeFlag() {
        return this.splitOrMergeFlag;
    }

    public void setSplitOrMergeFlag(String splitOrMergeFlag) {
        this.splitOrMergeFlag = splitOrMergeFlag;
    }

    public FiBaseInfoVo getBaseInfo() {
        return this.baseInfo;
    }

    public void setBaseInfo(FiBaseInfoVo baseInfo) {
        this.baseInfo = baseInfo;
    }

    public FiSellerInfoVo getSellerInfo() {
        return this.sellerInfo;
    }

    public void setSellerInfo(FiSellerInfoVo sellerInfo) {
        this.sellerInfo = sellerInfo;
    }

    public FiBuyerInfoVo getBuyerInfo() {
        return this.buyerInfo;
    }

    public void setBuyerInfo(FiBuyerInfoVo buyerInfo) {
        this.buyerInfo = buyerInfo;
    }

    public FiAmtInfoVo getAmtInfo() {
        return this.amtInfo;
    }

    public void setAmtInfo(FiAmtInfoVo amtInfo) {
        this.amtInfo = amtInfo;
    }

    public FiFinInfoVo getFinInfo() {
        return this.finInfo;
    }

    public void setFinInfo(FiFinInfoVo finInfo) {
        this.finInfo = finInfo;
    }

    public FiOtherInfoVo getOtherInfo() {
        return this.otherInfo;
    }

    public void setOtherInfo(FiOtherInfoVo otherInfo) {
        this.otherInfo = otherInfo;
    }

    public FiSystemInfoVo getSystemInfo() {
        return this.systemInfo;
    }

    public void setSystemInfo(FiSystemInfoVo systemInfo) {
        this.systemInfo = systemInfo;
    }

    public BillVo toBill() throws MsgException {
        if (CollectionUtils.isEmpty(this.amtInfo.getRecentrys())) {
            throw new MsgException(ResManager.loadKDString((String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"FiBillDateSynVo_0", (String)"imc-sim-mservice", (Object[])new Object[0]));
        }
        BillVo bill = new BillVo();
        bill.setBillNo(this.baseInfo.getBillNo());
        bill.setBillDate(this.baseInfo.getApplyDate());
        bill.setAutoInvoice(Integer.parseInt(this.baseInfo.getAutoOpen()));
        bill.setInvoiceType(InvoiceType.getInvoiceTypeCodeByBaseCode((String)this.baseInfo.getInvoiceType()));
        bill.setOrgCode(this.baseInfo.getOrgNumber());
        bill.setPriority(0);
        bill.setBuyerTaxpayerId(this.buyerInfo.getBuyerTaxNo());
        bill.setBuyerName(this.buyerInfo.getBuyerName());
        bill.setBuyerBankAndAccount(this.buyerInfo.getBuyerAccount());
        if (StringUtils.isBlank((CharSequence)this.buyerInfo.getBuyerAddAndTel())) {
            bill.setBuyerAddressAndTel(this.buyerInfo.getBuyerAddress() + this.buyerInfo.getBuyerFixedTelephone());
        } else {
            bill.setBuyerAddressAndTel(this.buyerInfo.getBuyerAddAndTel());
        }
        bill.setBuyerProperty(0);
        bill.setSellerTaxpayerId(this.sellerInfo.getSalerTaxNo());
        bill.setSellerName(this.sellerInfo.getSalerName());
        bill.setSellerBankAndAccount(this.sellerInfo.getSalerAccount());
        bill.setSellerAddressAndTel(this.sellerInfo.getSalerAddress() + this.sellerInfo.getSalerPhone());
        bill.setIncludeTaxFlag(this.amtInfo.getRecentrys().get(0).getTaxFlag());
        bill.setBuyerRecipientPhone(this.buyerInfo.getBuyerMobilePhone());
        bill.setBuyerRecipientMail(this.buyerInfo.getBuyerEmail());
        bill.setDrawer(this.otherInfo.getDrawer());
        bill.setPayee(this.otherInfo.getPayee());
        bill.setReviewer(this.otherInfo.getReviewer());
        bill.setRemark(this.otherInfo.getRemark());
        bill.setIncludeTaxAmount(new BigDecimal(this.amtInfo.getTotalAmount()));
        bill.setTotalTaxAmount(new BigDecimal(this.amtInfo.getTotalTaxAmount()));
        bill.setTotalAmount(bill.getIncludeTaxAmount().subtract(bill.getTotalTaxAmount()));
        bill.setBillProperty("0".equals(this.baseInfo.getType()) ? 1 : -1);
        if (!StringUtils.isEmpty((CharSequence)this.amtInfo.getBillDiscountAmount())) {
            bill.setBillDiscountAmount(new BigDecimal(this.amtInfo.getBillDiscountAmount()));
        }
        bill.setSystemSource("KINGDEE_FI");
        bill.setBillType("01");
        bill.setSplitOrMergeFlag(this.splitOrMergeFlag);
        bill.setAutoMerge(0);
        bill.setBizType(this.baseInfo.getBizType());
        bill.setRedflushBlue(this.baseInfo.getRedflushBlue());
        bill.setBlueinvoiceCode(this.baseInfo.getBlueinvoiceCode());
        bill.setBlueinvoiceNo(this.baseInfo.getBlueinvoiceNo());
        bill.setCurrency(this.amtInfo.getCurrency());
        bill.setExchangeDate(this.amtInfo.getExchangeDate());
        bill.setExchangeRate(this.amtInfo.getExchangeRate());
        bill.setCreator(this.systemInfo.getCreator());
        List<FiAmtRecenTrysVo> recentrys = this.amtInfo.getRecentrys();
        bill.setBillDetail(this.toBillDetail(bill, recentrys));
        BigDecimal totalDeduction = BigDecimal.ZERO;
        for (FiAmtRecenTrysVo recentry : recentrys) {
            if (!StringUtils.isNotBlank((CharSequence)recentry.getDeduction())) continue;
            totalDeduction = totalDeduction.add(new BigDecimal(recentry.getDeduction()));
        }
        if (!InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType())) {
            if (totalDeduction.compareTo(BigDecimal.ZERO) != 0) {
                bill.setDeduction(totalDeduction);
                bill.setTaxationStyle(TaxedTypeEnum.deduction.getValue());
            } else {
                bill.setTaxationStyle(TaxedTypeEnum.normal.getValue());
            }
            return bill;
        }
        if (totalDeduction.compareTo(BigDecimal.ZERO) != 0) {
            bill.setDeduction(totalDeduction);
            bill.setTaxationStyle(TaxedTypeEnum.all_e_deduction.getValue());
        } else if (TaxedTypeEnum.all_e_deduction_full.getValue().equals(this.baseInfo.getTaxationStyle())) {
            bill.setTaxationStyle(TaxedTypeEnum.all_e_deduction_full.getValue());
        } else {
            bill.setTaxationStyle(TaxedTypeEnum.normal.getValue());
        }
        return bill;
    }

    private List<BillDetailVo> toBillDetail(BillVo bill, List<FiAmtRecenTrysVo> list) throws MsgException {
        boolean isTobaccoEnterprise = TaxUtils.isTobaccoEnterprise((String)bill.getSellerTaxpayerId());
        if (list.isEmpty()) {
            return new ArrayList<BillDetailVo>();
        }
        ArrayList<BillDetailVo> result = new ArrayList<BillDetailVo>(list.size());
        int index = 0;
        int tobaccoGoodsCount = 0;
        for (FiAmtRecenTrysVo re : list) {
            String lineProperty;
            if (isTobaccoEnterprise) {
                if (TaxUtils.isTobaccoGoods((String)re.getGoodsCode())) {
                    ++tobaccoGoodsCount;
                }
            } else if (TaxUtils.isTobaccoGoods((String)re.getGoodsCode())) {
                throw new MsgException(ResManager.loadKDString((String)"\u5f00\u5177\u5377\u70df\u53d1\u7968\uff1a\u975e\u5377\u70df\u4f01\u4e1a\uff0c\u4e0d\u5141\u8bb8\u5f00\u5177\u5377\u70df\u660e\u7ec6\u53d1\u7968\u3002", (String)"FiBillDateSynVo_1", (String)"imc-sim-mservice", (Object[])new Object[0]));
            }
            if ("1".equals(lineProperty = re.getDiscountType())) {
                ((BillDetailVo)result.get(index - 1)).setLineProperty(2);
                ((BillDetailVo)result.get(index - 1)).setDiscountAmount(new BigDecimal(re.getDetailAmount()));
                ((BillDetailVo)result.get(index - 1)).setDiscountTaxAmount(new BigDecimal(re.getTaxAmount()));
                continue;
            }
            BillDetailVo vo = new BillDetailVo();
            if (StringUtils.isNotBlank((CharSequence)re.getDeduction())) {
                vo.setDeduction(new BigDecimal(re.getDeduction()));
            }
            vo.setBillSourceId(re.getItemID());
            vo.setGoodsName(StringUtils.isNotBlank((CharSequence)re.getMaterial()) ? re.getMaterial() : re.getExpenseItem());
            vo.setSpecification(re.getSpecModel());
            vo.setUnits(re.getUnit());
            vo.setQuantity(re.getNum());
            vo.setTaxRate(re.getTaxRate());
            vo.setTaxAmount(new BigDecimal(re.getTaxAmount()));
            vo.setPrice(re.getUnitPrice());
            vo.setAmount(new BigDecimal(re.getDetailAmount()));
            vo.setDiscountAmount(StringUtils.isNotBlank((CharSequence)re.getDiscountAmount()) ? new BigDecimal(re.getDiscountAmount()) : null);
            vo.setRevenueCode(re.getGoodsCode());
            vo.setPrivilegeFlag(Integer.valueOf(StringUtils.isNotBlank((CharSequence)re.getPreferentialPolicy()) ? Integer.parseInt(re.getPreferentialPolicy()) : 0));
            vo.setPrivilegeContent(re.getVatException());
            vo.setLineProperty(StringUtils.isNotBlank((CharSequence)lineProperty) ? ("0".equals(lineProperty) ? 2 : 0) : 2);
            result.add(vo);
            ++index;
        }
        if (isTobaccoEnterprise && tobaccoGoodsCount > 0) {
            bill.setSpecialType("11");
            if (tobaccoGoodsCount != list.size()) {
                throw new MsgException(ResManager.loadKDString((String)"\u5f00\u5177\u5377\u70df\u53d1\u7968\uff1a\u660e\u7ec6\u53ea\u80fd\u6709\u5377\u70df\u660e\u7ec6\u3002", (String)"FiBillDateSynVo_2", (String)"imc-sim-mservice", (Object[])new Object[0]));
            }
        }
        return result;
    }
}

