/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.common.constant.BillCenterLogEnum;
import kd.imc.sim.common.constant.SimCommonConstant;

public class SimIsomerismBillDataListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(SimIsomerismBillDataListPlugin.class);

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        switch (key) {
            case "addrelateinvoice": {
                this.addRelateInvoice(rows);
                break;
            }
            case "cancelrelateinvoice": {
                this.cancelRelateInvoice(rows);
                this.refresh();
            }
        }
    }

    private void addRelateInvoice(ListSelectedRowCollection listSelectedRowCollection) {
        String tipMsg;
        DynamicObject[] dynamicObjects;
        Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            return;
        }
        HashSet<String> billPositiveSet = new HashSet<String>(8);
        HashSet<String> billNegativeSet = new HashSet<String>(8);
        HashSet<Long> orgSet = new HashSet<Long>(8);
        ArrayList<DynamicObject> zeroBillList = new ArrayList<DynamicObject>(16);
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data", (boolean)false);
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)selectProperties, (QFilter[])new QFilter("id", "in", (Object)primaryKeyValues).toArray())) {
            String tipMsg2;
            String pushStatus = dynamicObject.getString("pushstatus");
            String invoiceStatus = dynamicObject.getString("invoice_status");
            if (!("0".equals(invoiceStatus) || "2".equals(invoiceStatus) || "1".equals(invoiceStatus))) {
                tipMsg2 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355:%s\uff0c\u5f00\u7968\u72b6\u6001\u53ea\u6709\u4e3a\uff1a\u672a\u5f00\u7968\u3001\u90e8\u5206\u5f00\u7968\u3001\u5f00\u7968\u7ed3\u675f\u65f6\uff0c\u624d\u5141\u8bb8\u56de\u586b\u53d1\u7968\u3002", (String)"SimIsomerismBillData_11", (String)"imc-sim-webapi", (Object[])new Object[0]), dynamicObject.getString("billno"));
                this.getView().showErrorNotification(tipMsg2);
                return;
            }
            if (!("-1".equals(pushStatus) || "0".equals(pushStatus) || "1".equals(pushStatus))) {
                tipMsg2 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355:%s\uff0c\u4e0b\u63a8\u72b6\u6001\u53ea\u6709\u4e3a\uff1a\u672a\u4e0b\u63a8\u3001\u90e8\u5206\u4e0b\u63a8\u3001\u5df2\u4e0b\u63a8\u65f6\uff0c\u624d\u5141\u8bb8\u56de\u586b\u53d1\u7968\u3002", (String)"SimIsomerismBillData_12", (String)"imc-sim-webapi", (Object[])new Object[0]), dynamicObject.getString("billno"));
                this.getView().showErrorNotification(tipMsg2);
                return;
            }
            String fillInStatus = dynamicObject.getString("fill_in_status");
            if ("1".equals(fillInStatus)) {
                String tipMsg3 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355:%s\uff0c\u5df2\u56de\u586b\u53d1\u7968\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u56de\u586b\u3002", (String)"SimIsomerismBillData_13", (String)"imc-sim-webapi", (Object[])new Object[0]), dynamicObject.getString("billno"));
                this.getView().showErrorNotification(tipMsg3);
                return;
            }
            BigDecimal totalAmount = dynamicObject.getBigDecimal("total_amount");
            if (totalAmount.compareTo(BigDecimal.ZERO) > 0) {
                billPositiveSet.add("1");
            } else if (totalAmount.compareTo(BigDecimal.ZERO) < 0) {
                billNegativeSet.add("-1");
            } else {
                zeroBillList.add(dynamicObject);
            }
            DynamicObject orgObject = dynamicObject.getDynamicObject("org");
            if (orgObject == null) continue;
            orgSet.add(orgObject.getLong("id"));
        }
        if (orgSet.size() > 1) {
            tipMsg = ResManager.loadKDString((String)"\u6240\u52fe\u9009\u7684\u8d26\u5355\u6570\u636e\u4e0d\u5141\u8bb8\u8de8\u591a\u4e2a\u4e0d\u540c\u7ec4\u7ec7\u8fdb\u884c\u56de\u586b\u53d1\u7968\u3002", (String)"SimIsomerismBillData_15", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showErrorNotification(tipMsg);
            return;
        }
        if (zeroBillList.size() > 1) {
            tipMsg = ResManager.loadKDString((String)"\u8d26\u5355\u91d1\u989d\u4e3a0\u7684\u8d26\u5355\uff0c\u8bf7\u5355\u72ec\u8fdb\u884c\u53d1\u7968\u56de\u586b\u3002", (String)"SimIsomerismBillData_18", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showErrorNotification(tipMsg);
            return;
        }
        if (zeroBillList.size() > 0 && (billPositiveSet.size() > 0 || billNegativeSet.size() > 0)) {
            tipMsg = ResManager.loadKDString((String)"\u8d26\u5355\u91d1\u989d\u4e3a0\u7684\u8d26\u5355\uff0c\u8bf7\u5355\u72ec\u8fdb\u884c\u53d1\u7968\u56de\u586b\u3002", (String)"SimIsomerismBillData_18", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showErrorNotification(tipMsg);
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        if (billPositiveSet.size() > 0 && billNegativeSet.size() > 0) {
            String tipMsg4 = ResManager.loadKDString((String)"\u8d26\u5355\u91d1\u989d\u5fc5\u987b\u540c\u65f6\u4e3a\u6b63\u6216\u8005\u4e3a\u8d1f\uff0c\u624d\u5141\u8bb8\u8fdb\u884c\u5408\u5e76\u56de\u586b\u53d1\u7968\u3002", (String)"SimIsomerismBillData_10", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showErrorNotification(tipMsg4);
            return;
        }
        if (billPositiveSet.size() > 0 && billNegativeSet.size() == 0) {
            paramMap.put("fillInBillType", "Positive");
        } else if (billPositiveSet.size() == 0 && billNegativeSet.size() > 0) {
            paramMap.put("fillInBillType", "Negative");
        } else {
            paramMap.put("fillInBillType", "Zerotive");
        }
        paramMap.put("fillInOpType", "1");
        paramMap.put("dynamicObjects", dynamicObjects);
        paramMap.put("orgId", orgSet.iterator().next());
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u8d26\u5355\u4e2d\u5fc3\u56de\u586b\u53d1\u7968", (String)"SimIsomerismBillData_20", (String)"imc-sim-webapi", (Object[])new Object[0]), paramMap, (String)"sim_fill_in_invoice", (String)"addRelateInvoice");
    }

    private void cancelRelateInvoice(ListSelectedRowCollection listSelectedRowCollection) {
        String invoiceCode;
        String invoiceNo;
        String tipMsg;
        Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            return;
        }
        if (primaryKeyValues.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u9009\u62e9\u4e00\u4e2a\u8d26\u5355\u8fdb\u884c\u53d6\u6d88\u56de\u586b", (String)"SimIsomerismBillData_4", (String)"imc-sim-webapi", (Object[])new Object[0]), SimCommonConstant.SHOW_TIME);
            return;
        }
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data", (boolean)true);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)selectProperties, (QFilter[])new QFilter("id", "in", (Object)primaryKeyValues).toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SimIsomerismBillData_8", (String)"imc-sim-webapi", (Object[])new Object[0]), SimCommonConstant.SHOW_TIME);
            return;
        }
        ArrayList<String> invoiceInfoList = new ArrayList<String>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String fillInStatus = dynamicObject.getString("fill_in_status");
            if (StringUtils.isBlank((CharSequence)fillInStatus) || "0".equals(fillInStatus)) {
                tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355:%s\uff0c\u8fd8\u672a\u56de\u586b\u53d1\u7968\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u56de\u586b\u3002", (String)"SimIsomerismBillData_14", (String)"imc-sim-webapi", (Object[])new Object[0]), dynamicObject.getString("billno"));
                this.getView().showErrorNotification(tipMsg);
                return;
            }
            DynamicObjectCollection invoiceItemCollection = dynamicObject.getDynamicObjectCollection("invoice");
            Iterator iterator = invoiceItemCollection.iterator();
            while (iterator.hasNext()) {
                DynamicObject invoiceItem = (DynamicObject)iterator.next();
                invoiceNo = invoiceItem.getString("invoiceno");
                invoiceCode = invoiceItem.getString("invoicecode");
                if (StringUtils.isBlank((CharSequence)invoiceCode)) {
                    invoiceCode = "NULL";
                }
                String invoiceInfo = invoiceNo + "-" + invoiceCode;
                invoiceInfoList.add(invoiceInfo);
            }
        }
        if (!invoiceInfoList.isEmpty()) {
            ArrayList<String> billNoList = new ArrayList<String>(dynamicObjects.length);
            HashSet<String> billPositiveSet = new HashSet<String>(8);
            HashSet<String> billNegativeSet = new HashSet<String>(8);
            HashSet<String> zeroBillSet = new HashSet<String>(16);
            HashSet<Long> orgSet = new HashSet<Long>(8);
            for (String invoiceInfo : invoiceInfoList) {
                DynamicObject[] billCenterObjects;
                String[] array = invoiceInfo.split("-");
                invoiceNo = array[0];
                invoiceCode = array[1];
                String paramCondition1 = "invoice.invoiceno";
                QFilter qFilter = new QFilter(paramCondition1, "=", (Object)invoiceNo);
                if (!"NULL".equals(invoiceCode)) {
                    String paramCondition2 = "invoice.invoicecode";
                    qFilter = qFilter.and(paramCondition2, "=", (Object)invoiceCode);
                }
                selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data", (boolean)false);
                for (DynamicObject billCenterObject : billCenterObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)selectProperties, (QFilter[])qFilter.toArray())) {
                    BigDecimal totalAmount = billCenterObject.getBigDecimal("total_amount");
                    if (totalAmount.compareTo(BigDecimal.ZERO) > 0) {
                        billPositiveSet.add("1");
                    } else if (totalAmount.compareTo(BigDecimal.ZERO) < 0) {
                        billNegativeSet.add("-1");
                    } else {
                        zeroBillSet.add(billCenterObject.getString("billno"));
                    }
                    DynamicObject orgObject = billCenterObject.getDynamicObject("org");
                    if (orgObject != null) {
                        orgSet.add(orgObject.getLong("id"));
                    }
                    String fillInStatus = billCenterObject.getString("fill_in_status");
                    String billNo = billCenterObject.getString("billno");
                    if (!StringUtils.isNotBlank((CharSequence)fillInStatus) && !"1".equals(fillInStatus)) continue;
                    billNoList.add(billNo);
                }
            }
            if (orgSet.size() > 1) {
                tipMsg = ResManager.loadKDString((String)"\u6240\u52fe\u9009\u7684\u8d26\u5355\u6570\u636e\u4e0d\u5141\u8bb8\u8de8\u591a\u4e2a\u4e0d\u540c\u7ec4\u7ec7\u8fdb\u884c\u53d6\u6d88\u56de\u586b\u53d1\u7968\u3002", (String)"SimIsomerismBillData_17", (String)"imc-sim-webapi", (Object[])new Object[0]);
                this.getView().showErrorNotification(tipMsg);
                return;
            }
            if (zeroBillSet.size() > 1) {
                tipMsg = ResManager.loadKDString((String)"\u8d26\u5355\u91d1\u989d\u4e3a0\u7684\u8d26\u5355\uff0c\u8bf7\u5355\u72ec\u8fdb\u884c\u53d1\u7968\u53d6\u6d88\u56de\u586b\u3002", (String)"SimIsomerismBillData_19", (String)"imc-sim-webapi", (Object[])new Object[0]);
                this.getView().showErrorNotification(tipMsg);
                return;
            }
            if (zeroBillSet.size() > 0 && (billPositiveSet.size() > 0 || billNegativeSet.size() > 0)) {
                tipMsg = ResManager.loadKDString((String)"\u8d26\u5355\u91d1\u989d\u4e3a0\u7684\u8d26\u5355\uff0c\u8bf7\u5355\u72ec\u8fdb\u884c\u53d1\u7968\u53d6\u6d88\u56de\u586b\u3002", (String)"SimIsomerismBillData_19", (String)"imc-sim-webapi", (Object[])new Object[0]);
                this.getView().showErrorNotification(tipMsg);
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            if (billPositiveSet.size() > 0 && billNegativeSet.size() > 0) {
                String tipMsg2 = ResManager.loadKDString((String)"\u8d26\u5355\u91d1\u989d\u5fc5\u987b\u540c\u65f6\u4e3a\u6b63\u6216\u8005\u4e3a\u8d1f\uff0c\u624d\u5141\u8bb8\u8fdb\u884c\u5408\u5e76\u53d6\u6d88\u56de\u586b\u53d1\u7968\u3002", (String)"SimIsomerismBillData_16", (String)"imc-sim-webapi", (Object[])new Object[0]);
                this.getView().showErrorNotification(tipMsg2);
                return;
            }
            if (billPositiveSet.size() > 0 && billNegativeSet.size() == 0) {
                paramMap.put("fillInBillType", "Positive");
            } else if (billPositiveSet.size() == 0 && billNegativeSet.size() > 0) {
                paramMap.put("fillInBillType", "Negative");
            } else {
                paramMap.put("fillInBillType", "Zerotive");
            }
            paramMap.put("fillInOpType", "2");
            DynamicObject[] billRelateInvoices = this.getBillRelateInvoicesMethod(billNoList);
            paramMap.put("billRelateInvoices", billRelateInvoices);
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u8d26\u5355\u4e2d\u5fc3\u53d6\u6d88\u56de\u586b", (String)"SimIsomerismBillData_21", (String)"imc-sim-webapi", (Object[])new Object[0]), paramMap, (String)"sim_fill_in_invoice", (String)"cancelRelateInvoice");
        }
    }

    private DynamicObject[] getBillRelateInvoicesMethod(List<String> billNoList) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        QFilter qFilter = new QFilter("billno", "in", billNoList).and("operate_type", "=", (Object)BillCenterLogEnum.INVOICE_FILL_IN_OP_TYPE.getBillStatus());
        DynamicObject[] billRelateInvoices = billCenterInvoiceLogService.dealLoadBillCenterLogMethod(qFilter);
        return billRelateInvoices;
    }

    private void refresh() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
        billList.clearSelection();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("custom_issue".equals(operate.getOperateKey())) {
            operate.getOption().setVariableValue("batchop_batchsize", "0");
        } else if ("delete".equals(operate.getOperateKey())) {
            args.setCancel(true);
            this.dealCheckDeleteDataMethod(operate);
        } else if ("push".equals(operate.getOperateKey())) {
            this.dealCheckPushDataMethod(operate);
        } else if ("creategiftreceipt".equals(operate.getOperateKey()) && (listSelectedRowCollection = operate.getListSelectedData()).size() > 1) {
            HashSet<String> billCenterIdSet = new HashSet<String>(listSelectedRowCollection.size());
            for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                billCenterIdSet.add(listSelectedRow.getBillNo());
            }
            if (billCenterIdSet.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u52fe\u9009\u4e00\u6761\u6570\u636e\u8fdb\u884c\u751f\u6210\u5c0f\u7968\u7801\u3002", (String)"SimIsomerismBillData_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void dealCheckPushDataMethod(FormOperate operate) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        ListSelectedRowCollection listSelectedRowCollection = operate.getListSelectedData();
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            Long pkId = (Long)listSelectedRow.getPrimaryKeyValue();
            DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadSingleObject(pkId);
            if (dynamicObject == null) continue;
            String billNo = dynamicObject.getString("billno");
            String pushstatus = dynamicObject.getString("pushstatus");
            String invoice_status = dynamicObject.getString("invoice_status");
            if ("-2".equals(pushstatus) && "-1".equals(invoice_status)) {
                String tipMsg = String.format(ResManager.loadKDString((String)"\u6b64\u8d26\u5355\u7f16\u53f7\uff1a%1$s\uff0c\u5bf9\u5e94\u7684\u8d26\u5355\u53ef\u5f00\u7968\u603b\u91d1\u989d\u4e3a0\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\u64cd\u4f5c\uff01", (String)"SimIsomerismBillData_7", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo);
                throw new KDBizException(tipMsg);
            }
            billCenterInvoiceCommonService.dealUpdateBillItemOpenInvoiceMethod(new DynamicObject[]{dynamicObject});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "hand_sync_bill_data": {
                this.dealOpenGetBillDataMethod();
                break;
            }
            case "scan_load_bill": {
                this.dealScanLoadBillDataMethod();
                break;
            }
            case "custom_issue": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (!operationResult.isSuccess()) break;
                HashMap<String, List> param = new HashMap<String, List>(4);
                param.put("pks", operationResult.getSuccessPkIds());
                ViewUtil.openDialog((AbstractFormPlugin)this, param, (String)"sim_bill_center_process", (String)"sim_bill_center_process");
                break;
            }
            case "creategiftreceipt": {
                OperationResult operationResult1 = afterDoOperationEventArgs.getOperationResult();
                if (!operationResult1.isSuccess()) break;
                BillShowParameter listParam = new BillShowParameter();
                listParam.setStatus(OperationStatus.ADDNEW);
                listParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listParam.setFormId("sim_gift_receipt");
                listParam.setPageId(this.getView().getPageId() + operationResult1.getSuccessPkIds().get(0));
                listParam.setCustomParam("billcenterId", operationResult1.getSuccessPkIds().get(0));
                listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "creategiftreceipt"));
                this.getView().showForm((FormShowParameter)listParam);
                break;
            }
            case "disablegiftreceipt": {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void dealScanLoadBillDataMethod() {
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("opType", "scanQrcode");
        String tipMsg = ResManager.loadKDString((String)"\u626b\u63cf\u4e8c\u7ef4\u7801\u540c\u6b65\u8ba2\u5355\u6570\u636e", (String)"SimIsomerismBillData_0", (String)"imc-sim-webapi", (Object[])new Object[0]);
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)tipMsg, customParams, (String)"sim_push_status_condition", (String)"openGetBillData");
    }

    private void dealCheckDeleteDataMethod(FormOperate operate) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        ListSelectedRowCollection listSelectedRowCollection = operate.getListSelectedData();
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            String tipMsg;
            Long pkId = (Long)listSelectedRow.getPrimaryKeyValue();
            DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadSingleObject(pkId);
            if (dynamicObject == null) continue;
            String invoice_status = dynamicObject.getString("invoice_status");
            String pushStatus = dynamicObject.getString("pushstatus");
            if ("1".equals(invoice_status) || "2".equals(invoice_status) || "7".equals(invoice_status)) {
                tipMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u7684\u6570\u636e\u4e0d\u80fd\u591f\u5220\u9664\uff01", (String)"SimIsomerismBillData_1", (String)"imc-sim-webapi", (Object[])new Object[0]);
                throw new KDBizException(tipMsg);
            }
            if ("0".equals(pushStatus) || "1".equals(pushStatus) || "2".equals(pushStatus)) {
                tipMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u7684\u6570\u636e\u4e0d\u80fd\u591f\u5220\u9664\uff01", (String)"SimIsomerismBillData_1", (String)"imc-sim-webapi", (Object[])new Object[0]);
                throw new KDBizException(tipMsg);
            }
            QFilter qFilter = new QFilter("id", "=", (Object)pkId);
            DeleteServiceHelper.delete((String)"sim_isomerism_bill_data", (QFilter[])new QFilter[]{qFilter});
            String tipMsg2 = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"SimIsomerismBillData_2", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showSuccessNotification(tipMsg2);
            IListView listView = (IListView)this.getView();
            listView.refresh();
        }
    }

    private void dealOpenGetBillDataMethod() {
        String tipMsg = ResManager.loadKDString((String)"\u540c\u6b65\u8d26\u5355\u4e2d\u5fc3\u6570\u636e", (String)"SimIsomerismBillData_3", (String)"imc-sim-webapi", (Object[])new Object[0]);
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)tipMsg, null, (String)"sim_get_bill_data", (String)"openGetBillData");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IListView listView = (IListView)this.getView();
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("openGetBillData".equals(actionId)) {
            listView.refresh();
        } else if ("creategiftreceipt".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if ("addRelateInvoice".equals(actionId) && returnData != null) {
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u56de\u586b\u53d1\u7968\u6210\u529f\uff01", (String)"SimIsomerismBillData_22", (String)"imc-sim-webapi", (Object[])new Object[0]));
        } else if ("cancelRelateInvoice".equals(actionId) && returnData != null) {
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u56de\u586b\u6210\u529f\uff01", (String)"SimIsomerismBillData_23", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("invoiceno".equals(args.getFieldName())) {
            args.setCancel(true);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow row = billList.getCurrentSelectedRowInfo();
            Object pkId = row.getPrimaryKeyValue();
            if (pkId == null || "".equals(pkId)) {
                String tipMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"SimIsomerismBillData_5", (String)"imc-sim-webapi", (Object[])new Object[0]);
                throw new KDBizException(tipMsg);
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sim_isomerism_bill_data");
            if (dynamicObject == null) {
                String tipMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"SimIsomerismBillData_5", (String)"imc-sim-webapi", (Object[])new Object[0]);
                throw new KDBizException(tipMsg);
            }
            Object entryPkId = row.getEntryPrimaryKeyValue();
            if (entryPkId == null || "".equals(entryPkId)) {
                String tipMsg = ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"SimIsomerismBillData_6", (String)"imc-sim-webapi", (Object[])new Object[0]);
                throw new KDBizException(tipMsg);
            }
            DynamicObjectCollection invoiceCollection = dynamicObject.getDynamicObjectCollection("invoice");
            for (DynamicObject invoiceItemObject : invoiceCollection) {
                Long invoiceItemId = invoiceItemObject.getLong("id");
                if (!entryPkId.equals(invoiceItemId)) continue;
                String invoiceNo = invoiceItemObject.getString("invoiceno");
                QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceNo);
                DynamicObject invoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (QFilter[])new QFilter[]{qFilter});
                if (invoiceObject == null) {
                    String tipMsg = ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"SimIsomerismBillData_6", (String)"imc-sim-webapi", (Object[])new Object[0]);
                    throw new KDBizException(tipMsg);
                }
                long invoiceId = invoiceObject.getLong("id");
                HashMap map = Maps.newHashMapWithExpectedSize((int)1);
                map.put("id", invoiceId);
                ViewUtil.openDialog((AbstractFormPlugin)this, (Map)map, (String)"sim_invoice_show", null);
                break;
            }
        } else if ("giftstatus".equals(args.getFieldName())) {
            args.setCancel(true);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow row = billList.getCurrentSelectedRowInfo();
            Object pkId = row.getPrimaryKeyValue();
            DynamicObject giftReceipt = QueryServiceHelper.queryOne((String)"sim_gift_receipt", (String)"id", (QFilter[])new QFilter("billcenterid", "=", pkId).toArray());
            if (giftReceipt != null) {
                long giftReceiptId = giftReceipt.getLong("id");
                BillShowParameter listParam = new BillShowParameter();
                listParam.setStatus(OperationStatus.VIEW);
                listParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listParam.setFormId("sim_gift_receipt");
                listParam.setPageId(this.getView().getPageId() + giftReceiptId);
                listParam.setPkId((Object)giftReceiptId);
                this.getView().showForm((FormShowParameter)listParam);
            }
        }
    }
}

