/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.home;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabCloseEvent;
import kd.bos.form.control.events.TabCloseListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.IconAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.report.ReportShowParameter;
import kd.imc.bdm.common.util.ImcConfigUtil;
import org.apache.commons.lang3.StringUtils;

public class InvoiceMenuOfTabPlugin
extends AbstractFormPlugin
implements TabCloseListener {
    private static final Log LOG = LogFactory.getLog(InvoiceMenuOfTabPlugin.class);
    private static final String CENTER = "center";
    private static final String ICON_PREFIX = "iconap";
    private static final String CACHE_APP = "keyIdToApp";
    private static final String PARAM_MENU = "menu";
    private static final String CACHE_FORMPAGE = "formPage";
    private static final Set<String> treeList = new ImmutableSet.Builder().add((Object)"bdm_org").build();
    private static final Set<String> templateTreeList = new ImmutableSet.Builder().add((Object)"bdm_goods_info").add((Object)"bdm_goods_info_group").build();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabCloseListener((TabCloseListener)this);
    }

    public void tabClose(TabCloseEvent tabCloseEvent) {
        List tabKeys = tabCloseEvent.getTabKeys();
        ArrayList tabListClose = new ArrayList(tabKeys.size());
        for (String tabKey : tabKeys) {
            IFormView formView = this.getView().getViewNoPlugin(tabKey);
            formView.close();
            HashMap<String, String> arg = new HashMap<String, String>(4);
            arg.put("pageId", tabKey);
            tabListClose.add(arg);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("closeWindow", tabListClose);
    }

    public void afterCreateNewData(EventObject e) {
        Label title;
        String menu = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_MENU);
        if (StringUtils.isEmpty((CharSequence)menu)) {
            return;
        }
        String formIds = ImcConfigUtil.getValue((String)"sim_starry_sky", (String)menu);
        if (StringUtils.isBlank((CharSequence)formIds)) {
            return;
        }
        List<String> formIdList = Arrays.asList(formIds.split(","));
        List showMenuList = AppMetadataCache.getAppMenusInfoByAppId((String)"sim").stream().filter(menuInfo -> formIdList.contains(menuInfo.getFormId())).collect(Collectors.toList());
        showMenuList.addAll(AppMetadataCache.getAppMenusInfoByAppId((String)"bdm").stream().filter(menuInfo -> formIdList.contains(menuInfo.getFormId())).collect(Collectors.toList()));
        int maxCount = 0;
        for (AppMenuInfo appMenuInfo : showMenuList) {
            this.creatLaunchNode(appMenuInfo, maxCount);
            this.getPageCache().put("keyIdToApp_iconap" + maxCount, JSONObject.toJSONString((Object)appMenuInfo));
            ++maxCount;
        }
        if (!showMenuList.isEmpty() && (title = (Label)this.getControl("title")) != null) {
            title.setText(formIdList.get(0));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith(ICON_PREFIX)) {
            String appStr = this.getPageCache().get("keyIdToApp_" + key);
            if (StringUtils.isBlank((CharSequence)appStr)) {
                return;
            }
            AppMenuInfo appMenuInfo = (AppMenuInfo)JSONObject.parseObject((String)appStr, AppMenuInfo.class);
            String formId = appMenuInfo.getFormId();
            String paramType = appMenuInfo.getParamType();
            FormShowParameter fsp = new FormShowParameter();
            if (StringUtils.equals((CharSequence)paramType, (CharSequence)"ListShowParameter")) {
                fsp = new ListShowParameter();
                ((ListShowParameter)fsp).setBillFormId(formId);
                if (treeList.contains(formId)) {
                    fsp.setFormId("bos_treelist");
                } else if (templateTreeList.contains(formId)) {
                    fsp.setFormId("bos_templatetreelist");
                } else {
                    fsp.setFormId("bos_list");
                }
            } else if (StringUtils.equals((CharSequence)paramType, (CharSequence)"ReportShowParameter")) {
                fsp = new ReportShowParameter();
                fsp.setFormId(formId);
            } else {
                fsp.setFormId(formId);
            }
            String pageID = this.getPageCache().get("formPage_" + key);
            IFormView childView = this.getView().getViewNoPlugin(pageID);
            if (pageID != null && childView != null) {
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                this.getView().sendFormAction(childView);
            } else {
                String param = appMenuInfo.getParams();
                if (StringUtils.isNotBlank((CharSequence)param)) {
                    JSONObject paramJson = JSONObject.parseObject((String)param);
                    fsp.getCustomParams().putAll(paramJson.getInnerMap());
                }
                fsp.getCustomParams().put("currentPageKey", "formPage_" + key);
                fsp.getOpenStyle().setShowType(ShowType.NewTabPage);
                fsp.getOpenStyle().setTargetKey("tabap");
                fsp.setCaption(appMenuInfo.getName().getLocaleValue());
                String markId = appMenuInfo.getId();
                boolean existView = true;
                String menuPageID = markId;
                while (existView) {
                    menuPageID = markId + "_" + kd.bos.login.utils.StringUtils.randomNumber((int)16);
                    existView = this.getView().existView(menuPageID);
                }
                fsp.setPageId(menuPageID);
                this.getPageCache().put("formPage_" + key, menuPageID);
                this.getView().showForm(fsp);
            }
        }
    }

    private void creatLaunchNode(AppMenuInfo appMenuInfo, int maxCount) {
        String nodeName = appMenuInfo.getName().getLocaleValue();
        String iconUrl = appMenuInfo.getShortcutIcon();
        this.getPageCache().put("cache_click_key", "" + maxCount);
        FlexPanelAp flexAp = new FlexPanelAp();
        flexAp.setKey("dflexpanel" + maxCount);
        flexAp.setDirection("column");
        flexAp.setAlignItems(CENTER);
        flexAp.setGrow(0);
        flexAp.setJustifyContent(CENTER);
        flexAp.setAlignItems(CENTER);
        flexAp.setShrink(0);
        flexAp.setWidth(new LocaleString("100px"));
        flexAp.setOverflow("hidden");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("12px");
        margin.setLeft("12px");
        style.setMargin(margin);
        flexAp.setStyle(style);
        IconAp icon = new IconAp();
        icon.setKey(ICON_PREFIX + maxCount);
        icon.setName(new LocaleString(nodeName));
        if (StringUtils.isEmpty((CharSequence)iconUrl)) {
            icon.setImageKey("/icons/pc/entrance/default_48_48.png");
        } else {
            icon.setImageKey(iconUrl);
        }
        icon.setHeight(new LocaleString("48px"));
        icon.setWidth(new LocaleString("48px"));
        icon.setRadius("6px");
        icon.setImageZoom(true);
        style = new Style();
        margin = new Margin();
        margin.setBottom("3px");
        style.setMargin(margin);
        icon.setStyle(style);
        LabelAp label = new LabelAp();
        label.setKey("dlabel" + maxCount);
        label.setName(new LocaleString(nodeName));
        label.setWidth(new LocaleString("100px"));
        label.setHeight(new LocaleString("31px"));
        label.setTextAlign(CENTER);
        label.setAutoTextWrap(true);
        label.setLineHeight("15px");
        style = new Style();
        margin = new Margin();
        margin.setBottom("3px");
        style.setMargin(margin);
        label.setStyle(style);
        flexAp.getItems().add(icon);
        flexAp.getItems().add(label);
        Container c = (Container)((Container)((Tab)this.getControl("tabap")).getItems().get(0)).getItems().get(0);
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(flexAp.createControl());
        c.insertControls(maxCount, list);
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith(ICON_PREFIX)) {
            Button button = new Button();
            button.setKey(key);
            button.setView(this.getView());
            button.addClickListener((ClickListener)this);
            e.setControl((Control)button);
        }
    }
}

