/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.alle;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.ShowTipsConstant;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceRequestDTO;
import kd.imc.bdm.common.openapi.helper.AllEApiHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.allele.ApiAllEHelper;
import kd.imc.sim.common.vo.openapi.InvoiceQueryVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class AllEInvoiceBatchQueryServiceImpl
implements OpenApiService {
    @Override
    public ApiResult processer(RequestVo requestVo) {
        ArrayList<AllEInvoiceRequestDTO> list = new ArrayList<AllEInvoiceRequestDTO>();
        try {
            InvoiceQueryVo queryVo = this.checkQueryVo(requestVo.getData());
            Object[] orgIds = this.getOrgIdsByTaxNo(queryVo.getSellerTaxpayerId());
            if (orgIds.length == 0) {
                return ResponseVo.fail((String)"9999", (String)ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u5b58\u5728\u7ec4\u7ec7\u4fe1\u606f", (String)"AllEInvoiceBatchQueryServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("orgid", "in", (Object)orgIds);
            ApiResult apiResult = this.checkQuryInvoice(queryVo, filter, "6");
            if (apiResult != null) {
                return apiResult;
            }
            if (queryVo.getInvoiceType().equals("01")) {
                filter.and("invoicetype", "=", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode());
            } else if (queryVo.getInvoiceType().equals("02")) {
                filter.and("invoicetype", "=", (Object)InvoiceType.ALL_E_NORMAL.getTypeCode());
            } else {
                return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_ERROR.getCode(), (String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_ERROR.getMsg());
            }
            DynamicObject[] invoiceList = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])filter.toArray(), null, (int)(queryVo.getPageNo() - 1), (int)queryVo.getPageSize());
            if (invoiceList == null || invoiceList.length == 0) {
                return ResponseVo.fail((String)"9999", (String)ResManager.loadKDString((String)"\u67e5\u8be2\u53d1\u7968\u7ed3\u679c\u4e3a\u7a7a", (String)"AllEInvoiceBatchQueryServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            AllEApiHelper allEApiHelper = new AllEApiHelper();
            for (DynamicObject dynamic : invoiceList) {
                AllEInvoiceRequestDTO allEInvoiceVO = allEApiHelper.transferAllEInvoiceVO(dynamic);
                list.add(allEInvoiceVO);
            }
        }
        catch (MsgException e) {
            return ResponseVo.fail((String)e.getErrorCode(), (String)e.getErrorMsg());
        }
        return ResponseVo.success((String)JSON.toJSONString(list));
    }

    public ApiResult checkQuryInvoice(InvoiceQueryVo queryVo, QFilter filter, String cancellation) {
        if (StringUtils.isNotEmpty((CharSequence)queryVo.getInvoiceDateS())) {
            try {
                filter.and("issuetime", ">=", (Object)DateUtils.stringToDate((String)queryVo.getInvoiceDateS(), (String)"yyyy-MM-dd"));
            }
            catch (RuntimeException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_QUERY_ERROR_DATEFORMAT.getCode(), (String)ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u8d77\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"AllEInvoiceBatchQueryServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)queryVo.getInvoiceDateE())) {
            try {
                Date dateEnd = DateUtils.stringToDate((String)queryVo.getInvoiceDateE(), (String)"yyyy-MM-dd");
                filter.and("issuetime", "<", (Object)DateUtils.addDay((Date)dateEnd, (int)1));
            }
            catch (RuntimeException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_QUERY_ERROR_DATEFORMAT.getCode(), (String)ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u6b62\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"AllEInvoiceBatchQueryServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)queryVo.getCreateDateS())) {
            try {
                filter.and("createtime", ">=", (Object)DateUtils.stringToDate((String)queryVo.getCreateDateS(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            catch (RuntimeException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_QUERY_ERROR_DATEFORMAT.getCode(), (String)ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u671f\u8d77\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd HH:mm:ss)", (String)"AllEInvoiceBatchQueryServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)queryVo.getCreateDateE())) {
            try {
                filter.and("createtime", "<=", (Object)DateUtils.stringToDate((String)queryVo.getCreateDateE(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            catch (RuntimeException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_QUERY_ERROR_DATEFORMAT.getCode(), (String)ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u671f\u6b62\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd HH:mm:ss)", (String)"AllEInvoiceBatchQueryServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)queryVo.getSerialNo())) {
            filter.and("billno", "=", (Object)queryVo.getSerialNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryVo.getInvoiceCode())) {
            filter.and("invoicecode", "=", (Object)queryVo.getInvoiceCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryVo.getInvoiceNumberS())) {
            filter.and("invoiceno", ">=", (Object)queryVo.getInvoiceNumberS());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryVo.getInvoiceNumberE())) {
            filter.and("invoiceno", "<=", (Object)queryVo.getInvoiceNumberE());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryVo.getInvoiceStatus())) {
            QFilter qFilter = null;
            if (queryVo.getInvoiceStatus().contains(cancellation)) {
                qFilter = new QFilter("invoicestatus", "=", (Object)cancellation);
                if (StringUtils.isNotEmpty((CharSequence)queryVo.getCancelDateS())) {
                    try {
                        qFilter.and("invaliddate", ">=", (Object)DateUtils.stringToDate((String)queryVo.getCancelDateS(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    catch (RuntimeException e) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_QUERY_ERROR_DATEFORMAT.getCode(), (String)ResManager.loadKDString((String)"\u4f5c\u5e9f\u65e5\u671f\u8d77\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd HH:mm:ss)", (String)"AllEInvoiceBatchQueryServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)queryVo.getCancelDateE())) {
                    try {
                        qFilter.and("invaliddate", "<=", (Object)DateUtils.stringToDate((String)queryVo.getCancelDateE(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    catch (RuntimeException e) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_QUERY_ERROR_DATEFORMAT.getCode(), (String)ResManager.loadKDString((String)"\u4f5c\u5e9f\u65e5\u671f\u6b62\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd HH:mm:ss)", (String)"AllEInvoiceBatchQueryServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    }
                }
            }
            if (qFilter != null) {
                ArrayList<String> status = new ArrayList<String>(Arrays.asList(queryVo.getInvoiceStatus().split(",")));
                status.remove(cancellation);
                qFilter.or("invoicestatus", "in", status);
                filter.and(qFilter);
            } else {
                filter.and("invoicestatus", "in", (Object)queryVo.getInvoiceStatus().split(","));
            }
        }
        if (queryVo.getPageNo() < 1) {
            queryVo.setPageNo(1);
        }
        if (queryVo.getPageSize() < 1 || queryVo.getPageSize() > 300) {
            queryVo.setPageSize(300);
        }
        return null;
    }

    public InvoiceQueryVo checkQueryVo(String data) {
        InvoiceQueryVo queryVo;
        try {
            queryVo = (InvoiceQueryVo)JSON.parseObject((String)data, InvoiceQueryVo.class);
        }
        catch (Exception e) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u4f20\u5165\u53d1\u7968\u67e5\u8be2\u4e1a\u52a1\u6570\u636e\u4e0d\u5408\u6cd5", (String)"AllEInvoiceBatchQueryServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (null == queryVo) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u4f20\u5165\u53d1\u7968\u67e5\u8be2\u4e1a\u52a1\u6570\u636e\u4e3a\u7a7a", (String)"AllEInvoiceBatchQueryServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)queryVo.getSellerTaxpayerId())) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_QUERY_NO_TAXPAYERID.getCode(), ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u672a\u4f20\u5165\u503c", (String)"AllEInvoiceBatchQueryServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)queryVo.getInvoiceDateS()) && StringUtils.isNotBlank((CharSequence)queryVo.getInvoiceDateE()) || StringUtils.isNotBlank((CharSequence)queryVo.getInvoiceDateS()) && StringUtils.isBlank((CharSequence)queryVo.getInvoiceDateE())) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_QUERY_ERROR_DATEFORMAT.getCode(), ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u8d77\u6b62\u4e0d\u80fd\u53ea\u586b\u5199\u4e00\u4e2a", (String)"AllEInvoiceBatchQueryServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)queryVo.getCreateDateS()) && StringUtils.isNotBlank((CharSequence)queryVo.getCreateDateE()) || StringUtils.isNotBlank((CharSequence)queryVo.getCreateDateS()) && StringUtils.isBlank((CharSequence)queryVo.getCreateDateE())) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_QUERY_ERROR_DATEFORMAT.getCode(), ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u671f\u8d77\u6b62\u4e0d\u80fd\u53ea\u586b\u5199\u4e00\u4e2a", (String)"AllEInvoiceBatchQueryServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        return queryVo;
    }

    public Object[] getOrgIdsByTaxNo(String taxNo) {
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"", (QFilter[])new QFilter("number", "=", (Object)taxNo).toArray());
        if (objects.length == 0) {
            return new Object[0];
        }
        for (DynamicObject dynamicObject : objects) {
            boolean isExist = ApiAllEHelper.checkIssueInvoicePermission((DynamicObject)dynamicObject);
            if (isExist) continue;
            throw new MsgException("9999", String.format(ShowTipsConstant.getTAXNO_UN_AUTH(), taxNo));
        }
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"", (QFilter[])new QFilter("epinfo", "in", (Object)Arrays.stream(objects).map(DataEntityBase::getPkValue).toArray()).toArray());
        if (orgs.length == 0) {
            return new Object[0];
        }
        return Arrays.stream(orgs).map(DataEntityBase::getPkValue).toArray();
    }
}

