/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.alle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.ShowTipsConstant;
import kd.imc.bdm.common.dto.allele.AllEleCreditQuotaResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.sim.common.helper.allele.ApiAllEHelper;
import kd.imc.sim.common.helper.allele.CreditQuotaHelper;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class AllEQueryCreditQuotaServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(AllEQueryCreditQuotaServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"AllEQueryCreditQuotaServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        JSONObject jsonObject = JSON.parseObject((String)requestVo.getData());
        String taxNo = jsonObject.getString("taxpayerId");
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u5f00\u7968\u4f01\u4e1a\u7a0e\u53f7\u4e3a\u7a7a", (String)"AllEQueryCreditQuotaServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        try {
            DynamicObject epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"", (QFilter[])new QFilter("number", "=", (Object)taxNo).toArray());
            boolean isExist = ApiAllEHelper.checkIssueInvoicePermission((DynamicObject)epInfo);
            if (!isExist) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ShowTipsConstant.getTAXNO_UN_AUTH(), taxNo));
            }
            ApiResult result = ApiAllEHelper.alleLoginCheck((String)taxNo, (String)"");
            if (result != null) {
                return result;
            }
            AllEleResponseDTO responseDTO = CreditQuotaHelper.queryCreditQuota((String)taxNo);
            JSONObject json = new JSONObject();
            json.put("totalVolume", (Object)((AllEleCreditQuotaResponseDTO)responseDTO.getData()).getTotalVolume());
            json.put("availableVolume", (Object)((AllEleCreditQuotaResponseDTO)responseDTO.getData()).getAvailableVolume());
            return ResponseVo.success((String)json.toJSONString());
        }
        catch (MsgException e) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6388\u4fe1\u989d\u5ea6\u5931\u8d25\uff1a%s", (String)"AllEQueryCreditQuotaServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getErrorMsg()));
        }
        catch (Exception e) {
            log.error("\u6570\u7535api\u67e5\u8be2\u6388\u4fe1\u989d\u5ea6\u5931\u8d25", (Throwable)e);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u83b7\u53d6\u6388\u4fe1\u989d\u5ea6\u5931\u8d25", (String)"AllEQueryCreditQuotaServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
    }
}

