/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.alle.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleQueryFullInvoicesDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.dto.allele.AllEleSearchOptDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.dto.allele.AllEleFullInvoiceItemDTO;
import kd.imc.sim.common.dto.allele.AllEleFullInvoiceResponseDTO;
import kd.imc.sim.common.helper.allele.ApiAllEHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.issuing.control.InvoiceSyncControl;
import kd.imc.sim.formplugin.openapi.dto.AllEQuickRedRequestDTO;
import kd.imc.sim.formplugin.openapi.dto.AllEQuickRedRequestItemsDTO;
import kd.imc.sim.formplugin.openapi.service.impl.alle.constant.EInvoiceErrCodeEnum;

public class ApiRedService {
    private static final Log log = LogFactory.getLog(ApiRedService.class);

    public static DynamicObject queryBlueInvoice(String invoiceCode, String invoiceNo) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)StringUtils.trimToEmpty((String)invoiceCode));
        qFilter.and("invoiceno", "=", (Object)invoiceNo);
        return BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])qFilter.toArray());
    }

    public static ApiResult createReturnFail(DynamicObject redConfirmBill) {
        String redInfoBillNo = redConfirmBill.getString("number");
        String confirmStatus = redConfirmBill.getString("confirmstatus");
        ApiResult failResult = ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRM_ERROR_STATUS.getCode(), (String)String.format(ApiErrCodeEnum.REDCONFIRM_ERROR_STATUS.getMsg(), redInfoBillNo, RedConfirmStatusEnum.getBillCodeByDesc((String)confirmStatus)));
        JSONObject json = new JSONObject();
        json.put("redInfoBillNo", (Object)redInfoBillNo);
        json.put("govRedConfirmBillUuid", (Object)redConfirmBill.getString("govuuid"));
        json.put("redConfirmBillStatus", (Object)confirmStatus);
        log.info("\u521b\u5efa\u5931\u8d25\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)json.toJSONString());
        failResult.setData((Object)json);
        return failResult;
    }

    public static BigDecimal checkRedItems(List<AllEQuickRedRequestItemsDTO> itemsList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int i = 0; i < itemsList.size(); ++i) {
            AllEQuickRedRequestItemsDTO redItemDto = itemsList.get(i);
            BigDecimal redAmount = ApiRedService.checkRedItem(i, redItemDto);
            totalAmount = totalAmount.add(redAmount);
        }
        return totalAmount;
    }

    public static BigDecimal checkRedItem(int i, AllEQuickRedRequestItemsDTO redItemDto) {
        BigDecimal redPrice = BigDecimal.ZERO;
        BigDecimal redNum = BigDecimal.ZERO;
        BigDecimal redTax = redItemDto.getTaxAmount();
        if (!StringUtils.isEmpty((CharSequence)redItemDto.getPrice())) {
            redPrice = new BigDecimal(redItemDto.getPrice());
        }
        if (!StringUtils.isEmpty((CharSequence)redItemDto.getQuantity())) {
            redNum = new BigDecimal(redItemDto.getQuantity());
        }
        if (MathUtils.isZero((BigDecimal)redNum) && !MathUtils.isZero((BigDecimal)redPrice)) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20020.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"ApiRedService_0", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, EInvoiceErrCodeEnum.AllE_RED_20020.getMsg()));
        }
        if (MathUtils.isZero((BigDecimal)redPrice) && !MathUtils.isZero((BigDecimal)redNum) && StringUtils.isEmpty((CharSequence)redItemDto.getOriginalSeq())) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20021.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"ApiRedService_0", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, EInvoiceErrCodeEnum.AllE_RED_20021.getMsg()));
        }
        if (StringUtils.isEmpty((CharSequence)redItemDto.getTaxRate())) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20024.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"ApiRedService_0", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, EInvoiceErrCodeEnum.AllE_RED_20024.getMsg()));
        }
        BigDecimal redAmount = redItemDto.getAmount();
        if (MathUtils.isZero((BigDecimal)redAmount) && !MathUtils.isZero((BigDecimal)redNum)) {
            redAmount = redNum.multiply(redPrice).setScale(2, RoundingMode.HALF_UP);
            redItemDto.setAmount(redAmount);
        }
        if (!MathUtils.bigDecimalIsNegativeValue((BigDecimal)redAmount)) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20034.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"ApiRedService_0", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, EInvoiceErrCodeEnum.AllE_RED_20034.getMsg()));
        }
        if (!MathUtils.isZero((BigDecimal)redNum) && !MathUtils.bigDecimalIsNegativeValue((BigDecimal)redNum)) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20035.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"ApiRedService_0", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, EInvoiceErrCodeEnum.AllE_RED_20035.getMsg()));
        }
        if (!MathUtils.isZero((BigDecimal)redTax) && !MathUtils.bigDecimalIsNegativeValue((BigDecimal)redTax)) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20036.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"ApiRedService_0", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, EInvoiceErrCodeEnum.AllE_RED_20036.getMsg()));
        }
        if (!MathUtils.isZero((BigDecimal)redNum) && !MathUtils.isZero((BigDecimal)redPrice) && redNum.multiply(redPrice).setScale(2, RoundingMode.HALF_UP).add(redAmount.abs()).abs().compareTo(InvoiceConstant.DIFF_01) > 0) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20022.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"ApiRedService_0", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, EInvoiceErrCodeEnum.AllE_RED_20022.getMsg()));
        }
        if (MathUtils.isZero((BigDecimal)redAmount)) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20032.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\uff0c%2$s", (String)"ApiRedService_0", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, EInvoiceErrCodeEnum.AllE_RED_20032.getMsg()));
        }
        return redAmount;
    }

    public static ApiResult downloadBlueInvoice(Long orgId, AllEQuickRedRequestDTO allEQuickRedRequestDTO) {
        AllEleResponseListDTO<AllEleFullInvoiceResponseDTO> response;
        String startTime;
        ApiResult result = ApiAllEHelper.alleLoginCheck((String)allEQuickRedRequestDTO.getSellerTaxpayerId(), (String)"");
        if (result != null) {
            return result;
        }
        String sellerTaxNo = allEQuickRedRequestDTO.getSellerTaxpayerId();
        String invoiceCode = allEQuickRedRequestDTO.getInvoiceCode();
        String invoiceNo = allEQuickRedRequestDTO.getInvoiceNo();
        String invoiceType = allEQuickRedRequestDTO.getInvoiceType();
        String blueIssueTime = allEQuickRedRequestDTO.getOriginalIssueTime();
        if (StringUtils.isEmpty((CharSequence)blueIssueTime)) {
            throw new MsgException(ApiErrCodeEnum.ILLEGAL_PARAM.getCode(), ResManager.loadKDString((String)"\u539f\u84dd\u7968\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApiRedService_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        try {
            Date originalIssueTime = DateUtils.stringToDate((String)blueIssueTime, (String)"yyyy-MM-dd HH:mm:ss");
            startTime = DateUtils.format((Date)originalIssueTime);
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new MsgException(ApiErrCodeEnum.ILLEGAL_PARAM.getCode(), ResManager.loadKDString((String)"\u539f\u84dd\u7968\u5f00\u7968\u65e5\u671f\u7684\u65f6\u95f4\u683c\u5f0f\u5fc5\u987b\u4e3a\u201cYYYY-MM-DD HH:MM:SS\u201d", (String)"ApiRedService_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        AllEleQueryFullInvoicesDTO request = new AllEleQueryFullInvoicesDTO();
        AllEleSearchOptDTO searchOpt = new AllEleSearchOptDTO();
        if (StringUtils.isEmpty((CharSequence)invoiceCode)) {
            searchOpt.setInvoiceCode("");
            searchOpt.setQdInvoiceNo(invoiceNo);
        } else {
            searchOpt.setInvoiceCode(invoiceCode);
            searchOpt.setInvoiceNo(invoiceNo);
        }
        request.setRequest_path(AllEleInterfaceTypeEnum.PAGE_QUERY_FULL_INVOICE_BODY.getRequestPath());
        searchOpt.setPageNo(Integer.valueOf(1));
        searchOpt.setPageSize(Integer.valueOf(10));
        searchOpt.setDataType(Integer.valueOf(2));
        if (InvoiceType.ALL_E_NORMAL.getLqptCode().equals(invoiceType)) {
            searchOpt.setInvoiceType("26");
        } else if (InvoiceType.ALL_E_SPECIAL.getLqptCode().equals(invoiceType)) {
            searchOpt.setInvoiceType("27");
        }
        searchOpt.setStartTime(startTime);
        searchOpt.setEndTime(startTime);
        request.setSearchOpt(searchOpt);
        log.info("\u6570\u7535\u7968\u7ea2\u51b2api queryBlueInvoice request: ", (Object)JSON.toJSONString((Object)request));
        boolean isVirtual = StringUtils.isNotBlank((CharSequence)ImcConfigUtil.getValue((String)"all_ele_mock_invoice", (String)sellerTaxNo));
        if (isVirtual) {
            response = new AllEleResponseListDTO<AllEleFullInvoiceResponseDTO>();
            String json = "{\n\t\t\t\"invoiceSource\": \"\",\n\t\t\t\"invoiceRiskLevel\": \"\",\n\t\t\t\"invoiceType\": '" + searchOpt.getInvoiceType() + "',\n\t\t\t\"invoiceCode\": \"" + StringUtils.trimToEmpty((String)allEQuickRedRequestDTO.getInvoiceCode()) + "\",\n\t\t\t\"etaxInvoiceNo\": \"\",\n\t\t\t\"invoiceNo\": \"" + allEQuickRedRequestDTO.getInvoiceNo() + "\",\n\t\t\t\"invoiceDate\": \"" + allEQuickRedRequestDTO.getOriginalIssueTime().substring(0, 10) + "\",\n\t\t\t\"invoiceStatus\": \"0\",\n\t\t\t\"salerTaxNo\": \"" + allEQuickRedRequestDTO.getSellerTaxpayerId() + "\",\n\t\t\t\"salerName\": \"" + allEQuickRedRequestDTO.getSellerName() + "\",\n\t\t\t\"buyerTaxNo\": \"" + allEQuickRedRequestDTO.getBuyerTaxpayerId() + "\",\n\t\t\t\"buyerName\": \"" + allEQuickRedRequestDTO.getBuyerName() + "\",\n\t\t\t\"invoiceAmount\": \"100\",\n\t\t\t\"totalTaxAmount\": \"13\",\n\t\t\t\"totalAmount\": \"113\",\n\t\t\t\"checkCode\": \"\",\n\t\t\t\"salerAddressPhone\": \"\",\n\t\t\t\"salerAccount\": \"\",\n\t\t\t\"buyerAddressPhone\": \"\",\n\t\t\t\"buyerAccount\": \"\",\n\t\t\t\"password\": \"\",\n\t\t\t\"remark\": \"\",\n\t\t\t\"machineNo\": \"\",\n\t\t\t\"drawer\": \"TEST\",\n\t\t\t\"payee\": \"\",\n\t\t\t\"reviewer\": \"\"\t\t}";
            log.info("\u6570\u7535\u7ea2\u51b2\uff0cmock\uff1a" + json);
            AllEleFullInvoiceResponseDTO responseDTO = (AllEleFullInvoiceResponseDTO)JSON.parseObject((String)json, AllEleFullInvoiceResponseDTO.class);
            ArrayList<AllEleFullInvoiceItemDTO> items = new ArrayList<AllEleFullInvoiceItemDTO>();
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalTaxAmount = BigDecimal.ZERO;
            if (allEQuickRedRequestDTO.getInvoiceDetail() == null || allEQuickRedRequestDTO.getInvoiceDetail().isEmpty()) {
                AllEleFullInvoiceItemDTO invoiceItemDTO = new AllEleFullInvoiceItemDTO();
                invoiceItemDTO.setGoodsCode("3010101020102000000");
                invoiceItemDTO.setGoodsName("*\u8fd0\u8f93\u670d\u52a1*\u5ba2\u8fd0\u670d\u52a1\u8d39");
                invoiceItemDTO.setUnit("");
                invoiceItemDTO.setNum("");
                invoiceItemDTO.setUnitPrice("");
                invoiceItemDTO.setDetailAmount("100");
                invoiceItemDTO.setTaxRate("0.13");
                invoiceItemDTO.setTaxAmount("13");
                totalAmount = new BigDecimal("100");
                totalTaxAmount = new BigDecimal("13");
                items.add(invoiceItemDTO);
            } else {
                for (AllEQuickRedRequestItemsDTO redRequestItemsDTO : allEQuickRedRequestDTO.getInvoiceDetail()) {
                    ApiRedService.mockItems(items, redRequestItemsDTO);
                    totalAmount = totalAmount.add(redRequestItemsDTO.getAmount().abs());
                    totalTaxAmount = totalTaxAmount.add(redRequestItemsDTO.getTaxAmount().abs());
                }
                if (invoiceNo.startsWith("30")) {
                    AllEQuickRedRequestItemsDTO redRequestItemsDTO = allEQuickRedRequestDTO.getInvoiceDetail().get(0);
                    ApiRedService.mockItems(items, redRequestItemsDTO);
                    totalAmount = totalAmount.add(redRequestItemsDTO.getAmount().abs());
                    totalTaxAmount = totalTaxAmount.add(redRequestItemsDTO.getTaxAmount().abs());
                }
            }
            BigDecimal totalIncludeTaxAmount = totalAmount.add(totalTaxAmount);
            responseDTO.setItems(items);
            responseDTO.setInvoiceAmount(totalAmount.stripTrailingZeros().toPlainString());
            responseDTO.setTotalTaxAmount(totalTaxAmount.stripTrailingZeros().toPlainString());
            responseDTO.setTotalAmount(totalIncludeTaxAmount.stripTrailingZeros().toPlainString());
            ArrayList<AllEleFullInvoiceResponseDTO> objects = new ArrayList<AllEleFullInvoiceResponseDTO>();
            objects.add(responseDTO);
            response.setDescription("ok");
            response.setErrcode(ErrorType.SUCCESS.getCode());
            response.setData(objects);
        } else {
            response = ApiRedService.repeatQuery(invoiceType, sellerTaxNo, request, AllEleFullInvoiceResponseDTO.class);
        }
        if (!StringUtils.equals((CharSequence)response.getErrcode(), (CharSequence)ErrorType.SUCCESS.getCode())) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20033.getCode(), EInvoiceErrCodeEnum.AllE_RED_20033.getMsg() + ": " + response.getDescription());
        }
        List data = response.getData();
        if (data.isEmpty()) {
            throw new MsgException(EInvoiceErrCodeEnum.AllE_RED_20033.getCode(), EInvoiceErrCodeEnum.AllE_RED_20033.getMsg() + ": " + response.getDescription());
        }
        ArrayList<DynamicObject> newInvoiceList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        AllEleFullInvoiceResponseDTO responseDTO = (AllEleFullInvoiceResponseDTO)data.get(0);
        QFilter filter = new QFilter("invoicecode", "=", (Object)StringUtils.trimToEmpty((String)responseDTO.getInvoiceCode()));
        filter.and("invoiceno", "=", (Object)responseDTO.getInvoiceNo());
        DynamicObject invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter.toArray());
        if (invoiceObj != null) {
            invoiceObj.set("invoicestatus", (Object)InvoiceSyncControl.transInvoiceStatus((String)responseDTO.getInvoiceStatus()));
            invoiceObj.set("issuetime", (Object)DateUtils.handleDate((String)responseDTO.getInvoiceDate()));
            log.info("\u66f4\u65b0\u6570\u7535\u7968\u6570\u636e...");
            updateList.add(invoiceObj);
        } else {
            invoiceObj = InvoiceSyncControl.transRpaObj((Long)orgId, (AllEleFullInvoiceResponseDTO)responseDTO);
            invoiceObj.set("billno", (Object)("300_" + UUID.getBatchNumber() + "_0001"));
            invoiceObj.set("orderno", (Object)UUID.randomUUID());
            invoiceObj.set("issuesource", (Object)"12");
            invoiceObj.set("orgid", (Object)orgId);
            invoiceObj.set("ofdstatus", (Object)"0");
            newInvoiceList.add(invoiceObj);
        }
        invoiceObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
        IssueInvoiceService.updateBaseInvoiceType((DynamicObject)invoiceObj);
        InvoiceSyncControl.afterCommonBatchSync(newInvoiceList, updateList);
        return null;
    }

    private static AllEleResponseListDTO<AllEleFullInvoiceResponseDTO> repeatQuery(String invoiceType, String sellerTaxNo, AllEleQueryFullInvoicesDTO request, Class<AllEleFullInvoiceResponseDTO> allEleFullInvoiceResponseDTOClass) {
        boolean isNeedQuery;
        log.info("interRepeatQuery");
        AllEleResponseListDTO response = AllEleServiceHelper.doPostList((String)sellerTaxNo, (AllEleRequestDTO)request, AllEleFullInvoiceResponseDTO.class);
        boolean bl = isNeedQuery = StringUtils.equals((CharSequence)response.getErrcode(), (CharSequence)ErrorType.SUCCESS.getCode()) && response.getData().isEmpty();
        if (!isNeedQuery) {
            return response;
        }
        if (InvoiceType.ALL_E_NORMAL.getLqptCode().equals(invoiceType)) {
            request.getSearchOpt().setInvoiceType("1");
            response = AllEleServiceHelper.doPostList((String)sellerTaxNo, (AllEleRequestDTO)request, AllEleFullInvoiceResponseDTO.class);
            boolean bl2 = isNeedQuery = StringUtils.equals((CharSequence)response.getErrcode(), (CharSequence)ErrorType.SUCCESS.getCode()) && response.getData().isEmpty();
            if (!isNeedQuery) {
                return response;
            }
            request.getSearchOpt().setInvoiceType("3");
            return AllEleServiceHelper.doPostList((String)sellerTaxNo, (AllEleRequestDTO)request, AllEleFullInvoiceResponseDTO.class);
        }
        request.getSearchOpt().setInvoiceType("4");
        response = AllEleServiceHelper.doPostList((String)sellerTaxNo, (AllEleRequestDTO)request, AllEleFullInvoiceResponseDTO.class);
        boolean bl3 = isNeedQuery = StringUtils.equals((CharSequence)response.getErrcode(), (CharSequence)ErrorType.SUCCESS.getCode()) && response.getData().isEmpty();
        if (!isNeedQuery) {
            return response;
        }
        request.getSearchOpt().setInvoiceType("2");
        return AllEleServiceHelper.doPostList((String)sellerTaxNo, (AllEleRequestDTO)request, AllEleFullInvoiceResponseDTO.class);
    }

    private static void mockItems(List<AllEleFullInvoiceItemDTO> items, AllEQuickRedRequestItemsDTO redRequestItemsDTO) {
        AllEleFullInvoiceItemDTO invoiceItemDTO = new AllEleFullInvoiceItemDTO();
        invoiceItemDTO.setGoodsCode(redRequestItemsDTO.getRevenueCode());
        DynamicObject taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)redRequestItemsDTO.getRevenueCode());
        if (taxClassCode == null) {
            throw new MsgException(ApiErrCodeEnum.ALLE_ITEM_TAXRATE_CODE_NOT_FOUND.getCode(), ApiErrCodeEnum.ALLE_ITEM_TAXRATE_CODE_NOT_FOUND.getMsg());
        }
        invoiceItemDTO.setGoodsName(String.format("*%1$s*%2$s", taxClassCode.getString("simplename"), redRequestItemsDTO.getGoodsName()));
        invoiceItemDTO.setUnit(redRequestItemsDTO.getUnits());
        invoiceItemDTO.setNum(new BigDecimal(redRequestItemsDTO.getQuantity()).abs().stripTrailingZeros().toPlainString());
        invoiceItemDTO.setUnitPrice(redRequestItemsDTO.getPrice());
        BigDecimal redAmount = redRequestItemsDTO.getAmount();
        if (MathUtils.isZero((BigDecimal)redAmount)) {
            redAmount = new BigDecimal(redRequestItemsDTO.getQuantity()).multiply(new BigDecimal(redRequestItemsDTO.getPrice())).setScale(2, RoundingMode.HALF_UP);
            redRequestItemsDTO.setAmount(redAmount);
        }
        invoiceItemDTO.setDetailAmount(redAmount.abs().stripTrailingZeros().toPlainString());
        invoiceItemDTO.setTaxRate(redRequestItemsDTO.getTaxRate());
        BigDecimal taxAmount = redRequestItemsDTO.getTaxAmount();
        if (MathUtils.isZero((BigDecimal)taxAmount)) {
            taxAmount = redAmount.multiply(new BigDecimal(redRequestItemsDTO.getTaxRate())).setScale(2, RoundingMode.HALF_UP);
            redRequestItemsDTO.setTaxAmount(taxAmount);
        }
        invoiceItemDTO.setTaxAmount(taxAmount.abs().stripTrailingZeros().toPlainString());
        items.add(invoiceItemDTO);
    }

    public static String dealCheckInvoiceDetailMethod(String orderNo, List<AllEQuickRedRequestItemsDTO> invoiceDetail, String specialType) {
        if (log.isInfoEnabled()) {
            log.info("dealCheckInvoiceDetailMethod, orderNo:{}, specialType:{}", (Object)orderNo, (Object)specialType);
        }
        if ("E07".equals(specialType) && invoiceDetail != null) {
            for (AllEQuickRedRequestItemsDTO redRequestItemsDTO : invoiceDetail) {
                String units = redRequestItemsDTO.getUnits();
                int lineProperty = redRequestItemsDTO.getLineProperty();
                if (0 != lineProperty && 2 != lineProperty || "\u8f86".equals(units)) continue;
                return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u5355\u4f4d\u680f\u5fc5\u987b\u4e3a:\u8f86", (String)"PartRedService_5", (String)"imc-sim-webapi", (Object[])new Object[0]), orderNo);
            }
        }
        return null;
    }
}

