/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.openapi.InvoiceDetailVo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.common.vo.starrysky.StarrySkyBillInvoiceQueryRequestVo;
import kd.imc.sim.common.vo.starrysky.StarrySkyBillInvoiceQueryResponseVo;
import kd.imc.sim.common.vo.starrysky.StarrySkyInvoiceVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public abstract class AbstractKingdeeBillInvoiceQueryImpl
implements OpenApiService {
    protected static final String BILL_QUERY_FIELD = String.join((CharSequence)",", "billno", "confirmstate", "validstate", "mainissuedamount", "surplusamount", "invoiceamount", "closestatus", "buyeremail", "buyerphone", "invoicetype", "sim_original_bill_item.id", "sim_original_bill_item.billsourceid");

    protected ApiResult billInvoiceQuery(StarrySkyBillInvoiceQueryRequestVo queryVo, boolean isEas) {
        QFilter qFilter = new QFilter("number", "=", (Object)queryVo.getOrgNumber());
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"", (QFilter[])qFilter.toArray());
        if (org == null) {
            return ResponseVo.fail((ApiErrCodeEnum)ApiErrCodeEnum.ORG_NOT_EXIST);
        }
        qFilter = new QFilter("orgid", "=", org.getPkValue()).and(OrgHelper.getIdFilter(queryVo.getBillNos(), (String)"billno"));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)BILL_QUERY_FIELD, (QFilter[])qFilter.toArray());
        if (bills.length == 0) {
            return ResponseVo.fail((ApiErrCodeEnum)ApiErrCodeEnum.BILL_NOT_EXIST);
        }
        qFilter = new QFilter("sbillid", "in", (Object)Arrays.stream(bills).map(DataEntityBase::getPkValue).toArray());
        DynamicObject[] billRelationArr = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])qFilter.toArray());
        Map<Object, List<DynamicObject>> relationMap = Arrays.stream(billRelationArr).collect(Collectors.groupingBy(k -> k.get("sbillid")));
        ArrayList<StarrySkyBillInvoiceQueryResponseVo> billInvoiceQueryList = new ArrayList<StarrySkyBillInvoiceQueryResponseVo>(bills.length);
        for (DynamicObject bill : bills) {
            List<DynamicObject> billRelationList;
            StarrySkyBillInvoiceQueryResponseVo billInvoiceQuery;
            billInvoiceQuery.setCloseStatus("1".equalsIgnoreCase((billInvoiceQuery = (StarrySkyBillInvoiceQueryResponseVo)DynamicObjectUtil.dynamicObject2Bean(StarrySkyBillInvoiceQueryResponseVo.class, (DynamicObject)bill)).getCloseStatus()) ? "1" : "0");
            billInvoiceQueryList.add(billInvoiceQuery);
            if (!isEas && "0".equals(billInvoiceQuery.getConfirmState()) || CollectionUtils.isEmpty(billRelationList = relationMap.get(bill.getPkValue()))) continue;
            qFilter = new QFilter("id", "in", (Object)billRelationList.stream().map(relation -> relation.get("tbillid")).toArray());
            ArrayList<StarrySkyInvoiceVo> invoices = new ArrayList<StarrySkyInvoiceVo>();
            boolean isNegativeBill = bill.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0;
            String invoiceType = bill.getString("invoicetype");
            ArrayList invoiceIdList = new ArrayList();
            if (isNegativeBill && InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
                DynamicObject[] redInfos;
                for (DynamicObject redInfo : redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info", (boolean)true), (QFilter[])qFilter.toArray())) {
                    if (StringUtils.isBlank((CharSequence)redInfo.getString("infocode"))) {
                        if (queryVo.getIssued().booleanValue()) continue;
                        invoices.add(this.redInfoObj2Vo(redInfo));
                        continue;
                    }
                    qFilter = new QFilter("orgid", "=", org.getPkValue()).and("infocode", "in", (Object)Arrays.stream(redInfos).map(red -> red.getString("infocode")).toArray());
                    DynamicObject[] invoice = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"", (QFilter[])qFilter.toArray());
                    if (invoice.length == 0) {
                        if (queryVo.getIssued().booleanValue()) continue;
                        invoices.add(this.redInfoObj2Vo(redInfo));
                        continue;
                    }
                    invoiceIdList.addAll(Arrays.stream(invoice).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
                }
            } else if (isNegativeBill && InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                DynamicObject[] redConfirmBill = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"number", (QFilter[])qFilter.toArray());
                qFilter = new QFilter("orgid", "=", org.getPkValue()).and("infocode", "in", (Object)Arrays.stream(redConfirmBill).map(red -> red.getString("number")).toArray());
                DynamicObject[] invoice = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"", (QFilter[])qFilter.toArray());
                invoiceIdList.addAll(Arrays.stream(invoice).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
            } else if (!isEas) {
                billInvoiceQuery.setRelations(this.convertRelation(bill, billRelationList));
                invoiceIdList.addAll(billRelationList.stream().map(relation -> relation.get("tbillid")).collect(Collectors.toList()));
            } else {
                DynamicObject[] invoiceIds = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"", (QFilter[])new QFilter("billno", "in", (Object)billRelationList.stream().map(relation -> relation.get("tbillno")).toArray()).toArray());
                invoiceIdList.addAll(Arrays.stream(invoiceIds).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
            }
            if (!CollectionUtils.isEmpty(invoiceIdList)) {
                qFilter = new QFilter("id", "in", invoiceIdList);
                if (queryVo.getIssued().booleanValue()) {
                    qFilter.and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
                }
                DynamicObject[] invoice = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])qFilter.toArray());
                invoices.addAll(this.invoiceObj2Vo(invoice));
            }
            billInvoiceQuery.setInvoices(invoices);
        }
        return ResponseVo.success((String)JSONObject.toJSONString(billInvoiceQueryList));
    }

    private List<BillRelationDTO> convertRelation(DynamicObject bill, List<DynamicObject> relations) {
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        Map<Long, String> item2BillSourceIdMap = items.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("billsourceid")));
        ArrayList<BillRelationDTO> relationList = new ArrayList<BillRelationDTO>(relations.size());
        for (DynamicObject relation : relations) {
            BillRelationDTO relationDTO = (BillRelationDTO)DynamicObjectUtil.dynamicObject2Bean(BillRelationDTO.class, (DynamicObject)relation);
            relationDTO.setBillSourceId(item2BillSourceIdMap.get(relationDTO.getsDetailId()));
            relationList.add(relationDTO);
        }
        return relationList;
    }

    protected List<StarrySkyInvoiceVo> invoiceObj2Vo(DynamicObject[] invoiceArr) {
        ArrayList<StarrySkyInvoiceVo> invoiceList = new ArrayList<StarrySkyInvoiceVo>(invoiceArr.length);
        for (DynamicObject invoice : invoiceArr) {
            StarrySkyInvoiceVo starrySkyInvoiceVo = (StarrySkyInvoiceVo)((Object)DynamicObjectUtil.dynamicObject2Bean(StarrySkyInvoiceVo.class, (DynamicObject)invoice));
            starrySkyInvoiceVo.setIssueStatus(invoice.getString("issuestatus"));
            starrySkyInvoiceVo.setInvoiceDetail(this.buildInvoiceDetail(invoice.getDynamicObjectCollection("items")));
            invoiceList.add(starrySkyInvoiceVo);
        }
        return invoiceList;
    }

    protected StarrySkyInvoiceVo redInfoObj2Vo(DynamicObject redInfo) {
        StarrySkyInvoiceVo starrySkyInvoiceVo = (StarrySkyInvoiceVo)((Object)DynamicObjectUtil.dynamicObject2Bean(StarrySkyInvoiceVo.class, (DynamicObject)redInfo));
        starrySkyInvoiceVo.setRelationType("2");
        starrySkyInvoiceVo.setIssueStatus(IssueStatusEnum.none.getCode());
        starrySkyInvoiceVo.setInvoiceDetail(this.buildInvoiceDetail(redInfo.getDynamicObjectCollection("items")));
        return starrySkyInvoiceVo;
    }

    private List<InvoiceDetailVo> buildInvoiceDetail(DynamicObjectCollection items) {
        ArrayList<InvoiceDetailVo> detailList = new ArrayList<InvoiceDetailVo>();
        if (!CollectionUtils.isEmpty((Collection)items)) {
            for (DynamicObject item : items) {
                detailList.add((InvoiceDetailVo)DynamicObjectUtil.dynamicObject2Bean(InvoiceDetailVo.class, (DynamicObject)item));
            }
        }
        return detailList;
    }
}

