/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.openapi.FindOrderOpenNewVo;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class BillInvoiceNewQueryImpl
implements OpenApiService {
    private static Log logger = LogFactory.getLog(BillInvoiceNewQueryImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillInvoiceQueryImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        FindOrderOpenNewVo findOrderOpenNewVo = (FindOrderOpenNewVo)JSON.parseObject((String)requestVo.getData(), FindOrderOpenNewVo.class);
        if (findOrderOpenNewVo == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillInvoiceQueryImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        VerifyResult res = this.checkFindOrderOpen(findOrderOpenNewVo);
        if (!res.isSucceed()) {
            return ResponseVo.fail((String)res.getCode(), (String)res.getDesc());
        }
        Map result = InvoiceQueryUtil.queryInvoiceDataByBillNosForApi((String)findOrderOpenNewVo.getBatchNo(), (String)findOrderOpenNewVo.getBillNo());
        if (CollectionUtils.isEmpty((Map)result)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.FIND_ORDER_NOORG.getCode(), (String)String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7%s\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a", (String)"BillInvoiceQueryImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]), findOrderOpenNewVo.getBatchNo()));
        }
        ArrayList<HashMap<String, Object>> invoice = new ArrayList<HashMap<String, Object>>(result.size());
        for (Map.Entry entry : result.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            String billNo = (String)entry.getKey();
            map.put("billNo", billNo);
            DynamicObject originalBill = this.getOriginalBillMethod(billNo);
            this.dealPutOriginalBillMethod(map, originalBill);
            map.put("invoiceList", entry.getValue());
            invoice.add(map);
        }
        logger.info("BillInvoiceQueryImpl response {}", (Object)JSON.toJSONString(invoice));
        return ResponseVo.success((String)JSON.toJSONString(invoice));
    }

    private void dealPutOriginalBillMethod(Map<String, Object> map, DynamicObject originalBill) {
        if (originalBill != null) {
            DynamicObject orgObject = originalBill.getDynamicObject("orgid");
            if (orgObject != null) {
                map.put("invoiceOrgCode", orgObject.getString("number"));
            }
            map.put("billStatus", originalBill.getString("validstate"));
            map.put("invIssueDateBegin", null);
            map.put("invIssueDateEnd", null);
            map.put("totalAmount", originalBill.getBigDecimal("totalamount"));
            map.put("totalRows", originalBill.getString("itemcount"));
            String currency = originalBill.getString("currency");
            if (StringUtils.isBlank((CharSequence)currency)) {
                currency = "CNY";
            }
            map.put("billCurrency", currency);
            map.put("invoiceCurrency", currency);
            map.put("issueFinishAmount", originalBill.getBigDecimal("mainissuedamount").add(originalBill.getBigDecimal("mainissuedtax")));
            map.put("notIssueAmount", originalBill.getBigDecimal("surplusamount").add(originalBill.getBigDecimal("surplustax")));
            map.put("billMergeStatus", originalBill.getString("mergelable"));
            map.put("openInvoiceResultEntryLink", null);
            map.put("openInvoiceWorkStageEntryLink", null);
        }
    }

    private DynamicObject getOriginalBillMethod(String billNo) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
        DynamicObject originalBill = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (QFilter[])qFilter.toArray());
        return originalBill;
    }

    private VerifyResult checkFindOrderOpen(FindOrderOpenNewVo vo) {
        if (StringUtils.isEmpty((CharSequence)vo.getBatchNo())) {
            return VerifyResult.error(ApiErrCodeEnum.FIND_BATCH_NO.getCode(), ApiErrCodeEnum.FIND_BATCH_NO.getMsg());
        }
        return VerifyResult.succeed();
    }
}

