/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.dto.BillMatch.BillMatchDetailVo;
import kd.imc.bdm.common.dto.BillMatch.BillMatchInvoiceDetailVo;
import kd.imc.bdm.common.dto.BillMatch.BillMatchResultResponseVo;
import kd.imc.bdm.common.dto.BillMatch.BillMatchResultVo;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class BillMatchResultServiceImpl
implements OpenApiService {
    private static final Log LOGGER = LogFactory.getLog(BillMatchResultServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        BillMatchResultVo billMatchResultVo = (BillMatchResultVo)JSON.parseObject((String)requestVo.getData(), BillMatchResultVo.class);
        String batchNo = billMatchResultVo.getBatchNo();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_billmatch_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_billmatch_data"), (QFilter[])new QFilter("batchno", "=", (Object)batchNo).toArray());
        if (dynamicObjects.length == 0) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_CHECK_ERROR.getCode(), (String)ApiErrCodeEnum.BILL_MATCH_CHECK_ERROR.getMsg());
        }
        Map itemExtra = ImcConfigUtil.getValue((String)"bill_match_api_extra_item");
        ArrayList<JSONObject> dataList = new ArrayList<JSONObject>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            BillMatchResultResponseVo billMatchResultResponseVo = (BillMatchResultResponseVo)JSON.parseObject((String)dynamicObject.getString("responsedata_tag"), BillMatchResultResponseVo.class);
            JSONObject billMatchResultResponseVoJson = (JSONObject)JSON.toJSON((Object)billMatchResultResponseVo);
            if (billMatchResultResponseVo.getBillDetail() != null) {
                JSONArray billDetailArray = new JSONArray();
                for (BillMatchDetailVo matchDetailVo : billMatchResultResponseVo.getBillDetail()) {
                    JSONObject billMatchDetailVoJson = (JSONObject)JSON.toJSON((Object)matchDetailVo);
                    if (matchDetailVo.getMatchAmount() == null) {
                        billMatchDetailVoJson.remove((Object)"matchAmount");
                    }
                    if (matchDetailVo.getMatchTaxAmount() == null) {
                        billMatchDetailVoJson.remove((Object)"matchTaxAmount");
                    }
                    if (matchDetailVo.getMatchTotalAmount() == null) {
                        billMatchDetailVoJson.remove((Object)"matchTotalAmount");
                    }
                    if (matchDetailVo.getInvoiceDetail() == null) {
                        billMatchDetailVoJson.remove((Object)"invoiceDetail");
                    }
                    if (matchDetailVo.getInvoiceDetail() != null) {
                        JSONArray invoiceDetailArray = new JSONArray();
                        for (BillMatchInvoiceDetailVo invoiceDetailVo : matchDetailVo.getInvoiceDetail()) {
                            JSONObject invoiceDetailVoJson = (JSONObject)JSON.toJSON((Object)invoiceDetailVo);
                            if (!itemExtra.isEmpty()) {
                                String invoiceNo = invoiceDetailVo.getInvoiceNo();
                                String originalSeq = invoiceDetailVo.getOriginalSeq();
                                DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("invoiceno", "=", (Object)invoiceNo).toArray());
                                DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
                                boolean startZero = false;
                                for (DynamicObject item : items) {
                                    int seq = item.getInt("seq");
                                    if (seq == 0) {
                                        startZero = true;
                                    }
                                    if (startZero) {
                                        String itemSeq = String.valueOf(seq + 1);
                                        if (!originalSeq.equals(itemSeq)) continue;
                                        for (Map.Entry entry : itemExtra.entrySet()) {
                                            try {
                                                String itemKey = (String)entry.getKey();
                                                invoiceDetailVoJson.put(itemKey, item.get(itemKey));
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    } else {
                                        if (!originalSeq.equals(String.valueOf(seq))) continue;
                                        for (Map.Entry entry : itemExtra.entrySet()) {
                                            try {
                                                String itemKey = (String)entry.getKey();
                                                invoiceDetailVoJson.put(itemKey, item.get(itemKey));
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                    break;
                                }
                            }
                            invoiceDetailArray.add((Object)invoiceDetailVoJson);
                        }
                        billMatchDetailVoJson.put("invoiceDetail", (Object)invoiceDetailArray);
                    }
                    billDetailArray.add((Object)billMatchDetailVoJson);
                }
                billMatchResultResponseVoJson.put("billDetail", (Object)billDetailArray);
            }
            dataList.add(billMatchResultResponseVoJson);
        }
        return ApiResult.success((Object)SerializationUtils.toJsonString(dataList));
    }
}

