/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.dto.BillMatch.BillMatchResultResponseVo;
import kd.imc.bdm.common.dto.BillMatch.BillMatchVo;
import kd.imc.bdm.common.dto.BillMatch.MatchBillDetailVo;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.NumberGenerateUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillMatchConfig;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.schedule.bill.NegativeBillMatchTask;
import org.apache.commons.collections.CollectionUtils;

public class BillMatchServiceImpl
implements OpenApiService {
    private static final String[] ctrlStrategy = new String[]{"7", "2", "1", "6", "5"};

    @Override
    public ApiResult processer(RequestVo requestVo) {
        List billMatchVos = JSON.parseArray((String)requestVo.getData(), BillMatchVo.class);
        if (CollectionUtils.isEmpty((Collection)billMatchVos)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_EMPTY.getCode(), (String)ApiErrCodeEnum.BILL_MATCH_EMPTY.getMsg());
        }
        ArrayList minusBillDTOs = Lists.newArrayListWithCapacity((int)0);
        for (BillMatchVo billMatchVo : billMatchVos) {
            QFilter buyerFilter;
            DynamicObject dynamicObject;
            DynamicObject dynamicObject2;
            long orgId;
            if (StringUtils.isEmpty((CharSequence)billMatchVo.getBillNo())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillMatchServiceImpl_19", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)billMatchVo.getRedReason())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ea2\u51b2\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillMatchServiceImpl_20", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (!billMatchVo.getBillNo().matches("^[a-zA-Z0-9_-]+")) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u53ea\u80fd\u4f7f\u7528\uff1a\u6570\u5b57\u3001\u82f1\u6587\u3001\u4e0b\u5212\u7ebf\u3001-", (String)"BillMatchServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            boolean isOrgEmpty = StringUtils.isEmpty((CharSequence)billMatchVo.getOrgCode());
            boolean isSallerTaxEmpty = StringUtils.isEmpty((CharSequence)billMatchVo.getSalerTaxNo());
            boolean isSallerNameEmpty = StringUtils.isEmpty((CharSequence)billMatchVo.getSellerName());
            boolean isBuyerTaxEmpty = StringUtils.isEmpty((CharSequence)billMatchVo.getBuyerTaxNo());
            boolean isBuyerNameEmpty = StringUtils.isEmpty((CharSequence)billMatchVo.getBuyerName());
            if (isOrgEmpty && isSallerTaxEmpty && isSallerNameEmpty) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7\u3001\u9500\u65b9\u540d\u79f0\u3001\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"BillMatchServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (isBuyerNameEmpty && isBuyerTaxEmpty) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0\u3001\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"BillMatchServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("number", "=", (Object)billMatchVo.getOrgCode());
            if (!isOrgEmpty) {
                DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)String.join((CharSequence)",", "epinfo"), (QFilter[])filter.toArray());
                if (orgObject == null) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7\u586b\u5199\u9519\u8bef\u6216\u672a\u5f55\u5165", (String)"BillMatchServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                if (!isSallerTaxEmpty && !billMatchVo.getSalerTaxNo().equals(orgObject.getDynamicObject("epinfo").getString("number"))) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7\u4e0e\u9500\u65b9\u7a0e\u53f7\u4e0d\u5339\u914d", (String)"BillMatchServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                billMatchVo.setSalerTaxNo(orgObject.getDynamicObject("epinfo").getString("number"));
                orgId = (Long)orgObject.getPkValue();
            } else if (!isSallerTaxEmpty) {
                filter = new QFilter("number", "=", (Object)billMatchVo.getSalerTaxNo());
                dynamicObject2 = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "org", "name"), (QFilter[])filter.toArray());
                if (dynamicObject2 == null) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u586b\u5199\u9519\u8bef", (String)"BillMatchServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                DynamicObject[] orgObjects = BusinessDataServiceHelper.load((String)"bdm_org", (String)String.join((CharSequence)",", "epinfo"), (QFilter[])new QFilter("epinfo", "=", (Object)dynamicObject2.getLong("id")).toArray());
                if (orgObjects.length > 1) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6b64\u7a0e\u53f7\u5206\u914d\u7ed9\u591a\u4e2a\u7ec4\u7ec7\u4f7f\u7528\uff0c\u5fc5\u987b\u586b\u5199\u7ec4\u7ec7\u7f16\u7801", (String)"BillMatchServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)orgObjects[0]);
            } else {
                filter = new QFilter("name", "=", (Object)billMatchVo.getSellerName());
                dynamicObject2 = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "org", "number"), (QFilter[])filter.toArray());
                if (dynamicObject2 == null) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0\u586b\u5199\u9519\u8bef", (String)"BillMatchServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                billMatchVo.setSalerTaxNo(dynamicObject2.getString("number"));
                orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject2.get("org"));
            }
            if (isBuyerTaxEmpty && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)"taxno", (QFilter[])(buyerFilter = new QFilter("name", "=", (Object)billMatchVo.getBuyerName())).toArray())) != null) {
                billMatchVo.setBuyerTaxNo(dynamicObject.getString("taxno"));
            }
            if ((InvoiceUtils.isSpecialInvoice((String)billMatchVo.getInvoiceType()) || InvoiceUtils.isAllESpecialInvoice((String)billMatchVo.getInvoiceType())) && isBuyerTaxEmpty) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4e13\u7968\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillMatchServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            DynamicObject matchConfig = this.checkCtrlConfig(billMatchVo.getRedReason(), orgId);
            if (matchConfig == null) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u6216\u5b8c\u5584-\u8d1f\u6570\u5339\u914d\u539f\u84dd\u7968\u914d\u7f6e", (String)"BillMatchServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            String matchStandard = matchConfig.getString("matchstandard");
            if (StringUtils.isEmpty((CharSequence)matchStandard)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u5339\u914d\u57fa\u51c6\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5b8c\u5584-\u8d1f\u6570\u5339\u914d\u539f\u84dd\u7968\u914d\u7f6e", (String)"BillMatchServiceImpl_15", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            MinusBillMatchConfig minusBillMatchConfig = NegativeBillMatchTask.buildMatchConfigByDynamicObject((DynamicObject)matchConfig);
            HashSet detailId = Sets.newHashSetWithExpectedSize((int)0);
            for (MatchBillDetailVo item : billMatchVo.getItems()) {
                DynamicObject[] goods;
                if (StringUtils.isEmpty((CharSequence)item.getDetailId())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6ID\u5fc5\u4f20", (String)"BillMatchServiceImpl_16", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                if (!item.getDetailId().matches("^\\d+$")) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6ID\u5fc5\u987b\u5168\u4e3a\u6570\u5b57", (String)"BillMatchServiceImpl_18", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                detailId.add(item.getDetailId());
                if (StringUtils.isEmpty((CharSequence)item.getGoodsCode()) && StringUtils.isEmpty((CharSequence)item.getGoodsName())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u4e0e\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"BillMatchServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                if (StringUtils.equals((CharSequence)"2", (CharSequence)matchStandard) && StringUtils.isEmpty((CharSequence)item.getNum())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6309\u6570\u91cf\u5339\u914d\u65f6\uff0c\u660e\u7ec6\u6570\u91cf\u5fc5\u586b", (String)"BillMatchServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                if (StringUtils.equals((CharSequence)"1", (CharSequence)matchStandard) && StringUtils.isEmpty((CharSequence)item.getAmount())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6309\u91d1\u989d\u5339\u914d\u65f6\uff0c\u660e\u7ec6\u91d1\u989d\u5fc5\u586b", (String)"BillMatchServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                if (StringUtils.isEmpty((CharSequence)item.getGoodsCode())) {
                    goods = BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)String.join((CharSequence)",", "number", "name", "taxcode"), (QFilter[])new QFilter("name", "=", (Object)item.getGoodsName()).toArray());
                    if (goods.length == 0) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u4e0e\u5546\u54c1\u7f16\u7801\u672a\u5728\u7cfb\u7edf\u4e2d\u914d\u7f6e\uff0c\u8bf7\u8865\u5145\u5b8c\u6574", (String)"BillMatchServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    }
                    if (goods.length > 1) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u4e2d\u5546\u54c1\u540d\u79f0\u5bf9\u5e94\u591a\u4e2a\u5546\u54c1\uff0c\u8bf7\u586b\u5199\u5546\u54c1\u7f16\u7801", (String)"BillMatchServiceImpl_14", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    }
                    item.setGoodsCode(goods[0].getDynamicObject("taxcode").getString("mergecode"));
                    item.setSpbm(goods[0].getString("number"));
                    item.setGoodsName(this.formatGoodsName(goods[0].getString("name"), goods[0].getDynamicObject("taxcode").getString("simplename")));
                } else {
                    goods = BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)String.join((CharSequence)",", "number", "name", "taxcode"), (QFilter[])new QFilter("number", "=", (Object)item.getGoodsCode()).toArray());
                    if (goods.length == 0) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u4e0e\u5546\u54c1\u7f16\u7801\u672a\u5728\u7cfb\u7edf\u4e2d\u914d\u7f6e\uff0c\u8bf7\u8865\u5145\u5b8c\u6574", (String)"BillMatchServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    }
                    item.setGoodsName(this.formatGoodsName(goods[0].getString("name"), goods[0].getDynamicObject("taxcode").getString("simplename")));
                    item.setSpbm(goods[0].getString("number"));
                    item.setGoodsCode(goods[0].getDynamicObject("taxcode").getString("mergecode"));
                }
                JSONObject itemExtJson = new JSONObject();
                itemExtJson.put("extrafield", (Object)item.getExtraField());
                itemExtJson.put("extrafield2", (Object)item.getExtraField2());
                itemExtJson.put("extrafield3", (Object)item.getExtraField3());
                itemExtJson.put("extrafield4", (Object)item.getExtraField4());
                itemExtJson.put("extrafield5", (Object)item.getExtraField5());
                item.setItemExtJson(itemExtJson);
            }
            if (detailId.size() != billMatchVo.getItems().size()) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_MATCH_PULL_FORM_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u660e\u7ec6ID\u5fc5\u4f20\u4e14\u552f\u4e00", (String)"BillMatchServiceImpl_17", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            MinusBillDTO minusBillDTO = (MinusBillDTO)JSON.parseObject((String)SerializationUtils.toJsonString((Object)billMatchVo), MinusBillDTO.class);
            minusBillDTO.setOrgId(Long.valueOf(orgId));
            minusBillDTO.setConfig(minusBillMatchConfig);
            minusBillDTOs.add(minusBillDTO);
        }
        String batchNo = NumberGenerateUtil.generateByPrefixWithRandom((String)"BM", (String)"_", (int)4);
        for (MinusBillDTO minusBillDTO : minusBillDTOs) {
            DynamicObject matchBillObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_billmatch_data");
            matchBillObject.set("batchno", (Object)batchNo);
            matchBillObject.set("billno", (Object)minusBillDTO.getBillNo());
            matchBillObject.set("matchstatus", (Object)"0");
            matchBillObject.set("requestdata_tag", (Object)SerializationUtils.toJsonString((Object)minusBillDTO));
            BillMatchResultResponseVo billMatchResultResponseVo = new BillMatchResultResponseVo();
            billMatchResultResponseVo.setBillNo(minusBillDTO.getBillNo());
            billMatchResultResponseVo.setMatchStatus("0");
            matchBillObject.set("responsedata_tag", (Object)SerializationUtils.toJsonString((Object)billMatchResultResponseVo));
            ImcSaveServiceHelper.save((DynamicObject)matchBillObject);
        }
        return ResponseVo.success((String)batchNo);
    }

    private DynamicObject checkCtrlConfig(String redReason, long orgId) {
        QFilter qFilter = ImcBaseDataHelper.getBillMatchSettingFilter((Object)orgId);
        for (int i = 0; i < ctrlStrategy.length; ++i) {
            DynamicObject matchConfig = this.findMatchConfig(qFilter, ctrlStrategy[i], redReason);
            if (matchConfig != null) {
                return matchConfig;
            }
            if (i != ctrlStrategy.length - 1) continue;
            return null;
        }
        return null;
    }

    private DynamicObject findMatchConfig(QFilter qFilter, String ctrlstrategy, String redReason) {
        QFilter filter = new QFilter("ctrlstrategy", "=", (Object)ctrlstrategy);
        QFilter redReasonFilter = new QFilter("redreason", "like", (Object)("%" + redReason + "%"));
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bdm_match_ori_inv_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_match_ori_inv_setting"), (QFilter[])filter.and(qFilter).and(redReasonFilter).toArray(), (String)"modifytime DESC");
        if (configs.length == 0) {
            return null;
        }
        return configs[0];
    }

    private String formatGoodsName(String name, String simpleName) {
        return "*" + simpleName + "*" + name;
    }
}

