/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.constant.ApiConfig;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvItemSettingConstant;
import kd.imc.bdm.common.constant.table.BdmIssueInvSettingConstant;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillCheckProcessDto;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AddressSplitHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.InvItemConfigHelper;
import kd.imc.bdm.common.helper.InvTitleSettingHelper;
import kd.imc.bdm.common.helper.IssueInvSettingHelper;
import kd.imc.bdm.common.helper.IssuePolicyHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MaterialInfoUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.helper.ThirdOrgHelper;
import kd.imc.sim.billcenter.sys.ExternalApprovalService;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.constant.ValidTypeEnum;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.InvTitleMatchHelper;
import kd.imc.sim.common.helper.MaterialToGoodsInfoHelp;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.helper.cache.GoodsInfoCacheHelper;
import kd.imc.sim.common.helper.goodsinfo.UnitConversionHelp;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.issueinvoice.impl.AllEleIssueInvoiceImpl;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillValidResultController;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceControlHelper;
import kd.imc.sim.formplugin.match.BillMatchHelper;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;
import kd.imc.sim.scan.ImacScanService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BillPushServiceImpl
implements OpenApiService {
    private static final Log LOGGER = LogFactory.getLog(BillPushServiceImpl.class);
    protected static final String TYPE_TIME_SELECT_PROPERTIES = "invoicetype,issuetime,buyeraddr,buyerbank";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResult processer(RequestVo requestVo) {
        String errorMsg;
        DLock lock = null;
        long startTime = System.currentTimeMillis();
        try {
            ApiResult apiResult;
            List bills = JSON.parseArray((String)requestVo.getData(), BillVo.class);
            if (CollectionUtils.isEmpty((Collection)bills)) {
                ApiResult apiResult2 = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_DATA.getCode(), (String)ResManager.loadKDString((String)"\u5355\u636e\u6570\u636e\u672a\u4f20\u5165", (String)"BillPushServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
                return apiResult2;
            }
            if (!ApiConfig.checkDisposeLimit((int)bills.size())) {
                ApiResult apiResult3 = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_EXCEED_BATCH_LIMIT.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u6279\u6b21\u63a8\u9001\u8d85\u8fc7\u8d85\u8fc7\u5904\u7406\u6700\u5927\u503c\uff0c\u5f53\u524d\u6700\u5927\u503c\uff1a%s\u3002\u5982\u9700\u8c03\u6574\u8bf7\uff0c\u524d\u5f80\u53d1\u7968\u4e91\u5f00\u7968\u8bbe\u7f6e\u9875\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"BillPushServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiConfig.getDisposeLimit()));
                return apiResult3;
            }
            DynamicObject sellerInvoiceSetting = null;
            HashSet<Object> autoInvoice = new HashSet<Object>(bills.size());
            HashSet<Object> autoMerge = new HashSet<Object>(bills.size());
            HashSet<String> billNos = new HashSet<String>(bills.size());
            ArrayList updateList = Lists.newArrayList();
            ArrayList saveList = Lists.newArrayList();
            ArrayList updateNo = Lists.newArrayList();
            Map pushGoodsInfoData = Maps.newHashMapWithExpectedSize((int)bills.size());
            BillVo billVo = (BillVo)bills.get(0);
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billVo.getBillNo())) {
                ApiResult apiResult4 = ResponseVo.fail((String)ApiErrCodeEnum.FIND_ORDER_NO.getCode(), (String)ApiErrCodeEnum.FIND_ORDER_NO.getMsg());
                return apiResult4;
            }
            HashSet<Long> hasPermOrgs = new HashSet<Long>(bills.size());
            lock = DLock.create((String)("BILL_PUSH_" + billVo.getSellerTaxpayerId() + billVo.getBillNo()));
            if (!lock.tryLock(1000L)) {
                ApiResult apiResult5 = ResponseVo.fail((String)ApiErrCodeEnum.BILL_HANDLER_ING.getCode(), (String)ApiErrCodeEnum.BILL_HANDLER_ING.getMsg());
                return apiResult5;
            }
            HashMap<Long, DynamicObject> issueConfigMap = new HashMap<Long, DynamicObject>();
            for (BillVo bill2 : bills) {
                ApiResult apiResult6;
                Pair pairMap;
                String buyerBankNo;
                bill2.setBuyerTaxpayerId(bill2.getBuyerTaxpayerId().replaceAll(" ", "").toUpperCase());
                if (bill2.getBuyerTaxpayerId().length() > 20) {
                    ApiResult apiResult7 = ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getMsg());
                    return apiResult7;
                }
                String buyerBankAndAccount = bill2.getBuyerBankAndAccount();
                if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)buyerBankAndAccount) && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(buyerBankNo = (String)(pairMap = AddressSplitHelper.splitBankAndName((String)buyerBankAndAccount)).getValue())) && buyerBankNo.length() > 50) {
                    ApiResult apiResult8 = ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNT_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNT_CHECK.getMsg());
                    return apiResult8;
                }
                if (bill2.getBillDetail() == null) {
                    pairMap = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_ITEM_DATA.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u5165\u660e\u7ec6\u4e3a\u7a7a\u6216\u660e\u7ec6\u683c\u5f0f\u4e0d\u662fbillDetail", (String)"BillPushServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    return pairMap;
                }
                if (!ApiConfig.checkDetailLimit((int)bill2.getBillDetail().size())) {
                    pairMap = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_DETAIL_LIMIT.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s \u660e\u7ec6\u63a8\u9001\u8d85\u8fc7\u5904\u7406\u6700\u5927\u503c\uff0c\u5f53\u524d\u6700\u5927\u503c\uff1a%2$s\u3002\u5982\u9700\u8c03\u6574\u8bf7\uff0c\u524d\u5f80\u53d1\u7968\u4e91\u5f00\u7968\u8bbe\u7f6e\u9875\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"BillPushServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]), bill2.getBillNo(), ApiConfig.getDetailLimit()));
                    return pairMap;
                }
                this.warpOrgId(bill2, requestVo.getBusinessSystemCode());
                try {
                    if (!hasPermOrgs.contains(bill2.getOrgId()) && SystemParameterHelper.getSimParameterBoolean((long)bill2.getOrgId(), (String)"billpush_check_perm")) {
                        PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (long)bill2.getOrgId(), (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
                    }
                }
                catch (KDBizException e) {
                    buyerBankNo = ResponseVo.fail((String)"19999", (String)e.getMessage());
                    if (lock != null) {
                        lock.unlock();
                    }
                    return buyerBankNo;
                }
                hasPermOrgs.add(bill2.getOrgId());
                String sellerTaxNo = bill2.getSellerTaxpayerId();
                String invoiceType = bill2.getInvoiceType();
                if (AllEleAuthHelper.elePaperSetValue((Object)sellerTaxNo, (Object)invoiceType)) {
                    bill2.setIsElePaper("1");
                }
                if (!(apiResult6 = BillValidResultController.handleValidResult((BillVo)bill2)).getSuccess()) {
                    ApiResult apiResult9 = apiResult6;
                    return apiResult9;
                }
                if (apiResult6.getData() != null && kd.bos.dataentity.utils.StringUtils.isNotBlank((Object)apiResult6.getData())) {
                    updateList.add((DynamicObject)apiResult6.getData());
                    updateNo.add(bill2.getBillNo());
                }
                this.checkInputItemPrice(issueConfigMap, bill2);
            }
            try {
                DynamicObject invTitleSetting = InvTitleSettingHelper.getInvTitleSetting((Long)billVo.getOrgId());
                boolean isOpenTitleMapping = invTitleSetting != null && invTitleSetting.getBoolean(InvTitleSettingHelper.InvTitleMappingEnum.TIT_MAPP_BILL_PUSH.getCode());
                InvTitleMatchHelper.setAsstactInfo((List)bills, (boolean)isOpenTitleMapping);
                InvTitleMatchHelper.matchInvTitle((List)bills, (boolean)isOpenTitleMapping, (DynamicObject)invTitleSetting);
                BillValidaterHelper.setSaleInfoByTaxNo((List)bills);
                this.fillInfoFromRedConfirm(bills);
                if (billVo.getCondition().booleanValue()) {
                    MaterialToGoodsInfoHelp.instanceMaterialInfoUtilByBillList((List)bills, (long)((BillVo)bills.get(0)).getOrgId(), (boolean)false);
                } else {
                    boolean isLoad = MaterialToGoodsInfoHelp.getLoadTag((List)bills);
                    if (isLoad) {
                        pushGoodsInfoData = MaterialToGoodsInfoHelp.loadPushGoodsInfoData((long)((BillVo)bills.get(0)).getOrgId(), (List)bills);
                    }
                }
                Map invItemConfig = InvItemConfigHelper.getInvItemConfig((Long)((BillVo)bills.get(0)).getOrgId());
                BillPushServiceImpl.goodsMapping(bills, billNos, pushGoodsInfoData, billVo.getCondition(), ((BillVo)bills.get(0)).getOrgId(), invItemConfig);
                bills.stream().flatMap(bill -> bill.getBillDetail().stream()).forEach(detailVo -> {
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((Object)detailVo.getPrivilegeFlag())) {
                        detailVo.setPrivilegeFlag(Integer.valueOf("0"));
                    }
                });
            }
            finally {
                MaterialInfoUtil.clear();
            }
            long goodsMatchTime = System.currentTimeMillis();
            LOGGER.info("goodsMatchTime " + (goodsMatchTime - startTime));
            int serialNo = 1000;
            boolean billFromScan = false;
            String batchNumber = "100_" + UUID.getBatchNumber() + '_';
            BillMatchHelper billMatchHelper = new BillMatchHelper();
            QFilter qFilter = ImcBaseDataHelper.getInvoiceTypeManage((Object)billVo.getOrgId()).and("sourcetype", "=", (Object)"0");
            DynamicObject[] invoiceTypeManage = BusinessDataServiceHelper.load((String)"bdm_invoicetype_manage", (String)String.join((CharSequence)",", "filter_tag", "invoicetype"), (QFilter[])qFilter.toArray(), (String)String.format("%s asc, %s desc", "priority", "ctrlstrategy"));
            DynamicObject[] drawerStrategyArr = DrawerStrategyHelper.queryDrawerStrategyByOrg((Long)billVo.getOrgId());
            DynamicObject defaultDrawerStrategy = BusinessDataServiceHelper.newDynamicObject((String)"bdm_drawer_strategy");
            defaultDrawerStrategy.set("drawerstrategy", (Object)"1,1,1");
            HashMap infoCodeMap = Maps.newHashMapWithExpectedSize((int)bills.size());
            for (BillVo bill3 : bills) {
                QFilter blueInvoiceFilter;
                DynamicObject invoice;
                ApiResult details;
                ApiResult apiResult10;
                boolean isEtaxInvoice;
                bill3.setOriBuyerName(bill3.getBuyerName());
                bill3.setOriBuyerAddr(bill3.getBuyerAddressAndTel());
                bill3.setOriBuyerBank(bill3.getBuyerBankAndAccount());
                bill3.setSystemSource(requestVo.getBusinessSystemCode());
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)bill3.getBillSource())) {
                    bill3.setBillSource("2");
                } else if ("5".equals(bill3.getBillSource()) || "7".equals(bill3.getBillSource())) {
                    bill3.setAutoInvoice(0);
                    billFromScan = true;
                }
                this.saveOriginalItemData(bill3);
                if (updateNo.contains(bill3.getBillNo())) {
                    for (DynamicObject dynamicObject : updateList) {
                        if (!dynamicObject.getString("billno").equals(bill3.getBillNo())) continue;
                        this.warpDataByAutoInvoice(autoInvoice, autoMerge, bill3, dynamicObject);
                    }
                    continue;
                }
                DynamicObject enterpriseBaseInfoDynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_enterprise_baseinfo"), (QFilter[])new QFilter("number", "=", (Object)bill3.getSellerTaxpayerId()).toArray());
                if (null == enterpriseBaseInfoDynamicObject) {
                    ApiResult apiResult11 = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[%2$s]\u672a\u5728\u5e73\u53f0\u7ef4\u62a4", (String)"BillPushServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), bill3.getBillNo(), bill3.getSellerTaxpayerId()));
                    return apiResult11;
                }
                String originalDrawer = bill3.getDrawer();
                DynamicObject originalBill = DynamicObjectUtil.bean2DynamicObject((Object)billVo, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill"));
                boolean bl = isEtaxInvoice = InvoiceUtils.isAllEInvoice((Object)bill3.getInvoiceType()) || "1".equals(bill3.getIsElePaper());
                if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)bill3.getAccount()) && isEtaxInvoice && !EnterpriseHelper.isLqptChannel((String)bill3.getSellerTaxpayerId())) {
                    bill3.setDrawer(AllEleAuthHelper.getDrawerByAccount((String)bill3.getSellerTaxpayerId(), (String)bill3.getAccount()));
                } else {
                    billMatchHelper.matchDrawer(originalBill, drawerStrategyArr, defaultDrawerStrategy);
                    bill3.setDrawer(originalBill.getString("drawer"));
                }
                bill3.setPayee(originalBill.getString("payee"));
                bill3.setReviewer(originalBill.getString("reviewer"));
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)bill3.getDrawer())) {
                    LOGGER.info("drawerMatchNobody\u672a\u5339\u914d\u5230\u5f00\u7968\u4eba\u7528\u63a5\u53e3\u63a8\u5165\u7684\u5f00\u7968\u4eba");
                    bill3.setDrawer(originalDrawer);
                }
                billMatchHelper.matchInvoiceType(bill3, invoiceTypeManage);
                BillCheckProcessDto process = new BillCheckProcessDto(Boolean.valueOf(bill3.getAutoInvoice() == 1));
                ApiResult validResult = BillValidaterHelper.validBillCommon((BillVo)bill3, billNos, (ValidTypeEnum)ValidTypeEnum.BILL, (boolean)true, (BillCheckProcessDto)process);
                if (!validResult.getSuccess()) {
                    apiResult10 = validResult;
                    return apiResult10;
                }
                validResult = BillValidaterHelper.validAllEDeduction((BillVo)bill3, (ValidTypeEnum)ValidTypeEnum.BILL);
                if (!validResult.getSuccess()) {
                    apiResult10 = validResult;
                    return apiResult10;
                }
                BillValidaterHelper.validSpecialType((BillVo)bill3);
                BillValidaterHelper.checkReductionTaxType((BillVo)bill3);
                validResult = BillValidaterHelper.validBillBuyer((BillVo)bill3, (ValidTypeEnum)ValidTypeEnum.BILL);
                if (!validResult.getSuccess()) {
                    apiResult10 = validResult;
                    return apiResult10;
                }
                validResult = BillValidaterHelper.validBillSeller((BillVo)bill3, (DynamicObject)enterpriseBaseInfoDynamicObject, sellerInvoiceSetting, (ValidTypeEnum)ValidTypeEnum.BILL);
                if (!validResult.getSuccess()) {
                    apiResult10 = validResult;
                    return apiResult10;
                }
                validResult = BillValidaterHelper.validBillDetailEntrance((BillVo)bill3, (ValidTypeEnum)ValidTypeEnum.BILL);
                if (!validResult.getSuccess()) {
                    apiResult10 = validResult;
                    return apiResult10;
                }
                if (bill3.getDeduction().compareTo(BigDecimal.ZERO) != 0) {
                    if (bill3.getTotalAmount().abs().compareTo(bill3.getDeduction().abs()) < 0) {
                        apiResult10 = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5dee\u989d\u5927\u4e8e\u53d1\u7968\u91d1\u989d", (String)"BillPushServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), bill3.getBillNo()));
                        return apiResult10;
                    }
                    details = bill3.getBillDetail().stream().filter(detail -> Integer.parseInt("1") != detail.getLineProperty()).collect(Collectors.toList());
                    if (details.stream().anyMatch(detail -> MathUtils.isNullOrZero((BigDecimal)detail.getDeduction())) && details.stream().anyMatch(detail -> !MathUtils.isNullOrZero((BigDecimal)detail.getDeduction()))) {
                        Object object = ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u591a\u884c\u660e\u7ec6\u6263\u9664\u989d\u65f6\uff0c\u5fc5\u987b\u6bcf\u884c\u90fd\u586b\u5199\u6263\u9664\u989d", (String)"BillPushServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), bill3.getBillNo()));
                        return object;
                    }
                }
                if (bill3.getTotalAmount().compareTo(BigDecimal.ZERO) >= 0) {
                    bill3.setBillProperty(1);
                } else {
                    bill3.setBillProperty(-1);
                }
                this.processBillAllDiscount(bill3);
                bill3.setTaxRate(((BillDetailVo)bill3.getBillDetail().get(0)).getTaxRate());
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)bill3.getSpecialType())) {
                    bill3.setSpecialType("00");
                }
                if (!(validResult = BillValidaterHelper.validAllESpecial((BillVo)bill3)).getSuccess()) {
                    details = validResult;
                    return details;
                }
                DynamicObject dynamicBill = DynamicObjectUtil.bean2DynamicObject((Object)bill3, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill"));
                dynamicBill.set("itemcount", (Object)dynamicBill.getDynamicObjectCollection("sim_original_bill_item").size());
                dynamicBill.set("id", (Object)DBServiceHelper.genGlobalLongId());
                this.setExtJsonData(bill3, dynamicBill);
                switch (dynamicBill.getString("specialtype")) {
                    case "E06": {
                        DynamicObjectUtil.bean2DynamicObject((Object)bill3.getEstateLeaseInfo(), (DynamicObject)dynamicBill);
                        break;
                    }
                    case "E03": {
                        DynamicObjectUtil.bean2DynamicObject((Object)bill3.getBuildInfo(), (DynamicObject)dynamicBill);
                        break;
                    }
                    case "E05": {
                        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)dynamicBill.getString("cobuyerflag"))) {
                            dynamicBill.getDynamicObjectCollection("cobuyers").clear();
                            dynamicBill.set("cobuyerflag", (Object)"0");
                        }
                        DynamicObjectCollection saleses = dynamicBill.getDynamicObjectCollection("estatesales");
                        for (int i = 0; i < saleses.size(); ++i) {
                            ((DynamicObject)saleses.get(i)).set("seq", (Object)(i + 1));
                        }
                        DynamicObjectCollection cobuyers = dynamicBill.getDynamicObjectCollection("cobuyers");
                        for (int i = 0; i < cobuyers.size(); ++i) {
                            ((DynamicObject)cobuyers.get(i)).set("seq", (Object)(i + 1));
                        }
                        break;
                    }
                    case "E04": {
                        dynamicBill.getDynamicObjectCollection("travelers").clear();
                        dynamicBill.getDynamicObjectCollection("vehichevesselships").clear();
                        break;
                    }
                    case "E09": {
                        dynamicBill.getDynamicObjectCollection("freights").clear();
                        dynamicBill.getDynamicObjectCollection("vehichevesselships").clear();
                        break;
                    }
                    case "E07": {
                        BillValidaterHelper.dealCheckVessalShipPeriodMethod((String)requestVo.getInterfaceCode(), (String)requestVo.getData());
                        BillValidaterHelper.dealSetPeriodDateMethod((DynamicObject)dynamicBill);
                        dynamicBill.getDynamicObjectCollection("travelers").clear();
                        dynamicBill.getDynamicObjectCollection("freights").clear();
                        break;
                    }
                    default: {
                        dynamicBill.getDynamicObjectCollection("vehichevesselships").clear();
                        dynamicBill.getDynamicObjectCollection("travelers").clear();
                        dynamicBill.getDynamicObjectCollection("freights").clear();
                    }
                }
                this.dealClearSpecialItemsMethod(dynamicBill);
                ApiResult errorResult = this.checkBillDate(bill3, dynamicBill);
                if (errorResult != null) {
                    ApiResult apiResult12 = errorResult;
                    return apiResult12;
                }
                String billName = InvoiceUtils.isEtcInvoice((String)bill3.getInvoiceType()) || AllEleAuthHelper.isElePaper((Object)bill3.getIsElePaper()) ? ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"BillPushServiceImpl_56", (String)"imc-sim-webapi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868", (String)"BillPushServiceImpl_57", (String)"imc-sim-webapi", (Object[])new Object[0]);
                this.setInfoCode(bill3);
                DynamicObject redInfoOrRedConfirmBill = RedInfoHelper.checkInfoCode((BillVo)bill3, (long)bill3.getOrgId(), (HashMap)infoCodeMap, (String)billName);
                if (null != redInfoOrRedConfirmBill && InvoiceUtils.isAllEInvoice((Object)bill3.getInvoiceType())) {
                    dynamicBill.set("salerorbuyer", (Object)this.getSalerOrBuyer(redInfoOrRedConfirmBill));
                    String originalinvoiceno = redInfoOrRedConfirmBill.getString("originalinvoiceno");
                    if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)bill3.getBlueinvoiceNo()) && !originalinvoiceno.equals(bill3.getBlueinvoiceNo())) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u5f85\u7ea2\u51b2\u53d1\u7968\u53f7\u7801\u4e0e\u7ea2\u5b57\u4fe1\u606f\u8868%2$s\u7684\u5f85\u7ea2\u51b2\u53d1\u7968\u53f7\u7801\u4e0d\u4e00\u81f4", (String)"BillPushServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), bill3.getBillNo(), bill3.getInfoCode()));
                    }
                    dynamicBill.set("blueinvoiceno", (Object)originalinvoiceno);
                    dynamicBill.set("originalissuetime", redInfoOrRedConfirmBill.get("originalissuetime"));
                    dynamicBill.set("blueinvoicetype", (Object)redInfoOrRedConfirmBill.getString("originalinvoicetype"));
                    String redReason = redInfoOrRedConfirmBill.getString("redreason");
                    dynamicBill.set("redreason", (Object)RedConfirmBillRedReasonEnum.getBillCodeByCode((String)redReason));
                    dynamicBill.set("infocode", (Object)bill3.getInfoCode());
                } else {
                    dynamicBill.set("blueinvoicecode", (Object)bill3.getBlueinvoiceCode());
                    dynamicBill.set("blueinvoiceno", (Object)bill3.getBlueinvoiceNo());
                    if (InvoiceUtils.isAllEInvoice((Object)bill3.getInvoiceType())) {
                        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)dynamicBill.getString("salerorbuyer"))) {
                            dynamicBill.set("salerorbuyer", (Object)"0");
                        }
                        if (bill3.getBillProperty() == Integer.parseInt("-1") && kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)dynamicBill.getString("redreason"))) {
                            dynamicBill.set("redreason", (Object)RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode());
                        }
                    }
                }
                String blueInvoiceCode = kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)dynamicBill.getString("blueinvoicecode"));
                String blueInvoiceNo = kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)dynamicBill.getString("blueinvoiceno"));
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)blueInvoiceNo) && (invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)TYPE_TIME_SELECT_PROPERTIES, (QFilter[])(blueInvoiceFilter = InvoiceUtils.getInvoiceFilter((Object)blueInvoiceCode, (Object)blueInvoiceNo)).toArray())) != null) {
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((Object)dynamicBill.get("blueinvoicetype"))) {
                        dynamicBill.set("blueinvoicetype", invoice.get("invoicetype"));
                    }
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((Object)dynamicBill.get("originalissuetime"))) {
                        dynamicBill.set("originalissuetime", invoice.get("issuetime"));
                    }
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((Object)dynamicBill.get("buyeraddr"))) {
                        dynamicBill.set("buyeraddr", invoice.get("buyeraddr"));
                    }
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((Object)dynamicBill.get("buyerbank"))) {
                        dynamicBill.set("buyerbank", invoice.get("buyerbank"));
                    }
                }
                CacheHelper.remove((String)("sim_repeat_push_bill_id_" + bill3.getBillNo()));
                BillValidResultController.setOldPk((DynamicObject)dynamicBill);
                IssuePolicyHelper.setBizControl((String)bill3.getIssueBizType(), (DynamicObject)dynamicBill);
                errorResult = this.warpDataByAutoInvoice(autoInvoice, autoMerge, bill3, dynamicBill);
                if (errorResult != null) {
                    blueInvoiceFilter = errorResult;
                    return blueInvoiceFilter;
                }
                dynamicBill.set("createdate", (Object)new Date());
                dynamicBill.set("originbillseq", (Object)(batchNumber + serialNo));
                dynamicBill.set("surplusamount", dynamicBill.get("invoiceamount"));
                dynamicBill.set("surplustax", dynamicBill.get("totaltax"));
                dynamicBill.set("billstatus", (Object)BillHelper.getBillStatusByTableName((String)"sim_original_bill", (String)"2"));
                dynamicBill.set("comprehensivestatus", (Object)BillHelper.getComprehensiveStatusByBillStatus((String)dynamicBill.getString("billstatus")));
                dynamicBill.set("billsourcetype", (Object)"A");
                dynamicBill.set("showbuyerbank", (Object)BillPushServiceImpl.getShowBank(bill3.getOrgId(), bill3.getShowBuyerBank(), "showbuyerbank"));
                dynamicBill.set("showsalerbank", (Object)BillPushServiceImpl.getShowBank(bill3.getOrgId(), bill3.getShowSalerBank(), "showsalerbank"));
                String productType = dynamicBill.getString("producttype");
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)productType)) {
                    dynamicBill.set("producttype", (Object)"1");
                }
                this.setMatchStatus(dynamicBill);
                this.setCreator(bill3, dynamicBill);
                IssueInvoiceService.updateTaxOrg((DynamicObject)dynamicBill);
                saveList.add(dynamicBill);
                ++serialNo;
                billNos.add(bill3.getBillNo());
            }
            autoInvoice.removeIf(Objects::isNull);
            autoMerge.removeIf(Objects::isNull);
            BotpHelper.dealPushArFields((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            if (CollectionUtils.isNotEmpty((Collection)saveList)) {
                billMatchHelper.matchAll((List)saveList, "0");
                ImcSaveServiceHelper.save((List)saveList);
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                ImcSaveServiceHelper.update((List)updateList);
            }
            Set dataBizKeySet = null;
            JSONObject dataBizJson = null;
            try {
                ArrayList dataList = new ArrayList(saveList);
                dataList.addAll(updateList);
                JSONObject riskResult = BillRiskControlService.riskControl(dataList, (String)"sim_original_bill", (RiskControlRecordConstant.ExecuteActionEnum)RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_ISSUE);
                dataBizJson = riskResult.getJSONObject("DATA_BIZ_NO_MAP");
                dataBizKeySet = (Set)riskResult.get((Object)"DATA_BIZ_KEY_ARR");
            }
            catch (Exception e) {
                LOGGER.error("risk control exception", (Throwable)e);
            }
            if (CollectionUtils.isNotEmpty(dataBizKeySet)) {
                autoInvoice.removeAll(dataBizKeySet);
            }
            LOGGER.info("autoInvoice size:" + autoInvoice.size());
            if (billFromScan) {
                MsgResponse msgResponse = ImacScanService.getWeChatScanUrl(saveList.toArray(new DynamicObject[0]), requestVo);
                if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
                    JSONObject jsonObject = JSON.parseObject((String)msgResponse.getRespData());
                    if ("2".equals(requestVo.getVersion())) {
                        ApiResult apiResult13 = ResponseVo.success((String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u6210\u529f", (String)"BillPushServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)jsonObject.toJSONString());
                        return apiResult13;
                    }
                    ApiResult apiResult14 = ResponseVo.success((String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u6210\u529f", (String)"BillPushServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), (Object)jsonObject.getString("url_link"));
                    return apiResult14;
                }
            } else {
                this.executeAutoIssueInvoice(autoInvoice, autoMerge);
            }
            ApiResult riskControlResult = BillRiskControlService.getApiResult((JSONObject)dataBizJson);
            if (riskControlResult != null) {
                apiResult = riskControlResult;
                return apiResult;
            }
            LOGGER.info("\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u6210\u529f");
            apiResult = ResponseVo.success((String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u6210\u529f", (String)"BillPushServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), null);
            return apiResult;
        }
        catch (MsgException msgException) {
            LOGGER.error("\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u5f02\u5e38MsgException ", (Throwable)msgException);
            String errorMsg2 = "singleMoreThanTaxControl".equals(msgException.getErrorCode()) ? String.format(ResManager.loadKDString((String)"%s \u5355\u636e\u5b58\u5728\u660e\u7ec6\u8d85\u8fc7\u7a0e\u63a7\u5c3e\u5dee\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u540e\u5f00\u7968\u3002", (String)"BillPushServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]), msgException.getErrorMsg()) : msgException.getErrorMsg();
            ApiResult apiResult = ResponseVo.fail((String)(kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)msgException.getErrorCode()) ? ApiErrCodeEnum.ERROR.getCode() : msgException.getErrorCode()), (String)errorMsg2);
            return apiResult;
        }
        catch (KDBizException e) {
            errorMsg = e.getMessage();
        }
        catch (Exception e) {
            LOGGER.error("\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u5f02\u5e38Exception ", (Throwable)e);
            errorMsg = String.format(ResManager.loadKDString((String)"\u63a8\u9001\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5 %s", (String)"BillPushServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage());
            if (e instanceof JSONException) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u63a5\u6536\u7684\u6570\u636e\u8f6c\u6362\u5f02\u5e38:%s", (String)"BillPushServiceImpl_46", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage());
            } else if (e instanceof NumberFormatException) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u63a5\u6536\u7684\u6570\u636e\u8f6c\u6362\u5f02\u5e38:%s", (String)"BillPushServiceImpl_46", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage());
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
    }

    private void checkInputItemPrice(HashMap<Long, DynamicObject> issueConfigMap, BillVo bill) {
        Long orgid = bill.getOrgId();
        DynamicObject issueInvSetting = issueConfigMap.get(orgid);
        if (null == issueInvSetting) {
            issueInvSetting = IssueInvSettingHelper.getIssueInvSetting((Long)orgid);
            issueConfigMap.put(orgid, issueInvSetting);
        }
        if (null != issueInvSetting) {
            boolean isSplit = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"));
            boolean isHint = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"));
            List billDetails = bill.getBillDetail();
            if (null != billDetails && billDetails.size() > 0) {
                boolean isEle = InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) || "1".equals(bill.getIsElePaper());
                for (BillDetailVo billDetail : billDetails) {
                    String price = billDetail.getPrice();
                    BigDecimal priceValue = BigDecimal.ZERO;
                    try {
                        priceValue = new BigDecimal(price);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (isSplit && !BigDecimalUtil.compareZero((BigDecimal)priceValue)) {
                        BigDecimal newPriceValue = PriceHelper.getValue((BigDecimal)priceValue, (boolean)isEle);
                        billDetail.setPrice(newPriceValue.toPlainString());
                    }
                    if (!isHint || BigDecimalUtil.compareZero((BigDecimal)priceValue)) continue;
                    PriceHelper.checkPriceLegal((BigDecimal)priceValue, (String)"\u5355\u4ef7", (boolean)isEle);
                }
            }
        }
    }

    private void fillInfoFromRedConfirm(List<BillVo> bills) {
        String redConfirmBillNo;
        Set redConfirmNumbers = bills.stream().map(o -> o.getInfoCode()).filter(o -> kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)o)).collect(Collectors.toSet());
        if (redConfirmNumbers.size() == 0) {
            return;
        }
        HashMap<String, List> redConfirmBillNoBillVos = new HashMap<String, List>();
        for (BillVo bill : bills) {
            String infoCode = bill.getInfoCode();
            if (!kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)infoCode)) continue;
            List billVos = redConfirmBillNoBillVos.computeIfAbsent(infoCode, k -> new ArrayList());
            billVos.add(bill);
        }
        String sellerTaxpayerId = bills.get(0).getSellerTaxpayerId();
        boolean isFarmSale = "E12".equals(bills.get(0).getSpecialType());
        QFilter baseFilter = new QFilter("salertaxno", "=", (Object)sellerTaxpayerId);
        if (isFarmSale) {
            baseFilter = new QFilter("buyertaxno", "=", (Object)sellerTaxpayerId);
        }
        QFilter redConfirmFilter = new QFilter("number", "in", redConfirmNumbers).and(baseFilter);
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])redConfirmFilter.toArray());
        Map<String, DynamicObject> redConfirmBillNoMap = Arrays.stream(redConfirms).collect(Collectors.toMap(o -> o.getString("number"), o -> o));
        for (Map.Entry entry : redConfirmBillNoBillVos.entrySet()) {
            redConfirmBillNo = (String)entry.getKey();
            List billVos = (List)entry.getValue();
            if (null != redConfirmBillNoMap.get(redConfirmBillNo)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u4f20\u5165\u7684\u7ea2\u5b57\u786e\u8ba4\u5355%2$s\u5728\u53d1\u7968\u4e91\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u4e0b\u8f7d\u81f3\u53d1\u7968\u4e91", (String)"BillPushServiceImpl_75", (String)"imc-sim-webapi", (Object[])new Object[0]), ((BillVo)billVos.get(0)).getBillNo(), redConfirmBillNo));
        }
        if (redConfirms.length == 0) {
            return;
        }
        for (Map.Entry entry : redConfirmBillNoBillVos.entrySet()) {
            redConfirmBillNo = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (value.size() > 1) continue;
            BillVo billVo = (BillVo)value.get(0);
            DynamicObject redConfirm = redConfirmBillNoMap.get(redConfirmBillNo);
            BigDecimal totalAmount = billVo.getTotalAmount();
            BigDecimal totalTaxAmount = billVo.getTotalTaxAmount();
            int isIncludeTax = billVo.getIncludeTaxFlag();
            List billDetails = billVo.getBillDetail();
            BigDecimal totalItemAmount = BigDecimal.ZERO;
            BigDecimal totalItemTax = BigDecimal.ZERO;
            if (null != billDetails && billDetails.size() > 0) {
                for (BillDetailVo billDetail : billDetails) {
                    BigDecimal billDetailAmount = billDetail.getAmount();
                    if (null == billDetailAmount) {
                        billDetailAmount = BigDecimal.ZERO;
                    }
                    totalItemAmount = totalItemAmount.add(billDetailAmount);
                    BigDecimal taxAmount = billDetail.getTaxAmount();
                    if (null == taxAmount) {
                        taxAmount = BigDecimal.ZERO;
                    }
                    totalItemTax = totalItemTax.add(taxAmount);
                }
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)billVo.getBlueinvoiceCode()) && !Objects.equals(billVo.getBlueinvoiceCode(), redConfirm.getString("originalinvoicecode"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u4f20\u5165\u7684\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u4fe1\u606f\u548c\u7ea2\u5b57\u786e\u8ba4\u5355%2$s\u7684\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"BillPushServiceImpl_74", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), redConfirm.getString("number")));
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)billVo.getBlueinvoiceNo()) && !Objects.equals(billVo.getBlueinvoiceNo(), redConfirm.getString("originalinvoiceno"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u4f20\u5165\u7684\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u4fe1\u606f\u548c\u7ea2\u5b57\u786e\u8ba4\u5355%2$s\u7684\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"BillPushServiceImpl_74", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), redConfirm.getString("number")));
            }
            this.setTotalAmountInfo(billVo, redConfirm, totalAmount, totalTaxAmount, isIncludeTax, totalItemAmount, totalItemTax);
            this.addItemFromRedConfirm(billVo, redConfirm);
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)billVo.getBuyerName())) {
                billVo.setBuyerName(redConfirm.getString("buyername"));
            }
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)billVo.getBuyerTaxpayerId())) {
                billVo.setBuyerTaxpayerId(redConfirm.getString("buyertaxno"));
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)redConfirm.getString("originalinvoiceno"))) {
                billVo.setBlueinvoiceNo(redConfirm.getString("originalinvoiceno"));
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)redConfirm.getString("originalinvoicecode"))) {
                billVo.setBlueinvoiceCode(redConfirm.getString("originalinvoicecode"));
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)redConfirm.getString("originalinvoicetype"))) {
                billVo.setBlueInvoiceType(redConfirm.getString("originalinvoicetype"));
            }
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)billVo.getOriginalIssueTime())) {
                String dateStr = DateUtils.format((Date)redConfirm.getDate("originalissuetime"), (String)"yyyy-MM-dd HH:mm:ss");
                billVo.setOriginalIssueTime(dateStr);
            }
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)billVo.getBuyerRecipientPhone())) {
                billVo.setBuyerRecipientPhone(redConfirm.getString("buyerphone"));
            }
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)billVo.getBuyerRecipientMail())) {
                billVo.setBuyerRecipientMail(redConfirm.getString("buyeremail"));
            }
            billVo.setApplicant(redConfirm.getString("applicant"));
            if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(redConfirm.getString("applicant"))) {
                billVo.setSalerOrBuyer("0");
                continue;
            }
            billVo.setSalerOrBuyer("1");
        }
    }

    private void addItemFromRedConfirm(BillVo billVo, DynamicObject redConfirm) {
        List billDetails = billVo.getBillDetail();
        if (null != billDetails && billDetails.size() > 0) {
            return;
        }
        int includeTaxFlag = billVo.getIncludeTaxFlag();
        boolean isIncludeTax = 1 == includeTaxFlag;
        ArrayList<BillDetailVo> billDetailVos = new ArrayList<BillDetailVo>();
        billVo.setBillDetail(billDetailVos);
        DynamicObjectCollection redConfirmItems = redConfirm.getDynamicObjectCollection("items");
        for (DynamicObject redConfirmItem : redConfirmItems) {
            BillDetailVo billDetailVo = new BillDetailVo();
            billDetailVos.add(billDetailVo);
            billDetailVo.setRevenueCode(redConfirmItem.getString("goodscode"));
            String goodsName = redConfirmItem.getString("goodsname");
            if (goodsName.charAt(0) == '*') {
                String subValue = goodsName.substring(1, goodsName.length() - 1);
                int i = subValue.indexOf(42) + 2;
                goodsName = goodsName.substring(i, goodsName.length());
            }
            billDetailVo.setGoodsName(goodsName);
            billDetailVo.setTaxRate(redConfirmItem.getString("taxrate"));
            billDetailVo.setQuantity(redConfirmItem.getBigDecimal("num").toPlainString());
            if (isIncludeTax) {
                billDetailVo.setPrice(redConfirmItem.getBigDecimal("taxunitprice").toPlainString());
                billDetailVo.setAmount(redConfirmItem.getBigDecimal("taxamount"));
            } else {
                billDetailVo.setPrice(redConfirmItem.getBigDecimal("unitprice").toPlainString());
                billDetailVo.setAmount(redConfirmItem.getBigDecimal("amount"));
            }
            billDetailVo.setLineProperty(2);
            billDetailVo.setUnits(redConfirmItem.getString("unit"));
            billDetailVo.setSpecification(redConfirmItem.getString("specification"));
            billDetailVo.setPrivilegeContent(redConfirmItem.getString("zzstsgl"));
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)redConfirmItem.getString("taxpremark"))) {
                billDetailVo.setPrivilegeFlag(Integer.valueOf(Integer.parseInt(redConfirmItem.getString("taxpremark"))));
            }
            billDetailVo.setOriginalSeq(Integer.valueOf(redConfirmItem.getInt("originseq")));
        }
    }

    private void setTotalAmountInfo(BillVo billVo, DynamicObject redConfirm, BigDecimal totalAmount, BigDecimal totalTaxAmount, int isIncludeTax, BigDecimal totalItemAmount, BigDecimal totalItemTax) {
        if (0 == isIncludeTax) {
            if (BigDecimalUtil.compareZero((BigDecimal)totalAmount)) {
                billVo.setTotalAmount(redConfirm.getBigDecimal("invoiceamount"));
            }
            if (BigDecimalUtil.compareZero((BigDecimal)totalTaxAmount)) {
                billVo.setTotalTaxAmount(redConfirm.getBigDecimal("totaltax"));
            }
            if (billVo.getTotalAmount().compareTo(redConfirm.getBigDecimal("invoiceamount")) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u4f20\u5165\u7684\u91d1\u989d\u548c\u7ea2\u5b57\u786e\u8ba4\u5355%2$s\u7684\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"BillPushServiceImpl_71", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), redConfirm.getString("number")));
            }
        } else {
            if (BigDecimalUtil.compareZero((BigDecimal)totalAmount)) {
                billVo.setTotalAmount(redConfirm.getBigDecimal("totalamount"));
            }
            if (BigDecimalUtil.compareZero((BigDecimal)totalTaxAmount)) {
                billVo.setTotalTaxAmount(redConfirm.getBigDecimal("totaltax"));
            }
            if (billVo.getTotalAmount().compareTo(redConfirm.getBigDecimal("totalamount")) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u4f20\u5165\u7684\u91d1\u989d\u548c\u7ea2\u5b57\u786e\u8ba4\u5355%2$s\u7684\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"BillPushServiceImpl_72", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), redConfirm.getString("number")));
            }
        }
        if (billVo.getTotalTaxAmount().compareTo(redConfirm.getBigDecimal("totaltax")) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u4f20\u5165\u7684\u7a0e\u989d\u548c\u7ea2\u5b57\u786e\u8ba4\u5355%2$s\u7684\u7a0e\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"BillPushServiceImpl_73", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), redConfirm.getString("number")));
        }
    }

    protected void setMatchStatus(DynamicObject dynamicBill) {
        if ("-1".equals(dynamicBill.getString("billproperties"))) {
            String blueInvoiceCode = dynamicBill.getString("blueinvoicecode");
            String blueInvoiceNo = dynamicBill.getString("blueinvoiceno");
            String infoCode = dynamicBill.getString("infocode");
            String systemSource = dynamicBill.getString("systemsource");
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)blueInvoiceCode) && kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)blueInvoiceNo) && kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)infoCode) && "KINGDEE_FI".equals(systemSource)) {
                dynamicBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.UN_PROCESS.getCode());
            }
        }
    }

    protected void setInfoCode(BillVo billVo) {
        DynamicObject redConfirmObj;
        if (billVo.getBillProperty() != -1) {
            return;
        }
        if (billVo.getAutoInvoice() != 1) {
            return;
        }
        if (!InvoiceUtils.isAllEInvoice((Object)billVo.getInvoiceType())) {
            return;
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)billVo.getInfoCode())) {
            return;
        }
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billVo.getBlueinvoiceNo())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,\u539f\u84dd\u7968\u4fe1\u606f\u5fc5\u586b\uff0c\u5426\u5219\u65e0\u6cd5\u5f00\u7968", (String)"BillPushServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo()));
        }
        String blueInvoiceCode = StringUtils.trimToEmpty((String)billVo.getBlueinvoiceCode());
        String blueInvoiceNo = StringUtils.trimToEmpty((String)billVo.getBlueinvoiceNo());
        QFilter blueFilter = InvoiceQueryUtil.getInvoiceByCodeAndNo((String)blueInvoiceCode, (String)blueInvoiceNo);
        DynamicObject blueInvoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])blueFilter.toArray());
        if (null == blueInvoiceObj) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,\u539f\u84dd\u7968\u5728\u53d1\u7968\u4e91\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5c06\u539f\u84dd\u7968\u4e0b\u8f7d\u81f3\u53d1\u7968\u4e91", (String)"BillPushServiceImpl_47", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo()));
        }
        Boolean isPartRed = Boolean.FALSE;
        if (billVo.getTotalAmount().abs().compareTo(blueInvoiceObj.getBigDecimal("invoiceamount")) < 0) {
            redConfirmObj = this.doPartRed(billVo);
            isPartRed = Boolean.TRUE;
        } else {
            QFilter redConfirmFilter = new QFilter("originalinvoicecode", "=", (Object)kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)billVo.getBlueinvoiceCode()));
            redConfirmFilter.and("originalinvoiceno", "=", (Object)kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)billVo.getBlueinvoiceNo()));
            redConfirmObj = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "issuestatus", "source", "number"), (QFilter[])redConfirmFilter.toArray());
        }
        if (redConfirmObj != null) {
            String source = redConfirmObj.getString("source");
            if (!IssueStatusEnum.none.getCode().equals(redConfirmObj.getString("issuestatus")) || "5".equals(source) || "10".equals(source)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,\u539f\u84dd\u7968\u53d1\u7968\u4ee3\u7801\u53f7\u7801\uff1a%2$s\uff0c\u5df2\u7ecf\u751f\u6210\u4e86\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u8bf7\u586b\u5199\u786e\u8ba4\u5355\u7f16\u53f7", (String)"BillPushServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), billVo.getBlueinvoiceNo()));
            }
        } else {
            redConfirmObj = RedConfirmBillHelper.createRedConfirmByBlue((BillVo)billVo, (String)UUID.randomUUID(), (DynamicObject)blueInvoiceObj, (Boolean)isPartRed);
        }
        billVo.setInfoCode(redConfirmObj.getString("number"));
    }

    private void setDefaultTerminalNo(BillVo billVo, SaleInfo saleInfo, DynamicObject equipmentDynamicObject) {
        if (!"8".equals(equipmentDynamicObject.getString("equipmenttype"))) {
            return;
        }
        String terminalNo = billVo.getTerminalNo();
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)terminalNo) && saleInfo.getDefaultDev().equals(billVo.getDeviceNo())) {
            billVo.setTerminalNo(saleInfo.getDefaultTerminal());
        }
    }

    public void processBillAllDiscount(BillVo bill) {
        if (MathUtils.isZero((BigDecimal)bill.getBillDiscountAmount())) {
            return;
        }
        if (bill.getBillProperty() == -1) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u8d1f\u6570\u5355\u636e\u4e0d\u80fd\u6709\u6574\u5355\u6298\u6263\u884c", (String)"BillPushServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal includeTaxAmount = BigDecimal.ZERO;
        BigDecimal billTotalAmount = BigDecimal.ZERO;
        BigDecimal billIncludeTaxAmount = BigDecimal.ZERO;
        if (!MathUtils.bigDecimalIsNegativeValue((BigDecimal)bill.getBillDiscountAmount())) {
            bill.setBillDiscountAmount(bill.getBillDiscountAmount().negate());
        }
        BigDecimal surplusAllDiscountAmount = bill.getBillDiscountAmount();
        for (int i = 0; i < bill.getBillDetail().size(); ++i) {
            BillDetailVo detail = (BillDetailVo)bill.getBillDetail().get(i);
            boolean hasZKItem = false;
            if (i < bill.getBillDetail().size() - 1 && bill.getBillDetail().get(i + 1) != null && 1 == ((BillDetailVo)bill.getBillDetail().get(i + 1)).getLineProperty()) {
                hasZKItem = true;
            }
            if (detail.getLineProperty() == 1 || detail.getLineProperty() == 2 && hasZKItem) continue;
            billTotalAmount = detail.getAmount().add(billTotalAmount);
            billIncludeTaxAmount = detail.getIncludeTaxAmount().add(billIncludeTaxAmount);
        }
        if (MathUtils.isZero((BigDecimal)billTotalAmount)) {
            throw new MsgException(ResManager.loadKDString((String)"\u6574\u5355\u6298\u6263\u91d1\u989d\u586b\u5199\u6709\u8bef\uff0c\u660e\u7ec6\u5df2\u6709\u6298\u6263\u884c\uff0c\u65e0\u6cd5\u6574\u5355\u6298\u6263", (String)"BillPushServiceImpl_14", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (bill.getIncludeTaxFlag() == 0) {
            if (!MathUtils.isZero((BigDecimal)bill.getDeduction())) {
                billTotalAmount = billTotalAmount.subtract(bill.getDeduction());
            }
            if (bill.getBillDiscountAmount().negate().compareTo(billTotalAmount) >= 0) {
                throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 %1$s \u6574\u5355\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e%2$s", (String)"BillPushServiceImpl_15", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), billTotalAmount));
            }
        } else {
            if (!MathUtils.isZero((BigDecimal)bill.getDeduction())) {
                billIncludeTaxAmount = billIncludeTaxAmount.subtract(bill.getDeduction());
            }
            if (bill.getBillDiscountAmount().negate().compareTo(billIncludeTaxAmount) >= 0) {
                throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 %1$s \u6574\u5355\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e%2$s", (String)"BillPushServiceImpl_15", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), billIncludeTaxAmount));
            }
        }
        HashMap<Integer, BillDetailVo> discountItems = new HashMap<Integer, BillDetailVo>();
        for (int i = 0; i < bill.getBillDetail().size(); ++i) {
            BillDetailVo discountLine;
            BigDecimal discountTax;
            BigDecimal discountAmount;
            BillDetailVo detail = (BillDetailVo)bill.getBillDetail().get(i);
            detail.setDetailRowNo(i);
            boolean hasZKItem = false;
            if (i < bill.getBillDetail().size() - 1 && bill.getBillDetail().get(i + 1) != null && 1 == ((BillDetailVo)bill.getBillDetail().get(i + 1)).getLineProperty()) {
                hasZKItem = true;
            }
            totalAmount = totalAmount.add(detail.getAmount().setScale(2, RoundingMode.HALF_UP));
            totalTaxAmount = totalTaxAmount.add(detail.getTaxAmount().setScale(2, RoundingMode.HALF_UP));
            includeTaxAmount = includeTaxAmount.add(detail.getIncludeTaxAmount().setScale(2, RoundingMode.HALF_UP));
            if (detail.getLineProperty() != 2 || hasZKItem) continue;
            String itemTaxRate = detail.getTaxRate();
            if (bill.getIncludeTaxFlag() == 1) {
                BigDecimal includeBigDecimal = detail.getIncludeTaxAmount();
                if (!MathUtils.isZero((BigDecimal)detail.getDeduction())) {
                    BigDecimal bigDecimal = MathUtils.notIncludeTaxConvertToHs((BigDecimal)detail.getAmount().subtract(detail.getDeduction()), (BigDecimal)new BigDecimal(detail.getTaxRate()));
                    includeBigDecimal = includeBigDecimal.subtract(bigDecimal);
                }
                BigDecimal discountTaxAmount = includeBigDecimal.divide(billIncludeTaxAmount, 100, 4).multiply(bill.getBillDiscountAmount()).setScale(2, 1);
                surplusAllDiscountAmount = surplusAllDiscountAmount.subtract(discountTaxAmount);
                discountAmount = discountTaxAmount.divide(BigDecimal.ONE.add(new BigDecimal(itemTaxRate)), 2, 4);
                discountTax = discountTaxAmount.subtract(discountAmount);
                discountLine = new BillDetailVo(detail.getGoodsName(), discountTaxAmount, detail.getTaxRate(), discountTax, detail.getRevenueCode(), detail.getRevenueName(), detail.getPrivilegeFlag().intValue(), detail.getPrivilegeContent(), bill.getIncludeTaxFlag());
            } else {
                BigDecimal amount = detail.getAmount();
                if (!MathUtils.isZero((BigDecimal)detail.getDeduction())) {
                    amount = amount.subtract(detail.getDeduction());
                }
                discountAmount = amount.divide(billTotalAmount, 100, 4).multiply(bill.getBillDiscountAmount()).setScale(2, 1);
                surplusAllDiscountAmount = surplusAllDiscountAmount.subtract(discountAmount);
                discountTax = discountAmount.multiply(new BigDecimal(itemTaxRate)).setScale(2, 4);
                discountLine = new BillDetailVo(detail.getGoodsName(), discountAmount, detail.getTaxRate(), discountTax, detail.getRevenueCode(), detail.getRevenueName(), detail.getPrivilegeFlag().intValue(), detail.getPrivilegeContent(), bill.getIncludeTaxFlag());
            }
            discountItems.put(i + 1, discountLine);
            discountLine.setDetailRowNo(i + 1);
            bill.getBillDetail().add(i + 1, discountLine);
            ++i;
            totalAmount = totalAmount.add(discountLine.getAmount());
            totalTaxAmount = totalTaxAmount.add(discountLine.getTaxAmount());
            includeTaxAmount = includeTaxAmount.add(discountLine.getIncludeTaxAmount());
        }
        block2: while (surplusAllDiscountAmount.compareTo(BigDecimal.ZERO) != 0) {
            List billDetails = bill.getBillDetail();
            Set entries = discountItems.entrySet();
            for (Map.Entry entry : entries) {
                BillDetailVo billDetailVo = (BillDetailVo)billDetails.get((Integer)entry.getKey());
                billDetailVo.setIncludeTaxAmount(billDetailVo.getIncludeTaxAmount().subtract(InvoiceConstant.DIFF_01));
                billDetailVo.setAmount(billDetailVo.getAmount().subtract(InvoiceConstant.DIFF_01));
                billDetailVo.setRemainAmount(bill.getIncludeTaxFlag() == 1 ? billDetailVo.getIncludeTaxAmount() : billDetailVo.getAmount());
                includeTaxAmount = includeTaxAmount.subtract(InvoiceConstant.DIFF_01);
                totalAmount = totalAmount.subtract(InvoiceConstant.DIFF_01);
                if ((surplusAllDiscountAmount = surplusAllDiscountAmount.add(InvoiceConstant.DIFF_01)).compareTo(BigDecimal.ZERO) != 0) continue;
                continue block2;
            }
        }
        bill.setIncludeTaxAmount(includeTaxAmount);
        bill.setTotalAmount(totalAmount);
        bill.setTotalTaxAmount(totalTaxAmount);
        bill.setOriginalIncludeTaxAmount(includeTaxAmount);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setCreator(BillVo billVo, DynamicObject dynamicBill) {
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billVo.getCreator())) {
            DynamicObject user = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id", (QFilter[])new QFilter("name", "=", (Object)billVo.getCreator()).toArray());
            if (user == null) throw new MsgException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u4eba(\u5236\u5355\u4eba) %s \u4e0d\u5b58\u5728\uff0c\u8bf7\u524d\u5f80'\u57fa\u7840\u670d\u52a1'-'\u4eba\u5458\u7ba1\u7406'\u4e2d\u65b0\u589e", (String)"BillPushServiceImpl_16", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getCreator()));
            dynamicBill.set("creator", user.getPkValue());
            return;
        } else {
            dynamicBill.set("creator", (Object)RequestContext.get().getUserId());
        }
    }

    public void executeAutoIssueInvoice(Set<Object> autoInvoice, Set<Object> autoMerge) {
        DynamicObject[] bills;
        ArrayList<Object> pkValueList = new ArrayList<Object>(autoInvoice);
        pkValueList.addAll(autoMerge);
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((Object[])pkValueList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"))) {
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject billItem : dynamicObjectCollection) {
                if (!kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)billItem.getString("goodscode"))) continue;
                throw new MsgException(ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6216\u5f00\u7968\u540d\u79f0\u672a\u80fd\u5339\u914d\u5230\u5f00\u7968\u9879", (String)"BillPushServiceImpl_17", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            bill.set("itemcount", (Object)dynamicObjectCollection.size());
        }
        LOGGER.info("BillPush bills length:" + bills.length);
        if (autoInvoice.size() > 0) {
            this.dealOpenApprovalWorkFlowMethod(bills);
        }
        if (autoMerge.size() > 0) {
            IssueInvoiceControlHelper.issueInvoice((DynamicObject[])bills, (Integer)1, (boolean)false, (boolean)true);
        }
    }

    private void dealOpenApprovalWorkFlowMethod(DynamicObject[] originalBillList) {
        String approval_switch_cfg = ImcConfigUtil.getValue((String)CacheKeyEnum.APPROVAL_WORK_FLOW_SWITCH.getConfigType(), (String)CacheKeyEnum.APPROVAL_WORK_FLOW_SWITCH.getConfigKey());
        if (StringUtils.isBlank((CharSequence)approval_switch_cfg)) {
            IssueInvoiceControlHelper.issueInvoice((DynamicObject[])originalBillList, (Integer)1, (boolean)false, (boolean)false);
        } else if ("Y".equals(approval_switch_cfg)) {
            for (DynamicObject originalBillObject : originalBillList) {
                originalBillObject.set("validstate", (Object)"0");
            }
            ImcSaveServiceHelper.update((DynamicObject[])originalBillList);
            String sub_work_flow_class = ImcConfigUtil.getValue((String)CacheKeyEnum.APPROVAL_WORK_FLOW_CLASS.getConfigType(), (String)CacheKeyEnum.APPROVAL_WORK_FLOW_CLASS.getConfigKey());
            if (StringUtils.isBlank((CharSequence)sub_work_flow_class)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f00\u542f\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a\u672a\u914d\u7f6e\u76f8\u5173\u7684\u5b9e\u73b0\u5b50\u7c7b\uff01", (String)"BillCreateServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            try {
                Class<?> clazz = Class.forName(sub_work_flow_class);
                ExternalApprovalService externalApprovalService = (ExternalApprovalService)clazz.newInstance();
                externalApprovalService.dealOpenApprovalWorkFlowMethod(new JSONObject(), originalBillList);
            }
            catch (Exception e) {
                String errorMsg = ResManager.loadKDString((String)"\u5f00\u542f\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a\u672a\u5339\u914d\u5230\u76f8\u5173\u7684\u5b9e\u73b0\u5b50\u7c7b\uff01", (String)"BillCreateServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
        } else {
            IssueInvoiceControlHelper.issueInvoice((DynamicObject[])originalBillList, (Integer)1, (boolean)false, (boolean)false);
        }
    }

    protected ApiResult checkBillDate(BillVo bill, DynamicObject dynamicBill) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)bill.getBillDate())) {
            try {
                dynamicBill.set("billdate", (Object)simpleDateFormat.parse(bill.getBillDate()));
            }
            catch (ParseException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5bf9\u5e94\u5355\u636e\u65e5\u671f[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"BillPushServiceImpl_18", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), bill.getBillDate()));
            }
        } else {
            dynamicBill.set("billdate", (Object)new Date());
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)bill.getContractDate())) {
            try {
                dynamicBill.set("contractdate", (Object)simpleDateFormat.parse(bill.getContractDate()));
            }
            catch (ParseException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5bf9\u5e94\u5408\u540c\u65e5\u671f[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"BillPushServiceImpl_19", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), bill.getContractDate()));
            }
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)bill.getExchangeDate())) {
            try {
                dynamicBill.set("exchangedate", (Object)simpleDateFormat.parse(bill.getExchangeDate()));
            }
            catch (ParseException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5bf9\u5e94\u6c47\u7387\u65e5\u671f[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"BillPushServiceImpl_20", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), bill.getExchangeDate()));
            }
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)bill.getOriginalIssueTime())) {
            try {
                dynamicBill.set("originalissuetime", (Object)simpleDateFormat.parse(bill.getOriginalIssueTime()));
            }
            catch (ParseException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5bf9\u5e94\u5f85\u51b2\u84dd\u7968\u65e5\u671f[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"BillPushServiceImpl_21", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), bill.getOriginalIssueTime()));
            }
        }
        if (bill.getEstateLeaseInfo() != null && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)bill.getEstateLeaseInfo().getStartLeaseDate())) {
            try {
                dynamicBill.set("startleasedate", (Object)simpleDateFormat.parse(bill.getEstateLeaseInfo().getStartLeaseDate()));
            }
            catch (ParseException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u79df\u8d41\u671f\u8d77\u65e5\u671f[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"BillPushServiceImpl_22", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), bill.getEstateLeaseInfo().getStartLeaseDate()));
            }
        }
        if (bill.getEstateLeaseInfo() != null && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)bill.getEstateLeaseInfo().getEndLeaseDate())) {
            try {
                dynamicBill.set("endleasedate", (Object)simpleDateFormat.parse(bill.getEstateLeaseInfo().getEndLeaseDate()));
            }
            catch (ParseException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u79df\u8d41\u671f\u6b62\u65e5\u671f[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"BillPushServiceImpl_23", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), bill.getEstateLeaseInfo().getEndLeaseDate()));
            }
        }
        DynamicObjectCollection travelerCollection = dynamicBill.getDynamicObjectCollection("travelers");
        for (DynamicObject travelerItem : travelerCollection) {
            Date travelerDate = travelerItem.getDate("traveldate");
            if (travelerDate == null) continue;
            String traveler_date = simpleDateFormat.format(travelerDate);
            try {
                travelerItem.set("traveldate", (Object)simpleDateFormat.parse(traveler_date));
            }
            catch (ParseException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5bf9\u5e94\u65c5\u5ba2\u8fd0\u8f93\u5206\u5f55\u4e2d\u51fa\u884c\u65e5\u671f[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"BillPushServiceImpl_45", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), traveler_date));
            }
        }
        return null;
    }

    protected ApiResult warpDataByAutoInvoice(Set<Object> autoInvoice, Set<Object> autoMerge, BillVo bill, DynamicObject dynamicBill) {
        boolean allowPush = "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_BILL_AUTO_MERGE_1_ALLOW_PUSH));
        if (!allowPush && bill.getAutoMerge() == 1 && bill.getAutoInvoice() != 1) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_IS_AUTO.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u7684\u81ea\u52a8\u5408\u5e76\u6807\u5fd7\u4e3a\u5408\u5e76\u65f6\uff0c\u81ea\u52a8\u5f00\u7968\u6807\u8bb0\u9700\u6807\u8bb0\u4e3a\u81ea\u52a8\u5f00\u7968\u72b6\u6001", (String)"BillPushServiceImpl_24", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo()));
        }
        if (bill.getAutoInvoice() == 1 && !"5".equals(bill.getBillSource())) {
            if (bill.getAutoInvoice() == 1 && bill.getBillProperty() == -1) {
                if (InvoiceUtils.isSpecialInvoice((String)bill.getInvoiceType())) {
                    if (!RedInfoConstant.ApplicantEnum.SALER.getCode().equals(bill.getApplicant())) {
                        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)bill.getInfoCode())) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICECODE.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u8d1f\u6570\u4e13\u7528\u53d1\u7968\u7ea2\u5b57\u4fe1\u606f\u8868\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u81ea\u52a8\u5f00\u7968", (String)"BillPushServiceImpl_25", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo()));
                        }
                        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)bill.getBlueinvoiceCode())) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICECODE.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u8d1f\u6570\u4e13\u7528\u53d1\u7968\u539f\u84dd\u7968\u4ee3\u7801\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u81ea\u52a8\u5f00\u7968", (String)"BillPushServiceImpl_26", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo()));
                        }
                        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)bill.getBlueinvoiceNo())) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICECODE.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u8d1f\u6570\u4e13\u7528\u53d1\u7968\u539f\u84dd\u7968\u53f7\u7801\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u81ea\u52a8\u5f00\u7968", (String)"BillPushServiceImpl_27", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo()));
                        }
                    }
                } else {
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)bill.getBlueinvoiceCode()) && !InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType())) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICECODE.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u81ea\u52a8\u5f00\u7968\u539f\u53d1\u7968\u4ee3\u7801\u4e3a\u7a7a", (String)"BillPushServiceImpl_28", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo()));
                    }
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)bill.getBlueinvoiceNo()) && !InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType())) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_CANCEL_NO_INVOICENUMBER.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u81ea\u52a8\u5f00\u7968\u539f\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a", (String)"BillPushServiceImpl_29", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo()));
                    }
                }
                QFilter filter = new QFilter("invoicecode", "=", (Object)bill.getBlueinvoiceCode()).and("invoiceno", "=", (Object)bill.getBlueinvoiceNo());
                String selFields = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true);
                DynamicObject vatObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)selFields, (QFilter[])filter.toArray());
                if (null != vatObj) {
                    if (bill.getTotalAmount().abs().compareTo(vatObj.getBigDecimal("remainredamount").abs()) > 0) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.OVER_CANRED_AMOUNT.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u53ef\u7ea2\u51b2\u91d1\u989d", (String)"BillPushServiceImpl_30", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo()));
                    }
                    if (bill.getTotalTaxAmount().abs().compareTo(vatObj.getBigDecimal("canredtaxamount").abs()) > 0) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.OVER_CANRED_AMOUNT.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u7a0e\u989d\u5927\u4e8e\u53d1\u7968\u53ef\u51b2\u7ea2\u7a0e\u989d", (String)"BillPushServiceImpl_31", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo()));
                    }
                }
                String firstRemark = String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:%1$s\u53f7\u7801:%2$s", (String)"BillPushServiceImpl_32", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBlueinvoiceCode(), bill.getBlueinvoiceNo());
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)bill.getRemark())) {
                    bill.setRemark(firstRemark);
                } else {
                    String inRemarkStr = bill.getRemark();
                    bill.setRemark(firstRemark.concat(inRemarkStr));
                    if (GBKUtils.getGBKLength((String)bill.getRemark()) > 230) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_REMARK_OVER.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7ea2\u5b57\u53d1\u7968\u5907\u6ce8\u957f\u5ea6\u8d85\u9650,\u6700\u5927\u957f\u5ea6\u4e3a%2$s", (String)"BillPushServiceImpl_33", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), 230 - GBKUtils.getGBKLength((String)firstRemark)));
                    }
                }
            }
            if (bill.getAutoMerge() == 1) {
                autoMerge.add(dynamicBill.getPkValue());
            } else {
                autoInvoice.add(dynamicBill.getPkValue());
            }
        } else {
            dynamicBill.set("splitrule", (Object)"");
        }
        return null;
    }

    protected void warpOrgId(BillVo billVo, String businessSystemCode) {
        SaleInfo saleInfo;
        DynamicObject orgDynamicObject;
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)billVo.getOrgCode())) {
            if ("KINGDEECLOUD".equals(businessSystemCode)) {
                billVo.setOrgCode(ThirdOrgHelper.getOrgNumberByThirdOrgNumber((String)billVo.getOrgCode()));
            }
            orgDynamicObject = TaxUtils.getOrgDynamicObjectByOrgNumber((String)billVo.getOrgCode());
            saleInfo = TaxUtils.getSaleInfoByOrgDynamicObject((DynamicObject)orgDynamicObject);
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billVo.getSellerTaxpayerId())) {
                billVo.setSellerTaxpayerId(saleInfo.getSaleTaxNo());
            } else if (!saleInfo.getSaleTaxNo().equals(billVo.getSellerTaxpayerId())) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7%s\u4e0e\u4f20\u5165\u7684\u9500\u65b9\u7a0e\u53f7\u4e0d\u5339\u914d", (String)"BillPushServiceImpl_34", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getOrgCode()));
            }
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billVo.getSellerName())) {
                billVo.setSellerName(saleInfo.getSaleName());
            } else if (!saleInfo.getSaleName().equals(billVo.getSellerName())) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7%s\u4e0e\u4f20\u5165\u7684\u9500\u65b9\u540d\u79f0\u4e0d\u5339\u914d", (String)"BillPushServiceImpl_44", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getOrgCode()));
            }
        } else {
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billVo.getSellerTaxpayerId())) {
                throw new MsgException(ApiErrCodeEnum.NON_SELLER_INFO.getCode(), ApiErrCodeEnum.NON_SELLER_INFO.getMsg());
            }
            orgDynamicObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)billVo.getSellerTaxpayerId());
            saleInfo = TaxUtils.getSaleInfoByOrgDynamicObject((DynamicObject)orgDynamicObject);
        }
        LOGGER.info(String.format("BillPush \u4f20\u5165\u7684\u7a0e\u53f7\u662f\uff1a%s,orgCode\u662f\uff1a%s,\u8bbe\u5907\u7f16\u53f7\u662f\uff1a%s", billVo.getSellerTaxpayerId(), billVo.getOrgCode(), billVo.getDeviceNo()));
        billVo.setOrgId(Long.valueOf(orgDynamicObject.getLong("id")));
        if (InvoiceUtils.isAllEInvoice((Object)billVo.getInvoiceType())) {
            return;
        }
        DynamicObject equipmentDynamicObject = null;
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)billVo.getDeviceNo())) {
            equipmentDynamicObject = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)billVo.getDeviceNo(), (String)billVo.getSellerTaxpayerId());
            if (equipmentDynamicObject == null) {
                throw new MsgException(ApiErrCodeEnum.FIND_EQINFO_NOTFINDEQ.getCode(), ApiErrCodeEnum.FIND_EQINFO_NOTFINDEQ.getMsg());
            }
            if (billVo.getAutoInvoice() == 1 && "0".equalsIgnoreCase(equipmentDynamicObject.getString("disen"))) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u5bf9\u5e94\u7684\u8bbe\u5907%2$s\u5df2\u7ecf\u88ab\u7981\u7528", (String)"BillPushServiceImpl_35", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), billVo.getDeviceNo()));
            }
        } else {
            String randomEq = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_BILL_RANDOM_EQUIPMENT);
            String eqType = null;
            if (!CacheKeyEnum.SIM_BILL_RANDOM_EQUIPMENT.getDefaultValue().equals(randomEq)) {
                if ("ALL".equalsIgnoreCase(randomEq)) {
                    eqType = "ALL";
                } else {
                    try {
                        JSONObject json = JSONObject.parseObject((String)randomEq);
                        eqType = json.getString(businessSystemCode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (eqType != null) {
                    equipmentDynamicObject = EquipmentUtil.getRandomActiveEquipmentByOrgDynamicObject((DynamicObject)orgDynamicObject, (String)eqType, (String)billVo.getInvoiceType());
                }
            }
            if (eqType == null && equipmentDynamicObject == null) {
                equipmentDynamicObject = EquipmentUtil.getDefaultEquipmentByOrgDynamicObject((DynamicObject)orgDynamicObject);
            }
            if (equipmentDynamicObject == null && billVo.getAutoInvoice() == 1) {
                throw new MsgException(ApiErrCodeEnum.INV_STOCK_NON_DEVICE.getCode(), ApiErrCodeEnum.INV_STOCK_NON_DEVICE.getMsg());
            }
            if (equipmentDynamicObject != null) {
                billVo.setDeviceNo(equipmentDynamicObject.getString("equipmentno"));
                this.setDefaultTerminalNo(billVo, saleInfo, equipmentDynamicObject);
            }
        }
    }

    protected static void goodsMapping(List<BillVo> bills, Set<String> billNos, Map<String, DynamicObject> pushGoodsInfoData, boolean isCondition, long orgId, Map<String, Object> invItemConfig) {
        boolean completion = MaterialToGoodsInfoHelp.getCompletion((long)orgId);
        if (null != invItemConfig && Boolean.parseBoolean(String.valueOf(invItemConfig.get(InvItemSettingConstant.BusTypeEnum.ORGINAL_BILL_NEW.getValue())))) {
            Pair<Map<String, DynamicObject>, Map<String, DynamicObject>> goodsNameAndCodeMap = BillPushServiceImpl.getGoodsNameAndCodeMap(bills, orgId);
            UnitConversionHelp unitConversionHelp = new UnitConversionHelp();
            for (BillVo bill : bills) {
                for (BillDetailVo detail : bill.getBillDetail()) {
                    DynamicObject goodByMaterial;
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)detail.getMaterialType())) {
                        detail.setMaterialType(null);
                    }
                    if (GoodsInfoConstant.PushMatchRulesEnum.GOODS_INFO.getCode().equals(bill.getPushMatchRules()) || isCondition) {
                        MaterialToGoodsInfoHelp.fillInGoodsInfo((BillDetailVo)detail, (Map)((Map)goodsNameAndCodeMap.getKey()), (Map)((Map)goodsNameAndCodeMap.getValue()), (boolean)false, (boolean)false);
                        if (((Map)goodsNameAndCodeMap.getValue()).containsKey(detail.getGoodsCode()) || ((Map)goodsNameAndCodeMap.getKey()).containsKey(detail.getGoodsName())) {
                            LOGGER.info(String.format("\u7f16\u53f7\uff1a%s\uff0c\u540d\u79f0\uff1a%s \u4f5c\u4e3a\u5f00\u7968\u9879\u6620\u5c04\u6210\u529f", detail.getGoodsCode(), detail.getGoodsName()));
                            continue;
                        }
                    }
                    if (null == (goodByMaterial = isCondition ? MaterialToGoodsInfoHelp.getGoodInfoByMaterial((BillVo)bill, (String)detail.getGoodsCode(), (String)detail.getGoodsName(), (Long)orgId) : MaterialToGoodsInfoHelp.getMappingGoodsInfo((BillDetailVo)detail, (String)bill.getPushMatchRules(), pushGoodsInfoData))) continue;
                    MaterialToGoodsInfoHelp.setDetail((BillDetailVo)detail, (DynamicObject)goodByMaterial, (String)bill.getFillValueRule());
                    if (!GoodsInfoConstant.PushMatchRulesEnum.DEFAULT_MATERIAL.getCode().equals(bill.getPushMatchRules())) continue;
                    boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) || "1".equals(bill.getIsElePaper());
                    unitConversionHelp.setUnitConversion(goodByMaterial, detail, isAllEle);
                }
            }
            return;
        }
        if (completion) {
            Pair<Map<String, DynamicObject>, Map<String, DynamicObject>> goodsNameAndCodeMap = BillPushServiceImpl.getGoodsNameAndCodeMap(bills, orgId);
            boolean isCompletionPolicylogo = MaterialToGoodsInfoHelp.getCompletionPolicylogo((long)orgId);
            for (BillVo bill : bills) {
                for (BillDetailVo detail : bill.getBillDetail()) {
                    if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)detail.getMaterialType())) {
                        detail.setMaterialType(null);
                    }
                    MaterialToGoodsInfoHelp.fillInGoodsInfo((BillDetailVo)detail, (Map)((Map)goodsNameAndCodeMap.getKey()), (Map)((Map)goodsNameAndCodeMap.getValue()), (boolean)true, (boolean)isCompletionPolicylogo);
                }
            }
            return;
        }
        LOGGER.info(String.format("API\u63a8\u5355\u5f00\u5173\u672a\u6253\u5f00,billNo\uff1a%s\u672a\u8fdb\u884c\u5f00\u7968\u9879\u6620\u5c04", JSON.toJSONString(billNos)));
    }

    private static Pair<Map<String, DynamicObject>, Map<String, DynamicObject>> getGoodsNameAndCodeMap(List<BillVo> bills, long orgId) {
        HashSet<String> goodsNameSet = new HashSet<String>(bills.size());
        HashSet<String> goodsCodeSet = new HashSet<String>(bills.size());
        for (BillVo bill : bills) {
            List billDetail = bill.getBillDetail();
            for (BillDetailVo billDetailVo : billDetail) {
                goodsNameSet.add(billDetailVo.getGoodsName());
                goodsCodeSet.add(billDetailVo.getGoodsCode());
            }
        }
        Map goodsNameMap = GoodsInfoCacheHelper.getGoodsInfo((String)"name", (Long)orgId, goodsNameSet);
        Map goodsCodeMap = GoodsInfoCacheHelper.getGoodsInfo((String)"number", (Long)orgId, goodsCodeSet);
        return Pair.of((Object)goodsNameMap, (Object)goodsCodeMap);
    }

    protected void saveOriginalItemData(BillVo bill) {
        List billDetail = bill.getBillDetail();
        this.checkLength(bill.getTextField1(), String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s", (String)"BillPushServiceImpl_36", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), ResManager.loadKDString((String)"\u6269\u5c55\u5b57\u6bb51", (String)"BillPushServiceImpl_37", (String)"imc-sim-webapi", (Object[])new Object[0])));
        this.checkLength(bill.getTextField2(), String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s", (String)"BillPushServiceImpl_36", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), ResManager.loadKDString((String)"\u6269\u5c55\u5b57\u6bb52", (String)"BillPushServiceImpl_38", (String)"imc-sim-webapi", (Object[])new Object[0])));
        this.checkLength(bill.getTextField3(), String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s", (String)"BillPushServiceImpl_36", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), ResManager.loadKDString((String)"\u6269\u5c55\u5b57\u6bb53", (String)"BillPushServiceImpl_39", (String)"imc-sim-webapi", (Object[])new Object[0])));
        this.checkLength(bill.getTextField4(), String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s", (String)"BillPushServiceImpl_36", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), ResManager.loadKDString((String)"\u6269\u5c55\u5b57\u6bb54", (String)"BillPushServiceImpl_40", (String)"imc-sim-webapi", (Object[])new Object[0])));
        this.checkLength(bill.getTextField5(), String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s", (String)"BillPushServiceImpl_36", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), ResManager.loadKDString((String)"\u6269\u5c55\u5b57\u6bb55", (String)"BillPushServiceImpl_41", (String)"imc-sim-webapi", (Object[])new Object[0])));
        String specialChars = ImcConfigUtil.getValue((String)CacheKeyEnum.SIM_REPLACE_SPCIAL_CHARACTERS.getConfigType(), (String)CacheKeyEnum.SIM_REPLACE_SPCIAL_CHARACTERS.getConfigKey());
        boolean isRepalce = kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)specialChars);
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) || "1".equals(bill.getIsElePaper());
        for (BillDetailVo billDetailVo : billDetail) {
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billDetailVo.getDetailId())) {
                billDetailVo.setBillSourceId(billDetailVo.getDetailId());
            }
            billDetailVo.setOriGoodsName(billDetailVo.getGoodsName());
            if (isRepalce) {
                this.replaceSpecialChar(specialChars, billDetailVo);
            }
            billDetailVo.setPrice(PriceHelper.getStrValue((String)billDetailVo.getPrice(), (String)"\u5355\u4ef7", (boolean)isAllEle));
            billDetailVo.setQuantity(UnitPriceHelper.getNumStrValue((String)billDetailVo.getQuantity(), (String)"\u6570\u91cf"));
            billDetailVo.setOriNum(billDetailVo.getQuantity());
            billDetailVo.setOriUnit(billDetailVo.getUnits());
            billDetailVo.setOriUnitPrice(billDetailVo.getPrice());
            this.checkLength(billDetailVo.getExtraField(), String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s", (String)"BillPushServiceImpl_36", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), ResManager.loadKDString((String)"\u660e\u7ec6\u6269\u5c55\u5b57\u6bb51", (String)"BillPushServiceImpl_42", (String)"imc-sim-webapi", (Object[])new Object[0])));
            this.checkLength(billDetailVo.getExtraField2(), String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s", (String)"BillPushServiceImpl_36", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), ResManager.loadKDString((String)"\u660e\u7ec6\u6269\u5c55\u5b57\u6bb51", (String)"BillPushServiceImpl_42", (String)"imc-sim-webapi", (Object[])new Object[0])));
            this.checkLength(billDetailVo.getExtraField3(), String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s", (String)"BillPushServiceImpl_36", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), ResManager.loadKDString((String)"\u660e\u7ec6\u6269\u5c55\u5b57\u6bb51", (String)"BillPushServiceImpl_42", (String)"imc-sim-webapi", (Object[])new Object[0])));
            this.checkLength(billDetailVo.getExtraField4(), String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s", (String)"BillPushServiceImpl_36", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), ResManager.loadKDString((String)"\u660e\u7ec6\u6269\u5c55\u5b57\u6bb51", (String)"BillPushServiceImpl_42", (String)"imc-sim-webapi", (Object[])new Object[0])));
            this.checkLength(billDetailVo.getExtraField5(), String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s", (String)"BillPushServiceImpl_36", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), ResManager.loadKDString((String)"\u660e\u7ec6\u6269\u5c55\u5b57\u6bb51", (String)"BillPushServiceImpl_42", (String)"imc-sim-webapi", (Object[])new Object[0])));
        }
    }

    private void replaceSpecialChar(String specialChars, BillDetailVo billDetailVo) {
        String[] charArray = specialChars.split(",");
        String goodsName = billDetailVo.getGoodsName();
        for (String c : charArray) {
            goodsName = this.getReplacedChar(goodsName, c);
        }
        billDetailVo.setGoodsName(goodsName);
        String specification = billDetailVo.getSpecification();
        for (String c : charArray) {
            specification = this.getReplacedChar(specification, c);
        }
        billDetailVo.setSpecification(specification);
    }

    private String getReplacedChar(String goodsName, String c) {
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)goodsName)) {
            return goodsName;
        }
        String result = goodsName.replace(c, "");
        if (!result.contains(c)) {
            return result;
        }
        return this.getReplacedChar(result, c);
    }

    private void checkLength(String ... extraFields) {
        for (String extraField : extraFields) {
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)extraField) || GBKUtils.getGBKLength((String)extraField) <= 150) continue;
            throw new MsgException(ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u6216\u660e\u7ec6\u6269\u5c55\u5b57\u6bb5\u8d85\u957f", (String)"BillPushServiceImpl_43", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
    }

    protected String getSalerOrBuyer(DynamicObject redInfo) {
        if ("2".equals(redInfo.getString("applicant"))) {
            return "0";
        }
        return redInfo.getString("applicant");
    }

    protected void setExtJsonData(BillVo billVo, DynamicObject dynamicBill) {
        JSONObject extJson = billVo.getExtJson();
        this.setExtJsonData(extJson, dynamicBill);
        DynamicObjectCollection itemCollection = dynamicBill.getDynamicObjectCollection("sim_original_bill_item");
        List billDetailList = billVo.getBillDetail();
        if (CollectionUtils.isNotEmpty((Collection)billDetailList)) {
            for (int i = 0; i < billDetailList.size(); ++i) {
                BillDetailVo billDetailVo = (BillDetailVo)billDetailList.get(i);
                JSONObject detailExtJson = billDetailVo.getExtJson();
                this.setExtJsonData(detailExtJson, (DynamicObject)itemCollection.get(i));
            }
        }
    }

    private void setExtJsonData(JSONObject extJson, DynamicObject dynamicObject) {
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        if (extJson != null && !extJson.isEmpty()) {
            for (String key : extJson.keySet()) {
                if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)dynamicObject, (String)key)) continue;
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key);
                if (property instanceof DecimalProp) {
                    dynamicObject.set(key, (Object)extJson.getBigDecimal(key));
                    continue;
                }
                if (property instanceof DateTimeProp) {
                    dynamicObject.set(key, extJson.getTimestamp(key));
                    continue;
                }
                dynamicObject.set(key, extJson.get((Object)key));
            }
        }
    }

    protected void dealClearSpecialItemsMethod(DynamicObject invoiceDynamicObject) {
        String specialType = invoiceDynamicObject.getString("specialtype");
        if (!"E09".equals(specialType)) {
            invoiceDynamicObject.getDynamicObjectCollection("travelers").clear();
        }
        if (!"E05".equals(specialType)) {
            invoiceDynamicObject.getDynamicObjectCollection("estatesales").clear();
            invoiceDynamicObject.set("cobuyerflag", null);
            invoiceDynamicObject.getDynamicObjectCollection("cobuyers").clear();
        }
        if (!"E04".equals(specialType)) {
            invoiceDynamicObject.getDynamicObjectCollection("freights").clear();
        }
    }

    public static boolean getShowBank(Long orgId, String showBank, String param) {
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)showBank)) {
            if ("showbuyerbank".equals(param)) {
                return SystemParameterHelper.getBdmParameterBoolean((long)orgId, (String)"showbuyerbank");
            }
            if ("showsalerbank".equals(param)) {
                return SystemParameterHelper.getBdmParameterBoolean((long)orgId, (String)"showsalerbank");
            }
        }
        return AllEleIssueInvoiceImpl.checkShowBank((String)showBank);
    }

    private DynamicObject doPartRed(BillVo billVo) {
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billVo.getRedReason())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,\u90e8\u5206\u7ea2\u51b2\u65f6\u7ea2\u51b2\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillPushServiceImpl_51", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo()));
        }
        if (RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode().equals(billVo.getRedReason())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,\u7ea2\u51b2\u539f\u56e0\u4e3a\u5f00\u7968\u6709\u8bef\u65f6\uff0c\u4e0d\u80fd\u90e8\u5206\u7ea2\u51b2", (String)"BillPushServiceImpl_52", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo()));
        }
        List billDetailVos = billVo.getBillDetail();
        HashSet<Integer> originalSeqSet = new HashSet<Integer>(billDetailVos.size());
        for (int i = 0; i < billDetailVos.size(); ++i) {
            if (((BillDetailVo)billDetailVos.get(i)).getOriginalSeq() == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,\u90e8\u5206\u7ea2\u51b2\u65f6\uff0c\u8bf7\u4f20\u8f93\u539f\u84dd\u7968\u5e8f\u53f7", (String)"BillPushServiceImpl_48", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo()));
            }
            if (null == ((BillDetailVo)billDetailVos.get(i)).getOriginalSeq() || ((BillDetailVo)billDetailVos.get(i)).getOriginalSeq() < 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,\u539f\u84dd\u7968\u5e8f\u53f7\u4ece1\u5f00\u59cb", (String)"BillPushServiceImpl_49", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo()));
            }
            originalSeqSet.add(((BillDetailVo)billDetailVos.get(i)).getOriginalSeq());
        }
        if (originalSeqSet.size() < billDetailVos.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,\u539f\u84dd\u7968\u5e8f\u53f7\u5b58\u5728\u91cd\u590d", (String)"BillPushServiceImpl_50", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo()));
        }
        DynamicObject redConfirmBill = null;
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "tbillid", "ttable", "tbillno"), (QFilter[])new QFilter("sbillno", "=", (Object)billVo.getBillNo()).toArray());
        ArrayList<Long> tbillIds = new ArrayList<Long>(billDetailVos.size());
        for (DynamicObject billRelation : billRelations) {
            tbillIds.add(billRelation.getLong("tbillid"));
        }
        DynamicObject[] redConfirms = CollectionUtils.isNotEmpty(tbillIds) ? BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "number", "govuuid", "salertaxno", "source", "uploaddate"), (QFilter[])new QFilter("id", "in", tbillIds).toArray()) : BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)false), (QFilter[])new QFilter("billno", "=", (Object)billVo.getBillNo()).toArray());
        for (DynamicObject redConfirm : redConfirms) {
            if (!"1".equals(redConfirm.getString("uploadstatus"))) continue;
            if ("0".equals(redConfirm.getString("issuestatus"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,\u5df2\u5f00\u5177\u53d1\u7968\uff0c\u53d1\u7968\u53f7\u7801\uff1a%2$s", (String)"BillPushServiceImpl_54", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), redConfirm.getString("invoiceno")));
            }
            if (billVo.getTotalAmount().compareTo(redConfirm.getBigDecimal("invoiceamount")) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\uff1a%1$s,\u5df2\u5b58\u5728\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\uff1a%2$s\uff0c\u4ef7\u7a0e\u5408\u8ba1\uff1a%3$s", (String)"BillPushServiceImpl_55", (String)"imc-sim-webapi", (Object[])new Object[0]), billVo.getBillNo(), redConfirm.getString("number"), redConfirm.getString("totalamount")));
            }
            if (RedConfirmStatusEnum.validConfirmStatus.contains((Object)redConfirm.getString("confirmstatus"))) continue;
            redConfirmBill = redConfirm;
        }
        return redConfirmBill;
    }
}

