/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.vo.BillReIssueCreateRequestItemVo;
import kd.imc.sim.common.vo.BillReverseCreateRequestVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.dto.ReverseBillRelationDTO;
import kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.helper.WorkbenchReverseHelper;
import kd.imc.sim.formplugin.openapi.service.impl.AbstractBillReverseServiceImpl;
import org.apache.commons.lang3.tuple.Pair;

public class BillReIssueCreateServiceImpl
extends AbstractBillReverseServiceImpl {
    private static final Log log = LogFactory.getLog(BillReIssueCreateServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        BillReverseCreateRequestVo reIssueBillRequest = (BillReverseCreateRequestVo)JSONObject.parseObject((String)requestVo.getData(), BillReverseCreateRequestVo.class);
        if (log.isInfoEnabled()) {
            log.info(String.format("\u4e1a\u52a1\u7cfb\u7edf[%s]\u521b\u5efa\u91cd\u5f00\u5355\u636e\u4f20\u5165\u53c2\u6570[%s]", requestVo.getBusinessSystemCode(), requestVo.getData()));
        }
        Pair<DynamicObject, Object[]> invoiceRelationPair = this.checkInvoiceNoExsit(reIssueBillRequest, false);
        Object[] billIds = (Object[])invoiceRelationPair.getValue();
        DynamicObject reverseBill = this.checkCreateReIssueBill(reIssueBillRequest, billIds);
        JSONObject reverseBillJson = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)reverseBill));
        boolean isRedFlush = "B".equals(reverseBillJson.getString("billsourcetype"));
        DynamicObject reIssueBill = WorkbenchReverseHelper.createReIssueBill((JSONObject)reverseBillJson, (boolean)isRedFlush);
        BillReIssueCreateRequestItemVo reIssueBillRequestItem = reIssueBillRequest.getReIssueBill();
        if (reIssueBillRequestItem != null) {
            WorkbenchReverseHelper.overrideJson2Dynamic((JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reIssueBillRequestItem)), (DynamicObject)reIssueBill, (boolean)false);
            if (StringUtils.isNotBlank((CharSequence)reIssueBillRequestItem.getReIssueBillNo())) {
                reIssueBill.set("billno", (Object)reIssueBillRequestItem.getReIssueBillNo());
            }
        }
        reIssueBill.set("billsource", (Object)"2");
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            OperationResult operationResult = ImcSaveServiceHelper.saveOperate((String)"sim_original_bill", (DynamicObject[])new DynamicObject[]{reIssueBill}, null);
            if (!operationResult.isSuccess()) {
                ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_ERROR.getCode(), (String)OperationConstant.getErrorMsg((OperationResult)operationResult));
                return apiResult;
            }
            this.saveBillRelation(reverseBill, reIssueBill);
            JSONObject json = new JSONObject();
            json.put("billNo", (Object)reIssueBill.getString("billno"));
            ApiResult apiResult = ResponseVo.success((String)json.toJSONString());
            return apiResult;
        }
        catch (Exception e) {
            tx.markRollback();
            ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_ERROR.getCode(), (String)e.getMessage());
            return apiResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private DynamicObject checkCreateReIssueBill(BillReverseCreateRequestVo reIssueBillRequest, Object[] billIds) {
        QFilter qFilter = new QFilter("relationtype", "=", (Object)"0").and("sbillid", "in", (Object)billIds);
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_bill_relation", (String)"tbillid", (QFilter[])qFilter.toArray());
        if (billRelations.length == 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u9006\u5411\u5355", (String)"BillReIssueCreateServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        qFilter = new QFilter("id", "in", (Object)Arrays.stream(billRelations).map(billRelation -> billRelation.getLong("tbillid")).toArray());
        DynamicObject[] reverseBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "invoicecode", "invoiceno", "blueinvoicecode", "blueinvoiceno", "validstate", "billsourcetype"), (QFilter[])qFilter.toArray());
        DynamicObject reverseBill = null;
        for (DynamicObject bill : reverseBills) {
            if ("B".equals(bill.getString("billsourcetype"))) {
                if (!bill.getString("blueinvoicecode").equals(reIssueBillRequest.getInvoiceCode()) || !bill.getString("blueinvoiceno").equals(reIssueBillRequest.getInvoiceNo())) continue;
                reverseBill = bill;
                break;
            }
            if (!bill.getString("invoicecode").equals(reIssueBillRequest.getInvoiceCode()) || !bill.getString("invoiceno").equals(reIssueBillRequest.getInvoiceNo())) continue;
            reverseBill = bill;
            break;
        }
        if (reverseBill != null) {
            qFilter = new QFilter("relationtype", "=", (Object)"1").and("sbillid", "=", reverseBill.getPkValue());
            if (QueryServiceHelper.exists((String)"sim_bill_relation", (QFilter[])qFilter.toArray())) {
                throw new MsgException(ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u5b58\u5728\u5bf9\u5e94\u91cd\u5f00\u5355", (String)"BillReIssueCreateServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            reverseBill = BusinessDataServiceHelper.loadSingle((Object)reverseBill.getPkValue(), (String)"sim_original_bill");
        }
        return reverseBill;
    }

    private void saveBillRelation(DynamicObject reverseBill, DynamicObject reIssueBill) {
        DynamicObject[] reverseBillRelations;
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)reverseBill.get("orgid"));
        ArrayList<DynamicObject> relationList = new ArrayList<DynamicObject>(4);
        ReverseBillRelationDTO reverseBillRelationDTO = new ReverseBillRelationDTO(Long.valueOf(reverseBill.getLong("id")), Long.valueOf(reIssueBill.getLong("id")), Long.valueOf(orgId), "1");
        relationList.add(this.createBillRelation(reverseBillRelationDTO));
        QFilter qFilter = new QFilter("tbillid", "=", reverseBill.getPkValue());
        for (DynamicObject reverseBillRelation : reverseBillRelations = BusinessDataServiceHelper.load((String)"sim_bill_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_relation"), (QFilter[])qFilter.toArray())) {
            ReverseBillRelationDTO reIssueBillRelationDTO = new ReverseBillRelationDTO(Long.valueOf(reverseBillRelation.getLong("sbillid")), Long.valueOf(reIssueBill.getLong("id")), Long.valueOf(orgId), "0");
            relationList.add(this.createBillRelation(reIssueBillRelationDTO));
        }
        ImcSaveServiceHelper.save(relationList);
    }
}

