/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.invoice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiConfig;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.IssuePolicyHelper;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.check.BaseCheckService;
import kd.imc.sim.formplugin.openapi.check.CheckInvoiceOpenService;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceOpenServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(InvoiceOpenServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        String batch;
        ArrayList<Object> pkValue;
        block42: {
            if (null == requestVo) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"InvoiceOpenServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            List invoiceVoList = JSON.parseArray((String)requestVo.getData(), InvoiceVo.class);
            if (log.isInfoEnabled()) {
                log.info(String.format("api\u63a5\u53e3\u5f00\u7968 requestData\uff1a%s", JSON.toJSONString((Object)invoiceVoList)));
            }
            if (CollectionUtils.isEmpty((Collection)invoiceVoList)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"InvoiceOpenServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (!ApiConfig.checkDisposeLimit((int)invoiceVoList.size())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u8d85\u8fc7\u6700\u5927\u5904\u7406\u6570\uff08%1$s\uff09\uff0c\u5f53\u524d\u4f20\u5165\u6570\uff1a%2$s", (String)"InvoiceOpenServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), ApiConfig.getDisposeLimit(), invoiceVoList.size()));
            }
            for (InvoiceVo vo : invoiceVoList) {
                if (StringUtils.isEmpty((CharSequence)vo.getSerialNo()) || BaseCheckService.checkLength(vo.getSerialNo().length())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_NO_ISNULL.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_NO_ISNULL.getMsg());
                }
                vo.setBuyerTaxpayerId(vo.getBuyerTaxpayerId().replaceAll(" ", "").toUpperCase());
                if (vo.getBuyerTaxpayerId() == null || vo.getBuyerTaxpayerId().length() <= 20) continue;
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getMsg());
            }
            QFilter filter = new QFilter("billno", "in", (Object)invoiceVoList.stream().map(InvoiceVo::getSerialNo).toArray());
            DynamicObjectCollection query = QueryServiceHelper.query((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "billno", "issuestatus", "batchbelong"), (QFilter[])filter.toArray());
            HashMap<String, DynamicObject> issuingInvoice = new HashMap<String, DynamicObject>(query.size());
            HashMap<String, DynamicObject> issueFailInvoice = new HashMap<String, DynamicObject>(query.size());
            for (DynamicObject invoice2 : query) {
                String issueStatus = invoice2.getString("issuestatus");
                if (IssueStatusEnum.failed.getCode().equals(issueStatus) || IssueStatusEnum.timeout.getCode().equals(issueStatus)) {
                    issueFailInvoice.put(invoice2.getString("billno"), invoice2);
                    continue;
                }
                issuingInvoice.put(invoice2.getString("billno"), invoice2);
            }
            pkValue = new ArrayList<Object>(invoiceVoList.size());
            invoiceVoList.removeIf(invoice -> issuingInvoice.containsKey(invoice.getSerialNo()) || issueFailInvoice.containsKey(invoice.getSerialNo()));
            if (invoiceVoList.size() > 0) {
                DynamicObject[] invoiceList = new DynamicObject[invoiceVoList.size()];
                batch = requestVo.getBusinessSystemCode() + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + InvoiceOpenServiceImpl.getCacheId("simInvoiceOpenForApi");
                RequestContext context = RequestContext.get();
                for (int i = 0; i < invoiceVoList.size(); ++i) {
                    InvoiceVo invoiceVo = (InvoiceVo)invoiceVoList.get(i);
                    invoiceVo.setBatch(batch);
                    invoiceVo.setBillDate(new Date());
                    invoiceVo.setOrderNo(UUID.next());
                    invoiceVo.setSystemSource(requestVo.getBusinessSystemCode());
                    if (!ApiConfig.checkDetailLimit((int)invoiceVo.getInvoiceDetail().size())) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5f20\u53d1\u7968\uff0c\u660e\u7ec6\u8d85\u8fc7\u9650\u5236\uff0c\u5f53\u524d\u9650\u5236\u957f\u5ea6%2$s", (String)"InvoiceOpenServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, ApiConfig.getDetailLimit()));
                    }
                    String string = invoiceVo.getSpecialType();
                    String taxNo = invoiceVo.getSellerTaxpayerId();
                    if (StringUtils.isNotBlank((CharSequence)invoiceVo.getAccount())) {
                        String msg;
                        if (TaxUtils.isPurchaseInvoice((String)string) || "E16".equals(string)) {
                            taxNo = invoiceVo.getBuyerTaxpayerId();
                        }
                        if (StringUtils.isNotBlank((CharSequence)(msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)invoiceVo.getAccount())))) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
                        }
                    }
                    if (InvoiceUtils.isAllEInvoice((Object)invoiceVo.getInvoiceType()) && "1".equals(invoiceVo.getInvoiceProperty() + "")) {
                        return ResponseVo.fail((String)"9999", (String)String.format(ResManager.loadKDString((String)"\u7b2c%s\u5f20\u53d1\u7968\u4e3a\u8d1f\u6570\u6570\u7535\u7968\uff0c\u6682\u4e0d\u652f\u6301", (String)"InvoiceOpenServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1));
                    }
                    VerifyResult result = CheckInvoiceOpenService.checkInvoiceVo(invoiceVo);
                    if (!result.isSucceed()) {
                        return ResponseVo.fail((String)result.getCode(), (String)String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5f20\u53d1\u7968\uff0c%2$s", (String)"InvoiceOpenServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, result.getDesc()));
                    }
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
                    DynamicObjectUtil.bean2DynamicObject((Object)invoiceVo, (DynamicObject)obj);
                    if (AllEleAuthHelper.elePaperSetValue((Object)obj.getString("salertaxno"), (Object)obj.getString("invoicetype"))) {
                        obj.set("iselepaper", (Object)"1");
                        obj.set("jqbh", (Object)"");
                        obj.set("issuesource", (Object)"12");
                    }
                    this.setRedInfoRemark(obj);
                    obj.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
                    obj.set("invoicestatus", (Object)"");
                    obj.set("createtime", (Object)new Date());
                    obj.set("invoicingoperator", (Object)Long.parseLong(context.getUserId()));
                    IssuePolicyHelper.setBizControl((String)invoiceVo.getIssueBizType(), (DynamicObject)obj);
                    invoiceList[i] = obj;
                }
                try (TXHandle h1 = TX.required();){
                    try {
                        ImcSaveServiceHelper.save((DynamicObject[])invoiceList);
                        for (DynamicObject dynamicObject : invoiceList) {
                            pkValue.add(dynamicObject.getPkValue());
                        }
                        break block42;
                    }
                    catch (Exception exception) {
                        h1.markRollback();
                        log.error("api\u63a5\u53e3\u5f00\u7968 \u4fdd\u5b58\u5f85\u5f00\u5f02\u5e38", (Throwable)exception);
                        ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)exception.getMessage());
                        if (h1 != null) {
                            if (var12_14 != null) {
                                try {
                                    h1.close();
                                }
                                catch (Throwable throwable) {
                                    var12_14.addSuppressed(throwable);
                                }
                            } else {
                                h1.close();
                            }
                        }
                        return apiResult;
                    }
                }
            }
            if (issueFailInvoice.size() > 0) {
                DynamicObject[] invoices = issueFailInvoice.values().toArray(new DynamicObject[0]);
                batch = invoices[0].getString("batchbelong");
                pkValue.addAll(Stream.of(invoices).map(invoice -> invoice.get("id")).collect(Collectors.toList()));
            } else {
                batch = issuingInvoice.values().toArray(new DynamicObject[0])[0].getString("batchbelong");
            }
        }
        if (pkValue.size() > 0) {
            try {
                DynamicObject[] waitInvoiceList = BusinessDataServiceHelper.load((Object[])pkValue.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
                log.info("api\u63a5\u53e3\u5f00\u7968\uff0cwaitInvoiceList " + waitInvoiceList.length);
                IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])waitInvoiceList);
            }
            catch (Exception e) {
                log.error("api\u63a5\u53e3\u5f00\u7968\u63a8\u5165mq\u5f02\u5e38", (Throwable)e);
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
            }
            return ResponseVo.success((String)batch);
        }
        return ResponseVo.success((String)batch);
    }

    private void setRedInfoRemark(DynamicObject invoice) {
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) > 0) {
            return;
        }
        if (AllEleAuthHelper.elePaperSetValue((Object)invoice.getString("salertaxno"), (Object)invoice.getString("invoicetype"))) {
            return;
        }
        String remark = invoice.getString("remark");
        if (InvoiceUtils.isNormalInvoice((String)invoice.getString("invoicetype")) && (StringUtils.isBlank((CharSequence)remark) || !remark.contains("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801"))) {
            invoice.set("remark", (Object)RemarkTemplateHelper.generateRemark((DynamicObject)invoice));
        }
        if (InvoiceUtils.isSpecialInvoice((String)invoice.getString("invoicetype")) && (StringUtils.isBlank((CharSequence)remark) || !remark.contains("\u5f00\u5177\u7ea2\u5b57\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u4fe1\u606f\u8868\u7f16\u53f7"))) {
            invoice.set("remark", (Object)RemarkTemplateHelper.generateRemark((DynamicObject)invoice));
        }
    }

    public static String getCacheId(String key) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
        long id = cache.inc(key);
        return id + "";
    }
}

