/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.qr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.send.SendMsg2Imac;
import kd.imc.bdm.common.util.MD5;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.common.vo.openapi.ScanUrlVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class QRGetScanUrlServiceImpl
implements OpenApiService {
    private static final Log LOGGER = LogFactory.getLog(QRGetScanUrlServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        DynamicObject qrKeyDO;
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QRSaveBuyerServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        ScanUrlVo requestDataVO = null;
        if (StringUtils.isNotEmpty((CharSequence)requestVo.getData())) {
            requestDataVO = (ScanUrlVo)JSON.parseObject((String)requestVo.getData(), ScanUrlVo.class);
        }
        if (requestDataVO == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QRSaveBuyerServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        LOGGER.info("QRGetScanUrl \u5165\u53c2 " + JSONObject.toJSONString((Object)requestVo));
        if (StringUtils.isEmpty((CharSequence)requestDataVO.getBillNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"QRSaveBuyerServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)requestDataVO.getSellerTaxpayerId())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"QRSaveBuyerServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)requestDataVO.getBillAmount())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"QRSaveBuyerServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("eqinfotaxno", "=", (Object)requestDataVO.getSellerTaxpayerId());
        qFilter.and("systemcode", "=", (Object)requestVo.getBusinessSystemCode());
        if (StringUtils.isNotEmpty((CharSequence)requestDataVO.getQrKey())) {
            qFilter.and("number", "=", (Object)requestDataVO.getQrKey());
        }
        if ((qrKeyDO = BusinessDataServiceHelper.loadSingle((String)"bdm_scaninvoice_setting", (String)"number", (QFilter[])qFilter.toArray())) == null) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%s]\u8fd8\u672a\u914d\u7f6e\u52a8\u6001\u4e8c\u7ef4\u7801\u914d\u7f6e", (String)"ImacScanService_0", (String)"imc-sim-webapi", (Object[])new Object[0]), requestDataVO.getSellerTaxpayerId()));
        }
        JSONObject requestJson = new JSONObject();
        requestJson.put("billNo", (Object)requestDataVO.getBillNo());
        requestJson.put("accountId", (Object)RequestContext.get().getAccountId());
        requestJson.put("tenantId", (Object)RequestContext.get().getTenantId());
        requestJson.put("systemCode", (Object)requestVo.getBusinessSystemCode());
        requestJson.put("billSource", (Object)"5");
        requestJson.put("version", (Object)"2");
        requestJson.put("qrKey", (Object)qrKeyDO.getString("number"));
        requestJson.put("md5", (Object)MD5.md5Hex((String)(qrKeyDO.getString("number") + requestDataVO.getBillNo())));
        requestJson.put("billTotalAmount", (Object)requestDataVO.getBillAmount());
        ArrayList<JSONObject> requestJsonArray = new ArrayList<JSONObject>();
        requestJsonArray.add(requestJson);
        MsgRequest request = new MsgRequest();
        request.setIdentifytype("imacSciiFromImc");
        request.setMsgType("createWeChatUrl");
        request.setReqData(requestJsonArray);
        MsgResponse msgResponse = SendMsg2Imac.send((MsgRequest)request, (String)"/kapi/app/imasm/imacWebService".concat("?access_token="));
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            return ResponseVo.success((String)JSON.parseObject((String)msgResponse.getRespData()).toJSONString());
        }
        return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u83b7\u53d6\u626b\u7801\u5f00\u7968\u94fe\u63a5\u5931\u8d25", (String)"QRSaveBuyerServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }
}

