/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.qr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.vo.openapi.BuyerVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.check.ScanVerifyUtil;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import kd.imc.sim.formplugin.openapi.helper.ScanApiHelper;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class QRSaveBuyerServiceImpl
implements OpenApiService {
    private static final Log LOGGER = LogFactory.getLog(QRSaveBuyerServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QRSaveBuyerServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        JSONObject paramObject = JSONObject.parseObject((String)requestVo.getData());
        LOGGER.info("\u4fdd\u5b58\u9759\u6001\u4e8c\u7ef4\u7801\u5b57\u6bb5\u914d\u7f6e\u7684\u8bf7\u6c42\u53c2\u6570:{}", (Object)paramObject);
        BuyerVo requestDataVO = null;
        if (StringUtils.isNotEmpty((CharSequence)requestVo.getData())) {
            requestDataVO = (BuyerVo)JSON.parseObject((String)requestVo.getData(), BuyerVo.class);
        }
        if (requestDataVO == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"QRSaveBuyerServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        LOGGER.info("QRSaveBuyer \u5165\u53c2 " + JSONObject.toJSONString((Object)requestVo));
        VerifyResult result = ScanVerifyUtil.checkBuyerData(requestDataVO);
        if (!result.isSucceed()) {
            return ResponseVo.fail((String)result.getCode(), (String)result.getDesc());
        }
        try {
            if (StringUtils.isEmpty((CharSequence)requestDataVO.getQrKey())) {
                DynamicObject buyer = BusinessDataServiceHelper.newDynamicObject((String)"sim_scan_invoice");
                buyer.set("applydate", (Object)new Date());
                if (paramObject.containsKey((Object)"opType")) {
                    JSONObject paramMap = paramObject;
                    List<String> fieldKeyList = this.dealGetDynamicAllFiledMethod("sim_scan_invoice");
                    for (Map.Entry entryObject : paramMap.entrySet()) {
                        String key = (String)entryObject.getKey();
                        Object value = entryObject.getValue();
                        if ("opType".equals(key) || "applydate".equals(key)) continue;
                        boolean flag = this.dealCheckContainsFieldMethod(key, fieldKeyList);
                        if (flag) {
                            buyer.set(key, value);
                            continue;
                        }
                        if ("customMsg".equalsIgnoreCase(key)) {
                            buyer.set("remark", value);
                            continue;
                        }
                        if ("mail".equalsIgnoreCase(key)) {
                            buyer.set("buyeremail", value);
                            continue;
                        }
                        if (!"mobileNumber".equalsIgnoreCase(key)) continue;
                        buyer.set("buyerphone", value);
                    }
                    buyer.set("status", (Object)"0");
                } else {
                    DynamicObjectUtil.bean2DynamicObject((Object)requestDataVO, (DynamicObject)buyer);
                }
                ImcSaveServiceHelper.save((DynamicObject)buyer);
            } else {
                VerifyResult verifyResult = ScanVerifyUtil.checkQrKeyPushTitle(requestDataVO);
                if (!verifyResult.isSucceed()) {
                    return ResponseVo.fail((String)verifyResult.getCode(), (String)verifyResult.getDesc());
                }
                DynamicObject originalBill = ScanApiHelper.getOriginalBillDynamicObject(requestDataVO.getBillNo());
                if (originalBill == null) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.QR_SYSTEMERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u4e0d\u5b58\u5728", (String)"QRSaveBuyerServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), requestDataVO.getBillNo()));
                }
                originalBill.set("buyername", (Object)requestDataVO.getBuyerName());
                originalBill.set("buyertaxno", (Object)requestDataVO.getBuyerTaxNo());
                originalBill.set("buyeraddr", (Object)(requestDataVO.getAddress() + requestDataVO.getInvoicePhone()));
                originalBill.set("buyerbank", (Object)(requestDataVO.getBank() + requestDataVO.getBankAccount()));
                originalBill.set("buyerphone", (Object)requestDataVO.getMobileNumber());
                originalBill.set("buyeremail", (Object)requestDataVO.getMail());
                originalBill.set("buyerproperty", (Object)requestDataVO.getBuyerProperty());
                ImcSaveServiceHelper.update((DynamicObject)originalBill);
            }
        }
        catch (MsgException msgException) {
            return ResponseVo.fail((String)ApiErrCodeEnum.QR_SYSTEMERROR.getCode(), (String)msgException.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("QR\u4fdd\u5b58\u8d2d\u65b9\u4fe1\u606f\u63a5\u53e3-\u4fdd\u5b58\u65f6\u51fa\u73b0\u5f02\u5e38", (Object)e.getMessage());
            return ResponseVo.fail((String)ApiErrCodeEnum.QR_SYSTEMERROR.getCode(), (String)ApiErrCodeEnum.QR_SYSTEMERROR.getMsg());
        }
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u62ac\u5934\u6210\u529f", (String)"QRSaveBuyerServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }

    private List<String> dealGetDynamicAllFiledMethod(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            ArrayList<String> fieldKeyList = new ArrayList<String>(mainPros.size());
            for (IDataEntityProperty property : mainPros) {
                String fieldKey = property.getName();
                if (!StringUtils.isNotBlank((CharSequence)fieldKey)) continue;
                fieldKeyList.add(fieldKey);
            }
            return fieldKeyList;
        }
        return null;
    }

    private boolean dealCheckContainsFieldMethod(String fieldKey, List<String> fieldKeyList) {
        if (fieldKeyList != null && fieldKeyList.size() > 0) {
            for (String elementKey : fieldKeyList) {
                if (!StringUtils.isNotBlank((CharSequence)fieldKey) || !fieldKey.equalsIgnoreCase(elementKey)) continue;
                return true;
            }
        }
        return false;
    }
}

