/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.price.impl;

import java.math.BigDecimal;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.scm.common.ORMUtil;
import kd.scm.pur.price.IPrice;
import kd.scm.pur.price.param.PriceData;
import kd.scm.pur.price.param.PriceDataCollection;
import kd.scm.pur.price.param.PriceParam;
import kd.scm.pur.price.param.PriceParamCollection;

public class PriceImpl
implements IPrice {
    private static final String entityName = "pur_price";
    private static final String algoKey = "scm.pur.price.priceImpl.getPrice";
    private PriceParamCollection paramCol;
    private StringBuilder selectField = new StringBuilder();

    @Override
    public PriceDataCollection getPrice(PriceParamCollection paramCol) {
        this.paramCol = paramCol;
        DataSet dataSet = ORMUtil.queryDataSet((String)algoKey, (String)entityName, (String)this.getSelectFields(), (QFilter[])this.getQFilter(this.paramCol));
        return this.handleDataSet(dataSet);
    }

    private QFilter[] getQFilter(PriceParamCollection paramCol) {
        QFilter[] qfilter = new QFilter[paramCol.size()];
        for (int i = 0; i < paramCol.size(); ++i) {
            PriceParam param = paramCol.getPriceParam(i);
            qfilter[i] = this.priceParam2QFilter(param);
        }
        return qfilter;
    }

    private QFilter priceParam2QFilter(PriceParam priceParam) {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        QFilter purOrgFilter = new QFilter("purorgscope", "=", (Object)"1");
        if (priceParam.getPurOrg() > 0L) {
            purOrgFilter = purOrgFilter.or(new QFilter("purorgscope", "=", (Object)"2").and(new QFilter("purorgentry.entrypurorg", "=", (Object)priceParam.getPurOrg())));
        }
        QFilter supplierFilter = new QFilter("supscope", "=", (Object)"1");
        if (priceParam.getSupplier() > 0L) {
            supplierFilter = supplierFilter.or(new QFilter("supscope", "=", (Object)"2").and(new QFilter("supentry.entrysupplier", "=", (Object)priceParam.getSupplier())));
        }
        QFilter recOrgFilter = new QFilter("rcvorgscope", "=", (Object)"1");
        if (priceParam.getReceiveOrg() > 0L) {
            recOrgFilter = recOrgFilter.or(new QFilter("rcvorgscope", "=", (Object)"2").and(new QFilter("recorgentry.entryrcvorg", "=", (Object)priceParam.getReceiveOrg())));
        }
        QFilter bizTypeFilter = new QFilter("biztypescope", "=", (Object)"1");
        if (priceParam.getBizType() > 0L) {
            bizTypeFilter = bizTypeFilter.or(new QFilter("biztypescope", "=", (Object)"2").and(new QFilter("bizentry.entrybiztype", "=", (Object)priceParam.getBizType())));
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)priceParam.getTaxType());
        QFilter bizDateFilter = new QFilter("entryentity.datefrom", "<=", (Object)priceParam.getBizDate());
        bizDateFilter = bizDateFilter.and(new QFilter("entryentity.dateto", ">=", (Object)priceParam.getBizDate()));
        QFilter materialFilter = new QFilter("entryentity.material", "=", (Object)priceParam.getMaterial());
        filter = filter.and(supplierFilter).and(purOrgFilter).and(recOrgFilter).and(bizTypeFilter).and(enableFilter).and(taxTypeFilter).and(bizDateFilter).and(materialFilter);
        return filter;
    }

    private PriceDataCollection handleDataSet(DataSet dataSet) {
        PriceDataCollection col = new PriceDataCollection();
        dataSet = dataSet.filter(this.getDataSetFilter()).orderBy(this.getOrderItems()).top(1);
        for (Row row : dataSet) {
            PriceData priceData = new PriceData();
            priceData.setIndex(this.paramCol.getPriceParam(0).getIndex());
            priceData.setRow(row);
            col.addPriceData(priceData);
        }
        dataSet.close();
        return col;
    }

    private String getSelectFields() {
        this.selectField.append("id,number,curr currency,taxtype").append(",entryentity.id entryid").append(",entryentity.seq seq").append(",entryentity.material material").append(",entryentity.matclass matclass").append(",entryentity.unit unit").append(",entryentity.qtyto qtyto").append(",entryentity.price price").append(",entryentity.taxprice taxprice").append(",entryentity.dctrate discountrate").append(",entryentity.taxrate taxrate").append(",entryentity.lowprice lowprice").append(",entryentity.upprice upprice").append(",entryentity.datefrom datefrom").append(",entryentity.dateto dateto").append(",entryentity.minorderqty minorderqty").append(",entryentity.refprice refprice");
        return this.selectField.toString();
    }

    private String getDataSetFilter() {
        BigDecimal qty = this.paramCol.getPriceParam(0).getQty();
        QFilter filter = new QFilter("qtyto", ">=", (Object)qty);
        filter = filter.and(new QFilter("minorderqty", "<=", (Object)qty));
        return filter.toString();
    }

    private String[] getOrderItems() {
        return new String[]{"price asc", "datefrom", "dateto asc"};
    }
}

