/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.price.impl;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pur.price.IPriceService;
import kd.scm.pur.price.PriceContext;
import kd.scm.pur.price.impl.PriceImpl;
import kd.scm.pur.price.param.PriceData;
import kd.scm.pur.price.param.PriceDataCollection;
import kd.scm.pur.price.param.PriceParam;
import kd.scm.pur.price.param.PriceParamCollection;
import kd.scm.pur.price.util.ParamCheckUtil;

public class PriceServiceImpl
implements IPriceService {
    private static final String[] CHANGED_PROS = new String[]{"biztype", "org", "supplier", "currency", "taxtype", "billdate"};
    private static final String[] ENTRY_CHANGED_PROS = new String[]{"material", "matclass", "unit", "qty", "rcvorg"};
    private boolean isNeedChange = true;

    public boolean isNeedChange() {
        return this.isNeedChange;
    }

    public void setNeedChange(boolean isNeedChange) {
        this.isNeedChange = isNeedChange;
    }

    @Override
    public void process(PriceContext ctx) {
        if (this.isNeedChange && this.checkParam(ctx.getPriceParamCol())) {
            this.setNeedChange(false);
            PriceImpl iprice = new PriceImpl();
            PriceDataCollection dataCol = iprice.getPrice(ctx.getPriceParamCol());
            this.handleResult(dataCol, ctx.getModel());
            this.setNeedChange(true);
        }
    }

    @Override
    public PriceDataCollection getPrice(PriceContext ctx) {
        PriceDataCollection dataCol = null;
        if (this.checkParam(ctx.getPriceParamCol())) {
            PriceImpl iprice = new PriceImpl();
            dataCol = iprice.getPrice(ctx.getPriceParamCol());
        }
        return dataCol;
    }

    private boolean checkParam(PriceParamCollection priceCol) {
        return priceCol != null && priceCol.size() != 0;
    }

    @Override
    public PriceContext getPriceCtx(IDataModel model, String entryKey, String pro) {
        PriceContext ctx = new PriceContext();
        if (this.isNeedChange) {
            this.setNeedChange(false);
            PriceParamCollection col = null;
            if (ParamCheckUtil.contains(CHANGED_PROS, pro)) {
                col = this.getParam(model, entryKey, false);
            } else if (ParamCheckUtil.contains(ENTRY_CHANGED_PROS, pro)) {
                col = this.getParam(model, entryKey, true);
            }
            ctx.setPriceParamCol(col);
            this.setNeedChange(true);
        }
        ctx.setModel(model);
        return ctx;
    }

    private PriceParamCollection getParam(IDataModel model, String entryKey, boolean isEntry) {
        PriceParamCollection col = new PriceParamCollection();
        PriceParam param = null;
        if (isEntry) {
            int index = model.getEntryCurrentRowIndex(entryKey);
            col.setEntry(true);
            param = this.setParam(model, entryKey, index);
            if (null != param) {
                col.addPriceParam(param);
            }
        } else {
            for (int i = 0; i < model.getEntryRowCount(entryKey); ++i) {
                param = this.setParam(model, entryKey, i);
                if (null == param) continue;
                col.addPriceParam(param);
            }
        }
        return col;
    }

    private PriceParam setParam(IDataModel model, String entryKey, int index) {
        PriceParam param = null;
        DynamicObject dynamic = model.getEntryRowEntity(entryKey, index);
        long materialPk = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)dynamic, (String)"material");
        if (materialPk == 0L) {
            return param;
        }
        param = new PriceParam();
        param.setIndex(index);
        param.setMaterial(materialPk);
        param.setUnit(DynamicObjectUtil.getDynamicObjectPk((DynamicObject)dynamic, (String)"unit"));
        param.setReceiveOrg(DynamicObjectUtil.getDynamicObjectPk((DynamicObject)dynamic, (String)"rcvorg"));
        param.setQty(dynamic.getBigDecimal("qty"));
        dynamic = model.getDataEntity();
        param.setBizDate(dynamic.getDate("billdate"));
        param.setBizType(dynamic.getLong("biztype"));
        param.setTaxType(dynamic.getString("taxtype"));
        param.setPurOrg(DynamicObjectUtil.getDynamicObjectPk((DynamicObject)dynamic, (String)"org"));
        return param;
    }

    private void handleResult(PriceDataCollection dataCol, IDataModel model) {
        for (int i = 0; i < dataCol.size(); ++i) {
            PriceData priceData = dataCol.getPriceData(i);
            this.setPrice(priceData, model);
        }
    }

    private void setPrice(PriceData priceData, IDataModel model) {
        String taxType = model.getDataEntity().getString("taxtype");
        BigDecimal price = BigDecimal.ZERO;
        String pro = null;
        if (taxType.equals(TaxTypeEnum.TAXSEXPRICE_EXTAX.toString())) {
            price = priceData.getRow().getBigDecimal("price");
            pro = "price";
        } else if (taxType.equals(TaxTypeEnum.TAXSEXPRICE_INTAX.toString()) || taxType.equals(TaxTypeEnum.TAXSINPRICE_INTAX.toString())) {
            price = priceData.getRow().getBigDecimal("taxprice");
            pro = "taxprice";
        }
        if (price.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        model.setValue(pro, (Object)price, priceData.getIndex());
    }
}

