/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.price.param;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.scm.pur.price.param.PriceData;

public class PriceDataCollection
implements Serializable {
    private static final long serialVersionUID = -6001334473429501219L;
    private Map<Integer, PriceData> seq2PriceData = new HashMap<Integer, PriceData>();
    private List<PriceData> priceDatas = new ArrayList<PriceData>();

    public Map<Integer, PriceData> getSeq2PriceData() {
        return this.seq2PriceData;
    }

    public void setSeq2PriceData(Map<Integer, PriceData> seq2PriceData) {
        this.seq2PriceData = seq2PriceData;
    }

    public PriceData getPriceDataBySeq(int seq) {
        return this.seq2PriceData.get(seq);
    }

    public void setPurPriceInfoBySeq(int seq, PriceData priceData) {
        this.seq2PriceData.put(seq, priceData);
    }

    public PriceData getPriceData(int index) {
        return this.priceDatas.get(index);
    }

    public List<PriceData> getPriceDatas() {
        return Collections.unmodifiableList(this.priceDatas);
    }

    public void setPriceDatas(List<PriceData> priceDatas) {
        this.priceDatas = Collections.unmodifiableList(priceDatas);
    }

    public void addPriceData(int index, PriceData priceData) {
        this.priceDatas.add(index, priceData);
    }

    public void addPriceData(PriceData priceData) {
        this.priceDatas.add(priceData);
    }

    public int size() {
        return this.priceDatas.size();
    }

    public Iterator<PriceData> iterator() {
        return this.priceDatas.iterator();
    }

    public void merge(PriceDataCollection cols) {
        if (cols == null) {
            return;
        }
        for (Integer seq : cols.getSeq2PriceData().keySet()) {
            this.seq2PriceData.put(seq, cols.getPriceDataBySeq(seq));
        }
        Iterator<PriceData> iterator = cols.iterator();
        while (iterator.hasNext()) {
            this.priceDatas.add(iterator.next());
        }
    }

    public String toString() {
        StringBuilder displayMsg = new StringBuilder();
        displayMsg.append(" PriceDataCollection: { \n");
        displayMsg.append("seq2PriceData: \n");
        for (Map.Entry<Integer, PriceData> entry : this.seq2PriceData.entrySet()) {
            displayMsg.append(entry.getKey()).append(": ").append(entry.getValue()).append(" \n");
        }
        displayMsg.append("priceDatas: \n");
        if (this.priceDatas.size() > 0) {
            for (int i = 0; i < this.priceDatas.size(); ++i) {
                displayMsg.append("info ").append(i).append(": \n");
                displayMsg.append(this.priceDatas.get(i));
            }
        }
        displayMsg.append("} \n");
        return displayMsg.toString();
    }
}

