/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.blueprintshare;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.pur.common.blueprintshare.po.BluePrintDTO;
import kd.scm.pur.common.blueprintshare.support.PurBluePrintAttachmentSupport;
import kd.scm.pur.common.blueprintshare.support.PurBluePrintSortSupport;
import kd.scm.pur.common.blueprintshare.support.PurGetBlueprintSupport;
import kd.scm.pur.common.blueprintshare.support.VersionComparator;
import org.apache.commons.lang.StringUtils;

public class PurBluePrintBizHelper {
    private static final Log log = LogFactory.getLog(PurBluePrintBizHelper.class);
    private static final PurBluePrintSortSupport sortSupport = new PurBluePrintSortSupport();
    private static final PurGetBlueprintSupport getSupport = new PurGetBlueprintSupport();
    private static final PurBluePrintAttachmentSupport attachmentSupport = new PurBluePrintAttachmentSupport();
    private static final IAppCache cache = AppCache.get((String)"scm");

    public static void setGroupSort(DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long materielId = dynamicObject.getLong("materiel.id");
            Long createOrgId = dynamicObject.getLong("createorg.id");
            boolean isLatestVersion = dynamicObject.getBoolean("islatestversion");
            String version = dynamicObject.getString("version");
            String status = dynamicObject.getString("status");
            Date modifyTime = dynamicObject.getDate("modifytime");
            long modifyTimeLong = modifyTime == null ? System.currentTimeMillis() : modifyTime.getTime();
            log.info("\u4fdd\u5b58\u540e\uff0c\u5f00\u59cb\u8bbe\u7f6e\u5206\u7ec4\u6392\u5e8f\u4fe1\u606f\uff0c\u5f53\u524d\u5206\u7ec4\u4fe1\u606f\uff1a\u7269\u6599id\uff1a{}\uff0c\u521b\u5efa\u7ec4\u7ec7id\uff1a{}\uff0c\u662f\u5426\u6700\u65b0\u7248\u672c\uff1a{}\uff0c\u7248\u672c\uff1a{}", new Object[]{materielId, createOrgId, isLatestVersion, version});
            DynamicObject[] dynamicObjectArr = sortSupport.queryGroupDataByMaterielIdAndCreateOrgId(materielId, createOrgId);
            boolean hasLatestVersion = false;
            ArrayList<Object> auditObject = new ArrayList<Object>(dynamicObjectArr.length);
            ArrayList<DynamicObject> unAuditObject = new ArrayList<DynamicObject>(dynamicObjectArr.length);
            for (DynamicObject object : dynamicObjectArr) {
                boolean groupIsLatestVersion = object.getBoolean("islatestversion");
                String groupVersion = object.getString("version");
                String groupStatus = object.getString("status");
                if ("C".equals(groupStatus)) {
                    object.set("sort", (Object)(modifyTimeLong + "_1_" + groupVersion));
                    if ("C".equals(status) && isLatestVersion && !StringUtils.equals((String)version, (String)groupVersion) && groupIsLatestVersion) {
                        object.set("islatestversion", (Object)false);
                    }
                    auditObject.add(object);
                } else {
                    object.set("sort", (Object)(modifyTimeLong + "_0_" + groupVersion));
                    unAuditObject.add(object);
                }
                if (!groupIsLatestVersion) continue;
                hasLatestVersion = true;
            }
            if (!hasLatestVersion && !isLatestVersion) {
                sortSupport.setMaxVersionTag(auditObject.toArray(new DynamicObject[0]));
            }
            auditObject.addAll(unAuditObject);
            SaveServiceHelper.update((DynamicObject[])auditObject.toArray(new DynamicObject[0]));
        }
    }

    public static List<DynamicObject> refreshVersionAfterDeleteAndUnAudit(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> updateDynamicObjects = new ArrayList<DynamicObject>(dynamicObjects.length);
        HashSet<String> hasQuery = new HashSet<String>(0);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long materielId = dynamicObject.getLong("materiel.id");
            Long createOrgId = dynamicObject.getLong("createorg.id");
            String hasQueryFlag = createOrgId.toString() + materielId;
            if (hasQuery.contains(hasQueryFlag)) continue;
            hasQuery.add(createOrgId.toString() + materielId);
            boolean isLatestVersion = dynamicObject.getBoolean("islatestversion");
            if (!isLatestVersion) continue;
            DynamicObject[] queryDynamicObject = sortSupport.queryGroupDataByMaterielIdAndCreateOrgIdAudit(materielId, createOrgId);
            sortSupport.setMaxVersionTag(queryDynamicObject);
            updateDynamicObjects.addAll(Arrays.asList(queryDynamicObject));
        }
        return updateDynamicObjects;
    }

    public static Boolean isLatestVersion(String version, Long createOrgId, Long materielId) {
        if (StringUtils.isEmpty((String)version)) {
            return false;
        }
        VersionComparator versionComparator = new VersionComparator();
        String latestVersion = sortSupport.queryLatestVersionByOrgAndMateriel(createOrgId, materielId);
        int result = versionComparator.compare(version, latestVersion);
        return result >= 0;
    }

    public static Map<String, List<BluePrintDTO>> getBluePrintDTOS(Set<String> materielNumbers) throws Exception {
        if (materielNumbers == null || materielNumbers.isEmpty()) {
            return Collections.emptyMap();
        }
        log.info("\u6267\u884c\u83b7\u53d6\u7269\u6599\u7684\u6240\u6709\u7c7b\u578b\u56fe\u7eb8\uff0c\u7269\u6599\u7f16\u7801\uff1a" + materielNumbers);
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String cacheString = (String)cache.get("BLUEPRINT_MAP_CACHE_KEY_" + currentUserId, String.class);
        HashMap<String, List<BluePrintDTO>> bluePrintMapCache = new HashMap(0);
        if (StringUtils.isNotBlank((String)cacheString)) {
            ObjectMapper mapper = new ObjectMapper();
            bluePrintMapCache = (Map)mapper.readValue(cacheString, (TypeReference)new TypeReference<Map<String, List<BluePrintDTO>>>(){});
        }
        if (bluePrintMapCache != null && !bluePrintMapCache.isEmpty()) {
            HashSet<String> filterMaterielNumbers = new HashSet<String>(materielNumbers.size());
            for (String materielNumber : materielNumbers) {
                if (bluePrintMapCache.containsKey(materielNumber)) continue;
                filterMaterielNumbers.add(materielNumber);
            }
            if (filterMaterielNumbers.isEmpty()) {
                return bluePrintMapCache;
            }
            materielNumbers = filterMaterielNumbers;
        }
        return getSupport.getBluePrintMapXkPlm(materielNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getAttachmentAndBind(Object pkValue, String documentName, String documentIds) throws IOException {
        boolean success = true;
        String[] documentIdArr = documentIds.split(" , ");
        String[] documentNameArr = documentName.split(" , ");
        for (int i = 0; i < documentIdArr.length; ++i) {
            try (InputStream is = null;){
                String id = documentIdArr[i];
                String name = documentNameArr[i];
                is = attachmentSupport.getFileInputStreamFormLocal(id);
                String fileUrl = attachmentSupport.saveInputStreamToTempFile(is, name);
                attachmentSupport.saveUrlFile2AttachmentAndBind("pur_blueprint_share", pkValue, fileUrl, name, "10", "attachmentpanelap");
                continue;
            }
        }
        return success;
    }
}

