/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.blueprintshare.support;

import java.util.Comparator;

public class VersionComparator
implements Comparator<String> {
    @Override
    public int compare(String version1, String version2) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null) {
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        String[] parts1 = version1.split("\\.");
        String[] parts2 = version2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            String part2;
            String part1 = i < parts1.length ? parts1[i] : "";
            int cmp = this.comparePart(part1, part2 = i < parts2.length ? parts2[i] : "");
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private int comparePart(String part1, String part2) {
        Integer num1 = this.tryParseInt(part1);
        Integer num2 = this.tryParseInt(part2);
        if (num1 != null && num2 != null) {
            return Integer.compare(num1, num2);
        }
        return part1.compareTo(part2);
    }

    private Integer tryParseInt(String part) {
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

