/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.blueprintshare.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.pur.common.blueprintshare.PurBluePrintBizHelper;
import kd.scm.pur.common.constant.PurBlueprintShareConstant;
import org.apache.commons.lang.StringUtils;

public class SaveBluePrintTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(SaveBluePrintTask.class);
    private Map<String, Object> params;

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        this.params = params;
        List getBluePrints = (List)params.get("pur_get_blueprint");
        String type = (String)params.get("getType");
        if ("get".equals(type)) {
            String message = ResManager.loadKDString((String)"\u6b63\u5728\u4fdd\u5b58\u56fe\u7eb8", (String)"SaveBluePrintTask_6", (String)"scm-pur-common", (Object[])new Object[0]);
            this.feedbackProgress(message);
            this.saveBluePrint(getBluePrints);
        } else if ("update".equals(type)) {
            String message = ResManager.loadKDString((String)"\u6b63\u5728\u66f4\u65b0\u56fe\u7eb8", (String)"SaveBluePrintTask_7", (String)"scm-pur-common", (Object[])new Object[0]);
            this.feedbackProgress(message);
            this.updateBluePrint(getBluePrints);
        }
    }

    private void feedbackProgress(String message) {
        String sender = (String)this.params.get("sender");
        if (StringUtils.equals((String)"sender_view", (String)sender)) {
            super.feedbackProgress(0, message, null);
        }
    }

    protected void feedbackProgress(int progress) {
        String sender = (String)this.params.get("sender");
        if (StringUtils.equals((String)"sender_view", (String)sender)) {
            super.feedbackProgress(progress);
        }
    }

    public void updateBluePrint(List<Map<String, Object>> getBluePrints) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String value;
            String key;
            String value2;
            String documentName;
            String materielName;
            ArrayList<DynamicObject> updateBluePrints = new ArrayList<DynamicObject>(getBluePrints.size());
            ArrayList<Object> removeAttachmentIds = new ArrayList<Object>(getBluePrints.size());
            int progress = 0;
            for (int i = 0; i < getBluePrints.size(); ++i) {
                materielName = "";
                try {
                    Map<String, Object> getBluePrint = getBluePrints.get(i);
                    Map materiel = (Map)getBluePrint.get("materiel");
                    Object id = getBluePrint.get("sourceid");
                    if (materiel == null || id == null) {
                        return;
                    }
                    removeAttachmentIds.add(id);
                    documentName = (String)getBluePrint.get("documentname");
                    String version = (String)getBluePrint.get("version");
                    String documentIds = (String)getBluePrint.get("documentids");
                    if (StringUtils.isBlank((String)documentIds)) {
                        return;
                    }
                    Map materielNameObject = (Map)materiel.get("name");
                    materielName = (String)materielNameObject.get("zh_CN");
                    progress = 100 * i / (getBluePrints.size() * 2 + 2);
                    this.feedbackProgress(progress);
                    if (this.isStop()) {
                        this.stop();
                    }
                    String queryParma = PurBlueprintShareConstant.buildQueryParma("id", "version", "sourcetype", "islatestversion", "documentids", "status", "materiel", "documentname", "auditor", "auditdate");
                    DynamicObject bluePrintShare = BusinessDataServiceHelper.loadSingle((String)"pur_blueprint_share", (String)queryParma, (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
                    bluePrintShare.set("version", (Object)version);
                    bluePrintShare.set("sourcetype", (Object)"B");
                    bluePrintShare.set("islatestversion", (Object)true);
                    bluePrintShare.set("documentids", (Object)documentIds);
                    bluePrintShare.set("documentname", (Object)documentName);
                    bluePrintShare.set("status", (Object)"A");
                    bluePrintShare.set("auditor", null);
                    bluePrintShare.set("auditdate", null);
                    updateBluePrints.add(bluePrintShare);
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    String key2 = ResManager.loadKDString((String)"\u66f4\u65b0\u7269\u6599\uff1a{0}", (String)"SaveBluePrintTask_0", (String)"scm-pur-common", (Object[])new Object[]{materielName});
                    value2 = ResManager.loadKDString((String)"\u5931\u8d25", (String)"SaveBluePrintTask_1", (String)"scm-pur-common", (Object[])new Object[0]);
                    log.error(key2 + e.getMessage());
                    result.put(key2, value2);
                }
            }
            try {
                SaveServiceHelper.update((DynamicObject[])updateBluePrints.toArray(new DynamicObject[0]));
                progress = 100 * getBluePrints.size() / (getBluePrints.size() * 2 + 2);
                this.feedbackProgress(progress);
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                key = ResManager.loadKDString((String)"\u6279\u91cf\u66f4\u65b0\u56fe\u7eb8", (String)"SaveBluePrintTask_2", (String)"scm-pur-common", (Object[])new Object[0]);
                value = ResManager.loadKDString((String)"\u5931\u8d25", (String)"SaveBluePrintTask_1", (String)"scm-pur-common", (Object[])new Object[0]);
                log.error(key + e.getMessage());
                result.put(key, value);
            }
            try {
                AttachmentServiceHelper.batchRemove((String)"pur_blueprint_share", removeAttachmentIds);
                progress = 100 * (getBluePrints.size() + 1) / (getBluePrints.size() * 2 + 2);
                this.feedbackProgress(progress);
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                key = ResManager.loadKDString((String)"\u6279\u91cf\u6e05\u7a7a\u539f\u9644\u4ef6\u9762\u677f\u9644\u4ef6", (String)"SaveBluePrintTask_3", (String)"scm-pur-common", (Object[])new Object[0]);
                value = ResManager.loadKDString((String)"\u5931\u8d25", (String)"SaveBluePrintTask_1", (String)"scm-pur-common", (Object[])new Object[0]);
                log.error(key + e.getMessage());
                result.put(key, value);
            }
            for (int i = 0; i < updateBluePrints.size(); ++i) {
                materielName = "";
                try {
                    DynamicObject updateBluePrint = (DynamicObject)updateBluePrints.get(i);
                    long id = updateBluePrint.getLong("id");
                    documentName = updateBluePrint.getString("documentname");
                    String documentIds = updateBluePrint.getString("documentids");
                    materielName = updateBluePrint.getString("materiel.name");
                    progress = 100 * (i + getBluePrints.size() + 2) / (getBluePrints.size() * 2 + 2);
                    this.feedbackProgress(progress);
                    boolean success = PurBluePrintBizHelper.getAttachmentAndBind(id, documentName, documentIds);
                    if (!success) {
                        throw new Exception();
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    String key3 = ResManager.loadKDString((String)"\u9644\u4ef6\u7ed1\u5b9a\uff0c\u7269\u6599\uff1a{0}", (String)"SaveBluePrintTask_4", (String)"scm-pur-common", (Object[])new Object[]{materielName});
                    value2 = ResManager.loadKDString((String)"\u5931\u8d25", (String)"SaveBluePrintTask_1", (String)"scm-pur-common", (Object[])new Object[0]);
                    log.error(key3 + e.getMessage());
                    result.put(key3, value2);
                }
            }
            if (!result.isEmpty()) {
                throw new Exception();
            }
            String key4 = ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u6210\u529f", (String)"SaveBluePrintTask_5", (String)"scm-pur-common", (Object[])new Object[0]);
            result.put(key4, "");
            this.feedbackCustomdata(result);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u56fe\u7eb8\u5931\u8d25" + e.getMessage());
            this.feedbackCustomdata(result);
        }
    }

    public void saveBluePrint(List<Map<String, Object>> getBluePrints) {
        HashMap<String, String> result = new HashMap<String, String>(0);
        try {
            String value;
            String key;
            String documentName;
            ArrayList<DynamicObject> blueprintShareList = new ArrayList<DynamicObject>(getBluePrints.size());
            int progress = 0;
            String materielName = "";
            for (int i = 0; i < getBluePrints.size(); ++i) {
                try {
                    Map<String, Object> getBluePrint = getBluePrints.get(i);
                    Map materiel = (Map)getBluePrint.get("materiel");
                    if (materiel == null) continue;
                    Object materielId = materiel.get("id");
                    documentName = (String)getBluePrint.get("documentname");
                    String version = (String)getBluePrint.get("version");
                    String documentIds = (String)getBluePrint.get("documentids");
                    if (StringUtils.isBlank((String)documentIds)) continue;
                    Map materielNameObject = (Map)materiel.get("name");
                    materielName = (String)materielNameObject.get("zh_CN");
                    progress = 100 * i / (getBluePrints.size() * 2 + 1);
                    this.feedbackProgress(progress);
                    if (this.isStop()) {
                        this.stop();
                    }
                    DynamicObject blueprintShare = BusinessDataServiceHelper.newDynamicObject((String)"pur_blueprint_share");
                    blueprintShare.set("version", (Object)version);
                    blueprintShare.set("islatestversion", (Object)true);
                    blueprintShare.set("materiel", materielId);
                    blueprintShare.set("ctrlstrategy", (Object)5);
                    blueprintShare.set("enable", (Object)1);
                    blueprintShare.set("status", (Object)"A");
                    blueprintShare.set("sourcetype", (Object)"B");
                    blueprintShare.set("documentids", (Object)documentIds);
                    blueprintShare.set("documentname", (Object)documentName);
                    long currentUserId = UserServiceHelper.getCurrentUserId();
                    long orgId = RequestContext.get().getOrgId();
                    blueprintShare.set("creator", (Object)currentUserId);
                    blueprintShare.set("modifier", (Object)currentUserId);
                    blueprintShare.set("createorg", (Object)orgId);
                    blueprintShare.set("sort", (Object)(System.currentTimeMillis() + version));
                    blueprintShare.set("createtime", (Object)new Date(System.currentTimeMillis()));
                    blueprintShare.set("modifytime", (Object)new Date(System.currentTimeMillis()));
                    Object groupId = this.params.get("group");
                    blueprintShare.set("group", (Object)Long.parseLong((String)groupId));
                    blueprintShareList.add(blueprintShare);
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    key = ResManager.loadKDString((String)"\u4fdd\u5b58\u7269\u6599\uff1a{0}", (String)"SaveBluePrintTask_8", (String)"scm-pur-common", (Object[])new Object[]{materielName});
                    value = ResManager.loadKDString((String)"\u5931\u8d25", (String)"SaveBluePrintTask_1", (String)"scm-pur-common", (Object[])new Object[0]);
                    log.error(key + e.getMessage());
                    result.put(key, value);
                }
            }
            DynamicObject[] savedBluePrint = null;
            try {
                savedBluePrint = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])blueprintShareList.toArray(new DynamicObject[0]));
                progress = 100 * getBluePrints.size() / (getBluePrints.size() * 2 + 1);
                this.feedbackProgress(progress);
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                key = ResManager.loadKDString((String)"\u6279\u91cf\u4fdd\u5b58\u56fe\u7eb8\uff1a", (String)"SaveBluePrintTask_9", (String)"scm-pur-common", (Object[])new Object[]{materielName});
                value = ResManager.loadKDString((String)"\u5931\u8d25", (String)"SaveBluePrintTask_1", (String)"scm-pur-common", (Object[])new Object[0]);
                log.error(key + e.getMessage());
                result.put(key, value);
            }
            if (savedBluePrint == null) {
                String key2 = ResManager.loadKDString((String)"\u6279\u91cf\u4fdd\u5b58\u56fe\u7eb8\uff1a", (String)"SaveBluePrintTask_9", (String)"scm-pur-common", (Object[])new Object[]{materielName});
                String value2 = ResManager.loadKDString((String)"\u5931\u8d25", (String)"SaveBluePrintTask_1", (String)"scm-pur-common", (Object[])new Object[0]);
                log.error(key2 + value2);
                result.put(key2, value2);
                throw new Exception(key2 + value2);
            }
            for (int i = 0; i < savedBluePrint.length; ++i) {
                try {
                    DynamicObject dynamicObject = savedBluePrint[i];
                    Object pkValue = dynamicObject.getPkValue();
                    documentName = dynamicObject.getString("documentname");
                    String documentIds = dynamicObject.getString("documentids");
                    if (StringUtils.isBlank((String)documentIds) || documentName.isEmpty()) {
                        log.info("\u4fdd\u5b58\u540e\u7684\u56fe\u7eb8\u5171\u4eab\u6ca1\u6709\u661f\u7a7a\u83b7\u53d6\u5230\u7684\u6587\u4ef6id\u6216\u6587\u4ef6\u540d");
                        throw new Exception();
                    }
                    progress = 100 * (i + getBluePrints.size() + 1) / (getBluePrints.size() * 2 + 1);
                    this.feedbackProgress(progress);
                    boolean success = PurBluePrintBizHelper.getAttachmentAndBind(pkValue, documentName, documentIds);
                    if (!success) {
                        throw new Exception();
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    String key3 = ResManager.loadKDString((String)"\u9644\u4ef6\u7ed1\u5b9a\uff0c\u7269\u6599\uff1a{0}", (String)"SaveBluePrintTask_4", (String)"scm-pur-common", (Object[])new Object[]{materielName});
                    String value3 = ResManager.loadKDString((String)"\u5931\u8d25", (String)"SaveBluePrintTask_1", (String)"scm-pur-common", (Object[])new Object[0]);
                    log.error(key3 + e);
                    result.put(key3, value3);
                }
            }
            if (!result.isEmpty()) {
                throw new Exception();
            }
            String key4 = ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u6210\u529f", (String)"SaveBluePrintTask_5", (String)"scm-pur-common", (Object[])new Object[0]);
            result.put(key4, "");
            this.feedbackCustomdata(result);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u56fe\u7eb8\u5931\u8d25" + e.getMessage());
            this.feedbackCustomdata(result);
        }
    }
}

