/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.ecinvoice.service.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.entity.EmalStatus;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiResult;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.pur.common.ecinvoice.beans.EcConfirmInfo;
import kd.scm.pur.common.ecinvoice.beans.EcConfirmRecParam;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitParam;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitResult;
import kd.scm.pur.common.ecinvoice.beans.EcInvoiceInfo;
import kd.scm.pur.common.ecinvoice.exception.KDEcInvoiceException;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;
import net.sf.json.JSONObject;

public class CgEcInvoiceService
extends GenericEcInvoiceService {
    private static final Log log = LogFactory.getLog((String)CgEcInvoiceService.class.getName());

    @Override
    public EcInvSubmitParam packageEcSubmitParam(IDataModel model, DynamicObjectCollection reportDyoCol) {
        EcInvSubmitParam ecInvSubmitParam = super.packageEcSubmitParam(model, reportDyoCol);
        ecInvSubmitParam.setBizInvoiceContent(ResManager.loadKDString((String)"\u660e\u7ec6", (String)"CgEcInvoiceService_0", (String)"scm-pur-common", (Object[])new Object[0]));
        ecInvSubmitParam.setBillToParty(ecInvSubmitParam.getTitle());
        ecInvSubmitParam.setInvoiceAddress(ecInvSubmitParam.getBillToAddress());
        ecInvSubmitParam.setInvoicePhone(ecInvSubmitParam.getBillToContact());
        BigDecimal invoiceAmount = this.getInvoiceAmount(reportDyoCol);
        String ecAddressNum = AddressUtil.getLongNumber((Long)Long.parseLong(model.getValue("revaddress").toString()), (String)EcPlatformEnum.ECPLATFORM_CG.getVal());
        String[] ecAddress = this.getEcAddress(ecAddressNum);
        if (ecAddress.length < 3) {
            log.error("@@@\u5f00\u7968\u5f02\u5e38\uff1a\u5730\u5740\u6ca1\u67093\u7ea7\u7f16\u7801\u3002");
            throw new KDEcInvoiceException(ResManager.loadKDString((String)"\u5730\u5740\u6ca1\u67093\u7ea7\u7f16\u7801\u3002", (String)"CgEcInvoiceService_1", (String)"scm-pur-common", (Object[])new Object[0]));
        }
        int billToProvinceId = 0;
        int billToCityId = 1;
        int billToCountyId = 2;
        ecInvSubmitParam.setBillToProvince(ecAddress[billToProvinceId]);
        ecInvSubmitParam.setBillToCity(ecAddress[billToCityId]);
        ecInvSubmitParam.setBillToCounty(ecAddress[billToCountyId]);
        ecInvSubmitParam.setBillToTown("0");
        ecInvSubmitParam.setSettlementId(ecInvSubmitParam.getMarkId());
        ecInvSubmitParam.setInvoiceDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        ecInvSubmitParam.setInvoicePrice(invoiceAmount.toPlainString());
        ecInvSubmitParam.setAmount(this.getAmount(reportDyoCol));
        ecInvSubmitParam.setTax(this.getTax(reportDyoCol));
        return ecInvSubmitParam;
    }

    @Override
    protected EcInvSubmitResult parseResult(EcInvSubmitParam ecInvSubmitParam, Map<String, Map<String, Object>> res) {
        EcInvSubmitResult ecInvSubmitResult = super.parseResult(ecInvSubmitParam, res);
        Map<String, Object> resultMap = res.get(EcPlatformEnum.ECPLATFORM_CG.getVal());
        ecInvSubmitResult.setSuccess((Boolean)resultMap.get("success"));
        if (ecInvSubmitResult.isSuccess()) {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.HANDLING.getVal());
        } else {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.INVOICEFAILED.getVal());
            ArrayList<String> errorInfos = new ArrayList<String>();
            errorInfos.add(this.now() + ":" + resultMap.get("resultMessage"));
            ecInvSubmitResult.setErrorInfo(errorInfos);
        }
        ecInvSubmitResult.setPlatform(EcPlatformEnum.ECPLATFORM_CG.getVal());
        return ecInvSubmitResult;
    }

    @Override
    public String getEcOrderEntityKey() {
        return "pbd_order_cg";
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_CG.getVal();
    }

    @Override
    public EcInvoiceInfo packageEcInvoiceInfo(EcInvoiceInfo ecInvoiceInfo, JSONObject invoiceJo, Map<String, EmalStatus> emalStatusMap) {
        ecInvoiceInfo = super.packageEcInvoiceInfo(ecInvoiceInfo, invoiceJo, emalStatusMap);
        ecInvoiceInfo.setInvoiceState(PurEcInvoiceEnum.INVOICESUCCESS.getVal());
        return ecInvoiceInfo;
    }

    @Override
    protected ApiResult<List<EcConfirmInfo>> doConfirmRec(EcConfirmRecParam ecConfirmRecParam) {
        HashMap params = new HashMap(ecConfirmRecParam.getEcChildOrderIds().size());
        HashMap<String, String> platformParams = new HashMap<String, String>(ecConfirmRecParam.getEcChildOrderIds().size());
        ApiResult apiResult = new ApiResult();
        ArrayList<EcConfirmInfo> ecConfirmInfos = new ArrayList<EcConfirmInfo>();
        for (String orderId : ecConfirmRecParam.getEcChildOrderIds()) {
            platformParams.put("orderId", orderId);
            params.put(this.getPlatform(), platformParams);
            Map res = EcGroupApiUtil.confirmOrderReceive(params);
            HashMap<String, Object> confirmMap = new HashMap<String, Object>();
            Map resMap = (Map)res.get(this.getPlatform());
            if (Boolean.parseBoolean((String)resMap.get("success"))) continue;
            confirmMap.put("errorMsg", resMap.get("message"));
            confirmMap.put("confirmState", "2");
            confirmMap.put("childOrderId", orderId);
            EcConfirmInfo ecConfirmInfo = new EcConfirmInfo(confirmMap);
            ecConfirmInfos.add(ecConfirmInfo);
        }
        apiResult.setSuccess(true);
        apiResult.setResult(ecConfirmInfos);
        return apiResult;
    }
}

