/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.ecinvoice.service.impl;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.report.IReportListModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.entity.EmalStatus;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.ecapi.util.EmalStatusUtil;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.enums.ReturnStatusEnum;
import kd.scm.common.helper.apiconnector.api.ApiResult;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.common.util.ValidateMatchUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.common.ecinvoice.beans.EcConfirmInfo;
import kd.scm.pur.common.ecinvoice.beans.EcConfirmRecParam;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitParam;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitResult;
import kd.scm.pur.common.ecinvoice.beans.EcInvoiceInfo;
import kd.scm.pur.common.ecinvoice.exception.KDEcInvoiceException;
import kd.scm.pur.common.ecinvoice.service.IEcInvoiceService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class GenericEcInvoiceService
implements IEcInvoiceService {
    private final Log log = LogFactory.getLog((String)this.getClass().getName());
    public static final String REPORTLIST = "reportlistap";
    public static final String PLATFORM = "platform";
    public static final String ECCHILDORDERID = "jdchildorderid";
    public static final String ECINVOICESTATE = "jdinvoicestate";
    public static final String STATUSTYPE_OF_INVOICE = "3";
    private static final int SPLIT = 0;
    private static final int MERGE = 1;
    public static final String SPLIT_RULEID = "641135549335216128";
    public static final String MERGE_RULEID = "919591508682895360";

    public static String getSource(Long supplierId) {
        return MalNewOrderUtils.getPlatformBySupplierId((Long)supplierId);
    }

    public EcInvSubmitResult invoiceSubmit(IDataModel model, DynamicObjectCollection reportDyoCol) {
        EcInvSubmitParam ecInvSubmitParam = this.packageEcSubmitParam(model, reportDyoCol);
        this.beforeDoSubmit(ecInvSubmitParam);
        EcInvSubmitResult ecInvSubmitResult = this.doSubmit(ecInvSubmitParam);
        this.afterDoSubmit(ecInvSubmitResult);
        return ecInvSubmitResult;
    }

    @Override
    public List<EcInvSubmitResult> invoiceBatchSplitSubmit(IDataModel model, IFormView view) {
        boolean canSubmit = this.beforeBatchSplitSubmitCheck(view, model);
        if (!canSubmit) {
            return new ArrayList<EcInvSubmitResult>();
        }
        DynamicObjectCollection reportDyoCol = this.getSelectedDyObject(view);
        ArrayList<EcInvSubmitResult> ecInvSubmitResults = new ArrayList<EcInvSubmitResult>();
        DynamicObjectCollection splitReportDyoCol = new DynamicObjectCollection();
        ArrayList<DynamicObject> successInvoiceDyos = new ArrayList<DynamicObject>(reportDyoCol.size());
        HashSet<Long> failInvoicePks = new HashSet<Long>(16);
        List<DynamicObject> targetDatas = this.pushPurInvoice(model, reportDyoCol, this.selectRuleId(0));
        Map<String, DynamicObject> childOrderIdPurInvoiceMap = this.getChildOrderIdPurInvoiceMap(targetDatas);
        for (DynamicObject reportDyo : reportDyoCol) {
            splitReportDyoCol.add((Object)reportDyo);
            if (!targetDatas.isEmpty()) {
                EcInvSubmitResult ecInvSubmitResult = new EcInvSubmitResult();
                DynamicObject targetData = childOrderIdPurInvoiceMap.get(reportDyo.getString(ECCHILDORDERID));
                try {
                    ecInvSubmitResult = this.invoiceSubmit(model, splitReportDyoCol);
                    if (targetData == null) continue;
                    if (ecInvSubmitResult.isSuccess()) {
                        ecInvSubmitResult.setPurInvoiceId(targetData.getLong("id"));
                        successInvoiceDyos.add(targetData);
                    } else {
                        failInvoicePks.add(targetData.getLong("id"));
                    }
                }
                catch (Exception e) {
                    failInvoicePks.add(targetData.getLong("id"));
                    ecInvSubmitResult.setSuccess(false);
                    ecInvSubmitResult.getErrorInfo().add(e.getMessage());
                }
                ecInvSubmitResults.add(ecInvSubmitResult);
            }
            splitReportDyoCol.clear();
        }
        this.afterBatchSplitSubmit(successInvoiceDyos, ecInvSubmitResults);
        this.deleteFailPurInvoice(failInvoicePks);
        view.invokeOperation("refresh");
        return ecInvSubmitResults;
    }

    private Map<String, DynamicObject> getChildOrderIdPurInvoiceMap(List<DynamicObject> targetDatas) {
        HashMap<String, DynamicObject> resMap = new HashMap<String, DynamicObject>(targetDatas.size() * 2);
        HashSet<Long> ecOrderSet = new HashSet<Long>(targetDatas.size() * 2);
        for (DynamicObject targetData : targetDatas) {
            DynamicObjectCollection entryCol = targetData.getDynamicObjectCollection("entryentity1");
            String ecOrder = ((DynamicObject)entryCol.get(0)).getString("ecorder");
            if (StringUtils.isNotEmpty((CharSequence)ecOrder) && !"0".equals(ecOrder)) {
                ecOrderSet.add(Long.valueOf(ecOrder));
                continue;
            }
            resMap.put(((DynamicObject)entryCol.get(0)).getString("entryjdorder.number"), targetData);
        }
        DynamicObjectCollection ecOrderDynCol = this.queryEcOrderByPks(ecOrderSet);
        for (DynamicObject ecOrderDyn : ecOrderDynCol) {
            for (DynamicObject targetData : targetDatas) {
                DynamicObjectCollection entryCol = targetData.getDynamicObjectCollection("entryentity1");
                if (!((DynamicObject)entryCol.get(0)).getString("ecorder").equals(ecOrderDyn.getString("id"))) continue;
                resMap.put(ecOrderDyn.getString("orderid"), targetData);
            }
        }
        return resMap;
    }

    protected DynamicObjectCollection queryEcOrderByPks(Set<Long> ecOrderPkSet) {
        if (ecOrderPkSet == null || ecOrderPkSet.isEmpty()) {
            return new DynamicObjectCollection();
        }
        QFilter idFilter = new QFilter("id", "in", ecOrderPkSet);
        return QueryServiceHelper.query((String)this.getEcOrderEntityKey(), (String)("id," + DynamicObjectUtil.getSelectfields((String)this.getEcOrderEntityKey(), (boolean)false)), (QFilter[])new QFilter[]{idFilter});
    }

    protected String selectRuleId(int merge) {
        if (0 == merge) {
            return SPLIT_RULEID;
        }
        return MERGE_RULEID;
    }

    protected boolean beforeBatchSplitSubmitCheck(IFormView view, IDataModel model) {
        return this.commonCheck(model, view);
    }

    public boolean commonCheck(IDataModel model, IFormView view) {
        String phone;
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank((Object)model.getValue("revname"))) {
            sb.append(ResManager.loadKDString((String)"\u59d3\u540d,", (String)"GenericEcInvoiceService_0", (String)"scm-pur-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)(phone = String.valueOf(model.getValue("revphone"))))) {
            sb.append(ResManager.loadKDString((String)"\u8054\u7cfb\u65b9\u5f0f,", (String)"GenericEcInvoiceService_1", (String)"scm-pur-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)model.getValue("revaddress"))) {
            sb.append(ResManager.loadKDString((String)"\u7701\u5e02\u533a,", (String)"GenericEcInvoiceService_2", (String)"scm-pur-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)model.getValue("revaddressdetail"))) {
            sb.append(ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740,", (String)"GenericEcInvoiceService_3", (String)"scm-pur-common", (Object[])new Object[0]));
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
            sb.append(ResManager.loadKDString((String)"\u4e3a\u5fc5\u5f55\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"GenericEcInvoiceService_4", (String)"scm-pur-common", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)phone) && !ValidateMatchUtil.isTel((String)phone) && !ValidateMatchUtil.isMobileExact((String)phone)) {
            if (sb.length() > 1) {
                sb.append('\n');
            }
            sb.append(ResManager.loadKDString((String)"\u6536\u7968\u4eba\u8054\u7cfb\u65b9\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u60a8\u7684\u624b\u673a\u53f7\u7801\u6216\u56fa\u5b9a\u7535\u8bdd\u3002", (String)"GenericEcInvoiceService_5", (String)"scm-pur-common", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            view.showMessage(ResManager.loadKDString((String)"\u6536\u7968\u4eba\u4fe1\u606f\u586b\u5199\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GenericEcInvoiceService_6", (String)"scm-pur-common", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return false;
        }
        int[] selectIndexs = this.getSelectIndex(view);
        if (selectIndexs.length > 0) {
            DynamicObjectCollection dyoCol = this.getSelectedDyObject(view);
            List<String> stateList = this.check4InvoiceState(dyoCol);
            List<String> stockList = this.check4InvoiceAmount(dyoCol);
            List<String> titleList = this.check4InvoiceTitle(dyoCol);
            Boolean checkSwitch = (Boolean)this.getDefValue("checkswitch");
            if (checkSwitch != null && checkSwitch.booleanValue()) {
                List<String> invoiceAmountList = this.checkInvoiceAmount(dyoCol);
                Map<String, List<String>> map = this.checkReturnreqState(dyoCol);
                List<String> billNoList = map.get("billNoList");
                List<String> cfmstatusList = map.get("cfmstatusList");
                List<String> returnreqStateList = map.get("resultList");
                if (invoiceAmountList.size() > 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u91d1\u989d\u4e0e\u5b9e\u9645\u6536\u8d27\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5f00\u7968\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GenericEcInvoiceService_24", (String)"scm-pur-common", (Object[])new Object[0]));
                    return false;
                }
                if (returnreqStateList.size() > 0) {
                    view.showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u8ba2\u5355\u5b58\u5728\u672a\u5904\u7406\u5b8c\u6210\u7684\u552e\u540e\u7533\u8bf7\u6d41\u7a0b\uff0c\u65e0\u6cd5\u5f00\u7968\uff0c\u8bf7\u5728\u552e\u540e\u67e5\u8be2\u4e2d\u5904\u7406\u3002", (String)"GenericEcInvoiceService_23", (String)"scm-pur-common", (Object[])new Object[0]), MessageFormat.format(ResManager.loadKDString((String)"\u552e\u540e\u8ba2\u5355\uff1a{0} \u552e\u540e\u72b6\u6001\uff1a{1}\u3002", (String)"GenericEcInvoiceService_25", (String)"scm-pur-common", (Object[])new Object[0]), String.join((CharSequence)",", billNoList), String.join((CharSequence)",", cfmstatusList)), MessageTypes.Default);
                    return false;
                }
            }
            if (stateList.size() > 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f00\u7968\u72b6\u6001\u4e3a\u5f85\u7533\u8bf7\uff0c\u9a73\u56de\u6216\u5f00\u7968\u5931\u8d25\u7684\u7535\u5546\u8ba2\u5355\u624d\u80fd\u8fdb\u884c\u5f00\u7968\u7533\u8bf7\u3002", (String)"GenericEcInvoiceService_7", (String)"scm-pur-common", (Object[])new Object[0]));
                return false;
            }
            if (stockList.size() > 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6536\u8d27/\u5165\u5e93\u91d1\u989d\u5927\u4e8e\u96f6\u7684\u624d\u80fd\u8fdb\u884c\u5f00\u7968\u3002", (String)"GenericEcInvoiceService_8", (String)"scm-pur-common", (Object[])new Object[0]));
                return false;
            }
            if (titleList.size() > 0) {
                view.showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7535\u5546\u5b50\u8ba2\u5355{0}\u5bf9\u5e94\u7684\u5f00\u7968\u5355\u4f4d\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u5f00\u7968\u5355\u4f4d\u3002", (String)"GenericEcInvoiceService_26", (String)"scm-mal-common", (Object[])new Object[0]), String.join((CharSequence)",", titleList)));
                return false;
            }
            return true;
        }
        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"GenericEcInvoiceService_9", (String)"scm-pur-common", (Object[])new Object[0]));
        return false;
    }

    public <T> T getDefValue(String key) {
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"pur_invoicerequest");
        DataEntityPropertyCollection propertyCollection = dt.getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            if (!(property instanceof IFieldHandle) || ((IFieldHandle)property).isSysField() || !key.equals(property.getName())) continue;
            return (T)((IFieldHandle)property).getDefValue();
        }
        return null;
    }

    public List<String> checkInvoiceAmount(DynamicObjectCollection dyoCol) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (DynamicObject dyo : dyoCol) {
            BigDecimal stockamount;
            BigDecimal invoiceamount = dyo.getBigDecimal("invoiceamount");
            if (invoiceamount.subtract(stockamount = dyo.getBigDecimal("stockamount")).compareTo(BigDecimal.ZERO) == 0) continue;
            resultList.add(dyo.getString(ECCHILDORDERID));
        }
        return resultList;
    }

    private Map<String, List<String>> checkReturnreqState(DynamicObjectCollection dyoCol) {
        ArrayList<String> resultList = new ArrayList<String>();
        ArrayList billNoList = new ArrayList();
        ArrayList<String> cfmstatusList = new ArrayList<String>();
        List<Object> malnoList = new ArrayList();
        List<Object> returnreqList = new ArrayList();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(dyoCol.size());
        malnoList = dyoCol.stream().map(item -> item.getString("malno")).collect(Collectors.toList());
        DynamicObjectCollection returnreqCol = QueryServiceHelper.query((String)"mal_returnreq", (String)"billno,malorderno,cfmstatus", (QFilter[])new QFilter[]{new QFilter("malorderno", "in", malnoList)});
        for (DynamicObject dyo : dyoCol) {
            String malno = dyo.getString("malno");
            returnreqList = returnreqCol.stream().filter(item -> item.getString("malorderno").equals(malno)).collect(Collectors.toList());
            if ((returnreqList = returnreqList.stream().filter(item -> !item.getString("cfmstatus").equals("E") && !item.getString("cfmstatus").equals("F") && !item.getString("cfmstatus").equals("C")).collect(Collectors.toList())).size() <= 0) continue;
            resultList.add(dyo.getString(ECCHILDORDERID));
            billNoList.addAll(returnreqList.stream().map(item -> item.getString("billno")).collect(Collectors.toList()));
            for (DynamicObject dynamicObject : returnreqList) {
                if (dynamicObject.get("cfmstatus").equals(ReturnStatusEnum.TO_BE_CONFIRM.getVal())) {
                    cfmstatusList.add(ReturnStatusEnum.TO_BE_CONFIRM.getName());
                    continue;
                }
                if (dynamicObject.get("cfmstatus").equals(ReturnStatusEnum.CONFIRMED.getVal())) {
                    cfmstatusList.add(ReturnStatusEnum.CONFIRMED.getName());
                    continue;
                }
                cfmstatusList.add(ReturnStatusEnum.AUTO_CONFIRMED.getName());
            }
        }
        map.put("billNoList", billNoList);
        map.put("cfmstatusList", cfmstatusList);
        map.put("resultList", resultList);
        return map;
    }

    public List<String> check4InvoiceState(DynamicObjectCollection dyoCol) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (DynamicObject dyo : dyoCol) {
            String state = dyo.getString(ECINVOICESTATE);
            if (StringUtils.equals((CharSequence)PurEcInvoiceEnum.PREREQUEST.getVal(), (CharSequence)state) || StringUtils.equals((CharSequence)PurEcInvoiceEnum.INVOICEFAILED.getVal(), (CharSequence)state) || StringUtils.equals((CharSequence)PurEcInvoiceEnum.REJECT.getVal(), (CharSequence)state) || StringUtils.equals((CharSequence)PurEcInvoiceEnum.CANCEL.getVal(), (CharSequence)state)) continue;
            resultList.add(dyo.getString(ECCHILDORDERID));
        }
        return resultList;
    }

    public List<String> check4InvoiceTitle(DynamicObjectCollection dyoCol) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (DynamicObject dyo : dyoCol) {
            String title = dyo.getString("invoiceorg.ffirmname.zh_CN");
            if (!StringUtils.isBlank((CharSequence)title)) continue;
            resultList.add(dyo.getString(ECCHILDORDERID));
        }
        return resultList;
    }

    public List<String> check4InvoiceAmount(DynamicObjectCollection dyoCol) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (!ParamConfigUtil.getCacheBooleanParamConfig((String)"disableCheck4InvoiceAmount").booleanValue()) {
            for (DynamicObject dyo : dyoCol) {
                BigDecimal stockAmount = dyo.getBigDecimal("stockamount");
                if (stockAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                resultList.add(dyo.getString(ECCHILDORDERID));
            }
        }
        return resultList;
    }

    protected void afterBatchSplitSubmit(List<DynamicObject> successInvoiceDyos, List<EcInvSubmitResult> ecInvSubmitResults) {
        this.updateEcOrderInvoiceInfo(ecInvSubmitResults);
        this.updatePurInvoice(ecInvSubmitResults, successInvoiceDyos);
    }

    protected void updatePurInvoice(List<EcInvSubmitResult> ecInvSubmitResults, List<DynamicObject> successInvoiceDyos) {
    }

    protected void updateEcOrderInvoiceInfo(List<EcInvSubmitResult> ecInvSubmitResults) {
    }

    public void afterDoSubmit(EcInvSubmitResult ecInvSubmitResult) {
        DynamicObject[] ecOrders;
        for (DynamicObject ecOrder : ecOrders = this.loadEcOrders(ecInvSubmitResult.getEcOrderIds())) {
            if (ecInvSubmitResult.isSuccess()) {
                ecOrder.set("invoicestate", (Object)ecInvSubmitResult.getInvoiceState());
                ecOrder.set("invoiceresult", (Object)"");
                ecOrder.set("invoicetype", (Object)ecInvSubmitResult.getInvoiceType());
                ecOrder.set("markid", (Object)ecInvSubmitResult.getMarkId());
                continue;
            }
            ecOrder.set("invoicestate", (Object)PurEcInvoiceEnum.INVOICEFAILED.getVal());
            ecOrder.set("invoiceresult", ecInvSubmitResult.getErrorInfo());
            ecOrder.set("invoicetype", (Object)"");
            ecOrder.set("markid", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])ecOrders);
    }

    public EcInvSubmitResult doSubmit(EcInvSubmitParam ecInvSubmitParam) {
        Map res = EcGroupApiUtil.addInvoice(ecInvSubmitParam.covertToApiParamMap());
        this.log.info("@@ecInvSubmitParam:{},@@res:{}", (Object)ecInvSubmitParam, (Object)res);
        return this.parseResult(ecInvSubmitParam, res);
    }

    protected EcInvSubmitResult parseResult(EcInvSubmitParam ecInvSubmitParam, Map<String, Map<String, Object>> res) {
        EcInvSubmitResult ecInvSubmitResult = new EcInvSubmitResult();
        ecInvSubmitResult.setEcOrderIds(new HashSet<String>(Arrays.asList(ecInvSubmitParam.getSupplierOrder().split(","))));
        ecInvSubmitResult.setMarkId(ecInvSubmitParam.getMarkId());
        ecInvSubmitResult.setInvoiceType(ecInvSubmitParam.getInvoiceType());
        return ecInvSubmitResult;
    }

    public void beforeDoSubmit(EcInvSubmitParam ecInvSubmitParam) {
    }

    public EcInvSubmitResult validate(EcInvSubmitParam ecInvSubmitParam) {
        EcInvSubmitResult ecInvSubmitResult = new EcInvSubmitResult();
        ecInvSubmitResult.setSuccess(true);
        return ecInvSubmitResult;
    }

    public EcInvSubmitParam packageEcSubmitParam(IDataModel model, DynamicObjectCollection reportDyoCol) {
        EcInvSubmitParam ecInvSubmitParam = new EcInvSubmitParam();
        if (reportDyoCol == null || reportDyoCol.isEmpty()) {
            return ecInvSubmitParam;
        }
        String platform = model.getValue("currentplatform").toString();
        ecInvSubmitParam.setPlatfrom(platform);
        DynamicObject reportDyo = (DynamicObject)reportDyoCol.get(0);
        String invType = GenericEcInvoiceService.ierpMapEcInvType(reportDyo.getString("invtype"), platform);
        ecInvSubmitParam.setSupplierOrder(this.getEcChildOrderIdStr(reportDyoCol));
        String ecChildOrderId = reportDyo.getString(ECCHILDORDERID);
        String markId = this.generateMarkId(ecChildOrderId);
        ecInvSubmitParam.setMarkId(markId);
        ecInvSubmitParam.setInvoiceType(invType);
        ecInvSubmitParam.setBizInvoiceContent("1");
        ecInvSubmitParam.setTitle(reportDyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        ecInvSubmitParam.setTitleId(reportDyo.getString("invoiceorg.id"));
        ecInvSubmitParam.setEnterpriseTaxpayer(reportDyo.getString("invoiceorg.ftaxregnum").trim());
        ecInvSubmitParam.setBillToer((String)model.getValue("revname"));
        ecInvSubmitParam.setBillToContact((String)model.getValue("revphone"));
        ecInvSubmitParam.setBillToAddress((String)model.getValue("revaddressdetail"));
        ecInvSubmitParam.setEnterpriseRegAddress(reportDyo.getString("invoiceorg.faddress").trim());
        ecInvSubmitParam.setEnterpriseRegPhone(reportDyo.getString("invoiceorg.phone").trim());
        ecInvSubmitParam.setEnterpriseBankName(reportDyo.getString("invoiceorg.depositbank").trim());
        ecInvSubmitParam.setEnterpriseBankAccount(reportDyo.getString("invoiceorg.bankaccount").trim());
        ecInvSubmitParam.setRemark((String)model.getValue("remark"));
        return ecInvSubmitParam;
    }

    @Override
    public List<DynamicObject> pushPurInvoice(IDataModel model, DynamicObjectCollection reportDyoCol, String ruleId) {
        HashSet<String> childOrderIdSet = new HashSet<String>();
        for (DynamicObject reportDyo : reportDyoCol) {
            String ecChildOrderId = reportDyo.getString(ECCHILDORDERID);
            childOrderIdSet.add(ecChildOrderId);
        }
        String platform = model.getValue("currentplatform").toString();
        DynamicObjectCollection purOrderColl = this.preparePushBillData(platform, childOrderIdSet);
        if (!purOrderColl.isEmpty()) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setRuleId(ruleId);
            pushArgs.setSourceEntityNumber("pur_order");
            pushArgs.setTargetEntityNumber("pur_invoice");
            pushArgs.setBuildConvReport(true);
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
            for (DynamicObject billData : purOrderColl) {
                ListSelectedRow row = new ListSelectedRow((Object)billData.getLong("id"));
                row.setEntryEntityKey("materialentry");
                row.setEntryPrimaryKeyValue((Object)billData.getLong("entryentity"));
                selectedRowList.add(row);
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = null;
            try {
                result = ConvertServiceHelper.push((PushArgs)pushArgs);
            }
            catch (Exception e) {
                throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"GenericEcInvoiceService_10", (String)"scm-pur-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pur_invoice");
            if (result.isSuccess()) {
                List targetDatas = result.loadTargetDataObjects(BusinessDataServiceHelper::loadRefence, mainType);
                this.handleAfterPushBill(targetDatas, model, reportDyoCol);
                this.updateSumtaxamount(targetDatas);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                option.setVariableValue("WF", String.valueOf(false));
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pur_invoice", (DynamicObject[])targetDatas.toArray(new DynamicObject[0]), (OperateOption)option);
                if (!saveResult.isSuccess()) {
                    this.log.info("@@@kd.scm.pur.formplugin.util.PurEcInvoiceHelper.autoCreatePurInvoice:\u4fdd\u5b58\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
                    throw new KDBizException(new ErrorCode("operation error", ResManager.loadKDString((String)"\u751f\u6210\u5f00\u7968\u8bb0\u5f55\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GenericEcInvoiceService_11", (String)"scm-pur-common", (Object[])new Object[0])), new Object[]{saveResult.getMessage()});
                }
                List<DynamicObject> invoiceDynamicObjectList = Arrays.asList(BusinessDataServiceHelper.load((Object[])saveResult.getSuccessPkIds().toArray(), (DynamicObjectType)((DynamicObject)targetDatas.get(0)).getDynamicObjectType()));
                DynamicObject invoiceObj = invoiceDynamicObjectList.get(0);
                String billno = invoiceObj.getString("billno");
                if (StringUtils.isEmpty((CharSequence)billno)) {
                    OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"pur_invoice", (DynamicObject[])targetDatas.toArray(new DynamicObject[0]), (OperateOption)option);
                    this.log.info("@@@kd.scm.pur.formplugin.util.PurEcInvoiceHelper.autoCreatePurInvoice:\u5220\u9664\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails((List)deleteResult.getAllErrorOrValidateInfo()));
                    throw new KDBizException(new ErrorCode("operation error", ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u88ab\u7981\u7528\u751f\u6210\u53d1\u7968\u7b7e\u6536\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GenericEcInvoiceService_22", (String)"scm-pur-common", (Object[])new Object[0])), new Object[]{saveResult.getMessage()});
                }
                return invoiceDynamicObjectList;
            }
            this.log.info("@@@kd.scm.pur.formplugin.util.PurEcInvoiceHelper.autoCreatePurInvoice:\u5355\u636e\u4e0b\u63a8\u5931\u8d25\uff1a" + result.getMessage() + result.getReports());
        }
        return new ArrayList<DynamicObject>();
    }

    private void updateSumtaxamount(List<DynamicObject> targetDatas) {
        for (DynamicObject targetData : targetDatas) {
            DynamicObjectCollection entryentityCol = targetData.getDynamicObjectCollection("entryentity1");
            BigDecimal actchecktaxamountTotal = BigDecimal.ZERO;
            BigDecimal sumamount = BigDecimal.ZERO;
            BigDecimal sumtax = BigDecimal.ZERO;
            for (DynamicObject entry : entryentityCol) {
                BigDecimal actchecktaxamount = entry.getBigDecimal("actchecktaxamount");
                BigDecimal amount1 = entry.getBigDecimal("amount1");
                BigDecimal tax1 = entry.getBigDecimal("tax1");
                actchecktaxamountTotal = actchecktaxamountTotal.add(actchecktaxamount);
                sumamount = sumamount.add(amount1);
                sumtax = sumtax.add(tax1);
            }
            targetData.set("insumtaxamount", (Object)actchecktaxamountTotal);
            targetData.set("sumtaxamount", (Object)actchecktaxamountTotal);
            targetData.set("sumamount", (Object)sumamount);
            targetData.set("sumtax", (Object)sumtax);
        }
    }

    public void handleAfterPushBill(List<DynamicObject> targetDatas, IDataModel model, DynamicObjectCollection reportDyoCol) {
        DynamicObject invoiceTypeObj;
        DynamicObject reportDyo = (DynamicObject)reportDyoCol.get(0);
        String invType = reportDyo.getString("invtype");
        Long invtypeid = 0L;
        if (StringUtils.isNotBlank((CharSequence)invType) && null != (invoiceTypeObj = QueryServiceHelper.queryOne((String)"bd_invoicetype", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)invType)}))) {
            invtypeid = invoiceTypeObj.getLong("id");
        }
        Object revaddress = model.getValue("revaddress");
        String platform = model.getValue("currentplatform").toString();
        String ecAddressNum = AddressUtil.getLongNumber((Long)Long.parseLong(String.valueOf(revaddress)), (String)platform);
        for (DynamicObject targetData : targetDatas) {
            targetData.set("revname", model.getValue("revname"));
            targetData.set("revphone", model.getValue("revphone"));
            targetData.set("revaddress", (Object)(model.getValue("wholeaddress") + "&" + model.getValue("revaddress") + "&" + ecAddressNum));
            targetData.set("invtype", (Object)invType);
            targetData.set("invtypeid_id", (Object)invtypeid);
            targetData.set("invdetail", (Object)"2");
            targetData.set("reqperson", (Object)RequestContext.get().getUserId());
            targetData.set("remark", model.getValue("remark"));
        }
        this.handleEntry(targetDatas);
    }

    protected void handleEntry(List<DynamicObject> targetDatas) {
        HashMap<String, DynamicObject> poentryIdInBillMap = new HashMap<String, DynamicObject>(256);
        HashMap<String, DynamicObject> poentryIdInvoiceEntryMap = new HashMap<String, DynamicObject>(256);
        HashMap poEntryIdEcOrderPk = new HashMap(256);
        HashSet<String> poEntryIds = new HashSet<String>();
        for (DynamicObject targetData : targetDatas) {
            DynamicObjectCollection entryentityCol = targetData.getDynamicObjectCollection("entryentity1");
            Iterator iterator = entryentityCol.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry2 = (DynamicObject)iterator.next();
                String poEntryId = entry2.getString("poentryid1");
                if (!StringUtils.isNotEmpty((CharSequence)poEntryId)) continue;
                poentryIdInvoiceEntryMap.put(poEntryId, entry2);
                poEntryIds.add(poEntryId);
            }
        }
        Map poEntryIdRetMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurOrderService", (String)"collectDataForReceiptAndReturn", (Object[])new Object[]{poEntryIds});
        DynamicObjectCollection receiptCol = QueryServiceHelper.query((String)"pur_receipt", (String)"id,billno,billdate,materialentry.id,materialentry.poentryid,remark entityname", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poentryIdInvoiceEntryMap.keySet()).and("isreturn", "in", (Object)false)});
        for (Object receipt : receiptCol) {
            receipt.set("entityname", (Object)"pur_receipt");
            poentryIdInBillMap.put(receipt.getString("materialentry.poentryid"), (DynamicObject)receipt);
        }
        DynamicObjectCollection instockCol = QueryServiceHelper.query((String)"pur_instock", (String)"id,billno,billdate,materialentry.id,materialentry.poentryid,remark entityname", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poentryIdInvoiceEntryMap.keySet())});
        for (DynamicObject instock : instockCol) {
            instock.set("entityname", (Object)"pur_instock");
            poentryIdInBillMap.put(instock.getString("materialentry.poentryid"), instock);
        }
        HashMap<Long, String> moEntryIdPoEntryIdMap = new HashMap<Long, String>();
        DynamicObjectCollection purOrderCol = QueryServiceHelper.query((String)"pur_order", (String)"materialentry.poentryid,materialentry.srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poentryIdInvoiceEntryMap.keySet())});
        for (DynamicObject purOrder : purOrderCol) {
            String poEntryId = purOrder.getString("materialentry.poentryid");
            String moEntryId = purOrder.getString("materialentry.srcentryid");
            if (!StringUtils.isNotEmpty((CharSequence)poEntryId) || !StringUtils.isNotEmpty((CharSequence)moEntryId)) continue;
            moEntryIdPoEntryIdMap.put(Long.valueOf(moEntryId), poEntryId);
        }
        DynamicObjectCollection malOrderCol = QueryServiceHelper.query((String)"mal_order", (String)"entryentity.id,entryentity.order", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", moEntryIdPoEntryIdMap.keySet())});
        for (DynamicObject malOrder : malOrderCol) {
            String ecOrderPk = malOrder.getString("entryentity.order");
            if (!StringUtils.isNotEmpty((CharSequence)ecOrderPk)) continue;
            poEntryIdEcOrderPk.put(moEntryIdPoEntryIdMap.get(malOrder.getLong("entryentity.id")), ecOrderPk);
        }
        poentryIdInvoiceEntryMap.forEach((poentryId, entry) -> {
            String ecOrderPk;
            DynamicObject inbillDyn = (DynamicObject)poentryIdInBillMap.get(poentryId);
            if (inbillDyn != null) {
                entry.set("inbillno1", (Object)inbillDyn.getString("billno"));
                entry.set("inbilldate1", (Object)inbillDyn.getDate("billdate"));
                entry.set("srcbillid1", (Object)inbillDyn.getString("id"));
                entry.set("srcentryid1", (Object)inbillDyn.getString("materialentry.id"));
                entry.set("srcbilltype1", (Object)inbillDyn.getString("entityname"));
            }
            if (StringUtils.isNotEmpty((CharSequence)(ecOrderPk = (String)poEntryIdEcOrderPk.get(poentryId))) && !"0".equals(ecOrderPk)) {
                entry.set("ecorder", (Object)ecOrderPk);
                entry.set("entryjdorder_id", (Object)ecOrderPk);
            }
            Map itemMap = (Map)poEntryIdRetMap.get(poentryId);
            String srcbilltype = entry.getString("srcbilltype1");
            BigDecimal amount1 = BigDecimal.ZERO;
            BigDecimal qty1 = BigDecimal.ZERO;
            BigDecimal tax1 = BigDecimal.ZERO;
            BigDecimal taxamount1 = BigDecimal.ZERO;
            if (srcbilltype.equals("pur_receipt")) {
                amount1 = entry.getBigDecimal("amount1").subtract((BigDecimal)itemMap.get("sumrecretamount"));
                qty1 = entry.getBigDecimal("qty1").subtract((BigDecimal)itemMap.get("sumrecretqty"));
                tax1 = entry.getBigDecimal("tax1").subtract((BigDecimal)itemMap.get("sumrecrettax"));
                taxamount1 = entry.getBigDecimal("taxamount1").subtract((BigDecimal)itemMap.get("sumrecrettaxamount"));
            } else {
                amount1 = entry.getBigDecimal("amount1").subtract((BigDecimal)itemMap.get("suminstockretamount"));
                qty1 = entry.getBigDecimal("qty1").subtract((BigDecimal)itemMap.get("suminstockretqty"));
                tax1 = entry.getBigDecimal("tax1").subtract((BigDecimal)itemMap.get("suminstockrettax"));
                taxamount1 = entry.getBigDecimal("taxamount1").subtract((BigDecimal)itemMap.get("suminstockrettaxamount"));
            }
            entry.set("qty1", (Object)qty1);
            if (qty1.compareTo(BigDecimal.ZERO) == 0) {
                entry.set("amount1", (Object)BigDecimal.ZERO);
                entry.set("tax1", (Object)BigDecimal.ZERO);
            } else {
                entry.set("amount1", (Object)amount1);
                entry.set("tax1", (Object)tax1);
            }
            entry.set("taxamount1", (Object)taxamount1);
            entry.set("actchecktaxamount", (Object)taxamount1);
        });
    }

    public BigDecimal getInvoiceAmount(DynamicObjectCollection reportDyoCol) {
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        for (DynamicObject dyo : reportDyoCol) {
            invoiceAmount = invoiceAmount.add(dyo.getBigDecimal("invoiceamount"));
        }
        return invoiceAmount;
    }

    public DynamicObjectCollection preparePushBillData(String platform, Set<String> childOrderIdSet) {
        if (MalOrderUtil.getDefaultMalVersion()) {
            List<Long> orderIdList = this.queryEcOrderPks(childOrderIdSet);
            QFilter filter1 = new QFilter("entryentity.order", "in", orderIdList);
            DynamicObjectCollection entityCollection = QueryServiceHelper.query((String)"mal_order", (String)"entryentity.id entryentity", (QFilter[])new QFilter[]{filter1});
            if (entityCollection.isEmpty()) {
                return new DynamicObjectCollection();
            }
            QFilter filter2 = new QFilter("materialentry.srcentryid", "in", entityCollection.stream().map(item -> item.getString("entryentity")).collect(Collectors.toList()));
            return QueryServiceHelper.query((String)"pur_order", (String)"id,materialentry.id entryentity", (QFilter[])new QFilter[]{filter2});
        }
        QFilter filter = new QFilter("materialentry.jdorder.number", "in", childOrderIdSet);
        return QueryServiceHelper.query((String)"pur_order", (String)"id,materialentry.id entryentity", (QFilter[])new QFilter[]{filter});
    }

    public List<Long> queryEcOrderPks(Set<String> childOrderIdSet) {
        DynamicObjectCollection dyns = this.queryEcOrders(childOrderIdSet);
        ArrayList<Long> res = new ArrayList<Long>();
        dyns.forEach(dyn -> res.add(dyn.getLong("id")));
        return res;
    }

    public DynamicObjectCollection queryEcOrders(Set<String> ecChildOrderIdSet) {
        return QueryServiceHelper.query((String)this.getEcOrderEntityKey(), (String)"id,porderid,entryentity.goods.number", (QFilter[])new QFilter[]{new QFilter("orderid", "in", ecChildOrderIdSet)});
    }

    public String getEcOrderEntityKey() {
        throw new KDEcInvoiceException("please provide ecOrderEntityKey.");
    }

    @Override
    public List<EcInvSubmitResult> invoiceMergeSubmit(IDataModel model, IFormView view) {
        boolean canSubmit = this.beforeInvoiceMergeSubmitCheck(model, view);
        if (!canSubmit) {
            return new ArrayList<EcInvSubmitResult>();
        }
        ArrayList<EcInvSubmitResult> ecInvSubmitResults = new ArrayList<EcInvSubmitResult>(16);
        Map<DynamicObject, DynamicObjectCollection> reportDyoColMap = this.beforeMergeSubmit(model, view);
        ArrayList<DynamicObject> successInvoiceDyos = new ArrayList<DynamicObject>(16);
        HashSet<Long> failInvoicePks = new HashSet<Long>(16);
        for (Map.Entry<DynamicObject, DynamicObjectCollection> entry : reportDyoColMap.entrySet()) {
            EcInvSubmitResult ecInvSubmitResult = new EcInvSubmitResult();
            DynamicObjectCollection reportDyos = entry.getValue();
            DynamicObject invoiceDyo = entry.getKey();
            try {
                ecInvSubmitResult = this.invoiceSubmit(model, reportDyos);
                if (ecInvSubmitResult.isSuccess()) {
                    successInvoiceDyos.add(invoiceDyo);
                } else {
                    failInvoicePks.add(invoiceDyo.getLong("id"));
                }
            }
            catch (Exception e) {
                failInvoicePks.add(invoiceDyo.getLong("id"));
                ecInvSubmitResult.setSuccess(false);
                ecInvSubmitResult.getErrorInfo().add(e.getMessage());
            }
            ecInvSubmitResults.add(ecInvSubmitResult);
        }
        this.afterMergeSubmit(successInvoiceDyos, ecInvSubmitResults);
        this.deleteFailPurInvoice(failInvoicePks);
        view.invokeOperation("refresh");
        return ecInvSubmitResults;
    }

    public boolean beforeInvoiceMergeSubmitCheck(IDataModel model, IFormView view) {
        int[] selectIndexs = this.getSelectIndex(view);
        if (selectIndexs != null && selectIndexs.length >= 500) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5408\u5e76\u5f00\u7968\u7684\u5b50\u8ba2\u5355\u6570\u4e0d\u80fd\u8d85\u8fc7500\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GenericEcInvoiceService_12", (String)"scm-pur-common", (Object[])new Object[0]));
            return false;
        }
        return this.commonCheck(model, view);
    }

    protected void afterMergeSubmit(List<DynamicObject> successInvoiceDyos, List<EcInvSubmitResult> ecInvSubmitResults) {
    }

    protected Map<DynamicObject, DynamicObjectCollection> beforeMergeSubmit(IDataModel model, IFormView view) {
        DynamicObjectCollection reportDyoCol = this.getSelectedDyObject(view);
        List<DynamicObject> targetDatas = this.pushPurInvoice(model, reportDyoCol, this.selectRuleId(1));
        reportDyoCol = this.refreshReportDyoCol(reportDyoCol, view);
        return this.splitReportDyoCol(targetDatas, reportDyoCol);
    }

    protected DynamicObjectCollection refreshReportDyoCol(DynamicObjectCollection reportDyoCol, IFormView view) {
        view.invokeOperation("refresh");
        ReportList list = (ReportList)view.getControl(REPORTLIST);
        IReportListModel reportModel = list.getReportModel();
        int rowCount = reportModel.getRowCount();
        DynamicObjectCollection result = new DynamicObjectCollection();
        for (int i = 1; i <= rowCount; ++i) {
            DynamicObject refreshReportDyo = reportModel.getRowData(i);
            for (DynamicObject reportDyo : reportDyoCol) {
                if (!StringUtils.equals((CharSequence)reportDyo.getString(ECCHILDORDERID), (CharSequence)refreshReportDyo.getString(ECCHILDORDERID))) continue;
                result.add((Object)refreshReportDyo);
            }
        }
        return result;
    }

    protected Map<DynamicObject, DynamicObjectCollection> splitReportDyoCol(List<DynamicObject> invoiceDyos, DynamicObjectCollection reportDyoCol) {
        HashMap<DynamicObject, DynamicObjectCollection> result = new HashMap<DynamicObject, DynamicObjectCollection>();
        for (DynamicObject invoiceDyo : invoiceDyos) {
            for (DynamicObject reportDyo : reportDyoCol) {
                if (!StringUtils.equals((CharSequence)invoiceDyo.getString("billno"), (CharSequence)reportDyo.getString("invoiceno"))) continue;
                DynamicObjectCollection reportCol = (DynamicObjectCollection)result.get(invoiceDyo);
                if (reportCol == null) {
                    reportCol = new DynamicObjectCollection();
                    result.put(invoiceDyo, reportCol);
                }
                reportCol.add((Object)reportDyo);
            }
        }
        return result;
    }

    protected String[] getEcAddress(String ecAddressNum) {
        String[] ecAddress = null;
        if (StringUtils.isNotEmpty((CharSequence)ecAddressNum)) {
            ecAddress = ecAddressNum.split("\\.");
        }
        return ecAddress;
    }

    protected String getEcChildOrderIdStr(DynamicObjectCollection reportDyoCol) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (DynamicObject dyo : reportDyoCol) {
            sb.append(dyo.getString(ECCHILDORDERID));
            if (++index >= reportDyoCol.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String generateMarkId(String ecOrderId) {
        Calendar calendar = Calendar.getInstance();
        StringBuilder markId = new StringBuilder();
        String d = new SimpleDateFormat("yyyyMMddHHmmss").format(calendar.getTime());
        SecureRandom random = new SecureRandom();
        markId.append(d).append(random.nextInt(10)).append(random.nextInt(10)).append('-').append(ecOrderId);
        return markId.length() > 30 ? markId.substring(0, 30) : markId.toString();
    }

    public String getInvoiceOrgCode() {
        return "";
    }

    @Override
    public void repaireData(IFormView view) {
    }

    @Override
    public void viewInvoice(IFormView view) {
        ReportList list = (ReportList)view.getControl(REPORTLIST);
        int[] selectIndex = list.getEntryState().getSelectedRows();
        if (null != selectIndex && selectIndex.length == 1) {
            String ecOrderId;
            DynamicObject dynamicObject;
            DynamicObjectCollection dyoCol = this.getSelectedDyObject(view);
            if (CollectionUtils.isEmpty((Collection)dyoCol)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"GenericEcInvoiceService_16", (String)"scm-pur-common", (Object[])new Object[0]));
            }
            if (null != (dynamicObject = this.queryEcOrder(ecOrderId = ((DynamicObject)dyoCol.get(0)).getString(ECCHILDORDERID)))) {
                String invaddress = dynamicObject.getString("invaddress");
                if (StringUtils.isNotBlank((CharSequence)invaddress) && !invaddress.equals("null")) {
                    view.openUrl(invaddress);
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7535\u5b50\u53d1\u7968\u53ef\u4f9b\u9884\u89c8\u3002", (String)"GenericEcInvoiceService_13", (String)"scm-pur-common", (Object[])new Object[0]));
                }
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7535\u5b50\u53d1\u7968\u53ef\u4f9b\u9884\u89c8\u3002", (String)"GenericEcInvoiceService_13", (String)"scm-pur-common", (Object[])new Object[0]));
            }
        } else if (null != selectIndex && selectIndex.length > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u67e5\u9605\u53d1\u7968\u3002", (String)"GenericEcInvoiceService_14", (String)"scm-pur-common", (Object[])new Object[0]));
        } else {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"GenericEcInvoiceService_9", (String)"scm-pur-common", (Object[])new Object[0]));
        }
    }

    public DynamicObjectCollection getSelectedDyObject(IFormView view) {
        ReportList list = (ReportList)view.getControl(REPORTLIST);
        IReportListModel reportModel = list.getReportModel();
        int[] selectedIndexs = list.getEntryState().getSelectedRows();
        DynamicObjectCollection selectedRowsDyObject = new DynamicObjectCollection();
        if (selectedIndexs.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"GenericEcInvoiceService_15", (String)"scm-pur-common", (Object[])new Object[0]));
        }
        for (int i = 0; i < selectedIndexs.length; ++i) {
            DynamicObject entryObject = reportModel.getRowData(selectedIndexs[i]);
            if (entryObject == null) continue;
            selectedRowsDyObject.add((Object)entryObject);
        }
        return selectedRowsDyObject;
    }

    public int[] getSelectIndex(IFormView view) {
        ReportList list = (ReportList)view.getControl(REPORTLIST);
        return list.getEntryState().getSelectedRows();
    }

    @Override
    public void updateInvoice(IFormView view) {
        try {
            int[] selectIndexs = this.getSelectIndex(view);
            if (null != selectIndexs && selectIndexs.length > 0 && this.checkBeforeUpdateInvoice(view)) {
                Set<String> ecChildOrderSet = this.getEcChildOrderIdSet(this.getSelectedDyObject(view));
                this.updatePurInvoiceAndEcOrder(ecChildOrderSet);
                view.invokeOperation("refresh");
                view.showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u6210\u529f\u3002", (String)"GenericEcInvoiceService_27", (String)"scm-pur-common", (Object[])new Object[0]));
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"GenericEcInvoiceService_9", (String)"scm-pur-common", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            view.showTipNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"GenericEcInvoiceService_17", (String)"scm-pur-common", (Object[])new Object[0]));
            this.log.error("@@@\u624b\u5de5\u66f4\u65b0\u53d1\u7968\u7b7e\u6536\u53d1\u7968\u4fe1\u606f\u3001\u72b6\u6001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
        }
    }

    public void updatePurInvoiceAndEcOrder(Set<String> ecChildOrderSet) {
        DynamicObject[] ecOrderDyos = this.loadEcOrders(ecChildOrderSet);
        if (null == ecChildOrderSet || ecChildOrderSet.isEmpty()) {
            return;
        }
        Map<String, DynamicObject> markIdPurInvoiceMap = this.getMarkIdPurInvoiceMap(ecOrderDyos, ecChildOrderSet);
        this.log.info("markIdPurInvoiceMap\uff1a" + markIdPurInvoiceMap);
        HashMap<String, List> markIdEcInvoiceInfosMap = new HashMap<String, List>();
        HashSet<Long> failPurInvoieIdSet = new HashSet<Long>();
        HashSet<DynamicObject> sucessPurInvDynSet = new HashSet<DynamicObject>();
        for (DynamicObject ecOrder : ecOrderDyos) {
            String markId = ecOrder.getString("markid");
            if (!StringUtils.isNotEmpty((CharSequence)markId)) continue;
            List ecInvoiceInfos = (List)markIdEcInvoiceInfosMap.get(markId);
            if (ecInvoiceInfos == null) {
                ecInvoiceInfos = (List)this.getEcInvoiceInfo(ecOrder).getResult();
                markIdEcInvoiceInfosMap.put(markId, ecInvoiceInfos);
            }
            if (ecInvoiceInfos.isEmpty()) continue;
            this.updateEcOrder(ecOrder, ecInvoiceInfos);
            DynamicObject purInvoice = markIdPurInvoiceMap.get(markId);
            if (purInvoice == null) continue;
            if (this.isInvoiceFail((EcInvoiceInfo)ecInvoiceInfos.get(0))) {
                failPurInvoieIdSet.add(purInvoice.getLong("id"));
            }
            if (this.isInvoiceSuccess((EcInvoiceInfo)ecInvoiceInfos.get(0))) {
                sucessPurInvDynSet.add(purInvoice);
            }
            this.updatePurInvoice(purInvoice, ecInvoiceInfos);
        }
        SaveServiceHelper.save((DynamicObject[])ecOrderDyos);
        this.submitAndAuditSuccessPurInvoice(sucessPurInvDynSet);
        this.deleteFailPurInvoice(failPurInvoieIdSet);
    }

    protected void deleteFailPurInvoice(Set<Long> failPurInvoieIdSet) {
        if (failPurInvoieIdSet != null && !failPurInvoieIdSet.isEmpty()) {
            this.log.info("@@@\u5220\u9664\u5931\u8d25\u7684\u53d1\u7968\u7b7e\u6536\uff1a" + failPurInvoieIdSet);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"pur_invoice", (Object[])failPurInvoieIdSet.toArray(), (OperateOption)option);
            if (!deleteResult.isSuccess()) {
                this.log.info("@@@\u5220\u9664\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails((List)deleteResult.getAllErrorOrValidateInfo()));
            }
        }
    }

    protected void submitAndAuditSuccessPurInvoice(Set<DynamicObject> sucessPurInvDynSet) {
        if (!sucessPurInvDynSet.isEmpty()) {
            OperationResult auditResult;
            SaveServiceHelper.save((DynamicObject[])sucessPurInvDynSet.toArray(new DynamicObject[0]));
            this.log.info("@@@\u4fdd\u5b58\u53d1\u7968\u7b7e\u6536\u5355\u4e2a\u6570:" + sucessPurInvDynSet.size());
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            Object[] pks = new Object[sucessPurInvDynSet.size()];
            int index = 0;
            for (DynamicObject purInvDyn : sucessPurInvDynSet) {
                pks[index++] = purInvDyn.getPkValue();
            }
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"pur_invoice", (Object[])pks, (OperateOption)option);
            if (!submitResult.isSuccess()) {
                this.log.info("@@@kd.scm.pur.formplugin.util.PurEcInvoiceHelper.autoCreatePurInvoice:\u63d0\u4ea4\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
            }
            if (!(auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"pur_invoice", (Object[])pks, (OperateOption)option)).isSuccess()) {
                this.log.info("@@@kd.scm.pur.formplugin.util.PurEcInvoiceHelper.autoCreatePurInvoice:\u5ba1\u6838\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
            }
        }
    }

    protected void updatePurInvoice(DynamicObject purInvoice, List<EcInvoiceInfo> ecInvoiceInfos) {
        this.updateInvoiceDetailEntry(purInvoice, ecInvoiceInfos);
        this.updateMaterialEntry(purInvoice, ecInvoiceInfos);
    }

    protected void updateInvoiceDetailEntry(DynamicObject purInvoice, List<EcInvoiceInfo> ecInvoiceInfos) {
        DynamicObjectCollection invoiceDetailEntryCol = purInvoice.getDynamicObjectCollection("entryentity");
        HashMap<String, DynamicObject> invIdInvDetailEntryMap = new HashMap<String, DynamicObject>();
        for (DynamicObject invoiceDetaiEntry : invoiceDetailEntryCol) {
            invIdInvDetailEntryMap.put(invoiceDetaiEntry.getString("invno"), invoiceDetaiEntry);
        }
        DynamicObject org = purInvoice.getDynamicObject("org");
        DynamicObject curr = purInvoice.getDynamicObject("curr");
        DynamicObject bizpartner = purInvoice.getDynamicObject("bizpartner");
        DynamicObject invtypeid = purInvoice.getDynamicObject("invtypeid");
        for (EcInvoiceInfo ecInvoiceInfo : ecInvoiceInfos) {
            DynamicObject invoiceDetailEntry;
            if (!ecInvoiceInfo.isSuccess() || !StringUtils.isNotEmpty((CharSequence)ecInvoiceInfo.getInvoiceId())) continue;
            if (invIdInvDetailEntryMap.containsKey(ecInvoiceInfo.getInvoiceId())) {
                invoiceDetailEntry = (DynamicObject)invIdInvDetailEntryMap.get(ecInvoiceInfo.getInvoiceId());
            } else {
                invoiceDetailEntry = new DynamicObject(invoiceDetailEntryCol.getDynamicObjectType());
                invoiceDetailEntryCol.add((Object)invoiceDetailEntry);
            }
            invoiceDetailEntry.set("invamount", (Object)ecInvoiceInfo.getInvoiceAmount());
            invoiceDetailEntry.set("invdate", (Object)ecInvoiceInfo.getInvoiceDate());
            invoiceDetailEntry.set("invcode", (Object)ecInvoiceInfo.getInvoiceCode());
            invoiceDetailEntry.set("invno", (Object)ecInvoiceInfo.getInvoiceId());
            invoiceDetailEntry.set("invaddr", (Object)ecInvoiceInfo.getInvoiceFileUrl());
            invoiceDetailEntry.set("invoiceamount", (Object)ecInvoiceInfo.getInvoiceNakedAmount());
            invoiceDetailEntry.set("invtax", (Object)ecInvoiceInfo.getInvoiceTaxAmount());
            if (invtypeid != null) {
                invoiceDetailEntry.set("invoicetype", (Object)invtypeid);
            }
            if (org != null) {
                String ffirmname = org.getString("ffirmname");
                invoiceDetailEntry.set("reccompany", (Object)ffirmname);
            }
            if (curr != null) {
                invoiceDetailEntry.set("invcurr", (Object)curr);
            }
            if (bizpartner == null) continue;
            String bizpartnerName = bizpartner.getString("name");
            invoiceDetailEntry.set("invcompany", (Object)bizpartnerName);
        }
        invoiceDetailEntryCol.removeIf(enty -> StringUtils.isEmpty((CharSequence)enty.getString("invno")));
    }

    protected void updateMaterialEntry(DynamicObject purInvoice, List<EcInvoiceInfo> ecInvoiceInfos) {
    }

    protected Map<String, DynamicObject> getMarkIdPurInvoiceMap(DynamicObject[] ecOrderDyos, Set<String> ecChildOrderSet) {
        HashMap<String, String> ecOrderId2markIdMap = new HashMap<String, String>(16);
        ArrayList<Long> ecOrderPks = new ArrayList<Long>(ecChildOrderSet.size());
        for (DynamicObject ecOrder : ecOrderDyos) {
            ecOrderPks.add(ecOrder.getLong("id"));
        }
        for (DynamicObject ecOrder : ecOrderDyos) {
            ecOrderId2markIdMap.put(ecOrder.getString("id"), ecOrder.getString("markid"));
        }
        HashMap malOrderId2MarkId = new HashMap();
        DynamicObjectCollection malOrderEntityCollection = this.queryMalOrder(ecOrderPks);
        for (DynamicObject malOrder : malOrderEntityCollection) {
            String ecOrderId = malOrder.getString("entryentity.order");
            malOrderId2MarkId.put(malOrder.getString("entryentity.id"), ecOrderId2markIdMap.get(ecOrderId));
        }
        DynamicObjectCollection purOrderEntityCollection = this.queryPurOrder(malOrderEntityCollection);
        HashMap<String, String> poEntryId2MalOrderEntryId = new HashMap<String, String>(16);
        for (DynamicObject dyo : purOrderEntityCollection) {
            poEntryId2MalOrderEntryId.put(dyo.getString("materialentry.poentryid"), dyo.getString("materialentry.srcentryid"));
        }
        if (purOrderEntityCollection.isEmpty()) {
            return new HashMap<String, DynamicObject>();
        }
        QFilter poEntryidFilter = new QFilter("entryentity1.poentryid1", "in", purOrderEntityCollection.stream().map(item -> item.getString("materialentry.poentryid")).collect(Collectors.toList()));
        String selectField = "org,curr,bizpartner,invtypeid,billstatus,billno,invoicecode,invoiceno,invoicedate,invoiceid,invaddress,entryentity1.entryjdorder,entryentity1.entryjdorder.number,entryentity,entryentity.invamount,entryentity.invcode,entryentity.invno,entryentity.invdate,entryentity.invserialnum,entryentity.invoiceamount,entryentity.invtax,entryentity.invoicetype,entryentity.reccompany,entryentity.invcurr,entryentity.invcompany,entryentity.invaddr,entryentity.invid,entryentity.invremark,entryentity.invattachment,sumtaxamount,insumtaxamount,sumamount,sumtax,sumqty,entryentity1.taxamount1,entryentity1.amount1,entryentity1.tax1,entryentity1.qty1,entryentity1,entryentity1.goods1,entryentity1.goods1.number,entryentity1.poentryid1";
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"pur_invoice", (String)selectField, (QFilter[])new QFilter[]{poEntryidFilter});
        HashMap<String, DynamicObject> markId2PurInvoiceMap = new HashMap<String, DynamicObject>();
        for (DynamicObject dyo : dyos) {
            for (DynamicObject entryDyo : dyo.getDynamicObjectCollection("entryentity1")) {
                String poEntryId = entryDyo.getString("poentryid1");
                String malOrderEntryId = (String)poEntryId2MalOrderEntryId.get(poEntryId);
                if (!StringUtils.isNotEmpty((CharSequence)malOrderEntryId)) continue;
                markId2PurInvoiceMap.put((String)malOrderId2MarkId.get(malOrderEntryId), dyo);
            }
        }
        return markId2PurInvoiceMap;
    }

    public DynamicObjectCollection queryPurOrder(DynamicObjectCollection malOrderEntityCollection) {
        QFilter filter2 = new QFilter("materialentry.srcentryid", "in", malOrderEntityCollection.stream().map(item -> item.getString("entryentity.id")).collect(Collectors.toList()));
        return QueryServiceHelper.query((String)"pur_order", (String)"materialentry.poentryid, materialentry.srcentryid", (QFilter[])new QFilter[]{filter2});
    }

    public DynamicObjectCollection queryMalOrder(List<Long> ecOrderPks) {
        QFilter filter1 = new QFilter("entryentity.order", "in", ecOrderPks);
        return QueryServiceHelper.query((String)"mal_order", (String)"entryentity.id, entryentity.order", (QFilter[])new QFilter[]{filter1});
    }

    protected void updateEcOrder(DynamicObject ecOrder, List<EcInvoiceInfo> ecInvoiceInfos) {
        this.updateEcOrderByEcInvInfo(ecOrder, ecInvoiceInfos.get(0));
    }

    protected String getEcOrderId(DynamicObject ecOrder) {
        return ecOrder.getString("orderid");
    }

    public DynamicObject queryEcOrderByPk(String ecOrderPk) {
        if (StringUtils.isEmpty((CharSequence)ecOrderPk)) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(ecOrderPk));
        return QueryServiceHelper.queryOne((String)this.getEcOrderEntityKey(), (String)"invoicestate,invoiceresult", (QFilter[])new QFilter[]{idFilter});
    }

    protected void updateEcOrderByEcInvInfo(DynamicObject ecOrder, EcInvoiceInfo ecInvoiceInfo) {
        ecOrder.set("invoicestate", (Object)ecInvoiceInfo.getInvoiceState());
        if (ecInvoiceInfo.getResultMessage() != null) {
            if (ecInvoiceInfo.getResultMessage().length() > 250) {
                ecOrder.set("invoiceresult", (Object)ecInvoiceInfo.getResultMessage().substring(0, 250));
            } else {
                ecOrder.set("invoiceresult", (Object)ecInvoiceInfo.getResultMessage());
            }
        }
        ecOrder.set("invoiceid", (Object)ecInvoiceInfo.getInvoiceId());
        ecOrder.set("invoicecode", (Object)ecInvoiceInfo.getInvoiceCode());
        ecOrder.set("invoicedate", (Object)ecInvoiceInfo.getInvoiceDate());
        ecOrder.set("invoiceamount", (Object)ecInvoiceInfo.getInvoiceNakedAmount());
        ecOrder.set("invoicetax", (Object)ecInvoiceInfo.getInvoiceTaxAmount());
        ecOrder.set("invoicetaxamount", (Object)ecInvoiceInfo.getInvoiceAmount());
        ecOrder.set("invoicetype", (Object)ecInvoiceInfo.getInvoiceType());
        ecOrder.set("invaddress", (Object)ecInvoiceInfo.getInvoiceFileUrl());
    }

    protected ApiResult<List<EcInvoiceInfo>> getEcInvoiceInfo(DynamicObject ecOrder) {
        Map<String, Object> param = this.prepareQueryParam(ecOrder);
        Map res = EcGroupApiUtil.queryInvoice(param);
        return this.parseQueryRes(res, ecOrder);
    }

    public ApiResult<List<EcInvoiceInfo>> parseQueryRes(Map<String, Map<String, Object>> res, DynamicObject ecOrder) {
        ApiResult apiResult = new ApiResult();
        ArrayList<EcInvoiceInfo> ecInvoiceInfos = new ArrayList<EcInvoiceInfo>();
        apiResult.setResult(ecInvoiceInfos);
        String platform = this.getPlatform();
        Map<String, Object> invoiceListRes = res.get(platform);
        if (invoiceListRes == null) {
            return apiResult;
        }
        apiResult.setResultCode(String.valueOf(invoiceListRes.get("resultCode")));
        apiResult.setResultMessage(String.valueOf(invoiceListRes.get("resultMessage")));
        apiResult.setSuccess(((Boolean)invoiceListRes.get("success")).booleanValue());
        String invoiceType = ecOrder.getString("invoicetype");
        Map emalStatusMap = EmalStatusUtil.getNumberAndEstatusNames((String)STATUSTYPE_OF_INVOICE, (String)platform);
        if (apiResult.isSuccess()) {
            Object invoiceObj = invoiceListRes.get("result");
            if (invoiceObj != null) {
                JSONArray invoiceListJa = JSONArray.fromObject((Object)invoiceListRes.get("result"));
                for (int i = 0; i < invoiceListJa.size(); ++i) {
                    JSONObject invoiceJo = invoiceListJa.getJSONObject(i);
                    EcInvoiceInfo ecInvoiceInfo = new EcInvoiceInfo();
                    ecInvoiceInfo.setResultMessage(apiResult.getResultMessage());
                    ecInvoiceInfo.setResultCode(apiResult.getResultCode());
                    ecInvoiceInfo.setInvoiceType(invoiceType);
                    ecInvoiceInfo.setPlatform(platform);
                    ecInvoiceInfo.setSuccess(true);
                    ecInvoiceInfo = this.packageEcInvoiceInfo(ecInvoiceInfo, invoiceJo, emalStatusMap);
                    ecInvoiceInfos.add(ecInvoiceInfo);
                }
            } else {
                ecInvoiceInfos.add(this.failQueryEcInvoiceInfo((ApiResult<List<EcInvoiceInfo>>)apiResult, emalStatusMap));
            }
        } else {
            ecInvoiceInfos.add(this.failQueryEcInvoiceInfo((ApiResult<List<EcInvoiceInfo>>)apiResult, emalStatusMap));
        }
        return apiResult;
    }

    public EcInvoiceInfo failQueryEcInvoiceInfo(ApiResult<List<EcInvoiceInfo>> apiResult, Map<String, EmalStatus> emalStatusMap) {
        EcInvoiceInfo failEcInvoiceInfo = new EcInvoiceInfo();
        failEcInvoiceInfo.setInvoiceState(this.getInvoiceStateFromMapping(apiResult.getResultCode(), emalStatusMap));
        failEcInvoiceInfo.setResultMessage(apiResult.getResultMessage());
        failEcInvoiceInfo.setResultCode(apiResult.getResultCode());
        failEcInvoiceInfo.setSuccess(this.isInvoiceSuccess(failEcInvoiceInfo));
        failEcInvoiceInfo.setPlatform(this.getPlatform());
        return failEcInvoiceInfo;
    }

    public String getInvoiceStateFromMapping(String ecInvStatus, Map<String, EmalStatus> emalStatusMap) {
        EmalStatus emalStatus = emalStatusMap.get(ecInvStatus);
        if (emalStatus != null) {
            return emalStatus.getNumber();
        }
        return PurEcInvoiceEnum.HANDLING.getVal();
    }

    public EcInvoiceInfo packageEcInvoiceInfo(EcInvoiceInfo ecInvoiceInfo, JSONObject invoiceJo, Map<String, EmalStatus> emalStatusMap) {
        ecInvoiceInfo.setInvoiceId((String)invoiceJo.get("invoiceId"));
        ecInvoiceInfo.setInvoiceCode((String)invoiceJo.get("invoiceCode"));
        if (invoiceJo.containsKey((Object)"invoiceDate")) {
            ecInvoiceInfo.setInvoiceDate(DateUtil.string2date((String)((String)invoiceJo.get("invoiceDate")), (String)"yyyy-MM-dd"));
        }
        if (invoiceJo.containsKey((Object)"invoiceNakedAmount")) {
            ecInvoiceInfo.setInvoiceNakedAmount(this.converStr2BigDecimal(invoiceJo.getString("invoiceNakedAmount")));
        }
        if (invoiceJo.containsKey((Object)"invoiceTaxRate")) {
            ecInvoiceInfo.setInvoiceTaxRate(this.converStr2BigDecimal(invoiceJo.getString("invoiceTaxRate")));
        }
        if (invoiceJo.containsKey((Object)"invoiceTaxAmount")) {
            ecInvoiceInfo.setInvoiceTaxAmount(this.converStr2BigDecimal(invoiceJo.getString("invoiceTaxAmount")));
        }
        if (invoiceJo.containsKey((Object)"invoiceAmount")) {
            ecInvoiceInfo.setInvoiceAmount(this.converStr2BigDecimal(invoiceJo.getString("invoiceAmount")));
        }
        if (invoiceJo.containsKey((Object)"fileUrl") && StringUtils.isNotEmpty((CharSequence)invoiceJo.getString("fileUrl"))) {
            ecInvoiceInfo.setInvoiceFileUrl(invoiceJo.getString("fileUrl"));
        }
        ecInvoiceInfo.setInvoiceState(this.getInvoiceStateFromMapping(ecInvoiceInfo.getResultCode(), emalStatusMap));
        return ecInvoiceInfo;
    }

    public Map<String, Object> prepareQueryParam(DynamicObject ecOrder) {
        String markId = ecOrder.getString("markid");
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        HashMap<String, String> platformParam = new HashMap<String, String>(16);
        platformParam.put("markId", markId);
        param.put(this.getPlatform(), platformParam);
        return param;
    }

    public String getPlatform() {
        return "";
    }

    public DynamicObject[] loadEcOrders(Set<String> ecChildOrderSet) {
        QFilter orderFiler = new QFilter("orderid", "in", ecChildOrderSet);
        String selectField = "markid,invoicestate,invoiceid,invoicecode,invoicedate,invoiceamount,invoicetax,invoicetaxamount,invoicetype,invaddress,invoiceresult,number,orderid,porderid,invoiceresult,entryentity.goods";
        return BusinessDataServiceHelper.load((String)this.getEcOrderEntityKey(), (String)selectField, (QFilter[])new QFilter[]{orderFiler});
    }

    public boolean checkBeforeUpdateInvoice(IFormView view) {
        DynamicObjectCollection dyoCol = this.getSelectedDyObject(view);
        for (DynamicObject dyo : dyoCol) {
            String invoiceState = dyo.getString(ECCHILDORDERID);
            if (!"1".equals(invoiceState) && !STATUSTYPE_OF_INVOICE.equals(invoiceState) && !"6".equals(invoiceState) && !"8".equals(invoiceState)) continue;
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u3002", (String)"GenericEcInvoiceService_18", (String)"scm-pur-common", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void confirmReceive(IFormView view) {
        EcConfirmRecParam ecConfirmRecParam = this.prepareEcConfirmRecParam(view);
        ApiResult<List<EcConfirmInfo>> apiResult = this.doConfirmRec(ecConfirmRecParam);
        this.afterDoConfirmRec(apiResult, view);
    }

    protected List<EcConfirmInfo> getBody(Map<String, Object> result) {
        ArrayList<EcConfirmInfo> ecConfirmInfos = new ArrayList<EcConfirmInfo>();
        if (result.get("result") instanceof List) {
            List resultMaps = (List)result.get("result");
            for (Map resultMap : resultMaps) {
                EcConfirmInfo ecConfirmInfo = new EcConfirmInfo(resultMap);
                ecConfirmInfos.add(ecConfirmInfo);
            }
        }
        return ecConfirmInfos;
    }

    protected void afterDoConfirmRec(ApiResult<List<EcConfirmInfo>> apiResult, IFormView view) {
        if (apiResult == null) {
            return;
        }
        this.log.info("@@\u66f4\u65b0\u6536\u8d27\u72b6\u6001\u7ed3\u679c\uff1a" + apiResult.toString());
        if (apiResult.isSuccess()) {
            List ecConfirmInfos = (List)apiResult.getResult();
            StringBuilder sb = new StringBuilder();
            for (EcConfirmInfo ecConfirmInfo : ecConfirmInfos) {
                if (!"2".equals(ecConfirmInfo.getConfirmState())) continue;
                sb.append(ecConfirmInfo.getChildOrderId()).append(":").append(ecConfirmInfo.getErrorMsg()).append("\n\r");
            }
            if (sb.length() > 0) {
                view.showTipNotification(sb.toString());
            } else {
                view.invokeOperation("refresh");
                view.showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6536\u8d27\u72b6\u6001\u6210\u529f\u3002", (String)"GenericEcInvoiceService_19", (String)"scm-pur-common", (Object[])new Object[0]));
            }
        } else if (StringUtils.isNotEmpty((CharSequence)apiResult.getResultMessage())) {
            view.showTipNotification(apiResult.getResultMessage());
        }
    }

    protected ApiResult<List<EcConfirmInfo>> doConfirmRec(EcConfirmRecParam ecConfirmRecParam) {
        return null;
    }

    protected EcConfirmRecParam prepareEcConfirmRecParam(IFormView view) {
        EcConfirmRecParam ecConfirmRecParam = new EcConfirmRecParam();
        DynamicObjectCollection reportDynCols = this.getSelectedDyObject(view);
        for (DynamicObject reportDyn : reportDynCols) {
            ecConfirmRecParam.getEcChildOrderIds().add(reportDyn.getString(ECCHILDORDERID));
        }
        return ecConfirmRecParam;
    }

    public int[] getAllRowIndex(IFormView view) {
        ReportList list = (ReportList)view.getControl(REPORTLIST);
        int rowCount = list.getReportModel().getRowCount();
        int[] rowIndex = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rowIndex[i] = i + 1;
        }
        return rowIndex;
    }

    public DynamicObject queryEcOrder(String ecOrderId) {
        QFilter qFilter2 = new QFilter("orderid", "=", (Object)ecOrderId);
        return QueryServiceHelper.queryOne((String)this.getEcOrderEntityKey(), (String)"invaddress", (QFilter[])new QFilter[]{qFilter2});
    }

    @Override
    public void showInvoiceLogistics(IFormView view) {
        DynamicObjectCollection col = this.getSelectedDyObject(view);
        if (col.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"GenericEcInvoiceService_21", (String)"scm-pur-common", (Object[])new Object[0]));
            return;
        }
        Set<String> ecChildOrderIds = this.getEcChildOrderIdSet(col);
        if (null != ecChildOrderIds && ecChildOrderIds.size() > 0) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pbd_logistics");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("ecChildOrderids", ecChildOrderIds);
            this.prepareInvoiceLogisticsFormShowParam(paramMap);
            showParameter.setCustomParams(paramMap);
            view.showForm(showParameter);
        }
    }

    public void prepareInvoiceLogisticsFormShowParam(Map<String, Object> showParamMap) {
        showParamMap.put("LOGISTICS_TYPE", "invoice");
        showParamMap.put(PLATFORM, this.getPlatform());
    }

    public Set<String> getEcChildOrderIdSet(DynamicObjectCollection selectedDyObject) {
        HashSet<String> resultSet = new HashSet<String>();
        for (DynamicObject dyo : selectedDyObject) {
            resultSet.add(dyo.getString(ECCHILDORDERID));
        }
        return resultSet;
    }

    public BigDecimal converStr2BigDecimal(Object obj) {
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        String str = this.converToString(obj);
        if ("".equals(str) || StringUtils.endsWithIgnoreCase((CharSequence)str, (CharSequence)"null")) {
            return BigDecimal.ZERO;
        }
        return CommonUtil.getBigDecimalPro((Object)str);
    }

    public String converToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Integer) {
            return obj.toString();
        }
        return (String)obj;
    }

    public boolean isInvoiceSuccess(EcInvoiceInfo ecInvoiceInfo) {
        String malInvoiceStatus = ecInvoiceInfo.getInvoiceState();
        boolean isSuccess = false;
        if (StringUtils.isNotBlank((CharSequence)malInvoiceStatus)) {
            switch (malInvoiceStatus) {
                case "4": 
                case "5": 
                case "6": {
                    isSuccess = true;
                    break;
                }
                default: {
                    isSuccess = false;
                }
            }
        }
        return isSuccess;
    }

    public boolean isInvoiceFail(EcInvoiceInfo ecInvoiceInfo) {
        String malInvoiceStatus = ecInvoiceInfo.getInvoiceState();
        boolean isFail = false;
        if (StringUtils.isNotBlank((CharSequence)malInvoiceStatus)) {
            switch (malInvoiceStatus) {
                case "3": 
                case "8": {
                    isFail = true;
                    break;
                }
                default: {
                    isFail = false;
                }
            }
        }
        return isFail;
    }

    public String now() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    public static String ierpMapEcInvType(String ierpInvType, String emalType) {
        QFilter emalTypeFilter = new QFilter("emaltype", "=", (Object)emalType);
        QFilter bdinvoicetypeNoFilter = new QFilter("bdinvoicetype.number", "=", (Object)ierpInvType);
        DynamicObject invTypeDyn = QueryServiceHelper.queryOne((String)"pbd_invoicetype", (String)"emalinvoicenumber", (QFilter[])new QFilter[]{emalTypeFilter, bdinvoicetypeNoFilter});
        if (invTypeDyn == null) {
            return "";
        }
        return invTypeDyn.getString("emalinvoicenumber");
    }

    protected BigDecimal getTax(DynamicObjectCollection reportDyoCol) {
        BigDecimal tax = BigDecimal.ZERO;
        for (DynamicObject dyo : reportDyoCol) {
            tax = tax.add(dyo.getBigDecimal("tax"));
        }
        return tax;
    }

    protected BigDecimal getAmount(DynamicObjectCollection reportDyoCol) {
        BigDecimal amount = BigDecimal.ZERO;
        for (DynamicObject dyo : reportDyoCol) {
            amount = amount.add(dyo.getBigDecimal("amount"));
        }
        return amount;
    }
}

