/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;

public class DataUpgradePluginUtils {
    private static final Log LOG = LogFactory.getLog(DataUpgradePluginUtils.class);
    private static final int PAGE_SIZE = 500;

    private static String getTotalNumTips() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u603b\u6570\u636e\u91cf", (String)"DataUpgradePluginUtils_1", (String)"scm-pur-common", (Object[])new Object[0]);
    }

    public static boolean upgradeDiscounttype(String dbKey, StringBuilder pProcessInfo, Date beginDate) {
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_ORDCHANGENTRY", "T_PUR_ORDCHANGE_A", beginDate);
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_ORDERENTRY", "T_PUR_ORDER_A", beginDate);
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_SALOUTSTOCKENTRY", "T_PUR_SALOUTSTOCK_A", beginDate);
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_RECEIPTENTRY", "T_PUR_RECEIPT_A", beginDate);
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_INSTOCKENTRY", "T_PUR_INSTOCK_A", beginDate);
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_RETURNENTRY", "T_PUR_RETURN_A", beginDate);
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_REQUESTENTRY", "T_PUR_REQUEST_A", beginDate);
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_CHECKENTRY", "T_PUR_CHECK_A", beginDate);
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_CHECKENTRY2", "T_PUR_CHECK_A", beginDate);
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_INVOICENTRY", "T_PUR_INVOICE_A", beginDate);
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_INVOICENTRY2", "T_PUR_INVOICE_A", beginDate);
        DataUpgradePluginUtils.upgradeDiscounttype(pProcessInfo, dbKey, "T_PUR_ORDERCHECK", "T_PUR_ORDER_A", beginDate);
        return true;
    }

    private static boolean upgradeDiscounttype(StringBuilder pProcessInfo, String dbKey, String table, String joinTable, Date beginDate) {
        DBRoute dbRoute = new DBRoute("pur");
        StringBuilder sb = new StringBuilder();
        sb.append("select t1.fentryId from ").append(table).append(" t1 ").append(" left join ").append(joinTable).append(" t2 ").append(" on t1.fid=t2.fid ").append(" where ");
        sb.append(" t1.FDctRate!=0 and (t1.fdiscounttype='NULL' OR fdiscounttype=' ')");
        Object[] params = null;
        if (beginDate != null) {
            sb.append(" and t2.fcreatetime >=?");
            params = new Object[]{beginDate};
        }
        try (DataSet totalData = DB.queryDataSet((String)"PurDiscountTypeUpgradePluginImpl.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sb.toString(), (Object[])params);){
            ArrayList idList = new ArrayList(16);
            totalData.forEach(rowx -> idList.add(String.valueOf(rowx.getLong("fentryId"))));
            int count = idList.size();
            pProcessInfo.append(DataUpgradePluginUtils.getTotalNumTips()).append(count).append("\n");
            LOG.info(pProcessInfo.toString());
            int totalPages = count / 500;
            if (count % 500 != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List subIdList = (pageIndex + 1) * 500 > count ? idList.subList(pageIndex * 500, idList.size()) : idList.subList(pageIndex * 500, (pageIndex + 1) * 500);
                if (subIdList.isEmpty()) continue;
                ArrayList<Object[]> parms = new ArrayList<Object[]>(500);
                for (Object idItem : subIdList) {
                    Object[] parm = new Object[]{"A", Long.parseLong(idItem.toString())};
                    parms.add(parm);
                }
                if (parms.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                dbRoute = new DBRoute(dbKey);
                DataUpgradePluginUtils.updateDiscounttype(dbRoute, parms, table);
            }
        }
        return true;
    }

    private static void updateDiscounttype(DBRoute dbRoute, List<Object[]> parms, String entryTable) {
        DB.executeBatch((DBRoute)dbRoute, (String)("update " + entryTable + " set fdiscounttype = ? where FEntryID = ?"), parms);
    }

    public static Boolean upgradeActcheckpriceOrAmount(String dbKey, StringBuilder pProcessInfo, Date beginDate) {
        DataUpgradePluginUtils.upgradeActcheckpriceOrAmount(pProcessInfo, dbKey, "T_PUR_CHECKENTRY2", "T_PUR_CHECK_A", beginDate);
        DataUpgradePluginUtils.upgradeActcheckpriceOrAmount(pProcessInfo, dbKey, "T_PUR_INVOICENTRY2", "T_PUR_INVOICE_A", beginDate);
        return true;
    }

    private static boolean upgradeActcheckpriceOrAmount(StringBuilder pProcessInfo, String dbKey, String table, String joinTable, Date beginDate) {
        DBRoute dbRoute = new DBRoute("pur");
        StringBuilder sb = new StringBuilder();
        sb.append("select t1.fentryId,t1.FAmount,t1.FPrice from ").append(table).append(" t1 ").append(" left join ").append(joinTable).append(" t2 ").append(" on t1.fid=t2.fid ").append(" where 1=1 ");
        Object[] params = null;
        if (beginDate != null) {
            sb.append(" and t2.fcreatetime >=?");
            params = new Object[]{beginDate};
        }
        try (DataSet totalData = DB.queryDataSet((String)"PurDiscountTypeUpgradePluginImpl.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sb.toString(), (Object[])params);){
            ArrayList idList = new ArrayList(16);
            totalData.forEach(rowx -> {
                BigDecimal price;
                BigDecimal amount = rowx.getBigDecimal("FAmount");
                BigDecimal actcheckprice = price = rowx.getBigDecimal("FPrice");
                BigDecimal actcheckamount = amount;
                Object[] parm = new Object[]{actcheckprice, actcheckamount, rowx.getLong("fentryId")};
                idList.add(parm);
            });
            int count = idList.size();
            pProcessInfo.append(DataUpgradePluginUtils.getTotalNumTips()).append(count).append("\n");
            LOG.info(pProcessInfo.toString());
            int totalPages = count / 500;
            if (count % 500 != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object> subIdList = (pageIndex + 1) * 500 > count ? idList.subList(pageIndex * 500, idList.size()) : idList.subList(pageIndex * 500, (pageIndex + 1) * 500);
                if (subIdList.isEmpty()) continue;
                dbRoute = new DBRoute(dbKey);
                DataUpgradePluginUtils.updateActcheckpriceOrAmount(dbRoute, subIdList, table);
            }
        }
        return true;
    }

    private static void updateActcheckpriceOrAmount(DBRoute dbRoute, List<Object[]> parms, String entryTable) {
        DB.executeBatch((DBRoute)dbRoute, (String)("update " + entryTable + " set factcheckprice = ? , factcheckamount = ?  where FEntryID = ?"), parms);
    }

    public static Boolean upgradePurStockOrg(String dbKey, StringBuilder pProcessInfo) {
        DBRoute dbRoute = new DBRoute("pur");
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,forgid from t_pur_supplierstock  where forgid is null or forgid=0");
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        try (DataSet totalData = DB.queryDataSet((String)"PurStockListUpgradePluginImpl.upgradePurStockOrg", (DBRoute)dbRoute, (String)sb.toString());){
            ArrayList idList = new ArrayList(16);
            totalData.forEach(rowx -> {
                Long fid = rowx.getLong("fid");
                Object[] parm = new Object[]{rootOrgId, fid};
                idList.add(parm);
            });
            int count = idList.size();
            pProcessInfo.append(DataUpgradePluginUtils.getTotalNumTips()).append(count).append("\n");
            LOG.info(pProcessInfo.toString());
            int totalPages = count / 500;
            if (count % 500 != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object> subIdList = (pageIndex + 1) * 500 > count ? idList.subList(pageIndex * 500, idList.size()) : idList.subList(pageIndex * 500, (pageIndex + 1) * 500);
                if (subIdList.isEmpty()) continue;
                dbRoute = new DBRoute(dbKey);
                DataUpgradePluginUtils.upgradePurStockOrg(dbRoute, subIdList, "t_pur_supplierstock");
            }
        }
        return true;
    }

    private static void upgradePurStockOrg(DBRoute dbRoute, List<Object[]> subIdList, String table) {
        DB.executeBatch((DBRoute)dbRoute, (String)("update " + table + " set forgid = ? where FID = ?"), subIdList);
    }

    public static Boolean updateInvoiceCheckNo(String dbKey, StringBuilder pProcessInfo, Date beginDate) {
        DBRoute dbRoute = new DBRoute(dbKey);
        StringBuilder sb = new StringBuilder();
        sb.append("select t1.fid from ").append("t_pur_invoice").append(" t1 ").append(" left join ").append("t_pur_invoice_a").append(" t2 ").append(" on t1.fid=t2.fid ");
        Object[] params = null;
        sb.append("where 1=1");
        if (beginDate != null) {
            sb.append(" and t2.fcreatetime >=?");
            params = new Object[]{beginDate};
        }
        try (DataSet totalData = DB.queryDataSet((String)"PurInvoiceCheckNoUpgradePluginImpl.updateInvoiceCheckNo", (DBRoute)dbRoute, (String)sb.toString(), (Object[])params);){
            ArrayList idList = new ArrayList(16);
            totalData.forEach(rowx -> {
                Long fid = rowx.getLong("fid");
                idList.add(fid);
            });
            int count = idList.size();
            pProcessInfo.append(DataUpgradePluginUtils.getTotalNumTips()).append(count).append("\n");
            LOG.info(pProcessInfo.toString());
            int totalPages = count / 500;
            if (count % 500 != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object[]> updateParams;
                List<Long> subIdList = (pageIndex + 1) * 500 > count ? idList.subList(pageIndex * 500, idList.size()) : idList.subList(pageIndex * 500, (pageIndex + 1) * 500);
                if (subIdList.isEmpty() || CollectionUtils.isEmpty(updateParams = DataUpgradePluginUtils.getPurInvoiceCheckNo(subIdList, dbRoute))) continue;
                DataUpgradePluginUtils.upgradePurInvoiceCheckNo(dbRoute, updateParams, "t_pur_invoicentry2_a");
            }
        }
        return true;
    }

    private static List<Object[]> getPurInvoiceCheckNo(List<Long> subIdList, DBRoute dbRoute) {
        Object[] purCheckParams;
        Map map = BFTrackerServiceHelper.findDirtSourceBills((String)"scp_invoice", (Long[])subIdList.toArray(new Long[0]));
        HashMap<Long, Long> mapEntry = new HashMap<Long, Long>(8);
        for (Map.Entry entry : map.entrySet()) {
            List value = (List)entry.getValue();
            for (BFRow bfrow : value) {
                if (bfrow.getId() == null || bfrow.getSId() == null) continue;
                mapEntry.put(bfrow.getId().getEntryId(), bfrow.getSId().getBillId());
            }
        }
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        if (mapEntry.isEmpty()) {
            return updateParams;
        }
        StringBuilder sbpurcheck = new StringBuilder();
        sbpurcheck.append("select t1.fid,t1.fbillno from ").append("t_pur_check t1");
        sbpurcheck.append(" where 1=1 ");
        sbpurcheck.append(" and t1.fid in (");
        for (Object obj : purCheckParams = mapEntry.values().toArray()) {
            sbpurcheck.append("?,");
        }
        sbpurcheck.deleteCharAt(sbpurcheck.length() - 1);
        sbpurcheck.append(")");
        HashMap mapPurCheckEntry = new HashMap(8);
        try (DataSet checkData = DB.queryDataSet((String)"PurInvoiceCheckNoUpgradePluginImpl.updateInvoiceCheckNo1", (DBRoute)dbRoute, (String)sbpurcheck.toString(), (Object[])purCheckParams);){
            checkData.forEach(rowx -> {
                Long fid = rowx.getLong("fid");
                String checkBillNo = rowx.getString("fbillno");
                mapPurCheckEntry.put(fid, checkBillNo);
            });
        }
        for (Map.Entry entry : mapEntry.entrySet()) {
            Long entryId = (Long)entry.getKey();
            Long checkBillId = (Long)entry.getValue();
            String checkBillNo = (String)mapPurCheckEntry.get(checkBillId);
            if (checkBillNo == null) continue;
            Object[] parm = new Object[]{checkBillNo, entryId};
            updateParams.add(parm);
        }
        return updateParams;
    }

    private static void upgradePurInvoiceCheckNo(DBRoute dbRoute, List<Object[]> subIdList, String table) {
        DB.executeBatch((DBRoute)dbRoute, (String)("update " + table + " set fcheckbillno = ? where fentryid = ?"), subIdList);
    }

    public static Boolean updateInvoiceInvoiceType(String dbKey, StringBuilder pProcessInfo) {
        Long invoiceTypeid = DataUpgradePluginUtils.queryInvoicetypes();
        DBRoute dbRoute = new DBRoute(dbKey);
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,forgid,fbizpartnerid,fcurrid from ").append("t_pur_invoice");
        try (DataSet totalData = DB.queryDataSet((String)"PurInvoiceInvoiceUpgradePluginImpl.updateInvoiceInvoiceType", (DBRoute)dbRoute, (String)sb.toString(), null);){
            ArrayList idList = new ArrayList(16);
            totalData.forEach(rowx -> {
                Long fid = rowx.getLong("fid");
                Long forgid = rowx.getLong("forgid");
                Long fbizpartnerid = rowx.getLong("fbizpartnerid");
                Long fcurrid = rowx.getLong("fcurrid");
                Object[] parm = new Object[]{fid, forgid, fbizpartnerid, fcurrid};
                idList.add(parm);
            });
            int count = idList.size();
            pProcessInfo.append(DataUpgradePluginUtils.getTotalNumTips()).append(count).append("\n");
            LOG.info(pProcessInfo.toString());
            int totalPages = count / 500;
            if (count % 500 != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List subIdList = (pageIndex + 1) * 500 > count ? idList.subList(pageIndex * 500, idList.size()) : idList.subList(pageIndex * 500, (pageIndex + 1) * 500);
                if (subIdList.isEmpty()) continue;
                ArrayList<Long> subOrgId = new ArrayList<Long>(8);
                ArrayList<Long> subBizPartnerId = new ArrayList<Long>(8);
                for (Object[] subId : subIdList) {
                    subOrgId.add((Long)subId[1]);
                    subBizPartnerId.add((Long)subId[2]);
                }
                Map<Long, String> orgMap = DataUpgradePluginUtils.queryOrgName(subOrgId);
                Map<Long, String> supplierMap = DataUpgradePluginUtils.queryBizPartnerName(subBizPartnerId);
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(8);
                for (Object[] subId : subIdList) {
                    Long fid = (Long)subId[0];
                    Long orgId = (Long)subId[1];
                    Long bizId = (Long)subId[2];
                    Long fcurrid = (Long)subId[3];
                    String orgCompanyName = orgMap.get(orgId) == null ? " " : orgMap.get(orgId);
                    String supplierName = supplierMap.get(bizId) == null ? " " : supplierMap.get(bizId);
                    Object[] parm = new Object[]{invoiceTypeid, fcurrid, orgCompanyName, supplierName, fid};
                    paramList.add(parm);
                }
                DataUpgradePluginUtils.upgradePurInvoiceInvoice(dbRoute, paramList, "t_pur_invoicedetail");
            }
        }
        return true;
    }

    private static Long queryInvoicetypes() {
        DBRoute dbRoute = new DBRoute("basedata");
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,fnumber from t_bd_invoicetype where fnumber='3'");
        ArrayList invoiceTypeids = new ArrayList(8);
        try (DataSet totalData = DB.queryDataSet((String)"PurInvoiceInvoiceUpgradePluginImpl.queryInvoicetypes", (DBRoute)dbRoute, (String)sb.toString(), null);){
            totalData.forEach(rowx -> invoiceTypeids.add(rowx.getLong("fid")));
        }
        if (CollectionUtils.isNotEmpty(invoiceTypeids)) {
            return (Long)invoiceTypeids.get(0);
        }
        return 0L;
    }

    private static Map<Long, String> queryOrgName(List<Long> subOrgId) {
        HashMap<Long, String> orgMap = new HashMap<Long, String>(8);
        if (CollectionUtils.isEmpty(subOrgId)) {
            return orgMap;
        }
        DBRoute dbRoute = new DBRoute("basedata");
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,ffirmname from t_ORG_ORG_L where flocaleid = 'zh_CN' and  fid in (");
        Object[] params = subOrgId.toArray();
        for (Long org : subOrgId) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        try (DataSet totalData = DB.queryDataSet((String)"PurInvoiceInvoiceUpgradePluginImpl.queryOrgName", (DBRoute)dbRoute, (String)sb.toString(), (Object[])params);){
            totalData.forEach(rowx -> orgMap.put(rowx.getLong("fid"), rowx.getString("ffirmname")));
        }
        return orgMap;
    }

    private static Map<Long, String> queryBizPartnerName(List<Long> subBizPartnerId) {
        HashMap<Long, String> supplierMap = new HashMap<Long, String>(8);
        if (CollectionUtils.isEmpty(subBizPartnerId)) {
            return supplierMap;
        }
        DBRoute dbRoute = new DBRoute("basedata");
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,fname from T_BD_BizPartner_L where  flocaleid = 'zh_CN' and fid in (");
        Object[] params = subBizPartnerId.toArray();
        for (Long org : subBizPartnerId) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        try (DataSet totalData = DB.queryDataSet((String)"PurInvoiceInvoiceUpgradePluginImpl.queryBizPartnerName", (DBRoute)dbRoute, (String)sb.toString(), (Object[])params);){
            totalData.forEach(rowx -> supplierMap.put(rowx.getLong("fid"), rowx.getString("fname")));
        }
        return supplierMap;
    }

    private static void upgradePurInvoiceInvoice(DBRoute dbRoute, List<Object[]> subIdList, String table) {
        DB.executeBatch((DBRoute)dbRoute, (String)("update " + table + " set finvoicetypeid = ?,fcurrencyid = ?,freccompany = ?,finvcompany = ? where fid = ?"), subIdList);
    }
}

