/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.util;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pur.common.consts.APVerifyEntryVo;

public final class StoreVerifyServiceDataLocalUtil {
    private static Log log = LogFactory.getLog(StoreVerifyServiceDataLocalUtil.class);
    private static Set<String> scVerifyRelations = new HashSet<String>(4);

    public static void storeVerifyDataFactory(String VerifyRelation, Set<Long> verifyBillIds, Map<Long, APVerifyEntryVo> verifyEntryModelMap, Boolean isAdd) {
        switch (VerifyRelation) {
            case "appurin": {
                StoreVerifyServiceDataLocalUtil.storeApVerifyData("im_purinbill", "pur_instock", verifyBillIds, verifyEntryModelMap, isAdd);
                break;
            }
            case "appurreced": {
                StoreVerifyServiceDataLocalUtil.storeApVerifyData("im_purreceivebill", "pur_receipt", verifyBillIds, verifyEntryModelMap, isAdd);
                break;
            }
            case "appurreturn": {
                StoreVerifyServiceDataLocalUtil.storeApVerifyData("im_purinbill", "pur_return", verifyBillIds, verifyEntryModelMap, isAdd);
                break;
            }
            case "purself": {
                StoreVerifyServiceDataLocalUtil.storeApPurSelf(verifyBillIds, verifyEntryModelMap, isAdd);
                break;
            }
            case "ominself": {
                StoreVerifyServiceDataLocalUtil.storeApPurSelf(verifyBillIds, verifyEntryModelMap, isAdd);
                break;
            }
        }
    }

    public static Boolean checkVerifyRelation(String relation) {
        Boolean verifyFlag = Boolean.FALSE;
        if (relation != null && !relation.trim().isEmpty() && scVerifyRelations.contains(relation)) {
            verifyFlag = Boolean.TRUE;
        }
        return verifyFlag;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void storeApVerifyData(String verifyEntity, String storeEntity, Set<Long> verifyBillIds, Map<Long, APVerifyEntryVo> verifyEntryModelMap, Boolean isAdd) {
        Set billIds = verifyBillIds.stream().map(Object::toString).collect(Collectors.toSet());
        DynamicObject[] purInstock = BusinessDataServiceHelper.load((String)storeEntity, (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcentryid,materialentry.srcbillid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcbillid", "in", billIds)});
        if (!isAdd.booleanValue()) {
            StoreVerifyServiceDataLocalUtil.storeVerifyData(isAdd, verifyEntryModelMap, purInstock);
            return;
        }
        if (purInstock != null && purInstock.length > 0) {
            StoreVerifyServiceDataLocalUtil.storeVerifyData(isAdd, verifyEntryModelMap, purInstock);
            return;
        }
        String errorMessage = ResManager.loadKDString((String)"\u6570\u636e\u5305\u6682\u4e0d\u6ee1\u8db3\u534f\u540c\u6838\u9500\u6570\u636e\u53cd\u5199\u3002", (String)"StoreVerifyServiceDataUtil_1", (String)"scm-pur-mservice", (Object[])new Object[0]);
        log.warn("VerifyService#handleVerifyData#errorMessage" + errorMessage);
        throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_003", errorMessage), new Object[0]);
    }

    private static void storeApPurSelf(Set<Long> verifyBillIds, Map<Long, APVerifyEntryVo> verifyEntryModelMap, Boolean isAdd) {
        Long sleepMillis;
        int maxRetry;
        AtomicInteger atomicInteger;
        Set billIds = verifyBillIds.stream().map(Object::toString).collect(Collectors.toSet());
        DynamicObject[] purInstock = BusinessDataServiceHelper.load((String)"pur_instock", (String)"billno,,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcentryid,materialentry.srcbillid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcbillid", "in", billIds)});
        DynamicObject[] purReturn = BusinessDataServiceHelper.load((String)"pur_return", (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcentryid,materialentry.srcbillid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcbillid", "in", billIds)});
        if (isAdd.booleanValue() && (purReturn == null || purReturn.length == 0)) {
            atomicInteger = new AtomicInteger(0);
            maxRetry = 3;
            sleepMillis = 100L;
            while (atomicInteger.getAndIncrement() < maxRetry) {
                log.info("storeApPurSelf\uff0c\u7b2c\u51e0\u6b21\u91cd\u8bd5" + atomicInteger.get());
                try {
                    Thread.sleep(sleepMillis);
                }
                catch (InterruptedException e) {
                    log.error(ExceptionUtil.getStackTrace((Throwable)e));
                }
                purReturn = BusinessDataServiceHelper.load((String)"pur_return", (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcentryid,materialentry.srcbillid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcbillid", "in", billIds)});
            }
        }
        if (isAdd.booleanValue() && (purReturn == null || purReturn.length == 0) && purInstock.length != verifyBillIds.size()) {
            atomicInteger = new AtomicInteger(0);
            maxRetry = 3;
            sleepMillis = 500L;
            while (atomicInteger.getAndIncrement() < maxRetry) {
                log.info("storeApPurSelf\uff0c\u7b2c\u51e0\u6b21\u91cd\u8bd5" + atomicInteger.get());
                try {
                    Thread.sleep(sleepMillis);
                }
                catch (InterruptedException e) {
                    log.error(ExceptionUtil.getStackTrace((Throwable)e));
                }
                purInstock = BusinessDataServiceHelper.load((String)"pur_instock", (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcentryid,materialentry.srcbillid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcbillid", "in", billIds)});
            }
        }
        if (isAdd.booleanValue()) {
            if (!(purInstock != null && purInstock.length != 0 || purReturn != null && purReturn.length != 0)) {
                String errorMessage = ResManager.loadKDString((String)"\u6570\u636e\u5305\u6682\u4e0d\u6ee1\u8db3\u534f\u540c\u6838\u9500\u6570\u636e\u53cd\u5199\u3002", (String)"StoreVerifyServiceDataUtil_1", (String)"scm-pur-mservice", (Object[])new Object[0]);
                log.warn("VerifyService#handleVerifyData#errorMessage" + errorMessage);
                throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_003", errorMessage), new Object[0]);
            }
            if (purInstock != null && purInstock.length > 0) {
                log.info("Verify blue start , pur_instock count :  " + purInstock.length);
                StoreVerifyServiceDataLocalUtil.storeVerifyData(isAdd, verifyEntryModelMap, purInstock);
            }
            if (purReturn != null && purReturn.length > 0) {
                log.info("verify blue start , pur_return count :  " + purReturn.length);
                StoreVerifyServiceDataLocalUtil.storeVerifyData(isAdd, verifyEntryModelMap, purReturn);
            }
        } else {
            if (purInstock != null && purInstock.length > 0) {
                log.info("UnVerify blue start , pur_instock count :  " + purInstock.length);
                StoreVerifyServiceDataLocalUtil.storeVerifyData(isAdd, verifyEntryModelMap, purInstock);
            }
            if (purReturn != null && purReturn.length > 0) {
                log.info("UnVerify blue start , pur_return count :  " + purReturn.length);
                StoreVerifyServiceDataLocalUtil.storeVerifyData(isAdd, verifyEntryModelMap, purReturn);
            }
        }
    }

    private static void storeVerifyData(Boolean isAdd, Map<Long, APVerifyEntryVo> verifyEntryModelMap, DynamicObject[] storeData) {
        if (storeData == null || storeData.length == 0) {
            return;
        }
        for (DynamicObject bill : storeData) {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryRow : materialentry) {
                String srcentryid = entryRow.getString("srcentryid");
                APVerifyEntryVo apVerifyEntryVo = verifyEntryModelMap.get(Long.valueOf(srcentryid));
                if (apVerifyEntryVo == null) continue;
                BigDecimal qty = entryRow.getBigDecimal("qty");
                BigDecimal basicQty = entryRow.getBigDecimal("basicqty");
                BigDecimal unmatchqty = entryRow.getBigDecimal("unmatchqty");
                BigDecimal unmatchbaseqty = entryRow.getBigDecimal("unmatchbaseqty");
                BigDecimal verifyQty = apVerifyEntryVo.getVerifyQty();
                BigDecimal verifyBaseQty = apVerifyEntryVo.getVerifyBaseQty();
                if (isAdd.booleanValue()) {
                    entryRow.set("unmatchqty", (Object)qty.subtract(qty.subtract(unmatchqty).add(verifyQty)));
                    entryRow.set("unmatchbaseqty", (Object)basicQty.subtract(basicQty.subtract(unmatchbaseqty).add(verifyBaseQty)));
                    continue;
                }
                entryRow.set("unmatchqty", (Object)unmatchqty.add(verifyQty));
                entryRow.set("unmatchbaseqty", (Object)unmatchbaseqty.add(verifyBaseQty));
            }
        }
        log.info("storeVerifyData save ,count: " + storeData.length);
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])storeData);
    }

    private static Set<Long> getVerifyScEntry(String entityKey, String entryKey, Set<Long> bills, Set<Long> entryIds) {
        List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)entityKey, (String)entryKey, (Long[])bills.toArray(new Long[0]), (Long[])entryIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        HashSet<Long> verifyScEntry = new HashSet<Long>(bfRowList.size());
        for (BFRow bfRow : bfRowList) {
            BFRowId bfRowSId = bfRow.getSId();
            BFRowId bfRowId = bfRow.getId();
            Long bfRowSIdEntryId = bfRowSId.getEntryId();
            if (!entryIds.contains(bfRowSIdEntryId)) continue;
            verifyScEntry.add(bfRowId.getEntryId());
        }
        log.info("VerifyService#handleVerifyData#verifyScEntry" + verifyScEntry);
        return verifyScEntry;
    }

    static {
        scVerifyRelations.add("appurin");
        scVerifyRelations.add("appurreced");
        scVerifyRelations.add("appurreturn");
        scVerifyRelations.add("purself");
        scVerifyRelations.add("ominself");
    }
}

