/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.ScDataHandleTaskHelper;
import kd.scm.common.helper.scdatahandle.args.CosmicParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleConfig;
import kd.scm.common.helper.scdatahandle.args.ScStoreDataHandleMessageInfo;
import kd.scm.common.helper.scdatahandle.channel.CosmicChannelService;
import kd.scm.common.helper.scdatahandle.entity.ScDataHandleLogInfo;
import kd.scm.common.helper.scdatahandle.log.ScDataHandleLog;
import kd.scm.common.helper.scdatahandle.storedata.AbstractPushDataHandler;
import kd.scm.common.helper.scdatahandle.storedata.CosmicPushDataHandler;
import kd.scm.pur.common.consts.APVerifyEntryVo;

public final class StoreVerifyServiceDataUtil {
    private static final Log log = LogFactory.getLog(StoreVerifyServiceDataUtil.class);
    private static final Set<String> scVerifyRelations = new HashSet<String>(4);

    public static void storeVerifyDataFactory(String verifyRelation, Set<Long> verifyBillIds, Map<Long, APVerifyEntryVo> verifyEntryModelMap, Boolean isAdd) {
        try {
            CosmicParamArgs cosmicParamArgs = new CosmicParamArgs();
            cosmicParamArgs.setCloudId("scm");
            cosmicParamArgs.setAppId("pur");
            cosmicParamArgs.setServiceName("PurStockUnMatchDataUpdateService");
            cosmicParamArgs.setMethodName("executeUnMatchQty");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(1024);
            HashSet<Long> verifyEntryIds = new HashSet<Long>(verifyEntryModelMap.keySet());
            paramMap.put("verifyRelation", verifyRelation);
            paramMap.put("verifyBillIds", SerializationUtils.toJsonString(verifyBillIds));
            paramMap.put("executeData", SerializationUtils.toJsonString(verifyEntryIds));
            paramMap.put("isAdd", isAdd);
            cosmicParamArgs.setParamMap(paramMap);
            ScDataHandleConfig scDataHandleConfig = new ScDataHandleConfig();
            scDataHandleConfig.setChannelInfo(CosmicChannelService.class.getName());
            scDataHandleConfig.setScHandleDataInfo(CosmicPushDataHandler.class.getName());
            scDataHandleConfig.setScPluginInfo("");
            String desc = ResManager.loadKDString((String)"\u6570\u636e\u5305\u6682\u4e0d\u6ee1\u8db3\u534f\u540c\u6838\u9500\u6570\u636e\u53cd\u5199\u3002", (String)"StoreVerifyServiceDataUtil_0", (String)"scm-pur-common", (Object[])new Object[0]);
            scDataHandleConfig.setEntityDesc(desc);
            scDataHandleConfig.setOperateDesc("PurStockUnMatchDataUpdateService");
            ScDataHandleLog scDataHandleLog = new ScDataHandleLog();
            ScDataHandleLogInfo scDataHandleLogInfo = new ScDataHandleLogInfo();
            scDataHandleLogInfo.setId(DBServiceHelper.genStringId());
            scDataHandleLogInfo.setLogDim("scdataframe");
            scDataHandleLogInfo.setTraceId(RequestContext.get().getTraceId());
            scDataHandleLogInfo.setUserName(RequestContext.get().getUserName());
            scDataHandleLogInfo.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
            scDataHandleLogInfo.setLogAppId("pbd");
            String paramJson = SerializationUtils.toJsonString((Object)cosmicParamArgs);
            scDataHandleLogInfo.setParams(paramJson);
            scDataHandleLogInfo.setParamsTag(paramJson);
            String configJson = SerializationUtils.toJsonString((Object)scDataHandleConfig);
            scDataHandleLogInfo.setConfig(configJson);
            scDataHandleLogInfo.setConfigTag(configJson);
            scDataHandleLogInfo.setEntityDesc(scDataHandleConfig.getEntityDesc());
            scDataHandleLogInfo.setOperateDesc(scDataHandleConfig.getOperateDesc());
            try {
                String pushDataClassString = scDataHandleConfig.getScHandleDataInfo();
                AbstractPushDataHandler abstractPushDataHandler = (AbstractPushDataHandler)TypesContainer.createInstance((String)pushDataClassString);
                ScDataHandleResult scDataHandleResult = new ScDataHandleResult();
                abstractPushDataHandler.exec(scDataHandleResult, (ScDataHandleArgs)cosmicParamArgs);
                scDataHandleLogInfo.setState("success");
                scDataHandleLogInfo.setLogType("successlog");
                scDataHandleLogInfo.setResult("success");
                scDataHandleLogInfo.setResult("success");
                scDataHandleLog.info(scDataHandleLogInfo);
            }
            catch (RuntimeException runtimeException) {
                scDataHandleLogInfo.setLogType("faillog");
                scDataHandleLogInfo.setState("fail");
                scDataHandleLogInfo.setRetry(Integer.valueOf(Integer.parseInt("0")));
                scDataHandleLogInfo.setResult(String.valueOf(runtimeException.getMessage()));
                scDataHandleLogInfo.setResult(String.valueOf(runtimeException.getMessage()));
                scDataHandleLog.info(scDataHandleLogInfo);
                ScStoreDataHandleMessageInfo scStoreDataHandleMessageInfo = new ScStoreDataHandleMessageInfo(scDataHandleLogInfo.getId());
                scStoreDataHandleMessageInfo.setScDataHandleArgs((ScDataHandleArgs)cosmicParamArgs);
                scStoreDataHandleMessageInfo.setScDataHandleConfig(scDataHandleConfig);
                ScDataHandleTaskHelper.executeTask((ScStoreDataHandleMessageInfo)scStoreDataHandleMessageInfo);
            }
        }
        catch (RuntimeException runtimeException) {
            log.warn((Throwable)runtimeException);
        }
    }

    public static Boolean checkVerifyRelation(String relation) {
        Boolean verifyFlag = Boolean.FALSE;
        if (relation != null && !relation.trim().isEmpty() && scVerifyRelations.contains(relation)) {
            verifyFlag = Boolean.TRUE;
        }
        return verifyFlag;
    }

    static {
        scVerifyRelations.add("appurin");
        scVerifyRelations.add("appurreced");
        scVerifyRelations.add("appurreturn");
        scVerifyRelations.add("purself");
        scVerifyRelations.add("ominself");
    }
}

