/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.pur.common.consts.APVerifyEntryVo;

public final class StoreVerifyServiceXkDataUtil {
    private static Log log = LogFactory.getLog(StoreVerifyServiceXkDataUtil.class);
    private static Set<String> scVerifyRelations = new HashSet<String>(4);

    public static void storeVerifyDataFactory(String VerifyRelation, Set<Long> verifyBillIds, Map<String, APVerifyEntryVo> verifyEntryModelMap, Boolean isAdd) {
        switch (VerifyRelation) {
            case "appurin": {
                StoreVerifyServiceXkDataUtil.storeApVerifyData("pur_instock", "pur_instock", verifyBillIds, verifyEntryModelMap, isAdd);
                break;
            }
            case "appurreced": {
                StoreVerifyServiceXkDataUtil.storeApVerifyData("pur_receipt", "pur_receipt", verifyBillIds, verifyEntryModelMap, isAdd);
                break;
            }
            case "appurreturn": {
                StoreVerifyServiceXkDataUtil.storeApVerifyData("pur_return", "pur_return", verifyBillIds, verifyEntryModelMap, isAdd);
                break;
            }
            case "purself": {
                StoreVerifyServiceXkDataUtil.storeApPurSelf(verifyBillIds, verifyEntryModelMap, isAdd);
                break;
            }
        }
    }

    public static Boolean checkVerifyRelation(String relation) {
        Boolean verifyFlag = Boolean.FALSE;
        if (relation != null && !relation.trim().isEmpty() && scVerifyRelations.contains(relation)) {
            verifyFlag = Boolean.TRUE;
        }
        return verifyFlag;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void storeApVerifyData(String verifyEntity, String storeEntity, Set<Long> verifyBillIds, Map<String, APVerifyEntryVo> verifyEntryModelMap, Boolean isAdd) {
        DynamicObject[] purInstock = BusinessDataServiceHelper.load((String)storeEntity, (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", verifyEntryModelMap.keySet())});
        if (!isAdd.booleanValue()) {
            StoreVerifyServiceXkDataUtil.storeVerifyData(isAdd, verifyEntryModelMap, purInstock);
            return;
        }
        if (purInstock != null && purInstock.length > 0) {
            StoreVerifyServiceXkDataUtil.storeVerifyData(isAdd, verifyEntryModelMap, purInstock);
            return;
        }
        String errorMessage = ResManager.loadKDString((String)"\u6570\u636e\u5305\u6682\u4e0d\u6ee1\u8db3\u534f\u540c\u6838\u9500\u6570\u636e\u53cd\u5199\u3002", (String)"StoreVerifyServiceXkDataUtil_1", (String)"scm-pur-mservice", (Object[])new Object[0]);
        log.warn("VerifyService#handleVerifyData#errorMessage" + errorMessage);
        throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_003", errorMessage), new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void storeApPurSelf(Set<Long> verifyBillIds, Map<String, APVerifyEntryVo> verifyEntryModelMap, Boolean isAdd) {
        DynamicObject[] purInstock = BusinessDataServiceHelper.load((String)"pur_instock", (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", verifyEntryModelMap.keySet())});
        DynamicObject[] purReturn = BusinessDataServiceHelper.load((String)"pur_return", (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", verifyEntryModelMap.keySet())});
        ArrayList<String> logStoreList = new ArrayList<String>(8);
        StringBuilder logString = null;
        if (isAdd.booleanValue() && purReturn.length == 0) {
            AtomicInteger atomicInteger = new AtomicInteger(0);
            int maxRetry = 3;
            Long sleepMillis = 100L;
            while (atomicInteger.getAndIncrement() < maxRetry) {
                logString = new StringBuilder();
                logString.append(atomicInteger.get());
                try {
                    Thread.sleep(sleepMillis);
                }
                catch (InterruptedException e) {
                    logString.append(e.getMessage());
                }
                logStoreList.add(logString.toString());
                purReturn = BusinessDataServiceHelper.load((String)"pur_return", (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", verifyEntryModelMap.keySet())});
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("storeApPurSelf#logStoreList{}", (Object)SerializationUtils.toJsonString(logStoreList));
        }
        if (!isAdd.booleanValue()) {
            StoreVerifyServiceXkDataUtil.storeVerifyData(isAdd, verifyEntryModelMap, purInstock);
            StoreVerifyServiceXkDataUtil.storeVerifyData(isAdd, verifyEntryModelMap, purReturn);
            return;
        }
        if (purInstock != null && purInstock.length > 0 && purReturn != null && purReturn.length > 0) {
            StoreVerifyServiceXkDataUtil.storeVerifyData(isAdd, verifyEntryModelMap, purInstock);
            StoreVerifyServiceXkDataUtil.storeVerifyData(isAdd, verifyEntryModelMap, purReturn);
            return;
        }
        String errorMessage = ResManager.loadKDString((String)"\u6570\u636e\u5305\u6682\u4e0d\u6ee1\u8db3\u534f\u540c\u6838\u9500\u6570\u636e\u53cd\u5199\u3002", (String)"StoreVerifyServiceXkDataUtil_1", (String)"scm-pur-mservice", (Object[])new Object[0]);
        log.warn("VerifyService#handleVerifyData#errorMessage" + errorMessage);
        throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_003", errorMessage), new Object[0]);
    }

    private static void storeVerifyData(Boolean isAdd, Map<String, APVerifyEntryVo> verifyEntryModelMap, DynamicObject[] storeData) {
        for (DynamicObject bill : storeData) {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryRow : materialentry) {
                String srcentryid = entryRow.getString("srcentryid");
                APVerifyEntryVo apVerifyEntryVo = verifyEntryModelMap.get(srcentryid);
                if (apVerifyEntryVo == null) continue;
                BigDecimal qty = entryRow.getBigDecimal("qty");
                BigDecimal basicQty = entryRow.getBigDecimal("basicqty");
                BigDecimal unmatchqty = entryRow.getBigDecimal("unmatchqty");
                BigDecimal unmatchbaseqty = entryRow.getBigDecimal("unmatchbaseqty");
                BigDecimal verifyQty = apVerifyEntryVo.getVerifyQty();
                BigDecimal verifyBaseQty = apVerifyEntryVo.getVerifyBaseQty();
                if (isAdd.booleanValue()) {
                    entryRow.set("unmatchqty", (Object)qty.subtract(qty.subtract(unmatchqty).add(verifyQty.abs())));
                    entryRow.set("unmatchbaseqty", (Object)basicQty.subtract(basicQty.subtract(unmatchbaseqty).add(verifyBaseQty.abs())));
                    continue;
                }
                entryRow.set("unmatchqty", (Object)unmatchqty.add(verifyQty.abs()));
                entryRow.set("unmatchbaseqty", (Object)unmatchbaseqty.add(verifyBaseQty.abs()));
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])storeData);
    }

    static {
        scVerifyRelations.add("appurin");
        scVerifyRelations.add("appurreced");
        scVerifyRelations.add("appurreturn");
        scVerifyRelations.add("purself");
    }
}

