/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scm.common.helper.SRMBillEntityTypeHelper;
import kd.scm.common.helper.transfer.SDKTransferHelper;
import kd.scm.common.helper.transfer.SRMTransferDataHelper;
import kd.scm.common.helper.transfer.entity.TransferInfo;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.business.transfer.BatchStockSupportDefault;
import kd.scm.sccore.business.OrderAvailableStockQtyHelper;
import kd.scm.sccore.business.SalOutStockAvailableBasicQtyHelper;

public final class PurBatchStockHelper {
    private static final Log log = LogFactory.getLog((String)PurBatchStockHelper.class.getName());

    public static Map<String, String> assembleExtStockData(DynamicObject bill, Map<String, String> extEntryProMap) {
        LinkedHashMap<String, String> extStockData = new LinkedHashMap<String, String>(16);
        extStockData.putAll(SDKTransferHelper.executeTransfer((DynamicObject)bill, extEntryProMap));
        return extStockData;
    }

    public static Map<String, String> assembleBatchExtEntryPro() {
        LinkedHashMap<String, String> sdkEntryMap = new LinkedHashMap<String, String>(16);
        TransferInfo transferInfo = SRMTransferDataHelper.getTransferInfo((String)"srmbatchstock");
        Map transferTypeMap = transferInfo.getTransferTypeMap();
        if (!transferTypeMap.isEmpty()) {
            String number = transferTypeMap.getOrDefault("number", "SCM_PUR_BATCHSTOCK_SUPPORT");
            String anInterface = transferTypeMap.getOrDefault("interface", "kd.sdk.scm.pur.extpoint.IBatchStockSupport");
            Class type = null;
            try {
                type = TypesContainer.getOrRegister((String)anInterface);
                sdkEntryMap.putAll(SDKTransferHelper.getSDKEntryMap((String)number, (Class)type, BatchStockSupportDefault.class));
            }
            catch (Throwable throwable) {
                log.error(throwable);
            }
        }
        return sdkEntryMap;
    }

    public static Map<String, String> assembleBatchExtHeadPro() {
        LinkedHashMap<String, String> sdkEntryMap = new LinkedHashMap<String, String>(16);
        TransferInfo transferInfo = SRMTransferDataHelper.getTransferInfo((String)"srmbatchstock");
        Map transferTypeMap = transferInfo.getTransferTypeMap();
        if (!transferTypeMap.isEmpty()) {
            String number = transferTypeMap.getOrDefault("number", "SCM_PUR_BATCHSTOCK_SUPPORT");
            String anInterface = transferTypeMap.getOrDefault("interface", "kd.sdk.scm.pur.extpoint.IBatchStockSupport");
            Class type = null;
            try {
                type = TypesContainer.getOrRegister((String)anInterface);
                sdkEntryMap.putAll(SDKTransferHelper.getSDKHeadMap((String)number, (Class)type, BatchStockSupportDefault.class));
            }
            catch (Throwable throwable) {
                log.error(throwable);
            }
        }
        return sdkEntryMap;
    }

    public static Map<Long, Map<String, BigDecimal>> assembleSalOutStcokData(DynamicObject[] dynamicObjects) {
        HashMap<Long, Map<String, BigDecimal>> availableSalOutMap = new HashMap<Long, Map<String, BigDecimal>>(1024);
        List salOutStockData = SalOutStockAvailableBasicQtyHelper.getJointSalOutStockData((DynamicObject[])dynamicObjects);
        Boolean callErpStockQty = ParamUtil.getBooleanParam((String)"eae607fb000143ac", (String)"availablestockqty");
        Map salOutStockAvailableBasicQty = new HashMap(1024);
        if (callErpStockQty.booleanValue()) {
            salOutStockAvailableBasicQty = SalOutStockAvailableBasicQtyHelper.assmibleSalOutStockAvailableBasicQty((List)salOutStockData, new HashMap());
        }
        DynamicObject material = null;
        DynamicObject unit = null;
        DynamicObject basicUnit = null;
        BigDecimal availableSalBasicQty = BigDecimal.ZERO;
        BigDecimal availableSalQty = BigDecimal.ZERO;
        HashMap<String, BigDecimal> rowMap = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject businesstype = dynamicObject.getDynamicObject("businesstype");
            boolean isGoodsBizType = MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)businesstype);
            DynamicObjectCollection rows = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                BigDecimal maxErpStock;
                Long entryId = row.getLong("id");
                BigDecimal sumreceiptqty = row.getBigDecimal("sumreceiptqty");
                BigDecimal sumreceiptBasicqty = CommonUtil.getDesQtyConv(material, unit, (BigDecimal)sumreceiptqty, basicUnit);
                BigDecimal suminstockqty = row.getBigDecimal("suminstockqty");
                BigDecimal suminstockBaseqty = CommonUtil.getDesQtyConv(material, unit, (BigDecimal)suminstockqty, basicUnit);
                BigDecimal basicQty = row.getBigDecimal("basicqty");
                BigDecimal qty = row.getBigDecimal("qty");
                material = row.getDynamicObject("material");
                unit = row.getDynamicObject("unit");
                basicUnit = row.getDynamicObject("basicunit");
                Map erpStockBasicQtyMap = (Map)salOutStockAvailableBasicQty.get(String.valueOf(entryId));
                BigDecimal bigDecimal = maxErpStock = sumreceiptBasicqty.compareTo(suminstockBaseqty) >= 0 ? sumreceiptBasicqty : suminstockBaseqty;
                if (erpStockBasicQtyMap != null) {
                    BigDecimal receiveBaseQtySum;
                    BigDecimal inBaseQtySum = (BigDecimal)erpStockBasicQtyMap.get("inBaseQtySum");
                    BigDecimal erpSumStockBasicQty = inBaseQtySum.add(receiveBaseQtySum = (BigDecimal)erpStockBasicQtyMap.get("receiveBaseQtySum"));
                    maxErpStock = maxErpStock.compareTo(erpSumStockBasicQty) >= 0 ? maxErpStock : erpSumStockBasicQty;
                }
                availableSalBasicQty = basicQty.compareTo(maxErpStock) > 0 ? basicQty.subtract(maxErpStock) : BigDecimal.ZERO;
                BigDecimal bigDecimal2 = availableSalQty = qty.compareTo(maxErpStock) > 0 ? qty.subtract(maxErpStock) : BigDecimal.ZERO;
                if (isGoodsBizType) {
                    availableSalBasicQty = availableSalQty;
                } else if (unit != null && basicUnit != null) {
                    availableSalQty = unit.getPkValue().equals(basicUnit.getPkValue()) ? availableSalBasicQty : CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)basicUnit, (BigDecimal)availableSalBasicQty, (DynamicObject)unit);
                }
                rowMap = new HashMap<String, BigDecimal>(2);
                rowMap.put("basicqty", availableSalBasicQty);
                rowMap.put("qty", availableSalQty);
                availableSalOutMap.put(entryId, rowMap);
            }
        }
        return availableSalOutMap;
    }

    public static List<DynamicObject> queryOrderDataCoreEntryIds(QFilter qFilter, Map<String, String> customParamMap) {
        Collection properties = OrderAvailableStockQtyHelper.assmibleMustProperties();
        properties.add("entrystatus");
        properties.add("billstatus");
        properties.add("businesstype");
        String entityFields = SRMBillEntityTypeHelper.getEntityFields((String)"pur_order", (Collection)properties);
        return OrderAvailableStockQtyHelper.queryOrderData((QFilter)qFilter, (String)("materialentry.linetype.acceptance acceptance,materialentry.linetype.number linetypenumber," + entityFields), null, customParamMap);
    }

    public static Map<String, BigDecimal> modifyOrderData(List<DynamicObject> orderData) {
        Map orderAvailableQtyMap = OrderAvailableStockQtyHelper.assembleOrderAvailableBasicQty(orderData);
        if (log.isInfoEnabled()) {
            log.info("PurBatchStockHelper#modifyOrderData#orderAvailableQtyMap:{}", (Object)SerializationUtils.toJsonString((Object)orderAvailableQtyMap));
        }
        return orderAvailableQtyMap;
    }
}

