/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public final class PurBillHelper {
    public static Map<Long, Collection<Long>> assembleBillOfEntry(List<ListSelectedRow> selectedRows) {
        LinkedHashMap<Long, Collection<Long>> checkMap = new LinkedHashMap<Long, Collection<Long>>(1024);
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            Object entryPrimaryKeyValue = listSelectedRow.getEntryPrimaryKeyValue();
            HashSet<Long> checkEntryIds = (HashSet<Long>)checkMap.get(Long.valueOf(primaryKeyValue.toString()));
            if (checkEntryIds == null) {
                checkEntryIds = new HashSet<Long>(20);
            }
            if (entryPrimaryKeyValue != null) {
                checkEntryIds.add(Long.valueOf(entryPrimaryKeyValue.toString()));
            }
            checkMap.put(Long.valueOf(primaryKeyValue.toString()), checkEntryIds);
        }
        return checkMap;
    }

    public static Set<Long> assembleSelectRowIds(String listselectedrowcollection) {
        Object[] entryPrimaryKeyValues;
        ListSelectedRowCollection rows;
        HashSet<Long> selectRows = new HashSet<Long>(156);
        if (StringUtils.isNotBlank((CharSequence)listselectedrowcollection) && (rows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)listselectedrowcollection, ListSelectedRowCollection.class)) != null && !rows.isEmpty() && (entryPrimaryKeyValues = rows.getEntryPrimaryKeyValues()) != null) {
            Arrays.stream(entryPrimaryKeyValues).forEach(row -> selectRows.add(Long.valueOf(row.toString())));
        }
        return selectRows;
    }

    public static Map<Long, Boolean> verifyRowTarget(String entityNumber, String entryNumber, Map<Long, Collection<Long>> checkMap) {
        ArrayList<Long> listEntryIds = new ArrayList<Long>(1024);
        for (Map.Entry<Long, Collection<Long>> entry : checkMap.entrySet()) {
            listEntryIds.addAll(entry.getValue());
        }
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(listEntryIds.size());
        if (!listEntryIds.isEmpty()) {
            Set value;
            String targetEntityNumber = PurBillHelper.getTargetEntityNumber(entityNumber);
            Map findTargetBills = BFTrackerServiceHelper.findTargetBills((String)entityNumber, (Long[])checkMap.keySet().toArray(new Long[0]));
            Set set = value = findTargetBills == null ? null : (Set)findTargetBills.get(targetEntityNumber);
            if (value != null && value.size() > 0) {
                List bfRowList = BFTrackerServiceHelper.loadSourceRowIds((String)targetEntityNumber, (Long[])value.toArray(new Long[0]), (OperateOption)OperateOption.create());
                listEntryIds.forEach(row -> resultMap.put((Long)row, Boolean.FALSE));
                for (BFRow bfRow : bfRowList) {
                    BFRowId bfRowSId = bfRow.getSId();
                    Long sIdEntryId = bfRowSId.getEntryId();
                    if (!listEntryIds.contains(sIdEntryId)) continue;
                    resultMap.put(sIdEntryId, Boolean.TRUE);
                }
            }
        } else {
            resultMap.putAll(PurBillHelper.verifyTarget(entityNumber, checkMap.keySet()));
        }
        return resultMap;
    }

    private static String getTargetEntityNumber(String entityNumber) {
        String targetEntityNumber = "pur_deliveryschedule";
        if ("pur_order".equals(entityNumber)) {
            targetEntityNumber = "pur_deliveryschedule";
        } else if ("scp_order".equals(entityNumber)) {
            targetEntityNumber = "scp_saloutstock";
        }
        return targetEntityNumber;
    }

    public static Map<Long, Boolean> verifyTarget(String entityNumber, Set<Long> checkBillIds) {
        Set value;
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(8);
        String targetEntityNumber = PurBillHelper.getTargetEntityNumber(entityNumber);
        Map findTargetBills = BFTrackerServiceHelper.findTargetBills((String)entityNumber, (Long[])checkBillIds.toArray(new Long[0]));
        Set set = value = findTargetBills == null ? null : (Set)findTargetBills.get(targetEntityNumber);
        if (value != null && value.size() > 0) {
            List bfRowList = BFTrackerServiceHelper.loadSourceRowIds((String)targetEntityNumber, (Long[])value.toArray(new Long[0]), (OperateOption)OperateOption.create());
            for (BFRow bfRow : bfRowList) {
                BFRowId bfRowSId = bfRow.getSId();
                Long sIdEntryId = bfRowSId.getEntryId();
                resultMap.put(sIdEntryId, Boolean.TRUE);
            }
        }
        return resultMap;
    }
}

