/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.pur.business.PurBillHelper;
import kd.scm.pur.business.PurOrderBillHelper;

public final class PurDeliveryScheduleHelper {
    public static void writeBackScheduleQty(DynamicObject[] bills, Set<Long> selectRows, Boolean closeFlag) {
        LinkedHashMap<Long, Map<String, BigDecimal>> paramMap = new LinkedHashMap<Long, Map<String, BigDecimal>>(56);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billDynamicObjectCollection = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : billDynamicObjectCollection) {
                Map<String, BigDecimal> dataMap;
                Long entryId = row.getLong("id");
                if (!selectRows.contains(entryId)) continue;
                String entrystatus = row.getString("entrystatus");
                String srcentryid = row.getString("srcentryid");
                BigDecimal qty = row.getBigDecimal("qty");
                BigDecimal basicqty = row.getBigDecimal("basicqty");
                BigDecimal promiseqty = row.getBigDecimal("promiseqty");
                BigDecimal promisebasicqty = row.getBigDecimal("promisebasicqty");
                String promisestatus = row.getString("promisestatus");
                if (srcentryid == null || srcentryid.isEmpty() || "0".equals(srcentryid)) continue;
                BigDecimal closeQty = BigDecimal.ZERO;
                BigDecimal closeBasicQty = BigDecimal.ZERO;
                if ("A".equals(promisestatus) || "C".equals(promisestatus)) {
                    closeQty = qty;
                    closeBasicQty = basicqty;
                } else if ("B".equals(promisestatus) || "D".equals(promisestatus)) {
                    closeQty = promiseqty;
                    closeBasicQty = promisebasicqty;
                }
                if (closeFlag.booleanValue()) {
                    if (!"B".equalsIgnoreCase(entrystatus)) continue;
                    dataMap = (HashMap<String, BigDecimal>)paramMap.get(Long.parseLong(srcentryid));
                    if (dataMap != null) {
                        dataMap.put("scheduleqty", ((BigDecimal)dataMap.get("scheduleqty")).add(closeQty.negate()));
                        dataMap.put("schedulebaseqty", ((BigDecimal)dataMap.get("schedulebaseqty")).add(closeBasicQty.negate()));
                        continue;
                    }
                    dataMap = new HashMap<String, BigDecimal>(56);
                    dataMap.put("scheduleqty", closeQty.negate());
                    dataMap.put("schedulebaseqty", closeBasicQty.negate());
                    paramMap.put(Long.parseLong(srcentryid), dataMap);
                    continue;
                }
                if (!"A".equalsIgnoreCase(entrystatus)) continue;
                dataMap = (Map)paramMap.get(Long.parseLong(srcentryid));
                if (dataMap != null) {
                    dataMap.put("scheduleqty", ((BigDecimal)dataMap.get("scheduleqty")).add(closeQty));
                    dataMap.put("schedulebaseqty", ((BigDecimal)dataMap.get("schedulebaseqty")).add(closeBasicQty));
                    continue;
                }
                dataMap = new HashMap(56);
                dataMap.put("scheduleqty", closeQty);
                dataMap.put("schedulebaseqty", closeBasicQty);
                paramMap.put(Long.parseLong(srcentryid), dataMap);
            }
        }
        if (!paramMap.isEmpty()) {
            PurOrderBillHelper.updateScheduleQty(paramMap);
        }
    }

    @Deprecated
    public static void writeBackScheduleQty(DynamicObject[] bills, Boolean closeFlag) {
        HashSet<Long> selectRows = new HashSet<Long>(156);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billDynamicObjectCollection = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : billDynamicObjectCollection) {
                Long entryId = row.getLong("id");
                selectRows.add(entryId);
            }
        }
        PurDeliveryScheduleHelper.writeBackScheduleQty(bills, selectRows, closeFlag);
    }

    public static Boolean verifyIsDraw(Long billId) {
        Boolean verify = Boolean.FALSE;
        Map dirtSourceBills = BFTrackerServiceHelper.findDirtSourceBills((String)"pur_deliveryschedule", (Long[])new Long[]{billId});
        List uninDrawData = (List)dirtSourceBills.get(billId);
        if (uninDrawData != null && !uninDrawData.isEmpty()) {
            verify = Boolean.TRUE;
        }
        return verify;
    }

    public static Set<Long> assembleSelectRowIds(String listselectedrowcollection) {
        return PurBillHelper.assembleSelectRowIds(listselectedrowcollection);
    }

    public static void promiseWriteBackScheduleQty(DynamicObject[] bills, Set<Long> selectRows, Boolean isPromise) {
        LinkedHashMap<Long, Map<String, BigDecimal>> paramMap = new LinkedHashMap<Long, Map<String, BigDecimal>>(56);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billDynamicObjectCollection = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : billDynamicObjectCollection) {
                Long entryId = row.getLong("id");
                if (!selectRows.contains(entryId)) continue;
                String srcentryid = row.getString("srcentryid");
                BigDecimal promiseqty = row.getBigDecimal("promiseqty");
                BigDecimal promisebasicqty = row.getBigDecimal("promisebasicqty");
                BigDecimal qty = row.getBigDecimal("qty");
                BigDecimal basicqty = row.getBigDecimal("basicqty");
                if (srcentryid.isEmpty() || "0".equals(srcentryid)) continue;
                HashMap<String, BigDecimal> dataMap = (HashMap<String, BigDecimal>)paramMap.get(Long.parseLong(srcentryid));
                if (isPromise.booleanValue()) {
                    BigDecimal confirmQty = qty.negate().add(promiseqty);
                    BigDecimal confirmBaseQty = basicqty.negate().add(promisebasicqty);
                    if (dataMap != null) {
                        dataMap.put("scheduleqty", ((BigDecimal)dataMap.get("scheduleqty")).add(confirmQty));
                        dataMap.put("schedulebaseqty", ((BigDecimal)dataMap.get("schedulebaseqty")).add(confirmBaseQty));
                        continue;
                    }
                    dataMap = new HashMap<String, BigDecimal>(56);
                    dataMap.put("scheduleqty", confirmQty);
                    dataMap.put("schedulebaseqty", confirmBaseQty);
                    paramMap.put(Long.parseLong(srcentryid), dataMap);
                    continue;
                }
                BigDecimal rejectQty = promiseqty.negate().add(qty);
                BigDecimal rejectBasicQty = promisebasicqty.negate().add(basicqty);
                if (dataMap != null) {
                    dataMap.put("scheduleqty", ((BigDecimal)dataMap.get("scheduleqty")).add(rejectQty));
                    dataMap.put("schedulebaseqty", ((BigDecimal)dataMap.get("schedulebaseqty")).add(rejectBasicQty));
                    continue;
                }
                dataMap = new HashMap(56);
                dataMap.put("scheduleqty", rejectQty);
                dataMap.put("schedulebaseqty", rejectBasicQty);
                paramMap.put(Long.parseLong(srcentryid), dataMap);
            }
        }
        if (!paramMap.isEmpty()) {
            PurOrderBillHelper.updateScheduleQty(paramMap);
        }
    }

    public static void updateRelateSalOutQty(Map<Long, Map<String, BigDecimal>> paramMap) {
        DynamicObject[] deliveryschedules;
        for (DynamicObject bill : deliveryschedules = BusinessDataServiceHelper.load((String)"pur_deliveryschedule", (String)"id,billno,materialentry.sumoutstockqty,materialentry.sumoutstockbaseqty", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", paramMap.keySet())})) {
            DynamicObjectCollection billDynamicObjectCollection = bill.getDynamicObjectCollection("materialentry");
            DynamicProperty sumoutstockqty = billDynamicObjectCollection.getDynamicObjectType().getProperty("sumoutstockqty");
            DynamicProperty sumoutstockbaseqty = billDynamicObjectCollection.getDynamicObjectType().getProperty("sumoutstockbaseqty");
            for (DynamicObject row : billDynamicObjectCollection) {
                Long entryId = row.getLong("id");
                Map<String, BigDecimal> dataMap = paramMap.get(entryId);
                if (dataMap == null || dataMap.isEmpty()) continue;
                sumoutstockqty.setValue((Object)row, (Object)((BigDecimal)sumoutstockqty.getValue((Object)row)).add(dataMap.get("qty")));
                sumoutstockbaseqty.setValue((Object)row, (Object)((BigDecimal)sumoutstockbaseqty.getValue((Object)row)).add(dataMap.get("basicqty")));
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])deliveryschedules);
    }

    public static List<Long> assembleLinkSalOutBillIds(Object entryId) {
        ArrayList<Long> linkSalOutIds = new ArrayList<Long>(56);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_saloutstock", (String)"id", (QFilter[])new QFilter[]{new QFilter("materialentry.dsentryid", "=", (Object)String.valueOf(entryId))}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                linkSalOutIds.add(row.getLong("id"));
            }
        }
        return linkSalOutIds;
    }
}

